/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.itemcreation.command;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.itemcreation.internal.AbstractCreationCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContainerCreationCommand
extends AbstractCreationCommand {
    private final IDOMPosition _originalDomPosition;
    private final TagIdentifier _containerTag;
    private final TagIdentifier _tagBeingCreated;
    private IDOMPosition _domPosition;
    private ContainerCreationCommand _nextCommand = null;

    ContainerCreationCommand(IDOMPosition domPosition, TagIdentifier containerTag, TagIdentifier tagBeingCreated) {
        this._domPosition = domPosition;
        this._originalDomPosition = domPosition;
        this._containerTag = containerTag;
        this._tagBeingCreated = tagBeingCreated;
    }

    @Override
    public final void execute() {
        this._domPosition = this.doExecute();
        if (this._nextCommand != null) {
            this._nextCommand.setDomPosition(this._domPosition);
            this._nextCommand.execute();
            this._domPosition = this._nextCommand.getDomPosition();
        }
    }

    public final Collection<IDOMPosition> getResult() {
        return Collections.singletonList(this._domPosition);
    }

    protected abstract IDOMPosition doExecute();

    public final ContainerCreationCommand chain(Command command) {
        if (!(command instanceof ContainerCreationCommand)) {
            throw new IllegalArgumentException("Can only chain ContainerCreationCommand's");
        }
        if (this._nextCommand == null) {
            this._nextCommand = (ContainerCreationCommand)command;
        } else {
            this._nextCommand.chain(command);
        }
        return this;
    }

    public final void setDomPosition(IDOMPosition domPosition) {
        if (this._domPosition.getContainerNode().getOwnerDocument() != domPosition.getContainerNode().getOwnerDocument()) {
            throw new IllegalArgumentException("New domPosition must be in same document as old domPosition");
        }
        this._domPosition = domPosition;
    }

    protected final IDOMPosition getDomPosition() {
        return this._domPosition;
    }

    protected final IDOMPosition getOriginalDomPosition() {
        return this._originalDomPosition;
    }

    protected final TagIdentifier getContainerTag() {
        return this._containerTag;
    }

    protected final TagIdentifier getTagBeingCreated() {
        return this._tagBeingCreated;
    }
}

