/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jst.jsp.core.internal.Assert;
import org.eclipse.jst.jsp.core.internal.JSPCoreMessages;
import org.eclipse.jst.jsp.core.internal.document.PageDirectiveWatcherFactory;
import org.eclipse.jst.jsp.core.internal.encoding.IJSPHeadContentDetector;
import org.eclipse.jst.jsp.core.internal.encoding.JSPDocumentHeadContentDetector;
import org.eclipse.jst.jsp.core.internal.parser.JSPReParser;
import org.eclipse.jst.jsp.core.internal.parser.JSPSourceParser;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.jst.jsp.core.internal.text.StructuredTextPartitionerForJSP;
import org.eclipse.wst.sse.core.internal.PropagatingAdapter;
import org.eclipse.wst.sse.core.internal.document.AbstractDocumentLoader;
import org.eclipse.wst.sse.core.internal.document.IDocumentCharsetDetector;
import org.eclipse.wst.sse.core.internal.document.IDocumentLoader;
import org.eclipse.wst.sse.core.internal.document.StructuredDocumentFactory;
import org.eclipse.wst.sse.core.internal.encoding.CodedReaderCreator;
import org.eclipse.wst.sse.core.internal.encoding.ContentTypeEncodingPreferences;
import org.eclipse.wst.sse.core.internal.encoding.util.BufferedLimitedReader;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.EmbeddedTypeHandler;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.ltk.parser.TagMarker;
import org.eclipse.wst.sse.core.internal.modelhandler.EmbeddedTypeRegistry;
import org.eclipse.wst.sse.core.internal.modelhandler.EmbeddedTypeRegistryImpl;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.document.IEncodedDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredTextReParser;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapter;

public class JSPDocumentLoader
extends AbstractDocumentLoader {
    private static final String DEFAULT_MIME_TYPE = "text/html";
    private static final String SPEC_DEFAULT_ENCODING = "ISO-8859-1";
    private EmbeddedTypeRegistry fEmbeddedContentTypeRegistry;

    protected static IFile getFileFor(IStructuredModel model) {
        if (model == null) {
            return null;
        }
        String path = model.getBaseLocation();
        if (path == null || path.length() == 0) {
            String id = model.getId();
            if (id == null) {
                return null;
            }
            path = id.toString();
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFileForLocation((IPath)new Path(path));
        return file;
    }

    protected void addNestablePrefix(JSPSourceParser parser, String tagName) {
        TagMarker bm = new TagMarker(tagName);
        parser.addNestablePrefix(bm);
    }

    public synchronized IEncodedDocument createNewStructuredDocument(IFile iFile) throws IOException, CoreException {
        IStructuredDocument structuredDocument = null;
        try {
            structuredDocument = this.createCodedDocument(iFile);
            EmbeddedTypeHandler embeddedType = this.getEmbeddedType(iFile);
            if (embeddedType != null) {
                embeddedType.initializeParser(structuredDocument.getParser());
            }
            this.fFullPreparedReader.reset();
            this.setDocumentContentsFromReader((IEncodedDocument)structuredDocument, this.fFullPreparedReader);
        }
        finally {
            if (this.fFullPreparedReader != null) {
                this.fFullPreparedReader.close();
            }
        }
        return structuredDocument;
    }

    private IStructuredDocument createCodedDocument(IFile iFile) throws CoreException, UnsupportedEncodingException, IOException {
        IStructuredDocument structuredDocument = (IStructuredDocument)this.createNewStructuredDocument();
        this.getCodedReaderCreator().set(iFile);
        this.fFullPreparedReader = this.getCodedReaderCreator().getCodedReader();
        this.fEncodingMemento = this.getCodedReaderCreator().getEncodingMemento();
        structuredDocument.setEncodingMemento(this.getCodedReaderCreator().getEncodingMemento());
        return structuredDocument;
    }

    public IEncodedDocument createNewStructuredDocument(String filename, InputStream inputStream) throws UnsupportedEncodingException, IOException {
        if (filename == null && inputStream == null) {
            throw new IllegalArgumentException("can not have both null filename and inputstream");
        }
        IEncodedDocument structuredDocument = this.createNewStructuredDocument();
        CodedReaderCreator codedReaderCreator = new CodedReaderCreator();
        try {
            try {
                codedReaderCreator.set(filename, inputStream);
                this.fFullPreparedReader = codedReaderCreator.getCodedReader();
                this.fEncodingMemento = codedReaderCreator.getEncodingMemento();
                structuredDocument.setEncodingMemento(this.fEncodingMemento);
                EmbeddedTypeHandler embeddedType = this.getEmbeddedType(null);
                this.fFullPreparedReader.reset();
                if (embeddedType != null) {
                    embeddedType.initializeParser(((IStructuredDocument)structuredDocument).getParser());
                }
                this.setDocumentContentsFromReader(structuredDocument, this.fFullPreparedReader);
            }
            catch (CoreException e) {
                throw new Error(e);
            }
        }
        finally {
            if (this.fFullPreparedReader != null) {
                this.fFullPreparedReader.close();
            }
        }
        return structuredDocument;
    }

    public IDocumentPartitioner getDefaultDocumentPartitioner() {
        return new StructuredTextPartitionerForJSP();
    }

    private String getDefaultMimeType() {
        return DEFAULT_MIME_TYPE;
    }

    public IDocumentCharsetDetector getDocumentEncodingDetector() {
        if (this.fDocumentEncodingDetector == null) {
            this.fDocumentEncodingDetector = new JSPDocumentHeadContentDetector();
        }
        return this.fDocumentEncodingDetector;
    }

    private EmbeddedTypeRegistry getEmbeddedContentTypeRegistry() {
        if (this.fEmbeddedContentTypeRegistry == null) {
            this.fEmbeddedContentTypeRegistry = EmbeddedTypeRegistryImpl.getInstance();
        }
        return this.fEmbeddedContentTypeRegistry;
    }

    private EmbeddedTypeHandler getEmbeddedType(IFile file) throws UnsupportedEncodingException, CoreException, IOException {
        EmbeddedTypeHandler handler = null;
        if (this.fFullPreparedReader == null) {
            handler = this.getJSPDefaultEmbeddedType();
        } else {
            String mimeType = null;
            IDocumentCharsetDetector jspProvider = this.getDocumentEncodingDetector();
            Reader fullPreparedReader = this.getFullPreparedReader();
            BufferedLimitedReader limitedReader = new BufferedLimitedReader(fullPreparedReader, 8192);
            jspProvider.set((Reader)limitedReader);
            if (jspProvider instanceof IJSPHeadContentDetector) {
                mimeType = ((IJSPHeadContentDetector)jspProvider).getContentType();
                fullPreparedReader.reset();
            }
            EmbeddedTypeRegistry reg = this.getEmbeddedContentTypeRegistry();
            handler = mimeType == null || mimeType.length() == 0 ? this.getJSPDefaultEmbeddedType() : reg.getTypeFor(mimeType);
        }
        return handler;
    }

    private EmbeddedTypeHandler getJSPDefaultEmbeddedType() {
        EmbeddedTypeRegistry reg = this.getEmbeddedContentTypeRegistry();
        return reg.getTypeFor(this.getDefaultMimeType());
    }

    public RegionParser getParser() {
        JSPSourceParser parser = new JSPSourceParser();
        this.addNestablePrefix(parser, "jsp");
        return parser;
    }

    protected String getPreferredNewLineDelimiter(IFile file) {
        String delimiter = ContentTypeEncodingPreferences.getPreferredNewLineDelimiter((String)ContentTypeIdForJSP.ContentTypeID_JSP);
        if (delimiter == null) {
            delimiter = super.getPreferredNewLineDelimiter(file);
        }
        return delimiter;
    }

    protected String getSpecDefaultEncoding() {
        return SPEC_DEFAULT_ENCODING;
    }

    protected IEncodedDocument newEncodedDocument() {
        IStructuredDocument structuredDocument = StructuredDocumentFactory.getNewStructuredDocumentInstance((RegionParser)this.getParser());
        ((BasicStructuredDocument)structuredDocument).setReParser((IStructuredTextReParser)new JSPReParser());
        EmbeddedTypeHandler embeddedType = this.getJSPDefaultEmbeddedType();
        embeddedType.initializeParser(structuredDocument.getParser());
        return structuredDocument;
    }

    public IDocumentLoader newInstance() {
        return new JSPDocumentLoader();
    }

    protected void preLoadAdapt(IStructuredModel structuredModel) {
        IDOMModel domModel = (IDOMModel)structuredModel;
        IDOMDocument document = domModel.getDocument();
        Assert.isNotNull(document, JSPCoreMessages.JSPDocumentLoader_1);
        PropagatingAdapter propagatingAdapter = (PropagatingAdapter)((INodeNotifier)document).getAdapterFor(PropagatingAdapter.class);
        propagatingAdapter.addAdaptOnCreateFactory((INodeAdapterFactory)new PageDirectiveWatcherFactory());
        ((INodeNotifier)document).getAdapterFor(ModelQueryAdapter.class);
    }
}

