/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.tests.internal.AbstractStringToolsTests;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class StringToolsTests
extends AbstractStringToolsTests {
    public StringToolsTests(String name) {
        super(name);
    }

    @Override
    protected String CR() {
        return StringTools.CR;
    }

    @Override
    protected void verifyReverse(String expected, String string) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.reverse((String)string));
    }

    @Override
    protected void verifyLast(char expected, String string) {
        StringToolsTests.assertEquals((char)expected, (char)StringTools.last((String)string));
    }

    @Override
    protected void verifyConcatenate(String expected, String[] array) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.concatenate((String[])array));
        Iterable iterable = IterableTools.iterable((Object[])array);
        StringToolsTests.assertEquals((String)expected, (String)StringTools.concatenate((Iterable)iterable));
        StringToolsTests.assertEquals((String)expected, (String)StringTools.concatenate(iterable.iterator()));
    }

    @Override
    protected void verifyConcatenate(String expected, String[] array, String delim) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.concatenate((String[])array, (String)delim));
        Iterable iterable = IterableTools.iterable((Object[])array);
        StringToolsTests.assertEquals((String)expected, (String)StringTools.concatenate((Iterable)iterable, (String)delim));
        StringToolsTests.assertEquals((String)expected, (String)StringTools.concatenate(iterable.iterator(), (String)delim));
    }

    @Override
    protected void verifyCenter(String expected, String string, int len) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.center((String)string, (int)len));
    }

    @Override
    protected void verifyPad(String expected, String string, int len) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.pad((String)string, (int)len));
    }

    @Override
    protected void verifyFit(String expected, String string, int len) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.fit((String)string, (int)len));
    }

    @Override
    protected void verifyZeroPad(String expected, String string, int len) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.zeroPad((String)string, (int)len));
    }

    @Override
    protected void verifyZeroFit(String expected, String string, int len) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.zeroFit((String)string, (int)len));
    }

    @Override
    protected void verifyRepeat(String expected, String string, int length) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.repeat((String)string, (int)length));
    }

    @Override
    protected void verifySeparate(String expected, String string, char separator, int segmentLength) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.separate((String)string, (char)separator, (int)segmentLength));
    }

    @Override
    protected void verifyQuote(String expected, String string) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.quote((String)string));
    }

    @Override
    protected void verifyCharDelimiter(String expected, String string, char delimiter) {
        Transformer<String, String> transformer = this.buildCharDelimiter(delimiter);
        StringToolsTests.assertEquals((String)expected, (String)((String)transformer.transform((Object)string)));
    }

    protected Transformer<String, String> buildCharDelimiter(char delimiter) {
        return new StringTools.CharDelimiter(delimiter);
    }

    @Override
    protected void verifyDelimit(String expected, String string, String delimiter) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.delimit((String)string, (String)delimiter));
    }

    @Override
    protected void verifyStringDelimiter(String expected, String string, String delimiter) {
        Transformer<String, String> transformer = this.buildStringDelimiter(delimiter);
        StringToolsTests.assertEquals((String)expected, (String)((String)transformer.transform((Object)string)));
    }

    protected Transformer<String, String> buildStringDelimiter(String string) {
        return new StringTools.StringDelimiter(string);
    }

    @Override
    protected void verifyRemoveFirstOccurrence(String expected, String string, char charToRemove) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.removeFirstOccurrence((String)string, (char)charToRemove));
    }

    @Override
    protected void verifyRemoveAllOccurrences(String expected, String string, char charToRemove) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.removeAllOccurrences((String)string, (char)charToRemove));
    }

    @Override
    protected void verifyRemoveAllSpaces(String expected, String string) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.removeAllSpaces((String)string));
    }

    @Override
    protected void verifyRemoveAllWhitespace(String expected, String string) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.removeAllWhitespace((String)string));
    }

    @Override
    protected void verifyCompressWhitespace(String expected, String string) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.compressWhitespace((String)string));
    }

    @Override
    protected void verifyCommonPrefixLength(int expected, String string1, String string2) {
        StringToolsTests.assertEquals((int)expected, (int)StringTools.commonPrefixLength((String)string1, (String)string2));
    }

    @Override
    protected void verifyCommonPrefixLengthMax(int expected, String string1, String string2, int max) {
        StringToolsTests.assertEquals((int)expected, (int)StringTools.commonPrefixLength((String)string1, (String)string2, (int)max));
    }

    @Override
    protected void verifyCapitalize(String expected, String string) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.capitalize((String)string));
        StringToolsTests.assertEquals((String)expected, (String)((String)StringTools.CAPITALIZER.transform((Object)string)));
    }

    @Override
    protected Object getCapitalizer() {
        return StringTools.CAPITALIZER;
    }

    @Override
    protected void verifyUncapitalize(String expected, String string) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.uncapitalize((String)string));
        StringToolsTests.assertEquals((String)expected, (String)((String)StringTools.UNCAPITALIZER.transform((Object)string)));
    }

    @Override
    protected Object getUncapitalizer() {
        return StringTools.UNCAPITALIZER;
    }

    @Override
    protected void verifyIsBlank(boolean expected, String string) {
        StringToolsTests.assertEquals((boolean)expected, (boolean)StringTools.isBlank((String)string));
        StringToolsTests.assertEquals((boolean)expected, (boolean)StringTools.IS_BLANK.evaluate((Object)string));
    }

    @Override
    protected Object getIsBlankPredicate() {
        return StringTools.IS_BLANK;
    }

    @Override
    protected void verifyIsNotBlank(boolean expected, String string) {
        StringToolsTests.assertEquals((boolean)expected, (boolean)StringTools.isNotBlank((String)string));
        StringToolsTests.assertEquals((boolean)expected, (boolean)StringTools.IS_NOT_BLANK.evaluate((Object)string));
    }

    @Override
    protected Object getIsNotBlankPredicate() {
        return StringTools.IS_NOT_BLANK;
    }

    @Override
    protected void verifyEqualsIgnoreCase(boolean expected, String string1, String string2) {
        StringToolsTests.assertEquals((boolean)expected, (boolean)StringTools.equalsIgnoreCase((String)string1, (String)string2));
    }

    @Override
    protected void verifyStartsWithIgnoreCase(boolean expected, String string, String prefix) {
        StringToolsTests.assertEquals((boolean)expected, (boolean)StringTools.startsWithIgnoreCase((String)string, (String)prefix));
        StringTools.StartsWithIgnoreCase predicate = new StringTools.StartsWithIgnoreCase(prefix);
        StringToolsTests.assertEquals((boolean)expected, (boolean)predicate.evaluate((Object)string));
    }

    @Override
    protected void verifyIsUppercase(String string) {
        StringToolsTests.assertTrue((boolean)StringTools.isUppercase((String)string));
    }

    @Override
    protected void denyIsUppercase(String string) {
        StringToolsTests.assertFalse((boolean)StringTools.isUppercase((String)string));
    }

    @Override
    protected void verifyIsLowercase(String string) {
        StringToolsTests.assertTrue((boolean)StringTools.isLowercase((String)string));
    }

    @Override
    protected void denyIsLowercase(String string) {
        StringToolsTests.assertFalse((boolean)StringTools.isLowercase((String)string));
    }

    @Override
    protected byte[] convertHexStringToByteArray(String string) {
        return StringTools.convertHexStringToByteArray((String)string);
    }

    @Override
    protected void verifyConvertCamelCaseToAllCaps(String expected, String string) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.convertCamelCaseToAllCaps((String)string));
    }

    @Override
    protected void verifyConvertCamelCaseToAllCapsMaxLength(String expected, String string, int max) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.convertCamelCaseToAllCaps((String)string, (int)max));
    }

    @Override
    protected void verifyConvertAllCapsToCamelCase(String expected, String string) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.convertAllCapsToCamelCase((String)string));
    }

    @Override
    protected void verifyConvertAllCapsToCamelCase(String expected, String string, boolean capFirst) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.convertAllCapsToCamelCase((String)string, (boolean)capFirst));
    }

    @Override
    protected void verifyIsQuoted(String string) {
        StringToolsTests.assertTrue((boolean)StringTools.isQuoted((String)string));
    }

    @Override
    protected void denyIsQuoted(String string) {
        StringToolsTests.assertFalse((boolean)StringTools.isQuoted((String)string));
    }

    @Override
    protected void verifyIsParenthetical(String string) {
        StringToolsTests.assertTrue((boolean)StringTools.isParenthetical((String)string));
    }

    @Override
    protected void denyIsParenthetical(String string) {
        StringToolsTests.assertFalse((boolean)StringTools.isParenthetical((String)string));
    }

    @Override
    protected void verifyIsBracketed(String string) {
        StringToolsTests.assertTrue((boolean)StringTools.isBracketed((String)string));
    }

    @Override
    protected void denyIsBracketed(String string) {
        StringToolsTests.assertFalse((boolean)StringTools.isBracketed((String)string));
    }

    @Override
    protected void verifyIsBraced(String string) {
        StringToolsTests.assertTrue((boolean)StringTools.isBraced((String)string));
    }

    @Override
    protected void denyIsBraced(String string) {
        StringToolsTests.assertFalse((boolean)StringTools.isBraced((String)string));
    }

    @Override
    protected void verifyIsChevroned(String string) {
        StringToolsTests.assertTrue((boolean)StringTools.isChevroned((String)string));
    }

    @Override
    protected void denyIsChevroned(String string) {
        StringToolsTests.assertFalse((boolean)StringTools.isChevroned((String)string));
    }

    @Override
    protected void verifyIsDelimited(String string, char c) {
        StringToolsTests.assertTrue((boolean)StringTools.isDelimited((String)string, (char)c));
    }

    @Override
    protected void denyIsDelimited(String string, char c) {
        StringToolsTests.assertFalse((boolean)StringTools.isDelimited((String)string, (char)c));
    }

    @Override
    protected void verifyIsDelimited2(String string, char start, char end) {
        StringToolsTests.assertTrue((boolean)StringTools.isDelimited((String)string, (char)start, (char)end));
    }

    @Override
    protected void denyIsDelimited2(String string, char start, char end) {
        StringToolsTests.assertFalse((boolean)StringTools.isDelimited((String)string, (char)start, (char)end));
    }

    @Override
    protected void verifyUndelimit(String expected, String string) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.undelimit((String)string));
    }

    @Override
    protected void verifyUndelimitInt(String expected, String string, int count) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.undelimit((String)string, (int)count));
    }

    @Override
    protected void verifyConvertToJavaStringLiteral(String expected, String string) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.convertToJavaStringLiteral((String)string));
        StringToolsTests.assertEquals((String)expected, (String)((String)StringTools.JAVA_STRING_LITERAL_TRANSFORMER.transform((Object)string)));
    }

    @Override
    protected Object getJavaStringLiteralTransformer() {
        return StringTools.JAVA_STRING_LITERAL_TRANSFORMER;
    }

    @Override
    protected void verifyConvertToJavaStringLiteralContent(String expected, String string) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.convertToJavaStringLiteralContent((String)string));
        StringToolsTests.assertEquals((String)expected, (String)((String)StringTools.JAVA_STRING_LITERAL_CONTENT_TRANSFORMER.transform((Object)string)));
    }

    @Override
    protected Object getJavaStringLiteralContentTransformer() {
        return StringTools.JAVA_STRING_LITERAL_CONTENT_TRANSFORMER;
    }

    @Override
    protected void verifyConvertToXmlAttributeValue(String expected, String string) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.convertToXmlAttributeValue((String)string));
        StringToolsTests.assertEquals((String)expected, (String)((String)StringTools.XML_ATTRIBUTE_VALUE_TRANSFORMER.transform((Object)string)));
    }

    @Override
    protected Object getXmlAttributeValueTransformer() {
        return StringTools.XML_ATTRIBUTE_VALUE_TRANSFORMER;
    }

    @Override
    protected void verifyConvertToDoubleQuotedXmlAttributeValue(String expected, String string) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.convertToDoubleQuotedXmlAttributeValue((String)string));
        StringToolsTests.assertEquals((String)expected, (String)((String)StringTools.DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE_TRANSFORMER.transform((Object)string)));
    }

    @Override
    protected Object getDoubleQuotedXmlAttributeValueTransformer() {
        return StringTools.DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE_TRANSFORMER;
    }

    @Override
    protected void verifyConvertToDoubleQuotedXmlAttributeValueContent(String expected, String string) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.convertToDoubleQuotedXmlAttributeValueContent((String)string));
        StringToolsTests.assertEquals((String)expected, (String)((String)StringTools.DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE_CONTENT_TRANSFORMER.transform((Object)string)));
    }

    @Override
    protected Object getDoubleQuotedXmlAttributeValueContentTransformer() {
        return StringTools.DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE_CONTENT_TRANSFORMER;
    }

    @Override
    protected void verifyConvertToSingleQuotedXmlAttributeValue(String expected, String string) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.convertToSingleQuotedXmlAttributeValue((String)string));
        StringToolsTests.assertEquals((String)expected, (String)((String)StringTools.SINGLE_QUOTED_XML_ATTRIBUTE_VALUE_TRANSFORMER.transform((Object)string)));
    }

    @Override
    protected Object getSingleQuotedXmlAttributeValueTransformer() {
        return StringTools.SINGLE_QUOTED_XML_ATTRIBUTE_VALUE_TRANSFORMER;
    }

    @Override
    protected void verifyConvertToSingleQuotedXmlAttributeValueContent(String expected, String string) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.convertToSingleQuotedXmlAttributeValueContent((String)string));
        StringToolsTests.assertEquals((String)expected, (String)((String)StringTools.SINGLE_QUOTED_XML_ATTRIBUTE_VALUE_CONTENT_TRANSFORMER.transform((Object)string)));
    }

    @Override
    protected Object getSingleQuotedXmlAttributeValueContentTransformer() {
        return StringTools.SINGLE_QUOTED_XML_ATTRIBUTE_VALUE_CONTENT_TRANSFORMER;
    }

    @Override
    protected void verifyConvertToXmlElementText(String expected, String string) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.convertToXmlElementText((String)string));
        StringToolsTests.assertEquals((String)expected, (String)((String)StringTools.XML_ELEMENT_TEXT_TRANSFORMER.transform((Object)string)));
    }

    @Override
    protected Object getXmlElementTextTransformer() {
        return StringTools.XML_ELEMENT_TEXT_TRANSFORMER;
    }

    @Override
    protected void verifyConvertToXmlElementCDATA(String expected, String string) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.convertToXmlElementCDATA((String)string));
        StringToolsTests.assertEquals((String)expected, (String)((String)StringTools.XML_ELEMENT_CDATA_TRANSFORMER.transform((Object)string)));
    }

    @Override
    protected Object getXmlElementCDATATransformer() {
        return StringTools.XML_ELEMENT_CDATA_TRANSFORMER;
    }

    @Override
    protected void verifyConvertToXmlElementCDATAContent(String expected, String string) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.convertToXmlElementCDATAContent((String)string));
        StringToolsTests.assertEquals((String)expected, (String)((String)StringTools.XML_ELEMENT_CDATA_CONTENT_TRANSFORMER.transform((Object)string)));
    }

    @Override
    protected Object getXmlElementCDATAContentTransformer() {
        return StringTools.XML_ELEMENT_CDATA_CONTENT_TRANSFORMER;
    }

    @Override
    protected Class<?> getToolsClass() {
        return StringTools.class;
    }

    public void testCharArrayTransformer() throws Exception {
        Transformer transformer = StringTools.CHAR_ARRAY_TRANSFORMER;
        TestTools.assertEquals("foo", (char[])transformer.transform((Object)"foo"));
        StringToolsTests.assertEquals((String)"CharArrayTransformer", (String)transformer.toString());
        StringToolsTests.assertSame((Object)transformer, (Object)TestTools.serialize(transformer));
    }
}

