/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.dom;

import junit.framework.TestCase;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.document.NodeListImpl;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;

public class NodeListImplTests
extends TestCase {
    public NodeListImplTests() {
    }

    public NodeListImplTests(String name) {
        super(name);
    }

    public void testInsertAtIndex() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        IDOMDocument document = model.getDocument();
        AccessorNodeList list = new AccessorNodeList();
        NodeListImplTests.assertEquals((String)"non-zero length at start", (int)0, (int)list.getLength());
        list.appendNode(document.createElement("test0"));
        list.appendNode(document.createElement("test1"));
        list.appendNode(document.createElement("test2"));
        list.appendNode(document.createElement("test3"));
        list.appendNode(document.createElement("test4"));
        list.appendNode(document.createElement("test5"));
        list.appendNode(document.createElement("test6"));
        list.insertNode(document.createElement("test"), 3);
        NodeListImplTests.assertEquals((String)"list size did not increment", (int)8, (int)list.getLength());
        NodeListImplTests.assertEquals((String)"test0 was not at expected index", (String)"test0", (String)list.item(0).getLocalName());
        NodeListImplTests.assertEquals((String)"test1 was not at expected index", (String)"test1", (String)list.item(1).getLocalName());
        NodeListImplTests.assertEquals((String)"test2 was not at expected index", (String)"test2", (String)list.item(2).getLocalName());
        NodeListImplTests.assertEquals((String)"test was not at expected index", (String)"test", (String)list.item(3).getLocalName());
        NodeListImplTests.assertEquals((String)"test3 was not at expected index", (String)"test3", (String)list.item(4).getLocalName());
        NodeListImplTests.assertEquals((String)"test4 was not at expected index", (String)"test4", (String)list.item(5).getLocalName());
        NodeListImplTests.assertEquals((String)"test5 was not at expected index", (String)"test5", (String)list.item(6).getLocalName());
        NodeListImplTests.assertEquals((String)"test6 was not at expected index", (String)"test6", (String)list.item(7).getLocalName());
    }

    public void testRemoveFromIndex() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        IDOMDocument document = model.getDocument();
        AccessorNodeList list = new AccessorNodeList();
        list.appendNode(document.createElement("test0"));
        list.appendNode(document.createElement("test1"));
        list.appendNode(document.createElement("test2"));
        list.appendNode(document.createElement("test3"));
        list.appendNode(document.createElement("test4"));
        list.appendNode(document.createElement("test5"));
        list.appendNode(document.createElement("test6"));
        NodeListImplTests.assertEquals((String)"wrong length after setup", (int)7, (int)list.getLength());
        Node excised = list.removeNode(3);
        NodeListImplTests.assertEquals((String)"test3 was not the one removed", (String)"test3", (String)excised.getLocalName());
        NodeListImplTests.assertEquals((String)"wrong length after removal", (int)6, (int)list.getLength());
        NodeListImplTests.assertEquals((String)"test0 was not at expected index", (String)"test0", (String)list.item(0).getLocalName());
        NodeListImplTests.assertEquals((String)"test1 was not at expected index", (String)"test1", (String)list.item(1).getLocalName());
        NodeListImplTests.assertEquals((String)"test2 was not at expected index", (String)"test2", (String)list.item(2).getLocalName());
        NodeListImplTests.assertEquals((String)"test4 was not at expected index", (String)"test4", (String)list.item(3).getLocalName());
        NodeListImplTests.assertEquals((String)"test5 was not at expected index", (String)"test5", (String)list.item(4).getLocalName());
        NodeListImplTests.assertEquals((String)"test6 was not at expected index", (String)"test6", (String)list.item(5).getLocalName());
    }

    public void testInsertAtNegativeIndex() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        IDOMDocument document = model.getDocument();
        AccessorNodeList list = new AccessorNodeList();
        list.insertNode(document.createElement("test-1"), -1);
        NodeListImplTests.assertEquals((String)"wrong length after insert at negative index", (int)1, (int)list.getLength());
    }

    public void testRemoveFromNegativeIndex() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        IDOMDocument document = model.getDocument();
        AccessorNodeList list = new AccessorNodeList();
        list.appendNode(document.createElement("test-1"));
        list.removeNode(-1);
        NodeListImplTests.assertEquals((String)"wrong length after removal at negative index", (int)1, (int)list.getLength());
    }

    public void testInsertAtExcessiveIndex() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        IDOMDocument document = model.getDocument();
        AccessorNodeList list = new AccessorNodeList();
        list.insertNode(document.createElement("test3"), 3);
        NodeListImplTests.assertEquals((String)"wrong length after insert at out of bounds index", (int)1, (int)list.getLength());
    }

    public void testRemoveFromExcessiveIndex() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        IDOMDocument document = model.getDocument();
        AccessorNodeList list = new AccessorNodeList();
        list.appendNode(document.createElement("test0"));
        list.removeNode(3);
        NodeListImplTests.assertEquals((String)"wrong length after removal at nonexistent index", (int)1, (int)list.getLength());
    }

    public void testAppend() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        IDOMDocument document = model.getDocument();
        AccessorNodeList list = new AccessorNodeList();
        NodeListImplTests.assertEquals((String)"non-zero length at start", (int)0, (int)list.getLength());
        list.appendNode(document.createElement("test1"));
        NodeListImplTests.assertEquals((String)"list size did not increment", (int)1, (int)list.getLength());
        list.appendNode(document.createElement("test2"));
        NodeListImplTests.assertEquals((String)"list size did not increment", (int)2, (int)list.getLength());
        list.appendNode(document.createElement("test3"));
        NodeListImplTests.assertEquals((String)"list size did not increment", (int)3, (int)list.getLength());
        Node element4 = list.appendNode(document.createElement("test4"));
        NodeListImplTests.assertEquals((String)"list size did not increment", (int)4, (int)list.getLength());
        NodeListImplTests.assertEquals((String)"test4 not returned from append", (String)"test4", (String)element4.getLocalName());
        Node element5 = list.appendNode(document.createElement("test5"));
        NodeListImplTests.assertEquals((String)"list size did not increment", (int)5, (int)list.getLength());
        NodeListImplTests.assertEquals((String)"test5 not returned from append", (String)"test5", (String)element5.getLocalName());
        Node element6 = list.appendNode(document.createElement("test6"));
        NodeListImplTests.assertEquals((String)"list size did not increment", (int)6, (int)list.getLength());
        NodeListImplTests.assertEquals((String)"test6 not returned from append", (String)"test6", (String)element6.getLocalName());
        Node element7 = list.appendNode(document.createElement("test7"));
        NodeListImplTests.assertEquals((String)"list size did not increment", (int)7, (int)list.getLength());
        NodeListImplTests.assertEquals((String)"test7 not returned from append", (String)"test7", (String)element7.getLocalName());
    }

    private static class AccessorNodeList
    extends NodeListImpl {
        private AccessorNodeList() {
        }

        public Node appendNode(Node node) {
            return super.appendNode(node);
        }

        public Node insertNode(Node node, int index) {
            return super.insertNode(node, index);
        }

        public Node removeNode(int index) {
            return super.removeNode(index);
        }
    }
}

