/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.contentoutline;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wst.html.core.internal.HTMLContentBuilder;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.html.core.internal.format.HTMLFormatProcessorImpl;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeIdForHTML;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMContentBuilder;
import org.eclipse.wst.xml.ui.internal.contentoutline.XMLNodeActionManager;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class HTMLNodeActionManager
extends XMLNodeActionManager {
    protected int fTagCase;
    protected int fAttrCase;

    public HTMLNodeActionManager(IStructuredModel model, Viewer viewer) {
        super(model, viewer);
        this.updateCase();
    }

    public DOMContentBuilder createDOMContentBuilder(Document document) {
        String modelContentTypeId;
        Object builder = null;
        String one = this.fModel.getModelHandler().getAssociatedContentTypeId();
        if (one != (modelContentTypeId = this.fModel.getContentTypeIdentifier())) {
            System.out.println("not equal");
        }
        builder = modelContentTypeId.equals(ContentTypeIdForHTML.ContentTypeID_HTML) ? new HTMLContentBuilder(document) : super.createDOMContentBuilder(document);
        return builder;
    }

    private boolean shouldIgnoreCase(CMNode cmnode) {
        if (!cmnode.supports("shouldIgnoreCase")) {
            return false;
        }
        return (Boolean)cmnode.getProperty("shouldIgnoreCase");
    }

    public String getLabel(Node parent, CMNode cmnode) {
        String result = null;
        if (this.shouldIgnoreCase(cmnode)) {
            String name = cmnode.getNodeName();
            if (cmnode.getNodeType() == 5) {
                if (this.fTagCase == 1) {
                    name = name.toLowerCase();
                } else if (this.fTagCase == 2) {
                    name = name.toUpperCase();
                }
            } else if (cmnode.getNodeType() == 2) {
                if (this.fAttrCase == 1) {
                    name = name.toLowerCase();
                } else if (this.fAttrCase == 2) {
                    name = name.toUpperCase();
                }
            }
            result = name;
        } else {
            result = super.getLabel(parent, cmnode);
        }
        return result;
    }

    protected void updateCase() {
        String modelContentTypeId;
        if (this.fModel != null && (modelContentTypeId = this.fModel.getContentTypeIdentifier()) != null && modelContentTypeId.equals(ContentTypeIdForHTML.ContentTypeID_HTML)) {
            Preferences prefs = HTMLCorePlugin.getDefault().getPluginPreferences();
            this.fTagCase = prefs.getInt("tagNameCase");
            this.fAttrCase = prefs.getInt("attrNameCase");
        }
    }

    public void reformat(Node newElement, boolean deep) {
        try {
            this.fModel.aboutToChangeModel();
            HTMLFormatProcessorImpl formatProcessor = new HTMLFormatProcessorImpl();
            formatProcessor.formatNode(newElement);
        }
        finally {
            this.fModel.changedModel();
        }
    }
}

