/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.common.util.TypeUtil;

public class JDTTypeResolver {
    private final Map<String, IType> resolvedTypes = new HashMap<String, IType>();
    private final IType type;
    private final IType[] superTypes;

    public JDTTypeResolver(IType type, IType[] superTypes) {
        this.type = type;
        this.superTypes = superTypes;
    }

    public String resolveMethodEraseTypeParams(String unresolvedSignature) {
        return this.resolveMethod(unresolvedSignature, TypeParameters.ERASE);
    }

    public String resolveMethodKeepTypeParams(String unresolvedSignature) {
        return this.resolveMethod(unresolvedSignature, TypeParameters.KEEP);
    }

    private String resolveMethod(String unresolvedSignature, TypeParameters eraseTypeParameters) {
        String unresolvedSignatureNormalized = unresolvedSignature.replaceAll("/", ".");
        String[] parameters = Signature.getParameterTypes((String)unresolvedSignatureNormalized);
        int i = 0;
        while (i < parameters.length) {
            parameters[i] = this.resolve(parameters[i], eraseTypeParameters);
            ++i;
        }
        String resolvedReturn = this.resolve(Signature.getReturnType((String)unresolvedSignatureNormalized), eraseTypeParameters);
        return Signature.createMethodSignature((String[])parameters, (String)resolvedReturn);
    }

    public String resolveEraseTypeParams(String unresolvedSignature) {
        return this.resolve(unresolvedSignature, TypeParameters.ERASE);
    }

    public String resolveKeepTypeParams(String unresolvedSignature) {
        return this.resolve(unresolvedSignature, TypeParameters.KEEP);
    }

    private String resolve(String unresolvedSignature, TypeParameters eraseTypeParameters) {
        int sigKind = Signature.getTypeSignatureKind((String)unresolvedSignature);
        switch (sigKind) {
            case 2: {
                return unresolvedSignature;
            }
            case 4: {
                String elementType = Signature.getElementType((String)unresolvedSignature);
                if (Signature.getTypeSignatureKind((String)elementType) == 2) {
                    return unresolvedSignature;
                }
                String resolvedElementType = this.resolveRelative(elementType, eraseTypeParameters);
                String resultType = "";
                int i = 0;
                while (i < Signature.getArrayCount((String)unresolvedSignature)) {
                    resultType = String.valueOf(resultType) + '[';
                    ++i;
                }
                return String.valueOf(resultType) + resolvedElementType;
            }
            case 3: {
                return this.resolveRelative(unresolvedSignature, eraseTypeParameters);
            }
            case 1: {
                return this.resolveRelative(unresolvedSignature, eraseTypeParameters);
            }
            case 5: {
                if (unresolvedSignature.charAt(0) == '*') {
                    return "Ljava.lang.Object;";
                }
                return this.resolve(unresolvedSignature.substring(1), eraseTypeParameters);
            }
            case 6: {
                return this.resolve(Signature.removeCapture((String)unresolvedSignature), eraseTypeParameters);
            }
        }
        return unresolvedSignature;
    }

    private String resolveRelative(String typeSignature, TypeParameters eraseTypeParameters) {
        ITypeParameter typeParam;
        if (typeSignature.charAt(0) == 'L') {
            return typeSignature;
        }
        ArrayList<String> typeParameters = new ArrayList<String>();
        IType resolvedType = this.resolveType(typeSignature);
        if (resolvedType != null) {
            if (eraseTypeParameters == TypeParameters.KEEP) {
                String[] stringArray = Signature.getTypeArguments((String)typeSignature);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String typeParam2 = stringArray[n2];
                    if (Signature.getTypeSignatureKind((String)(typeParam2 = Signature.removeCapture((String)typeParam2))) == 5) {
                        typeParam2 = typeParam2.charAt(0) == '*' ? "Ljava.lang.Object;" : typeParam2.substring(1);
                    }
                    String resolvedParameter = this.resolveRelative(typeParam2, eraseTypeParameters);
                    typeParameters.add(resolvedParameter);
                    ++n2;
                }
            }
            String resolvedTypeSignature = Signature.createTypeSignature((String)resolvedType.getFullyQualifiedName(), (boolean)true);
            if (typeParameters.size() > 0 && eraseTypeParameters == TypeParameters.KEEP) {
                StringBuffer sb = new StringBuffer(resolvedTypeSignature);
                if (sb.charAt(sb.length() - 1) == ';') {
                    sb = sb.delete(sb.length() - 1, sb.length());
                }
                sb.append("<");
                for (String param : typeParameters) {
                    sb.append(param);
                }
                sb.append(">;");
                return sb.toString();
            }
            return resolvedTypeSignature;
        }
        if ((Signature.getTypeSignatureKind((String)typeSignature) == 1 || Signature.getTypeSignatureKind((String)typeSignature) == 3) && (typeParam = this.type.getTypeParameter(Signature.getSignatureSimpleName((String)typeSignature))).exists()) {
            return "Ljava.lang.Object;";
        }
        return typeSignature;
    }

    private IType resolveType(String typeSignature) {
        String typeName = TypeUtil.getFullyQualifiedName(typeSignature);
        return this.resolveTypeName(typeName);
    }

    IType resolveTypeName(String typeName) {
        IType resolved = this.resolvedTypes.get(typeName);
        if (resolved != null) {
            return resolved;
        }
        resolved = this.resolveTypeNameRelative(typeName);
        this.resolvedTypes.put(typeName, resolved);
        return resolved;
    }

    private IType resolveTypeNameRelative(String typeName) {
        try {
            String[][] resolved = this.type.resolveType(typeName);
            if (resolved != null && resolved.length > 0) {
                return this.type.getJavaProject().findType(resolved[0][0], resolved[0][1]);
            }
            return this.resolveInParents(typeName);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    private IType resolveInParents(String fullyQualifiedName) throws JavaModelException {
        IType[] iTypeArray = this.superTypes;
        int n = this.superTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType superType = iTypeArray[n2];
            String[][] resolved = superType.resolveType(fullyQualifiedName);
            if (resolved != null && resolved.length > 0) {
                return this.type.getJavaProject().findType(resolved[0][0], resolved[0][1]);
            }
            ++n2;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TypeParameters {
        ERASE,
        KEEP;

    }
}

