/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.deque;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.eclipse.jpt.common.utility.deque.Deque;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

public class LinkedDeque<E>
implements Deque<E>,
Cloneable,
Serializable {
    private final NodeFactory<E> nodeFactory;
    private transient Node<E> head;
    private transient Node<E> tail;
    private static final long serialVersionUID = 1L;

    public LinkedDeque() {
        this(0);
    }

    public LinkedDeque(int cacheSize) {
        this(LinkedDeque.buildNodeFactory(cacheSize));
        this.head = null;
    }

    private static <E> NodeFactory<E> buildNodeFactory(int cacheSize) {
        if (cacheSize < -1) {
            throw new IllegalArgumentException("Cache size must be greater than or equal to -1: " + cacheSize);
        }
        return cacheSize == 0 ? SimpleNodeFactory.instance() : new CachingNodeFactory(cacheSize);
    }

    private LinkedDeque(NodeFactory<E> nodeFactory) {
        this.nodeFactory = nodeFactory;
        this.head = null;
        this.tail = null;
    }

    @Override
    public void enqueueTail(E element) {
        Node<E> newNode = this.nodeFactory.buildNode(element, null, this.tail);
        if (this.tail == null) {
            this.head = newNode;
        } else {
            this.tail.next = newNode;
        }
        this.tail = newNode;
    }

    @Override
    public void enqueueHead(E element) {
        Node<E> newNode = this.nodeFactory.buildNode(element, this.head, null);
        if (this.head == null) {
            this.tail = newNode;
        } else {
            this.head.prev = newNode;
        }
        this.head = newNode;
    }

    @Override
    public E dequeueHead() {
        if (this.head == null) {
            throw new NoSuchElementException();
        }
        Node<E> node = this.head;
        this.head = node.next;
        if (this.head == null) {
            this.tail = null;
        } else {
            this.head.prev = null;
        }
        Object element = node.element;
        this.nodeFactory.release(node);
        return element;
    }

    @Override
    public E dequeueTail() {
        if (this.tail == null) {
            throw new NoSuchElementException();
        }
        Node<E> node = this.tail;
        this.tail = node.prev;
        if (this.tail == null) {
            this.head = null;
        } else {
            this.tail.next = null;
        }
        Object element = node.element;
        this.nodeFactory.release(node);
        return element;
    }

    @Override
    public E peekHead() {
        if (this.head == null) {
            throw new NoSuchElementException();
        }
        return this.head.element;
    }

    @Override
    public E peekTail() {
        if (this.tail == null) {
            throw new NoSuchElementException();
        }
        return this.tail.element;
    }

    @Override
    public boolean isEmpty() {
        return this.head == null;
    }

    public LinkedDeque<E> clone() {
        E[] elements;
        LinkedDeque<E> clone = new LinkedDeque<E>(this.nodeFactory.copy());
        E[] EArray = elements = this.buildElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            E element = EArray[n2];
            clone.enqueueTail(element);
            ++n2;
        }
        return clone;
    }

    private E[] buildElements() {
        int size = this.size();
        if (size == 0) {
            return ObjectTools.EMPTY_OBJECT_ARRAY;
        }
        Object[] elements = new Object[size];
        int i = 0;
        Node<E> node = this.head;
        while (node != null) {
            elements[i++] = node.element;
            node = node.next;
        }
        return elements;
    }

    private int size() {
        int size = 0;
        Node<E> node = this.head;
        while (node != null) {
            ++size;
            node = node.next;
        }
        return size;
    }

    public String toString() {
        return Arrays.toString(this.buildElements());
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        E[] elements = this.buildElements();
        stream.writeInt(elements.length);
        E[] EArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            E element = EArray[n2];
            stream.writeObject(element);
            ++n2;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int len;
        stream.defaultReadObject();
        int i = len = stream.readInt();
        while (i-- > 0) {
            this.enqueueTail(stream.readObject());
        }
    }

    private static final class CachingNodeFactory<E>
    extends NodeFactory<E>
    implements Serializable {
        private final int maxCacheSize;
        private transient int cacheSize = 0;
        private transient Node<E> cacheHead;
        private static final long serialVersionUID = 1L;

        CachingNodeFactory(int maxCacheSize) {
            this.maxCacheSize = maxCacheSize;
        }

        @Override
        Node<E> buildNode(E element, Node<E> next, Node<E> prev) {
            if (this.cacheHead == null) {
                return super.buildNode(element, next, prev);
            }
            Node<E> node = this.cacheHead;
            this.cacheHead = node.next;
            --this.cacheSize;
            node.element = element;
            node.next = next;
            return node;
        }

        @Override
        void release(Node<E> node) {
            if (this.maxCacheSize == -1 || this.cacheSize < this.maxCacheSize) {
                node.element = null;
                node.next = this.cacheHead;
                node.prev = null;
                this.cacheHead = node;
                ++this.cacheSize;
            }
        }

        @Override
        NodeFactory<E> copy() {
            return new CachingNodeFactory<E>(this.maxCacheSize);
        }

        public String toString() {
            return ObjectTools.toString((Object)this, this.cacheSize);
        }
    }

    private static final class Node<E> {
        E element;
        Node<E> next;
        Node<E> prev;

        Node(E element, Node<E> next, Node<E> prev) {
            this.element = element;
            this.next = next;
            this.prev = prev;
        }

        public String toString() {
            return ObjectTools.toString((Object)this, this.element);
        }
    }

    private static abstract class NodeFactory<E> {
        NodeFactory() {
        }

        Node<E> buildNode(E element, Node<E> next, Node<E> prev) {
            return new Node<E>(element, next, prev);
        }

        abstract void release(Node<E> var1);

        abstract NodeFactory<E> copy();
    }

    private static class SimpleNodeFactory<E>
    extends NodeFactory<E>
    implements Serializable {
        public static final NodeFactory INSTANCE = new SimpleNodeFactory();
        private static final long serialVersionUID = 1L;

        public static <E> NodeFactory<E> instance() {
            return INSTANCE;
        }

        private SimpleNodeFactory() {
        }

        @Override
        void release(Node<E> node) {
        }

        @Override
        NodeFactory<E> copy() {
            return this;
        }

        public String toString() {
            return ObjectTools.singletonToString(this);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

