/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.parser.disco;

import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.wst.ws.internal.parser.disco.DISCOContractReference;
import org.eclipse.wst.ws.internal.parser.disco.DISCOReference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DISCOParser {
    private DocumentBuilder parser_;
    private final String NS_DISCO = "http://schemas.xmlsoap.org/disco/";
    private final String DISCOVERY = "discovery";
    private final String DISCOVERY_REF = "discoveryRef";
    private final String NS_CONTRACT_REF = "http://schemas.xmlsoap.org/disco/scl/";
    private final String CONTRACT_REF = "contractRef";
    private final String REF = "ref";
    private final String DOC_REF = "docRef";

    public DISCOParser() {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            this.parser_ = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.parser_ = null;
        }
    }

    public DISCOReference[] parse(String discoURI, InputSource source) throws Exception {
        if (this.parser_ != null) {
            Document doc = this.parser_.parse(source);
            Element rootElement = doc.getDocumentElement();
            if (rootElement != null && rootElement.getNamespaceURI().equals("http://schemas.xmlsoap.org/disco/") && rootElement.getLocalName().equals("discovery")) {
                NodeList childNodes = rootElement.getChildNodes();
                Vector<DISCOReference> discoReferences = new Vector<DISCOReference>();
                int i = 0;
                while (i < childNodes.getLength()) {
                    Node childNode = childNodes.item(i);
                    if (childNode instanceof Element) {
                        String ref;
                        Element element = (Element)childNode;
                        String localName = element.getLocalName();
                        String nsURI = element.getNamespaceURI();
                        if (nsURI.equals("http://schemas.xmlsoap.org/disco/") && localName.equals("discoveryRef")) {
                            ref = this.convertToAbsoluteURI(discoURI, element.getAttribute("ref"));
                            discoReferences.addElement(new DISCOReference(ref));
                        } else if (nsURI.equals("http://schemas.xmlsoap.org/disco/scl/") && localName.equals("contractRef")) {
                            ref = this.convertToAbsoluteURI(discoURI, element.getAttribute("ref"));
                            String docRef = this.convertToAbsoluteURI(discoURI, element.getAttribute("docRef"));
                            discoReferences.addElement(new DISCOContractReference(ref, docRef));
                        }
                    }
                    ++i;
                }
                int numberOfDISCOReferences = discoReferences.size();
                if (numberOfDISCOReferences > 0) {
                    Object[] references = new DISCOReference[numberOfDISCOReferences];
                    discoReferences.copyInto(references);
                    return references;
                }
            } else {
                throw new Exception();
            }
        }
        return null;
    }

    private String convertToAbsoluteURI(String discoURI, String refURI) {
        if (refURI != null) {
            if (refURI.indexOf("://") > -1) {
                return refURI;
            }
            StringBuffer absoluteURI = new StringBuffer(discoURI.substring(0, Math.max(discoURI.lastIndexOf(92), discoURI.lastIndexOf(47) + 1)));
            absoluteURI.append(refURI);
            return absoluteURI.toString();
        }
        return null;
    }
}

