/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.ui.actions.FindReferencesAction;
import org.eclipse.wst.jsdt.ui.search.ElementQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.QuerySpecification;

public class FindReferencesInHierarchyAction
extends FindReferencesAction {
    public FindReferencesInHierarchyAction(IWorkbenchSite site) {
        super(site);
    }

    public FindReferencesInHierarchyAction(JavaEditor editor) {
        super(editor);
    }

    @Override
    Class[] getValidTypes() {
        return new Class[]{IJavaScriptUnit.class, IType.class, IFunction.class, IField.class, ILocalVariable.class};
    }

    @Override
    void init() {
        this.setText(SearchMessages.Search_FindHierarchyReferencesAction_label);
        this.setToolTipText(SearchMessages.Search_FindHierarchyReferencesAction_tooltip);
        this.setImageDescriptor(JavaPluginImages.DESC_OBJS_SEARCH_REF);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.find_references_in_hierarchy_action");
    }

    @Override
    QuerySpecification createQuery(IJavaScriptElement element) throws JavaScriptModelException, InterruptedException {
        IType type = this.getType(element);
        if (type == null) {
            return super.createQuery(element);
        }
        JavaSearchScopeFactory factory = JavaSearchScopeFactory.getInstance();
        IJavaScriptSearchScope scope = SearchEngine.createHierarchyScope((IType)type);
        String description = factory.getHierarchyScopeDescription(type);
        return new ElementQuerySpecification(element, this.getLimitTo(), scope, description);
    }
}

