/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.collection;

import java.util.Collection;
import org.eclipse.jpt.common.utility.collection.Bag;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.internal.collection.SynchronizedBag;
import org.eclipse.jpt.common.utility.tests.internal.collection.BagTests;

public class SynchronizedBagTests
extends BagTests {
    public SynchronizedBagTests(String name) {
        super(name);
    }

    @Override
    protected Bag<String> buildBag_() {
        return CollectionTools.synchronizedBag();
    }

    @Override
    protected Bag<String> buildBag(Collection<String> c) {
        return CollectionTools.synchronizedBag((Bag)new HashBag(c));
    }

    @Override
    protected Bag<String> buildBag(int initialCapacity, float loadFactor) {
        return CollectionTools.synchronizedBag((Bag)new HashBag(initialCapacity, loadFactor));
    }

    @Override
    public void testClone() {
    }

    public void testCtorBagObject_nullBag() {
        boolean exCaught = false;
        try {
            SynchronizedBag bag = CollectionTools.synchronizedBag(null, (Object)"foo");
            SynchronizedBagTests.fail((String)("bogus bag: " + bag));
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        SynchronizedBagTests.assertTrue((boolean)exCaught);
    }

    public void testCtorBagObject_nullMutex() {
        HashBag wrapped = CollectionTools.hashBag();
        boolean exCaught = false;
        try {
            SynchronizedBag bag = CollectionTools.synchronizedBag((Bag)wrapped, null);
            SynchronizedBagTests.fail((String)("bogus bag: " + bag));
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        SynchronizedBagTests.assertTrue((boolean)exCaught);
    }

    public void testCtorBag_nullBag() {
        boolean exCaught = false;
        try {
            SynchronizedBag bag = CollectionTools.synchronizedBag(null);
            SynchronizedBagTests.fail((String)("bogus bag: " + bag));
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        SynchronizedBagTests.assertTrue((boolean)exCaught);
    }
}

