/* The following code was generated by JFlex 1.4.3 on 04-04-13 11:19 */

// *******************************************************************************
// * Copyright (c) 2005, 2009 Andrea Bittau, University College London, and others
// * All rights reserved. This program and the accompanying materials
// * are made available under the terms of the Eclipse Public License v1.0
// * which accompanies this distribution, and is available at
// * http://www.eclipse.org/legal/epl-v10.html
// *
// * Contributors:
// *     Andrea Bittau - initial API and implementation from the PsychoPath XPath 2.0
// *     David Carver - bug 280987 - fixed literal issues for integer and decimal
// *     Jesper S Moller - bug 283214 - fix IF THEN ELSE parsing and update grammars
// *     Jesper S Moller - bug 286061   correct handling of quoted string 
// *     Jesper Moller - bug 297707 - Missing the empty-sequence() type
// *     Jesper Moller - bug 388504 - XPath scanner does not detect non-ASCII names
// *******************************************************************************/


package org.eclipse.wst.xml.xpath2.processor.internal;

import java_cup.runtime.*;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.3
 * on 04-04-13 11:19 from the specification file
 * <tt>/Users/jesper/Eclipse/Repositories/webtools.sourceediting.xpath/bundles/org.eclipse.wst.xml.xpath2.processor/grammars/xpath.lex</tt>
 */
class XPathFlex implements java_cup.runtime.Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int COMMENT = 2;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1, 1
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\1\1\1\2\0\1\1\22\0\1\1\1\25\1\2\1\0"+
    "\1\33\2\0\1\3\1\15\1\21\1\22\1\7\1\32\1\14\1\5"+
    "\1\30\12\4\1\16\1\0\1\26\1\24\1\27\1\34\1\31\4\12"+
    "\1\13\25\12\1\17\1\0\1\20\1\0\1\12\1\0\1\44\1\47"+
    "\1\35\1\41\1\6\1\51\1\54\1\36\1\37\2\12\1\40\1\55"+
    "\1\43\1\52\1\56\1\57\1\46\1\42\1\45\1\50\1\60\1\53"+
    "\1\61\1\62\1\12\1\0\1\23\103\0\27\12\1\0\37\12\1\0"+
    "\u0208\12\160\0\16\12\1\0\u1c81\12\14\0\2\12\142\0\u0120\12\u0a70\0"+
    "\u03f0\12\21\0\ua7ff\12\u0400\10\u0400\11\u1900\0\u04d0\12\40\0\u020e\12\2\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\2\0\1\1\1\2\2\1\1\3\1\4\1\5\1\6"+
    "\1\1\1\5\1\7\1\10\1\11\1\12\1\13\1\14"+
    "\1\15\1\16\1\17\1\1\1\20\1\21\1\22\1\23"+
    "\1\24\1\25\1\26\17\5\2\2\1\0\1\27\1\0"+
    "\1\27\1\30\1\0\1\31\1\0\2\5\1\32\2\5"+
    "\1\33\1\34\1\35\1\36\1\37\1\40\1\41\1\42"+
    "\4\5\1\43\1\44\1\5\1\45\1\46\1\47\7\5"+
    "\1\50\2\5\1\51\5\5\1\52\4\5\1\53\1\54"+
    "\1\55\1\56\3\5\1\57\1\60\1\61\1\0\15\5"+
    "\1\62\10\5\1\63\10\5\1\64\1\65\4\5\1\66"+
    "\4\5\1\67\1\5\1\70\2\5\1\71\2\5\1\72"+
    "\2\5\1\73\1\5\1\74\2\5\1\75\1\76\12\5"+
    "\1\77\1\5\1\100\13\5\1\101\2\5\1\102\6\5"+
    "\1\103\14\5\1\104\1\5\1\105\2\5\1\106\2\5"+
    "\1\107\16\5\1\110\1\111\7\5\1\112\6\5\1\113"+
    "\4\5\1\114\1\115\1\5\1\116\1\5\1\117\1\120"+
    "\2\5\1\121\4\5\1\122\27\5\1\123\6\5\1\124"+
    "\1\5\1\125\14\5\1\126\1\127\4\5\1\130\1\131"+
    "\1\5\1\132\4\5\1\133";

  private static int [] zzUnpackAction() {
    int [] result = new int[335];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\63\0\146\0\146\0\231\0\314\0\377\0\u0132"+
    "\0\u0165\0\146\0\u0198\0\u01cb\0\146\0\u01fe\0\u0231\0\146"+
    "\0\146\0\146\0\146\0\146\0\146\0\u0264\0\u0297\0\u02ca"+
    "\0\u02fd\0\146\0\146\0\146\0\146\0\u0330\0\u0363\0\u0396"+
    "\0\u03c9\0\u03fc\0\u042f\0\u0462\0\u0495\0\u04c8\0\u04fb\0\u052e"+
    "\0\u0561\0\u0594\0\u05c7\0\u05fa\0\u062d\0\u0660\0\231\0\u0693"+
    "\0\314\0\u06c6\0\u06f9\0\u072c\0\146\0\u0198\0\u075f\0\u0792"+
    "\0\u01cb\0\u07c5\0\u07f8\0\146\0\146\0\146\0\146\0\146"+
    "\0\146\0\146\0\146\0\u082b\0\u085e\0\u0891\0\u08c4\0\u01cb"+
    "\0\u08f7\0\u092a\0\u01cb\0\u01cb\0\u01cb\0\u095d\0\u0990\0\u09c3"+
    "\0\u09f6\0\u0a29\0\u0a5c\0\u0a8f\0\u01cb\0\u0ac2\0\u0af5\0\u01cb"+
    "\0\u0b28\0\u0b5b\0\u0b8e\0\u0bc1\0\u0bf4\0\u01cb\0\u0c27\0\u0c5a"+
    "\0\u0c8d\0\u0cc0\0\u01cb\0\u01cb\0\u01cb\0\u01cb\0\u0cf3\0\u0d26"+
    "\0\u0d59\0\146\0\146\0\u0d8c\0\u0d8c\0\u0dbf\0\u0df2\0\u0e25"+
    "\0\u0e58\0\u0e8b\0\u0ebe\0\u0ef1\0\u0f24\0\u0f57\0\u0f8a\0\u0fbd"+
    "\0\u0ff0\0\u1023\0\u01cb\0\u1056\0\u1089\0\u10bc\0\u10ef\0\u1122"+
    "\0\u1155\0\u1188\0\u11bb\0\u01cb\0\u11ee\0\u1221\0\u1254\0\u1287"+
    "\0\u12ba\0\u12ed\0\u1320\0\u1353\0\u01cb\0\u01cb\0\u1386\0\u13b9"+
    "\0\u13ec\0\u141f\0\u01cb\0\u1452\0\u1485\0\u14b8\0\u14eb\0\u151e"+
    "\0\u1551\0\u01cb\0\u1584\0\u15b7\0\u01cb\0\u15ea\0\u161d\0\u01cb"+
    "\0\u1650\0\u1683\0\u01cb\0\u16b6\0\u01cb\0\u16e9\0\u171c\0\u01cb"+
    "\0\u01cb\0\u174f\0\u1782\0\u17b5\0\u17e8\0\u181b\0\u184e\0\u1881"+
    "\0\u18b4\0\u18e7\0\u191a\0\u01cb\0\u194d\0\u01cb\0\u1980\0\u19b3"+
    "\0\u19e6\0\u1a19\0\u1a4c\0\u1a7f\0\u1ab2\0\u1ae5\0\u1b18\0\u1b4b"+
    "\0\u1b7e\0\u01cb\0\u1bb1\0\u1be4\0\u01cb\0\u1c17\0\u1c4a\0\u1c7d"+
    "\0\u1cb0\0\u1ce3\0\u1d16\0\u01cb\0\u1d49\0\u1d7c\0\u1daf\0\u1de2"+
    "\0\u1e15\0\u1e48\0\u1e7b\0\u1eae\0\u1ee1\0\u1f14\0\u1f47\0\u1f7a"+
    "\0\u01cb\0\u1fad\0\u01cb\0\u1fe0\0\u2013\0\u01cb\0\u2046\0\u2079"+
    "\0\u01cb\0\u20ac\0\u20df\0\u2112\0\u2145\0\u2178\0\u21ab\0\u21de"+
    "\0\u2211\0\u2244\0\u2277\0\u22aa\0\u22dd\0\u2310\0\u2343\0\u01cb"+
    "\0\u01cb\0\u2376\0\u23a9\0\u23dc\0\u240f\0\u2442\0\u2475\0\u24a8"+
    "\0\u24db\0\u250e\0\u2541\0\u2574\0\u25a7\0\u25da\0\u260d\0\u01cb"+
    "\0\u2640\0\u2673\0\u26a6\0\u26d9\0\u01cb\0\u01cb\0\u270c\0\u01cb"+
    "\0\u273f\0\u2772\0\u27a5\0\u27d8\0\u280b\0\u283e\0\u2871\0\u28a4"+
    "\0\u28d7\0\u290a\0\u01cb\0\u293d\0\u2970\0\u29a3\0\u29d6\0\u2a09"+
    "\0\u2a3c\0\u2a6f\0\u2aa2\0\u2ad5\0\u2b08\0\u2b3b\0\u2b6e\0\u2ba1"+
    "\0\u2bd4\0\u2c07\0\u2c3a\0\u2c6d\0\u2ca0\0\u2cd3\0\u2d06\0\u2d39"+
    "\0\u2d6c\0\u2d9f\0\u01cb\0\u2dd2\0\u2e05\0\u2e38\0\u2e6b\0\u2e9e"+
    "\0\u2ed1\0\u01cb\0\u2f04\0\u01cb\0\u2f37\0\u2f6a\0\u2f9d\0\u2fd0"+
    "\0\u3003\0\u3036\0\u3069\0\u309c\0\u30cf\0\u3102\0\u3135\0\u3168"+
    "\0\u01cb\0\u01cb\0\u319b\0\u31ce\0\u3201\0\u3234\0\u01cb\0\u01cb"+
    "\0\u3267\0\u01cb\0\u329a\0\u32cd\0\u3300\0\u3333\0\u01cb";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[335];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\3\1\4\1\5\1\6\1\7\1\10\1\11\1\12"+
    "\1\13\1\3\2\14\1\15\1\16\1\17\1\20\1\21"+
    "\1\22\1\23\1\24\1\25\1\26\1\27\1\30\1\31"+
    "\1\32\1\33\1\34\1\35\1\36\1\14\1\37\1\40"+
    "\1\41\1\42\1\43\1\44\1\45\1\46\1\14\1\47"+
    "\1\50\1\51\1\14\1\52\1\53\1\54\4\14\15\4"+
    "\1\55\1\56\44\4\63\0\2\57\1\60\60\57\3\61"+
    "\1\62\57\61\4\0\1\7\1\63\1\64\4\0\1\64"+
    "\53\0\1\63\1\65\61\0\3\14\1\0\1\66\1\0"+
    "\3\14\20\0\3\14\1\67\14\14\1\70\1\14\1\71"+
    "\1\72\1\73\1\14\11\0\1\14\55\0\3\14\1\0"+
    "\1\66\1\0\3\14\20\0\26\14\16\0\1\74\62\0"+
    "\1\75\70\0\1\76\62\0\1\77\1\0\1\100\60\0"+
    "\1\101\2\0\1\102\63\0\1\103\36\0\3\14\1\0"+
    "\1\66\1\0\3\14\20\0\1\14\1\104\5\14\1\105"+
    "\5\14\1\106\10\14\4\0\3\14\1\0\1\66\1\0"+
    "\3\14\20\0\4\14\1\107\1\110\1\111\1\14\1\112"+
    "\3\14\1\113\11\14\4\0\2\14\1\114\1\0\1\66"+
    "\1\0\3\14\20\0\10\14\1\115\15\14\4\0\2\14"+
    "\1\116\1\0\1\66\1\0\3\14\20\0\2\14\1\117"+
    "\12\14\1\120\10\14\4\0\2\14\1\121\1\0\1\66"+
    "\1\0\3\14\20\0\1\122\6\14\1\123\5\14\1\124"+
    "\10\14\4\0\2\14\1\125\1\0\1\66\1\0\3\14"+
    "\20\0\7\14\1\126\5\14\1\127\10\14\4\0\3\14"+
    "\1\0\1\66\1\0\3\14\20\0\5\14\1\130\1\131"+
    "\1\14\1\132\15\14\4\0\2\14\1\133\1\0\1\66"+
    "\1\0\3\14\20\0\1\14\1\134\7\14\1\135\3\14"+
    "\1\136\7\14\1\137\4\0\2\14\1\140\1\0\1\66"+
    "\1\0\3\14\20\0\26\14\4\0\3\14\1\0\1\66"+
    "\1\0\3\14\20\0\6\14\1\141\17\14\4\0\3\14"+
    "\1\0\1\66\1\0\3\14\20\0\15\14\1\142\10\14"+
    "\4\0\3\14\1\0\1\66\1\0\3\14\20\0\11\14"+
    "\1\143\2\14\1\144\11\14\4\0\2\14\1\145\1\0"+
    "\1\66\1\0\3\14\20\0\10\14\1\146\15\14\4\0"+
    "\3\14\1\0\1\66\1\0\3\14\20\0\15\14\1\147"+
    "\10\14\4\0\3\14\1\0\1\66\1\0\3\14\20\0"+
    "\7\14\1\150\1\14\1\151\14\14\16\0\1\152\65\0"+
    "\1\153\43\0\1\57\63\0\1\61\63\0\1\63\1\0"+
    "\1\64\4\0\1\64\53\0\1\154\2\0\1\155\4\0"+
    "\1\155\52\0\2\14\1\156\1\0\1\66\1\0\3\14"+
    "\20\0\5\14\1\157\20\14\4\0\3\14\1\0\1\66"+
    "\1\0\3\14\20\0\21\14\1\160\4\14\4\0\2\14"+
    "\1\161\1\0\1\66\1\0\3\14\20\0\26\14\4\0"+
    "\3\14\1\0\1\66\1\0\3\14\20\0\1\162\25\14"+
    "\4\0\3\14\1\0\1\66\1\0\3\14\20\0\2\14"+
    "\1\163\23\14\4\0\3\14\1\0\1\66\1\0\3\14"+
    "\20\0\5\14\1\164\20\14\4\0\3\14\1\0\1\66"+
    "\1\0\3\14\20\0\20\14\1\165\5\14\4\0\3\14"+
    "\1\0\1\66\1\0\3\14\20\0\2\14\1\166\23\14"+
    "\4\0\3\14\1\0\1\66\1\0\3\14\20\0\5\14"+
    "\1\167\2\14\1\170\15\14\4\0\2\14\1\171\1\0"+
    "\1\66\1\0\3\14\20\0\26\14\4\0\3\14\1\0"+
    "\1\66\1\0\3\14\20\0\5\14\1\172\20\14\4\0"+
    "\3\14\1\0\1\66\1\0\3\14\20\0\23\14\1\173"+
    "\2\14\4\0\3\14\1\0\1\66\1\0\3\14\20\0"+
    "\1\174\25\14\4\0\3\14\1\0\1\66\1\0\3\14"+
    "\20\0\3\14\1\175\22\14\4\0\3\14\1\0\1\66"+
    "\1\0\3\14\20\0\1\14\1\176\24\14\4\0\3\14"+
    "\1\0\1\66\1\0\3\14\20\0\10\14\1\177\15\14"+
    "\4\0\3\14\1\0\1\66\1\0\3\14\20\0\20\14"+
    "\1\200\5\14\4\0\3\14\1\0\1\66\1\0\3\14"+
    "\20\0\20\14\1\201\5\14\4\0\3\14\1\0\1\66"+
    "\1\0\3\14\20\0\4\14\1\202\21\14\4\0\3\14"+
    "\1\0\1\66\1\0\3\14\20\0\1\203\3\14\1\204"+
    "\21\14\4\0\3\14\1\0\1\66\1\0\3\14\20\0"+
    "\10\14\1\205\15\14\4\0\3\14\1\0\1\66\1\0"+
    "\3\14\20\0\24\14\1\206\1\14\4\0\2\14\1\207"+
    "\1\0\1\66\1\0\3\14\20\0\26\14\4\0\2\14"+
    "\1\210\1\0\1\66\1\0\3\14\20\0\26\14\4\0"+
    "\3\14\1\0\1\66\1\0\3\14\20\0\21\14\1\211"+
    "\4\14\4\0\3\14\1\0\1\66\1\0\3\14\20\0"+
    "\10\14\1\212\15\14\4\0\3\14\1\0\1\66\1\0"+
    "\3\14\20\0\2\14\1\213\23\14\4\0\3\14\1\0"+
    "\1\66\1\0\3\14\20\0\3\14\1\214\5\14\1\215"+
    "\14\14\4\0\3\14\1\0\1\66\1\0\3\14\20\0"+
    "\4\14\1\216\21\14\4\0\3\14\1\0\1\66\1\0"+
    "\3\14\20\0\11\14\1\217\14\14\4\0\2\14\1\220"+
    "\1\0\1\66\1\0\3\14\20\0\15\14\1\221\10\14"+
    "\4\0\1\154\62\0\3\14\1\0\1\66\1\0\3\14"+
    "\20\0\20\14\1\222\5\14\4\0\2\14\1\223\1\0"+
    "\1\66\1\0\3\14\20\0\26\14\4\0\3\14\1\0"+
    "\1\66\1\0\3\14\20\0\10\14\1\224\15\14\4\0"+
    "\3\14\1\0\1\66\1\0\3\14\20\0\11\14\1\225"+
    "\14\14\4\0\2\14\1\226\1\0\1\66\1\0\3\14"+
    "\20\0\26\14\4\0\3\14\1\0\1\66\1\0\3\14"+
    "\20\0\3\14\1\227\22\14\4\0\3\14\1\0\1\66"+
    "\1\0\3\14\20\0\10\14\1\230\15\14\4\0\3\14"+
    "\1\0\1\66\1\0\3\14\20\0\20\14\1\231\5\14"+
    "\4\0\3\14\1\0\1\66\1\0\3\14\20\0\23\14"+
    "\1\232\2\14\4\0\3\14\1\0\1\66\1\0\3\14"+
    "\20\0\10\14\1\233\15\14\4\0\2\14\1\234\1\0"+
    "\1\66\1\0\3\14\20\0\26\14\4\0\3\14\1\0"+
    "\1\66\1\0\3\14\20\0\20\14\1\235\5\14\4\0"+
    "\3\14\1\0\1\66\1\0\3\14\20\0\1\236\25\14"+
    "\4\0\3\14\1\0\1\66\1\0\3\14\20\0\13\14"+
    "\1\237\12\14\4\0\3\14\1\0\1\66\1\0\3\14"+
    "\20\0\14\14\1\240\11\14\4\0\2\14\1\241\1\0"+
    "\1\66\1\0\3\14\20\0\26\14\4\0\3\14\1\0"+
    "\1\66\1\0\3\14\20\0\2\14\1\242\23\14\4\0"+
    "\2\14\1\243\1\0\1\66\1\0\3\14\20\0\26\14"+
    "\4\0\2\14\1\244\1\0\1\66\1\0\3\14\20\0"+
    "\26\14\4\0\2\14\1\245\1\0\1\66\1\0\3\14"+
    "\20\0\26\14\4\0\2\14\1\246\1\0\1\66\1\0"+
    "\3\14\20\0\26\14\4\0\3\14\1\0\1\66\1\0"+
    "\3\14\20\0\11\14\1\247\14\14\4\0\3\14\1\0"+
    "\1\66\1\0\3\14\20\0\10\14\1\250\15\14\4\0"+
    "\3\14\1\0\1\66\1\0\3\14\20\0\6\14\1\251"+
    "\17\14\4\0\3\14\1\0\1\66\1\0\3\14\20\0"+
    "\7\14\1\252\16\14\4\0\2\14\1\253\1\0\1\66"+
    "\1\0\3\14\20\0\26\14\4\0\3\14\1\0\1\66"+
    "\1\0\3\14\20\0\13\14\1\254\12\14\4\0\3\14"+
    "\1\0\1\66\1\0\3\14\20\0\15\14\1\255\10\14"+
    "\4\0\3\14\1\0\1\66\1\0\3\14\20\0\3\14"+
    "\1\256\22\14\4\0\2\14\1\257\1\0\1\66\1\0"+
    "\3\14\20\0\26\14\4\0\3\14\1\0\1\66\1\0"+
    "\3\14\20\0\1\260\25\14\4\0\3\14\1\0\1\66"+
    "\1\0\3\14\20\0\1\261\25\14\4\0\2\14\1\262"+
    "\1\0\1\66\1\0\3\14\20\0\26\14\4\0\3\14"+
    "\1\0\1\66\1\0\3\14\20\0\25\14\1\263\4\0"+
    "\3\14\1\0\1\66\1\0\3\14\20\0\25\14\1\264"+
    "\4\0\3\14\1\0\1\66\1\0\3\14\20\0\21\14"+
    "\1\265\4\14\4\0\3\14\1\0\1\66\1\0\3\14"+
    "\20\0\4\14\1\266\21\14\4\0\3\14\1\0\1\66"+
    "\1\0\3\14\20\0\7\14\1\267\16\14\4\0\2\14"+
    "\1\270\1\0\1\66\1\0\3\14\20\0\26\14\4\0"+
    "\3\14\1\0\1\66\1\0\3\14\20\0\7\14\1\271"+
    "\16\14\4\0\3\14\1\0\1\66\1\0\3\14\20\0"+
    "\11\14\1\272\14\14\4\0\2\14\1\273\1\0\1\66"+
    "\1\0\3\14\20\0\26\14\4\0\3\14\1\0\1\66"+
    "\1\0\3\14\20\0\20\14\1\274\5\14\4\0\3\14"+
    "\1\0\1\66\1\0\3\14\20\0\20\14\1\275\5\14"+
    "\4\0\3\14\1\0\1\66\1\0\3\14\20\0\5\14"+
    "\1\276\20\14\4\0\3\14\1\0\1\66\1\0\3\14"+
    "\20\0\5\14\1\277\20\14\4\0\3\14\1\0\1\66"+
    "\1\0\3\14\20\0\5\14\1\300\20\14\4\0\3\14"+
    "\1\0\1\66\1\0\3\14\20\0\2\14\1\301\23\14"+
    "\4\0\3\14\1\0\1\66\1\0\3\14\20\0\10\14"+
    "\1\302\15\14\4\0\3\14\1\0\1\66\1\0\3\14"+
    "\20\0\5\14\1\303\20\14\4\0\3\14\1\0\1\66"+
    "\1\0\3\14\20\0\11\14\1\304\14\14\4\0\3\14"+
    "\1\0\1\66\1\0\3\14\20\0\6\14\1\305\17\14"+
    "\4\0\3\14\1\0\1\66\1\0\3\14\20\0\15\14"+
    "\1\306\10\14\4\0\3\14\1\0\1\66\1\0\3\14"+
    "\20\0\6\14\1\307\17\14\4\0\2\14\1\310\1\0"+
    "\1\66\1\0\3\14\20\0\26\14\4\0\2\14\1\311"+
    "\1\0\1\66\1\0\3\14\20\0\26\14\4\0\3\14"+
    "\1\0\1\66\1\0\3\14\20\0\6\14\1\312\17\14"+
    "\4\0\3\14\1\0\1\66\1\0\2\14\1\313\20\0"+
    "\26\14\4\0\3\14\1\0\1\66\1\0\3\14\20\0"+
    "\10\14\1\314\15\14\4\0\3\14\1\0\1\66\1\0"+
    "\3\14\20\0\12\14\1\315\13\14\4\0\3\14\1\0"+
    "\1\66\1\0\3\14\20\0\6\14\1\316\17\14\4\0"+
    "\3\14\1\0\1\66\1\0\3\14\20\0\6\14\1\317"+
    "\17\14\4\0\3\14\1\0\1\66\1\0\3\14\20\0"+
    "\5\14\1\320\20\14\4\0\3\14\1\0\1\66\1\0"+
    "\3\14\20\0\6\14\1\321\17\14\4\0\2\14\1\322"+
    "\1\0\1\66\1\0\3\14\20\0\26\14\4\0\3\14"+
    "\1\0\1\66\1\0\3\14\20\0\7\14\1\323\16\14"+
    "\4\0\3\14\1\0\1\66\1\0\3\14\20\0\14\14"+
    "\1\324\11\14\4\0\3\14\1\0\1\66\1\0\3\14"+
    "\20\0\21\14\1\325\4\14\4\0\3\14\1\0\1\66"+
    "\1\0\3\14\20\0\10\14\1\326\15\14\4\0\3\14"+
    "\1\0\1\66\1\0\3\14\20\0\12\14\1\327\13\14"+
    "\4\0\3\14\1\0\1\66\1\0\3\14\20\0\16\14"+
    "\1\330\7\14\4\0\3\14\1\0\1\66\1\0\3\14"+
    "\20\0\6\14\1\331\17\14\4\0\3\14\1\0\1\66"+
    "\1\0\3\14\20\0\16\14\1\332\7\14\4\0\3\14"+
    "\1\0\1\66\1\0\3\14\20\0\10\14\1\333\15\14"+
    "\4\0\3\14\1\0\1\66\1\0\3\14\20\0\4\14"+
    "\1\334\21\14\4\0\3\14\1\0\1\66\1\0\3\14"+
    "\20\0\5\14\1\335\20\14\4\0\3\14\1\0\1\66"+
    "\1\0\3\14\20\0\10\14\1\336\15\14\4\0\3\14"+
    "\1\0\1\66\1\0\3\14\20\0\5\14\1\337\20\14"+
    "\4\0\3\14\1\0\1\66\1\0\3\14\20\0\3\14"+
    "\1\340\22\14\4\0\3\14\1\0\1\66\1\0\3\14"+
    "\20\0\10\14\1\341\15\14\4\0\3\14\1\0\1\66"+
    "\1\0\3\14\20\0\1\342\25\14\4\0\2\14\1\343"+
    "\1\0\1\66\1\0\3\14\20\0\26\14\4\0\3\14"+
    "\1\0\1\66\1\0\3\14\20\0\4\14\1\344\21\14"+
    "\4\0\3\14\1\0\1\66\1\0\3\14\20\0\6\14"+
    "\1\345\17\14\4\0\3\14\1\0\1\66\1\0\2\14"+
    "\1\346\20\0\26\14\4\0\3\14\1\0\1\66\1\0"+
    "\3\14\20\0\2\14\1\347\23\14\4\0\3\14\1\0"+
    "\1\66\1\0\3\14\20\0\7\14\1\350\16\14\4\0"+
    "\3\14\1\0\1\66\1\0\3\14\20\0\15\14\1\351"+
    "\10\14\4\0\3\14\1\0\1\66\1\0\3\14\20\0"+
    "\13\14\1\352\12\14\4\0\3\14\1\0\1\66\1\0"+
    "\3\14\20\0\2\14\1\353\23\14\4\0\3\14\1\0"+
    "\1\66\1\0\3\14\20\0\2\14\1\354\23\14\4\0"+
    "\3\14\1\0\1\66\1\0\3\14\20\0\2\14\1\355"+
    "\23\14\4\0\3\14\1\0\1\66\1\0\3\14\20\0"+
    "\5\14\1\356\20\14\4\0\2\14\1\357\1\0\1\66"+
    "\1\0\3\14\20\0\26\14\4\0\2\14\1\360\1\0"+
    "\1\66\1\0\3\14\20\0\26\14\4\0\2\14\1\361"+
    "\1\0\1\66\1\0\3\14\20\0\26\14\4\0\3\14"+
    "\1\0\1\66\1\0\3\14\20\0\1\362\25\14\4\0"+
    "\3\14\1\0\1\66\1\0\3\14\20\0\7\14\1\363"+
    "\16\14\4\0\3\14\1\0\1\66\1\0\3\14\20\0"+
    "\10\14\1\364\15\14\4\0\2\14\1\365\1\0\1\66"+
    "\1\0\3\14\20\0\7\14\1\366\16\14\4\0\2\14"+
    "\1\367\1\0\1\66\1\0\3\14\20\0\26\14\4\0"+
    "\3\14\1\0\1\66\1\0\3\14\20\0\1\370\25\14"+
    "\4\0\3\14\1\0\1\66\1\0\3\14\20\0\11\14"+
    "\1\371\14\14\4\0\3\14\1\0\1\66\1\0\3\14"+
    "\20\0\10\14\1\372\15\14\4\0\3\14\1\0\1\66"+
    "\1\0\3\14\20\0\10\14\1\373\15\14\4\0\3\14"+
    "\1\0\1\66\1\0\3\14\20\0\6\14\1\374\17\14"+
    "\4\0\3\14\1\0\1\66\1\0\3\14\20\0\6\14"+
    "\1\375\17\14\4\0\3\14\1\0\1\66\1\0\3\14"+
    "\20\0\2\14\1\376\23\14\4\0\3\14\1\0\1\66"+
    "\1\0\3\14\20\0\22\14\1\377\3\14\4\0\3\14"+
    "\1\0\1\66\1\0\3\14\20\0\10\14\1\u0100\15\14"+
    "\4\0\3\14\1\0\1\66\1\0\3\14\20\0\6\14"+
    "\1\u0101\17\14\4\0\3\14\1\0\1\66\1\0\2\14"+
    "\1\u0102\20\0\26\14\4\0\3\14\1\0\1\66\1\0"+
    "\3\14\20\0\3\14\1\u0103\22\14\4\0\3\14\1\0"+
    "\1\66\1\0\3\14\20\0\10\14\1\u0104\15\14\4\0"+
    "\3\14\1\0\1\66\1\0\3\14\20\0\5\14\1\u0105"+
    "\20\14\4\0\2\14\1\u0106\1\0\1\66\1\0\3\14"+
    "\20\0\26\14\4\0\3\14\1\0\1\66\1\0\2\14"+
    "\1\u0107\20\0\26\14\4\0\2\14\1\u0108\1\0\1\66"+
    "\1\0\3\14\20\0\26\14\4\0\3\14\1\0\1\66"+
    "\1\0\3\14\20\0\1\u0109\25\14\4\0\3\14\1\0"+
    "\1\66\1\0\3\14\20\0\17\14\1\u010a\6\14\4\0"+
    "\3\14\1\0\1\66\1\0\3\14\20\0\17\14\1\u010b"+
    "\6\14\4\0\3\14\1\0\1\66\1\0\3\14\20\0"+
    "\6\14\1\u010c\17\14\4\0\3\14\1\0\1\66\1\0"+
    "\3\14\20\0\13\14\1\u010d\12\14\4\0\3\14\1\0"+
    "\1\66\1\0\3\14\20\0\10\14\1\u010e\15\14\4\0"+
    "\3\14\1\0\1\66\1\0\3\14\20\0\6\14\1\u010f"+
    "\17\14\4\0\2\14\1\u0110\1\0\1\66\1\0\3\14"+
    "\20\0\26\14\4\0\3\14\1\0\1\66\1\0\3\14"+
    "\20\0\10\14\1\u0111\15\14\4\0\3\14\1\0\1\66"+
    "\1\0\3\14\20\0\15\14\1\u0112\10\14\4\0\3\14"+
    "\1\0\1\66\1\0\3\14\20\0\1\14\1\u0113\24\14"+
    "\4\0\3\14\1\0\1\66\1\0\2\14\1\u0114\20\0"+
    "\26\14\4\0\3\14\1\0\1\66\1\0\2\14\1\u0115"+
    "\20\0\26\14\4\0\3\14\1\0\1\66\1\0\3\14"+
    "\20\0\17\14\1\u0116\6\14\4\0\2\14\1\u0117\1\0"+
    "\1\66\1\0\3\14\20\0\26\14\4\0\3\14\1\0"+
    "\1\66\1\0\2\14\1\u0118\20\0\26\14\4\0\3\14"+
    "\1\0\1\66\1\0\3\14\20\0\15\14\1\u0119\10\14"+
    "\4\0\3\14\1\0\1\66\1\0\3\14\20\0\20\14"+
    "\1\u011a\5\14\4\0\3\14\1\0\1\66\1\0\3\14"+
    "\20\0\11\14\1\u011b\14\14\4\0\3\14\1\0\1\66"+
    "\1\0\3\14\20\0\11\14\1\u011c\14\14\4\0\3\14"+
    "\1\0\1\66\1\0\3\14\20\0\5\14\1\u011d\20\14"+
    "\4\0\3\14\1\0\1\66\1\0\3\14\20\0\5\14"+
    "\1\u011e\20\14\4\0\3\14\1\0\1\66\1\0\2\14"+
    "\1\u011f\20\0\26\14\4\0\3\14\1\0\1\66\1\0"+
    "\3\14\20\0\6\14\1\u0120\17\14\4\0\3\14\1\0"+
    "\1\66\1\0\3\14\20\0\15\14\1\u0121\10\14\4\0"+
    "\3\14\1\0\1\66\1\0\3\14\20\0\4\14\1\u0122"+
    "\21\14\4\0\2\14\1\u0123\1\0\1\66\1\0\3\14"+
    "\20\0\26\14\4\0\3\14\1\0\1\66\1\0\3\14"+
    "\20\0\2\14\1\u0124\23\14\4\0\3\14\1\0\1\66"+
    "\1\0\2\14\1\u0125\20\0\26\14\4\0\3\14\1\0"+
    "\1\66\1\0\3\14\20\0\2\14\1\u0126\23\14\4\0"+
    "\3\14\1\0\1\66\1\0\3\14\20\0\2\14\1\u0127"+
    "\23\14\4\0\3\14\1\0\1\66\1\0\3\14\20\0"+
    "\2\14\1\u0128\23\14\4\0\3\14\1\0\1\66\1\0"+
    "\3\14\20\0\1\u0129\25\14\4\0\3\14\1\0\1\66"+
    "\1\0\3\14\20\0\11\14\1\u012a\14\14\4\0\2\14"+
    "\1\u012b\1\0\1\66\1\0\3\14\20\0\26\14\4\0"+
    "\3\14\1\0\1\66\1\0\3\14\20\0\6\14\1\u012c"+
    "\17\14\4\0\3\14\1\0\1\66\1\0\3\14\20\0"+
    "\12\14\1\u012d\13\14\4\0\3\14\1\0\1\66\1\0"+
    "\3\14\20\0\5\14\1\u012e\20\14\4\0\3\14\1\0"+
    "\1\66\1\0\3\14\20\0\12\14\1\u012f\13\14\4\0"+
    "\3\14\1\0\1\66\1\0\3\14\20\0\12\14\1\u0130"+
    "\13\14\4\0\3\14\1\0\1\66\1\0\3\14\20\0"+
    "\6\14\1\u0131\17\14\4\0\2\14\1\u0132\1\0\1\66"+
    "\1\0\3\14\20\0\26\14\4\0\3\14\1\0\1\66"+
    "\1\0\2\14\1\u0133\20\0\26\14\4\0\3\14\1\0"+
    "\1\66\1\0\3\14\20\0\10\14\1\u0134\15\14\4\0"+
    "\3\14\1\0\1\66\1\0\3\14\20\0\13\14\1\u0135"+
    "\12\14\4\0\2\14\1\u0136\1\0\1\66\1\0\3\14"+
    "\20\0\26\14\4\0\3\14\1\0\1\66\1\0\3\14"+
    "\20\0\3\14\1\u0137\22\14\4\0\3\14\1\0\1\66"+
    "\1\0\3\14\20\0\3\14\1\u0138\22\14\4\0\3\14"+
    "\1\0\1\66\1\0\3\14\20\0\5\14\1\u0139\20\14"+
    "\4\0\3\14\1\0\1\66\1\0\3\14\20\0\5\14"+
    "\1\u013a\20\14\4\0\3\14\1\0\1\66\1\0\3\14"+
    "\20\0\10\14\1\u013b\15\14\4\0\3\14\1\0\1\66"+
    "\1\0\3\14\20\0\3\14\1\u013c\22\14\4\0\3\14"+
    "\1\0\1\66\1\0\3\14\20\0\2\14\1\u013d\23\14"+
    "\4\0\3\14\1\0\1\66\1\0\3\14\20\0\2\14"+
    "\1\u013e\23\14\4\0\3\14\1\0\1\66\1\0\3\14"+
    "\20\0\10\14\1\u013f\15\14\4\0\2\14\1\u0140\1\0"+
    "\1\66\1\0\3\14\20\0\26\14\4\0\2\14\1\u0141"+
    "\1\0\1\66\1\0\3\14\20\0\26\14\4\0\3\14"+
    "\1\0\1\66\1\0\3\14\20\0\14\14\1\u0142\11\14"+
    "\4\0\3\14\1\0\1\66\1\0\3\14\20\0\6\14"+
    "\1\u0143\17\14\4\0\3\14\1\0\1\66\1\0\3\14"+
    "\20\0\6\14\1\u0144\17\14\4\0\3\14\1\0\1\66"+
    "\1\0\3\14\20\0\11\14\1\u0145\14\14\4\0\3\14"+
    "\1\0\1\66\1\0\3\14\20\0\3\14\1\u0146\22\14"+
    "\4\0\3\14\1\0\1\66\1\0\3\14\20\0\17\14"+
    "\1\u0147\6\14\4\0\3\14\1\0\1\66\1\0\3\14"+
    "\20\0\17\14\1\u0148\6\14\4\0\3\14\1\0\1\66"+
    "\1\0\3\14\20\0\13\14\1\u0149\12\14\4\0\3\14"+
    "\1\0\1\66\1\0\3\14\20\0\14\14\1\u014a\11\14"+
    "\4\0\3\14\1\0\1\66\1\0\3\14\20\0\1\u014b"+
    "\25\14\4\0\3\14\1\0\1\66\1\0\3\14\20\0"+
    "\10\14\1\u014c\15\14\4\0\3\14\1\0\1\66\1\0"+
    "\3\14\20\0\2\14\1\u014d\23\14\4\0\3\14\1\0"+
    "\1\66\1\0\3\14\20\0\15\14\1\u014e\10\14\4\0"+
    "\3\14\1\0\1\66\1\0\3\14\20\0\6\14\1\u014f"+
    "\17\14";

  private static int [] zzUnpackTrans() {
    int [] result = new int[13158];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\2\0\2\11\5\1\1\11\2\1\1\11\2\1\6\11"+
    "\4\1\4\11\21\1\1\0\1\1\1\0\2\1\1\0"+
    "\1\11\1\0\5\1\10\11\46\1\2\11\1\1\1\0"+
    "\342\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[335];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
	public int lineno() { return yyline + 1; }
	public int colno() { return yycolumn + 1; }

	private Symbol symbol(int type) {
		return new Symbol(type, lineno(), colno());
	}
	private Symbol symbol(int type, Object value) {
		return new Symbol(type, lineno(), colno(), value);
	}

	private int commentLevel = 0;


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  XPathFlex(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  XPathFlex(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 180) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn++;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 74: 
          { return symbol(XpathSym.ANCESTOR);
          }
        case 92: break;
        case 57: 
          { return symbol(XpathSym.ITEM);
          }
        case 93: break;
        case 46: 
          { return symbol(XpathSym.GT);
          }
        case 94: break;
        case 81: 
          { return symbol(XpathSym.DESCENDANT);
          }
        case 95: break;
        case 15: 
          { return symbol(XpathSym.EQUALS);
          }
        case 96: break;
        case 26: 
          { return symbol(XpathSym.EQ);
          }
        case 97: break;
        case 70: 
          { return symbol(XpathSym.ELEMENT);
          }
        case 98: break;
        case 77: 
          { return symbol(XpathSym.NAMESPACE);
          }
        case 99: break;
        case 35: 
          { return symbol(XpathSym.IS);
          }
        case 100: break;
        case 23: 
          { // get rid of quotes
				String str = yytext();
				assert str.length() >= 2;
				return symbol(XpathSym.STRING, org.eclipse.wst.xml.xpath2.processor.internal.utils.LiteralUtils.unquote(str));
          }
        case 101: break;
        case 1: 
          { String err = "Unknown character at line " + lineno(); 
		err += " col " + colno();
		err += ": " + yytext(); 
			     
		throw new JFlexError(err);
          }
        case 102: break;
        case 20: 
          { return symbol(XpathSym.COMMA);
          }
        case 103: break;
        case 71: 
          { return symbol(XpathSym.COMMENT);
          }
        case 104: break;
        case 39: 
          { return symbol(XpathSym.LT);
          }
        case 105: break;
        case 31: 
          { return symbol(XpathSym.LESS_LESS);
          }
        case 106: break;
        case 65: 
          { return symbol(XpathSym.TREAT);
          }
        case 107: break;
        case 13: 
          { return symbol(XpathSym.STAR);
          }
        case 108: break;
        case 66: 
          { return symbol(XpathSym.UNION);
          }
        case 109: break;
        case 21: 
          { return symbol(XpathSym.DOLLAR);
          }
        case 110: break;
        case 85: 
          { return symbol(XpathSym.SCHEMA_ELEMENT);
          }
        case 111: break;
        case 36: 
          { return symbol(XpathSym.IN);
          }
        case 112: break;
        case 43: 
          { return symbol(XpathSym.OR);
          }
        case 113: break;
        case 25: 
          { return symbol(XpathSym.DOTDOT);
          }
        case 114: break;
        case 82: 
          { return symbol(XpathSym.TYPESWITCH);
          }
        case 115: break;
        case 5: 
          { return symbol(XpathSym.NCNAME, yytext());
          }
        case 116: break;
        case 19: 
          { return symbol(XpathSym.AT_SYM);
          }
        case 117: break;
        case 30: 
          { return symbol(XpathSym.LESSEQUAL);
          }
        case 118: break;
        case 27: 
          { commentLevel++; // int overflow =P
			  yybegin(COMMENT);
          }
        case 119: break;
        case 83: 
          { return symbol(XpathSym.DOCUMENT_NODE);
          }
        case 120: break;
        case 34: 
          { return symbol(XpathSym.FORWARD_SLASHSLASH);
          }
        case 121: break;
        case 18: 
          { return symbol(XpathSym.FORWARD_SLASH);
          }
        case 122: break;
        case 67: 
          { return symbol(XpathSym.EXCEPT);
          }
        case 123: break;
        case 89: 
          { return symbol(XpathSym.PRECEDING_SIBLING);
          }
        case 124: break;
        case 73: 
          { return symbol(XpathSym.INSTANCE);
          }
        case 125: break;
        case 54: 
          { return symbol(XpathSym.ELSE);
          }
        case 126: break;
        case 45: 
          { return symbol(XpathSym.GE);
          }
        case 127: break;
        case 47: 
          { commentLevel++;
          }
        case 128: break;
        case 37: 
          { return symbol(XpathSym.IF);
          }
        case 129: break;
        case 42: 
          { return symbol(XpathSym.TO);
          }
        case 130: break;
        case 84: 
          { return symbol(XpathSym.EMPTY_SEQUENCE);
          }
        case 131: break;
        case 80: 
          { return symbol(XpathSym.PRECEDING);
          }
        case 132: break;
        case 32: 
          { return symbol(XpathSym.GREATEREQUAL);
          }
        case 133: break;
        case 87: 
          { return symbol(XpathSym.ANCESTOR_OR_SELF);
          }
        case 134: break;
        case 78: 
          { return symbol(XpathSym.ATTRIBUTE);
          }
        case 135: break;
        case 86: 
          { return symbol(XpathSym.SCHEMA_ATTRIBUTE);
          }
        case 136: break;
        case 79: 
          { return symbol(XpathSym.FOLLOWING);
          }
        case 137: break;
        case 52: 
          { return symbol(XpathSym.FOR);
          }
        case 138: break;
        case 14: 
          { return symbol(XpathSym.PIPE);
          }
        case 139: break;
        case 22: 
          { return symbol(XpathSym.QUESTIONMARK);
          }
        case 140: break;
        case 38: 
          { return symbol(XpathSym.LE);
          }
        case 141: break;
        case 24: 
          { return symbol(XpathSym.DECIMAL, new java.math.BigDecimal(yytext()));
          }
        case 142: break;
        case 75: 
          { return symbol(XpathSym.INTERSECT);
          }
        case 143: break;
        case 48: 
          { commentLevel--; 
			  if(commentLevel == 0)
		          	yybegin(YYINITIAL);
          }
        case 144: break;
        case 44: 
          { return symbol(XpathSym.OF);
          }
        case 145: break;
        case 64: 
          { return symbol(XpathSym.CHILD);
          }
        case 146: break;
        case 40: 
          { return symbol(XpathSym.NE);
          }
        case 147: break;
        case 58: 
          { return symbol(XpathSym.SELF);
          }
        case 148: break;
        case 28: 
          { return symbol(XpathSym.COLONCOLON);
          }
        case 149: break;
        case 50: 
          { return symbol(XpathSym.DIV);
          }
        case 150: break;
        case 88: 
          { return symbol(XpathSym.FOLLOWING_SIBLING);
          }
        case 151: break;
        case 61: 
          { return symbol(XpathSym.TEXT);
          }
        case 152: break;
        case 68: 
          { return symbol(XpathSym.RETURN);
          }
        case 153: break;
        case 53: 
          { return symbol(XpathSym.MOD);
          }
        case 154: break;
        case 6: 
          { return symbol(XpathSym.PLUS);
          }
        case 155: break;
        case 29: 
          { return symbol(XpathSym.NOTEQUALS);
          }
        case 156: break;
        case 33: 
          { return symbol(XpathSym.GREATER_GREATER);
          }
        case 157: break;
        case 3: 
          { return symbol(XpathSym.INTEGER, new java.math.BigInteger(yytext()));
          }
        case 158: break;
        case 63: 
          { return symbol(XpathSym.EVERY);
          }
        case 159: break;
        case 72: 
          { return symbol(XpathSym.CASTABLE);
          }
        case 160: break;
        case 90: 
          { return symbol(XpathSym.DESCENDANT_OR_SELF);
          }
        case 161: break;
        case 76: 
          { return symbol(XpathSym.SATISFIES);
          }
        case 162: break;
        case 91: 
          { return symbol(XpathSym.PROCESSING_INSTRUCTION);
          }
        case 163: break;
        case 16: 
          { return symbol(XpathSym.LESSTHAN);
          }
        case 164: break;
        case 55: 
          { return symbol(XpathSym.CAST);
          }
        case 165: break;
        case 12: 
          { return symbol(XpathSym.RPAR);
          }
        case 166: break;
        case 2: 
          { /* ignore */
          }
        case 167: break;
        case 10: 
          { return symbol(XpathSym.LBRACKET);
          }
        case 168: break;
        case 60: 
          { return symbol(XpathSym.NODE);
          }
        case 169: break;
        case 56: 
          { return symbol(XpathSym.IDIV);
          }
        case 170: break;
        case 49: 
          { return symbol(XpathSym.DOUBLE, new Double(yytext()));
          }
        case 171: break;
        case 62: 
          { return symbol(XpathSym.THEN);
          }
        case 172: break;
        case 59: 
          { return symbol(XpathSym.SOME);
          }
        case 173: break;
        case 69: 
          { return symbol(XpathSym.PARENT);
          }
        case 174: break;
        case 7: 
          { return symbol(XpathSym.MINUS);
          }
        case 175: break;
        case 41: 
          { return symbol(XpathSym.AS);
          }
        case 176: break;
        case 4: 
          { return symbol(XpathSym.DOT);
          }
        case 177: break;
        case 11: 
          { return symbol(XpathSym.RBRACKET);
          }
        case 178: break;
        case 17: 
          { return symbol(XpathSym.GREATER);
          }
        case 179: break;
        case 51: 
          { return symbol(XpathSym.AND);
          }
        case 180: break;
        case 8: 
          { return symbol(XpathSym.LPAR);
          }
        case 181: break;
        case 9: 
          { return symbol(XpathSym.COLON);
          }
        case 182: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
              { return new java_cup.runtime.Symbol(XpathSym.EOF); }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
