/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.SuperListIterableWrapper;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.ReferenceTable;
import org.eclipse.jpt.jpa.core.context.Table;
import org.eclipse.jpt.jpa.core.context.VirtualJoinColumn;
import org.eclipse.jpt.jpa.core.context.VirtualReferenceTable;
import org.eclipse.jpt.jpa.core.internal.context.AbstractJpaContextModel;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmVirtualTable;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public abstract class AbstractOrmVirtualReferenceTable<P extends JpaContextModel, PA extends Table.ParentAdapter<P>, T extends ReferenceTable>
extends AbstractOrmVirtualTable<P, PA, T>
implements VirtualReferenceTable {
    protected final AbstractJpaContextModel.ContextListContainer<VirtualJoinColumn, JoinColumn> specifiedJoinColumnContainer;
    protected final JoinColumn.ParentAdapter joinColumnParentAdapter = this.buildJoinColumnParentAdapter();
    protected VirtualJoinColumn defaultJoinColumn;

    protected AbstractOrmVirtualReferenceTable(PA parentAdapter, T overriddenTable) {
        super(parentAdapter, overriddenTable);
        this.specifiedJoinColumnContainer = this.buildSpecifiedJoinColumnContainer();
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.updateSpecifiedJoinColumns(monitor);
        this.updateDefaultJoinColumn(monitor);
    }

    public ListIterable<VirtualJoinColumn> getJoinColumns() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumns() : this.getDefaultJoinColumns();
    }

    @Override
    public int getJoinColumnsSize() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumnsSize() : this.getDefaultJoinColumnsSize();
    }

    public ListIterable<VirtualJoinColumn> getSpecifiedJoinColumns() {
        return this.specifiedJoinColumnContainer;
    }

    @Override
    public int getSpecifiedJoinColumnsSize() {
        return this.specifiedJoinColumnContainer.size();
    }

    @Override
    public boolean hasSpecifiedJoinColumns() {
        return this.getSpecifiedJoinColumnsSize() != 0;
    }

    @Override
    public VirtualJoinColumn getSpecifiedJoinColumn(int index) {
        return (VirtualJoinColumn)this.specifiedJoinColumnContainer.get(index);
    }

    protected void updateSpecifiedJoinColumns(IProgressMonitor monitor) {
        this.specifiedJoinColumnContainer.update(monitor);
    }

    protected ListIterable<JoinColumn> getOverriddenJoinColumns() {
        return new SuperListIterableWrapper(((ReferenceTable)this.getOverriddenTable()).getSpecifiedJoinColumns());
    }

    protected void moveSpecifiedJoinColumn(int index, VirtualJoinColumn joinColumn) {
        this.specifiedJoinColumnContainer.move(index, joinColumn);
    }

    protected VirtualJoinColumn addSpecifiedJoinColumn(int index, JoinColumn joinColumn) {
        return (VirtualJoinColumn)this.specifiedJoinColumnContainer.addContextElement(index, joinColumn);
    }

    protected void removeSpecifiedJoinColumn(VirtualJoinColumn joinColumn) {
        this.specifiedJoinColumnContainer.remove(joinColumn);
    }

    protected AbstractJpaContextModel.ContextListContainer<VirtualJoinColumn, JoinColumn> buildSpecifiedJoinColumnContainer() {
        return this.buildVirtualContextListContainer("specifiedJoinColumns", new SpecifiedJoinColumnContainerAdapter());
    }

    @Override
    public VirtualJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(VirtualJoinColumn joinColumn) {
        VirtualJoinColumn old = this.defaultJoinColumn;
        this.defaultJoinColumn = joinColumn;
        this.firePropertyChanged("defaultJoinColumn", old, joinColumn);
    }

    protected ListIterable<VirtualJoinColumn> getDefaultJoinColumns() {
        return this.defaultJoinColumn != null ? new SingleElementListIterable((Object)this.defaultJoinColumn) : EmptyListIterable.instance();
    }

    protected int getDefaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultJoinColumn(IProgressMonitor monitor) {
        if (this.buildsDefaultJoinColumn()) {
            if (this.defaultJoinColumn == null) {
                this.setDefaultJoinColumn(this.buildJoinColumn(((ReferenceTable)this.getOverriddenTable()).getDefaultJoinColumn()));
            } else {
                this.defaultJoinColumn.update(monitor);
            }
        } else {
            this.setDefaultJoinColumn(null);
        }
    }

    protected boolean buildsDefaultJoinColumn() {
        return !this.hasSpecifiedJoinColumns();
    }

    protected VirtualJoinColumn buildJoinColumn(JoinColumn joinColumn) {
        return this.buildJoinColumn(this.joinColumnParentAdapter, joinColumn);
    }

    protected VirtualJoinColumn buildJoinColumn(JoinColumn.ParentAdapter columnParentAdapter, JoinColumn joinColumn) {
        return this.getContextModelFactory().buildOrmVirtualJoinColumn(columnParentAdapter, joinColumn);
    }

    protected abstract JoinColumn.ParentAdapter buildJoinColumnParentAdapter();

    @Override
    protected String buildDefaultSchema() {
        return this.getContextDefaultSchema();
    }

    @Override
    protected String buildDefaultCatalog() {
        return this.getContextDefaultCatalog();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        boolean continueValidating = this.buildTableValidator().validate(messages, reporter);
        if (continueValidating) {
            this.validateJoinColumns(messages, reporter);
        }
    }

    protected void validateJoinColumns(List<IMessage> messages, IReporter reporter) {
        this.validateModels((Iterable<? extends JpaContextModel>)this.getJoinColumns(), messages, reporter);
    }

    public class SpecifiedJoinColumnContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<VirtualJoinColumn, JoinColumn> {
        @Override
        public VirtualJoinColumn buildContextElement(JoinColumn resourceElement) {
            return AbstractOrmVirtualReferenceTable.this.buildJoinColumn(resourceElement);
        }

        @Override
        public ListIterable<JoinColumn> getResourceElements() {
            return AbstractOrmVirtualReferenceTable.this.getOverriddenJoinColumns();
        }

        @Override
        public JoinColumn extractResourceElement(VirtualJoinColumn contextElement) {
            return contextElement.getOverriddenColumn();
        }
    }
}

