/* The following code was generated by JFlex 1.2.2 on 8/6/16 1:32 PM */

/*******************************************************************************
 * Copyright (c) 2004, 2016 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wst.html.core.internal.parser;

import java.io.CharArrayReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.wst.html.core.internal.contenttype.IntStack;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockMarker;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockTokenizer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.util.Debug;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.parser.regions.XMLParserRegionFactory;
import org.eclipse.wst.xml.core.internal.regions.DOMRegionContext;

/**
 * Generate with -skel skeleton.sse
 */

/**
 * This class is a scanner generated by 
 * <a href="http://www.informatik.tu-muenchen.de/~kleing/jflex/">JFlex</a> 1.2.2
 * on 8/6/16 1:32 PM from the specification file
 * <tt>file:/Users/nitin/git/webtools.sourceediting/bundles/org.eclipse.wst.sse.core/DevTimeSupport/SedModel/HTMLTokenizer/devel/HTMLTokenizer.jflex</tt>
 */
public class HTMLTokenizer implements BlockTokenizer, DOMRegionContext {

  /** this character denotes the end of file */
  final public static int YYEOF = -1;

  /** lexical states */
  final public static int ST_XML_DOCTYPE_EXTERNAL_ID = 19;
  final public static int ST_XML_ELEMENT_DECLARATION_CONTENT = 23;
  final public static int ST_XML_PI_TAG_CLOSE = 11;
  final public static int ST_XML_DECLARATION_CLOSE = 17;
  final public static int ST_XML_PI_ATTRIBUTE_VALUE = 10;
  final public static int ST_XML_TAG_NAME = 12;
  final public static int ST_XML_ATTRIBUTE_VALUE = 15;
  final public static int ST_XML_DOCTYPE_ID_SYSTEM = 21;
  final public static int ST_XML_ATTRIBUTE_NAME = 13;
  final public static int ST_XML_ELEMENT_DECLARATION = 22;
  final public static int ST_XML_DOCTYPE_DECLARATION = 18;
  final public static int ST_XML_ATTLIST_DECLARATION = 24;
  final public static int ST_XML_COMMENT_END = 4;
  final public static int ST_CDATA_TEXT = 1;
  final public static int ST_XML_COMMENT = 3;
  final public static int ST_PI_CONTENT = 7;
  final public static int ST_PI_WS = 6;
  final public static int ST_CDATA_END = 2;
  final public static int ST_XML_ATTLIST_DECLARATION_CONTENT = 25;
  final public static int ST_BLOCK_TAG_SCAN = 26;
  final public static int ST_XML_PI_EQUALS = 9;
  final public static int ST_XML_DECLARATION = 16;
  final public static int YYINITIAL = 0;
  final public static int ST_XML_DOCTYPE_ID_PUBLIC = 20;
  final public static int ST_XML_EQUALS = 14;
  final public static int ST_PI = 5;
  final public static int ST_XML_PI_ATTRIBUTE_NAME = 8;

  /** 
   * Translates characters to character classes
   */
  final private static String yycmap_packed = 
    "\11\0\1\5\1\25\2\0\1\20\22\0\1\20\1\24\1\15\1\14"+
    "\1\22\1\23\1\16\1\17\1\13\1\13\1\10\1\22\1\22\1\7"+
    "\1\6\1\3\12\21\1\10\1\61\1\1\1\46\1\2\1\4\1\22"+
    "\1\36\1\62\1\34\1\35\1\51\1\57\1\40\1\40\1\43\1\40"+
    "\1\40\1\32\1\30\1\45\1\44\1\50\1\40\1\40\1\56\1\37"+
    "\1\60\2\40\1\26\1\47\1\40\1\11\1\0\1\12\1\0\1\10"+
    "\1\0\1\53\1\62\1\63\1\54\1\41\1\57\1\40\1\66\1\43"+
    "\2\40\1\33\1\31\1\45\1\44\1\50\1\40\1\40\1\42\1\52"+
    "\1\60\1\40\1\40\1\27\1\55\1\40\1\0\1\0\72\0\1\65"+
    "\10\0\27\64\1\0\37\64\1\0\72\64\2\0\13\64\2\0\10\64"+
    "\1\0\65\64\1\0\104\64\11\0\44\64\3\0\2\64\4\0\36\64"+
    "\70\0\131\64\22\0\7\64\16\0\2\65\56\0\106\65\32\0\2\65"+
    "\44\0\1\64\1\65\3\64\1\0\1\64\1\0\24\64\1\0\54\64"+
    "\1\0\7\64\3\0\1\64\1\0\1\64\1\0\1\64\1\0\1\64"+
    "\1\0\22\64\15\0\14\64\1\0\102\64\1\0\14\64\1\0\44\64"+
    "\1\0\4\65\11\0\65\64\2\0\2\64\2\0\2\64\3\0\34\64"+
    "\2\0\10\64\2\0\2\64\67\0\46\64\2\0\1\64\7\0\46\64"+
    "\12\0\21\65\1\0\27\65\1\0\3\65\1\0\1\65\1\0\2\65"+
    "\1\0\1\65\13\0\33\64\5\0\3\64\56\0\32\64\5\0\1\65"+
    "\12\64\10\65\15\0\12\65\6\0\1\65\107\64\2\0\5\64\1\0"+
    "\17\64\1\0\4\64\1\0\1\64\17\65\2\64\2\65\1\0\4\65"+
    "\2\0\12\65\u0207\0\3\65\1\0\65\64\2\0\1\65\1\64\20\65"+
    "\3\0\4\65\3\0\12\64\2\65\2\0\12\65\21\0\3\65\1\0"+
    "\10\64\2\0\2\64\2\0\26\64\1\0\7\64\1\0\1\64\3\0"+
    "\4\64\2\0\1\65\1\0\7\65\2\0\2\65\2\0\3\65\11\0"+
    "\1\65\4\0\2\64\1\0\3\64\2\65\2\0\12\65\2\64\20\0"+
    "\1\65\2\0\6\64\4\0\2\64\2\0\26\64\1\0\7\64\1\0"+
    "\2\64\1\0\2\64\1\0\2\64\2\0\1\65\1\0\5\65\4\0"+
    "\2\65\2\0\3\65\13\0\4\64\1\0\1\64\7\0\12\65\2\65"+
    "\3\64\14\0\3\65\1\0\7\64\1\0\1\64\1\0\3\64\1\0"+
    "\26\64\1\0\7\64\1\0\2\64\1\0\5\64\2\0\1\65\1\64"+
    "\10\65\1\0\3\65\1\0\3\65\22\0\1\64\5\0\12\65\21\0"+
    "\3\65\1\0\10\64\2\0\2\64\2\0\26\64\1\0\7\64\1\0"+
    "\2\64\2\0\4\64\2\0\1\65\1\64\6\65\3\0\2\65\2\0"+
    "\3\65\10\0\2\65\4\0\2\64\1\0\3\64\4\0\12\65\22\0"+
    "\2\65\1\0\6\64\3\0\3\64\1\0\4\64\3\0\2\64\1\0"+
    "\1\64\1\0\2\64\3\0\2\64\3\0\3\64\3\0\10\64\1\0"+
    "\3\64\4\0\5\65\3\0\3\65\1\0\4\65\11\0\1\65\17\0"+
    "\11\65\21\0\3\65\1\0\10\64\1\0\3\64\1\0\27\64\1\0"+
    "\12\64\1\0\5\64\4\0\7\65\1\0\3\65\1\0\4\65\7\0"+
    "\2\65\11\0\2\64\4\0\12\65\22\0\2\65\1\0\10\64\1\0"+
    "\3\64\1\0\27\64\1\0\12\64\1\0\5\64\4\0\7\65\1\0"+
    "\3\65\1\0\4\65\7\0\2\65\7\0\1\64\1\0\2\64\4\0"+
    "\12\65\22\0\2\65\1\0\10\64\1\0\3\64\1\0\27\64\1\0"+
    "\20\64\4\0\6\65\2\0\3\65\1\0\4\65\11\0\1\65\10\0"+
    "\2\64\4\0\12\65\221\0\56\64\1\0\1\64\1\65\2\64\7\65"+
    "\5\0\6\64\1\65\10\65\1\0\12\65\47\0\2\64\1\0\1\64"+
    "\2\0\2\64\1\0\1\64\2\0\1\64\6\0\4\64\1\0\7\64"+
    "\1\0\3\64\1\0\1\64\1\0\1\64\2\0\2\64\1\0\2\64"+
    "\1\0\1\64\1\65\2\64\6\65\1\0\2\65\1\64\2\0\5\64"+
    "\1\0\1\65\1\0\6\65\2\0\12\65\76\0\2\65\6\0\12\65"+
    "\13\0\1\65\1\0\1\65\1\0\1\65\4\0\2\65\10\64\1\0"+
    "\41\64\7\0\24\65\1\0\6\65\4\0\6\65\1\0\1\65\1\0"+
    "\25\65\3\0\7\65\1\0\1\65\346\0\46\64\12\0\47\64\11\0"+
    "\1\64\1\0\2\64\1\0\3\64\1\0\1\64\1\0\2\64\1\0"+
    "\5\64\51\0\1\64\1\0\1\64\1\0\1\64\13\0\1\64\1\0"+
    "\1\64\1\0\1\64\3\0\2\64\3\0\1\64\5\0\3\64\1\0"+
    "\1\64\1\0\1\64\1\0\1\64\1\0\1\64\3\0\2\64\3\0"+
    "\2\64\1\0\1\64\50\0\1\64\11\0\1\64\2\0\1\64\2\0"+
    "\2\64\7\0\2\64\1\0\1\64\1\0\7\64\50\0\1\64\4\0"+
    "\1\64\10\0\1\64\u0c06\0\234\64\4\0\132\64\6\0\26\64\2\0"+
    "\6\64\2\0\46\64\2\0\6\64\2\0\10\64\1\0\1\64\1\0"+
    "\1\64\1\0\1\64\1\0\37\64\2\0\65\64\1\0\7\64\1\0"+
    "\1\64\3\0\3\64\1\0\7\64\3\0\4\64\2\0\6\64\4\0"+
    "\15\64\5\0\3\64\1\0\7\64\323\0\15\65\4\0\1\65\104\0"+
    "\1\64\3\0\2\64\2\0\1\64\121\0\3\64\u0e82\0\1\65\1\0"+
    "\1\64\31\0\11\64\6\65\1\0\5\65\13\0\124\64\4\0\2\65"+
    "\2\0\2\65\2\0\132\64\1\0\3\65\6\0\50\64\u1cd3\0\u51a6\64"+
    "\u0c5a\0\u2ba4\64\134\0\u0800\0\u1ffe\0\2\0";

  /** 
   * Translates characters to character classes
   */
  final private static char [] yycmap = yy_unpack_cmap(yycmap_packed);

  /** 
   * Translates a state to a row index in the transition table
   */
  final private static int yy_rowMap [] = { 
        0,    55,   110,   165,   220,   275,   330,   385,   440,   495, 
      550,   605,   660,   715,   770,   825,   880,   935,   990,  1045, 
     1100,  1155,  1210,  1265,  1320,  1375,  1430,  1485,  1540,  1595, 
     1650,  1705,  1760,  1705,  1760,  1815,  1705,  1705,  1760,  1870, 
     1925,  1980,  2035,  2090,  2145,  2200,  1705,  1760,  2255,  2310, 
     2365,  1705,  2420,  2420,  2475,  2530,  2585,  2255,  2640,  2695, 
     1705,  2750,  2805,  2860,  2915,  1705,  2970,  3025,  3080,  3135, 
     3190,  1705,  3245,  3300,  3355,  3410,  3465,  3520,  3575,  3630, 
     3630,  3685,  3740,  3795,  3850,  3850,  3905,  3960,  4015,  4070, 
     4070,  4125,  4180,  4235,  4290,  1705,  4345,  4345,  4400,  4455, 
     4510,  4565,  1705,  1705,  1760,  1705,  1705,  4620,  4675,  4730, 
     4785,  4840,  4895,  4950,  5005,  5060,  1705,  5115,  5170,  1705, 
     1705,  2420,  5225,  2530,  1705,  5280,  2585,  1705,  2970,  5335, 
     3080,  1705,  5390,  3135,  4620,  5445,  5500,  5555,  3410,  1705, 
     5610,  5665,  3630,  3685,  3630,  5720,  3740,  1705,  5775,  5830, 
     5885,  5885,  5940,  5995,  3850,  3905,  3850,  6050,  3960,  1705, 
     6105,  4015,  4070,  6160,  4125,  1705,  6215,  6270,  6325,  6325, 
     6380,  6435,  6490,  4345,  6545,  4400,  1705,  6600,  6655,  6710, 
     6710,  6765,  6820,  6875,  6930,  6985,  7040,  7095,  1705,  7150, 
     7205,  1705,  1705,  1705,  2035,  7260,  7315,  7370,  7425,  7480, 
     7535,  5775,  7590,  7590,  6215,  7645,  7645,  7700,  6600,  7755, 
     7755,  7810,  1705,  7865,  7920,  7975,  1705,  8030,  8085,  8140, 
     8195,  8250,  8305,  8360,  5940,  6380,  8415,  6765,  8470,  8525, 
     8580,  1705,  8635,  8690,  8745,  8800,  8855,  8910,  8965,  9020, 
     9075,  9130,  9185,  9240,  9295,  1705,  1705,  9350,  9405,  9460, 
     9515,  1705,  1705,  1705,  9570,  9625,  9680,  9735,  9790,  9845, 
     1705,  9900,  4235,  4510,  9955, 10010, 10065, 10120,  2035
  };

  /** 
   * The packed transition table of the DFA
   */
  final private static String yy_packed = 
    "\1\34\1\35\14\34\1\36\4\34\1\37\43\34\1\40"+
    "\1\41\65\40\1\42\1\43\10\42\1\44\12\42\1\45"+
    "\41\42\1\46\1\47\65\46\1\42\1\43\5\42\1\50"+
    "\15\42\1\45\42\42\1\43\2\42\1\51\1\52\2\42"+
    "\1\53\3\42\1\53\3\42\1\52\4\42\1\52\1\54"+
    "\1\55\16\53\1\42\12\53\1\42\3\53\1\42\1\53"+
    "\1\42\1\43\2\42\1\51\1\56\12\42\1\56\4\42"+
    "\1\56\41\42\1\57\1\60\2\57\1\61\20\57\1\45"+
    "\41\57\1\42\1\43\2\42\1\62\1\52\2\42\1\63"+
    "\3\42\1\63\3\42\1\52\4\42\1\52\20\63\1\42"+
    "\12\63\1\42\3\63\1\42\1\63\1\42\1\43\2\42"+
    "\1\62\1\52\2\42\1\63\3\42\1\63\3\42\1\52"+
    "\4\42\1\52\20\63\1\64\12\63\1\42\3\63\1\42"+
    "\1\63\1\65\1\43\1\42\1\66\1\67\1\52\7\65"+
    "\1\70\1\65\1\71\1\52\4\65\1\52\41\65\1\42"+
    "\1\43\2\42\1\72\20\42\1\45\41\42\1\73\1\74"+
    "\1\75\1\76\4\73\1\77\3\73\1\77\11\73\20\100"+
    "\1\73\12\100\1\73\3\100\1\73\1\100\1\42\1\74"+
    "\1\75\1\76\1\42\1\52\2\42\5\101\3\42\1\52"+
    "\4\42\1\52\20\101\1\42\12\101\1\42\3\101\1\42"+
    "\1\101\1\42\1\74\1\75\1\76\1\42\1\52\2\42"+
    "\5\101\3\42\1\52\4\42\1\52\20\101\1\102\12\101"+
    "\1\42\3\101\1\42\1\101\1\103\1\74\1\75\1\104"+
    "\1\103\1\52\7\103\1\105\1\103\1\106\1\52\4\103"+
    "\1\52\41\103\1\42\1\107\1\110\2\42\1\52\12\42"+
    "\1\52\4\42\1\52\7\42\1\111\1\112\2\42\1\113"+
    "\7\42\1\113\1\42\1\112\1\111\13\42\1\43\1\110"+
    "\2\42\1\52\3\42\1\114\6\42\1\52\4\42\1\52"+
    "\42\42\1\43\1\110\2\42\1\52\2\42\1\115\1\114"+
    "\2\42\1\115\3\42\1\52\4\42\1\52\20\115\1\42"+
    "\12\115\1\42\3\115\1\42\1\115\1\42\1\43\1\110"+
    "\2\42\1\52\3\42\1\114\6\42\1\52\4\42\1\52"+
    "\14\42\1\116\5\42\1\117\5\42\1\116\10\42\1\120"+
    "\1\43\1\110\1\121\1\120\1\52\3\120\1\122\3\120"+
    "\1\123\1\120\1\124\1\52\4\120\1\52\41\120\1\125"+
    "\1\43\1\110\1\126\1\125\1\52\3\125\1\127\3\125"+
    "\1\130\1\125\1\131\1\52\4\125\1\52\41\125\1\132"+
    "\1\43\1\110\1\133\1\132\1\52\7\132\1\134\1\132"+
    "\1\135\1\52\4\132\1\52\41\132\1\136\1\137\1\140"+
    "\64\136\1\141\1\43\1\110\1\142\1\141\1\52\7\141"+
    "\1\143\1\141\1\144\1\52\4\141\1\52\41\141\1\145"+
    "\1\146\1\147\64\145\1\150\1\151\65\150\1\34\1\0"+
    "\14\34\1\0\4\34\1\0\43\34\3\0\1\152\1\153"+
    "\17\0\1\154\47\0\1\155\2\0\1\156\3\0\1\157"+
    "\3\0\1\155\4\0\1\155\20\156\1\0\12\156\1\0"+
    "\3\156\1\0\1\156\5\0\1\155\2\0\1\160\3\0"+
    "\1\160\3\0\1\155\2\0\1\161\1\0\1\155\20\160"+
    "\1\0\12\160\1\0\3\160\1\0\1\160\113\0\1\162"+
    "\54\0\1\163\63\0\1\164\61\0\1\165\71\0\1\52"+
    "\12\0\1\52\4\0\1\52\47\0\7\53\4\0\1\53"+
    "\4\0\20\53\1\0\12\53\1\0\5\53\6\0\7\53"+
    "\4\0\1\53\4\0\2\53\2\166\14\53\1\0\12\53"+
    "\1\0\5\53\6\0\7\53\4\0\1\53\4\0\2\53"+
    "\1\166\1\167\14\53\1\0\12\53\1\0\5\53\5\0"+
    "\1\56\12\0\1\56\4\0\1\56\43\0\1\170\66\0"+
    "\1\171\72\0\7\63\4\0\1\63\4\0\20\63\1\0"+
    "\12\63\1\0\5\63\1\65\2\0\1\172\1\65\1\0"+
    "\7\65\1\0\1\65\2\0\4\65\1\0\42\65\1\0"+
    "\1\171\1\172\1\65\1\0\7\65\1\0\1\65\2\0"+
    "\4\65\1\0\41\65\1\70\2\173\1\174\1\70\1\173"+
    "\7\70\1\175\1\70\2\173\4\70\1\173\41\70\1\71"+
    "\2\176\1\177\1\71\1\176\7\71\1\176\1\71\1\175"+
    "\1\176\4\71\1\176\41\71\1\73\3\0\22\73\20\0"+
    "\1\73\12\0\1\73\3\0\1\73\4\0\1\152\20\0"+
    "\1\154\44\0\1\200\64\0\1\73\3\0\2\73\7\77"+
    "\4\73\1\77\4\73\20\100\1\73\12\100\1\73\3\100"+
    "\1\77\1\100\6\0\7\100\4\0\1\100\4\0\20\100"+
    "\1\0\12\100\1\0\5\100\6\0\7\101\4\0\1\101"+
    "\4\0\20\101\1\0\12\101\1\0\5\101\1\103\2\0"+
    "\1\201\1\103\1\0\7\103\1\0\1\103\2\0\4\103"+
    "\1\0\42\103\1\0\1\200\1\201\1\103\1\0\7\103"+
    "\1\0\1\103\2\0\4\103\1\0\41\103\1\105\2\202"+
    "\1\203\1\105\1\202\7\105\1\204\1\105\2\202\4\105"+
    "\1\202\41\105\1\106\2\205\1\206\1\106\1\205\7\106"+
    "\1\205\1\106\1\204\1\205\4\106\1\205\41\106\3\0"+
    "\1\152\20\0\1\207\106\0\1\210\61\0\1\211\12\0"+
    "\1\211\46\0\2\212\33\0\12\213\1\214\54\213\6\0"+
    "\7\115\4\0\1\115\4\0\20\115\1\0\12\115\1\0"+
    "\5\115\47\0\1\215\5\0\1\215\71\0\1\216\6\0"+
    "\1\120\2\0\1\217\1\120\1\0\7\120\1\0\1\120"+
    "\2\0\4\120\1\0\41\120\1\122\2\213\1\220\1\122"+
    "\1\213\4\122\1\221\2\122\1\213\1\122\2\213\4\122"+
    "\1\213\41\122\1\123\2\222\1\223\1\123\1\222\7\123"+
    "\1\224\1\123\2\222\4\123\1\222\41\123\1\225\2\226"+
    "\1\227\1\230\1\226\3\230\2\225\2\230\1\226\1\225"+
    "\1\231\1\232\4\230\1\232\36\230\2\225\1\230\1\125"+
    "\2\0\1\233\1\125\1\0\7\125\1\0\1\125\2\0"+
    "\4\125\1\0\41\125\1\127\2\213\1\234\1\127\1\213"+
    "\4\127\1\235\2\127\1\213\1\127\2\213\4\127\1\213"+
    "\41\127\1\130\2\236\1\237\1\130\1\236\7\130\1\240"+
    "\1\130\2\236\4\130\1\236\41\130\1\131\2\241\1\242"+
    "\1\131\1\241\7\131\1\241\1\131\1\240\1\241\4\131"+
    "\1\241\41\131\1\132\2\0\1\243\1\132\1\0\7\132"+
    "\1\0\1\132\2\0\4\132\1\0\41\132\1\134\2\244"+
    "\1\245\1\134\1\244\7\134\1\246\1\134\2\244\4\134"+
    "\1\244\41\134\1\247\2\250\1\251\1\252\1\250\3\252"+
    "\2\247\2\252\1\250\1\247\1\253\1\254\4\252\1\254"+
    "\36\252\2\247\1\252\2\136\1\0\66\136\1\0\21\136"+
    "\1\255\42\136\1\141\2\0\1\256\1\141\1\0\7\141"+
    "\1\0\1\141\2\0\4\141\1\0\41\141\1\143\2\257"+
    "\1\260\1\143\1\257\7\143\1\261\1\143\2\257\4\143"+
    "\1\257\41\143\1\262\2\263\1\264\1\265\1\263\3\265"+
    "\2\262\2\265\1\263\1\262\1\266\1\267\4\265\1\267"+
    "\36\265\2\262\1\265\2\145\1\0\66\145\1\0\21\145"+
    "\1\270\42\145\7\0\1\271\1\0\1\272\62\0\1\155"+
    "\2\0\1\34\3\0\1\34\3\0\1\155\4\0\1\155"+
    "\20\34\1\0\12\34\1\0\3\34\1\0\1\34\1\273"+
    "\1\0\3\273\1\274\7\156\1\273\1\0\1\273\1\274"+
    "\1\156\1\273\1\0\1\273\1\274\20\156\1\273\12\156"+
    "\1\275\5\156\1\273\1\0\3\273\1\274\7\156\1\273"+
    "\1\0\1\273\1\274\1\276\1\273\1\0\1\273\1\274"+
    "\1\156\1\277\16\156\1\273\12\156\1\275\5\156\1\273"+
    "\1\0\3\273\1\274\7\160\1\273\1\0\1\273\1\274"+
    "\1\160\1\273\1\0\1\273\1\274\20\160\1\273\12\160"+
    "\1\300\5\160\23\0\1\161\54\0\1\272\57\0\1\301"+
    "\66\0\1\302\72\0\7\53\4\0\1\53\4\0\4\53"+
    "\2\303\12\53\1\0\12\53\1\0\5\53\6\0\7\53"+
    "\4\0\1\53\4\0\4\53\1\303\1\304\12\53\1\0"+
    "\12\53\1\0\5\53\15\173\1\175\51\173\17\176\1\175"+
    "\47\176\15\202\1\204\51\202\17\205\1\204\47\205\34\0"+
    "\1\305\26\0\1\305\42\0\1\306\12\0\1\306\55\0"+
    "\1\307\7\0\1\307\57\0\1\310\13\0\1\310\72\0"+
    "\1\311\4\0\15\222\1\224\51\222\1\225\2\226\1\312"+
    "\1\225\1\226\7\225\1\226\1\225\1\224\1\226\4\225"+
    "\1\226\41\225\17\226\1\224\47\226\1\225\2\226\1\312"+
    "\1\225\1\226\7\225\1\226\1\225\1\313\1\226\4\225"+
    "\1\226\41\225\17\0\1\314\47\0\17\226\1\313\47\226"+
    "\15\236\1\240\51\236\17\241\1\240\47\241\15\244\1\246"+
    "\51\244\1\247\2\250\1\315\1\247\1\250\7\247\1\250"+
    "\1\247\1\246\1\250\4\247\1\250\41\247\17\250\1\246"+
    "\47\250\1\247\2\250\1\315\1\247\1\250\7\247\1\250"+
    "\1\247\1\316\1\250\4\247\1\250\41\247\17\0\1\317"+
    "\47\0\17\250\1\316\47\250\2\136\1\0\6\136\1\320"+
    "\55\136\15\257\1\261\51\257\1\262\2\263\1\321\1\262"+
    "\1\263\7\262\1\263\1\262\1\261\1\263\4\262\1\263"+
    "\41\262\17\263\1\261\47\263\1\262\2\263\1\321\1\262"+
    "\1\263\7\262\1\263\1\262\1\322\1\263\4\262\1\263"+
    "\41\262\17\0\1\323\47\0\17\263\1\322\47\263\2\145"+
    "\1\0\6\145\1\324\55\145\7\0\1\325\113\0\1\326"+
    "\32\0\1\273\1\0\14\273\1\0\4\273\1\0\35\273"+
    "\1\0\6\273\1\0\3\273\1\274\2\273\1\327\3\273"+
    "\1\327\1\273\1\0\1\273\1\274\2\273\1\0\1\273"+
    "\1\274\20\327\1\273\12\327\1\330\3\327\1\273\1\327"+
    "\1\273\1\0\3\273\1\274\7\156\1\273\1\0\1\273"+
    "\1\274\1\276\1\273\1\0\1\273\1\274\20\156\1\273"+
    "\12\156\1\331\5\156\1\273\1\0\3\273\1\274\7\156"+
    "\1\273\1\0\1\273\1\274\1\332\1\273\1\0\1\273"+
    "\1\274\6\156\3\332\2\156\1\332\4\156\1\273\2\156"+
    "\1\332\1\156\2\332\2\156\1\332\1\156\1\275\2\332"+
    "\3\156\6\0\1\53\1\333\5\53\4\0\1\53\4\0"+
    "\20\53\1\0\12\53\1\0\5\53\37\0\1\334\12\0"+
    "\1\334\46\0\2\335\63\0\2\336\74\0\1\337\12\0"+
    "\1\337\46\0\2\340\36\0\2\341\1\0\3\341\2\0"+
    "\2\341\2\0\1\231\44\341\2\0\1\341\3\0\2\342"+
    "\1\0\3\342\2\0\2\342\2\0\1\253\44\342\2\0"+
    "\1\342\2\136\1\0\31\136\1\343\32\136\3\0\2\344"+
    "\1\0\3\344\2\0\2\344\2\0\1\266\44\344\2\0"+
    "\1\344\2\145\1\0\31\145\1\345\32\145\35\0\1\346"+
    "\31\0\1\273\1\0\3\273\1\347\7\327\1\273\1\0"+
    "\1\273\1\347\1\327\1\273\1\0\1\273\1\347\20\327"+
    "\1\273\12\327\1\350\5\327\61\0\1\330\5\0\1\273"+
    "\1\0\3\273\1\274\7\156\1\273\1\0\1\273\1\274"+
    "\1\332\1\273\1\0\1\273\1\274\6\156\3\332\2\156"+
    "\1\332\4\156\1\273\2\156\1\332\1\156\2\332\2\156"+
    "\1\332\1\156\1\331\2\332\3\156\6\0\7\53\4\0"+
    "\1\53\4\0\14\53\1\351\3\53\1\0\12\53\1\0"+
    "\5\53\47\0\1\352\5\0\1\352\54\0\1\353\64\0"+
    "\1\354\7\0\1\354\56\0\1\355\7\0\1\355\60\0"+
    "\1\356\23\0\2\136\1\0\32\136\1\357\31\136\2\145"+
    "\1\0\32\145\1\360\31\145\36\0\1\361\30\0\1\273"+
    "\1\0\3\273\1\347\2\273\1\327\3\273\1\327\1\273"+
    "\1\0\1\273\1\347\2\273\1\0\1\273\1\347\20\327"+
    "\1\273\12\327\1\0\3\327\1\273\1\327\6\0\7\53"+
    "\4\0\1\53\4\0\20\53\1\0\3\53\1\362\6\53"+
    "\1\0\5\53\50\0\1\363\60\0\1\364\13\0\1\364"+
    "\55\0\1\365\51\0\2\366\71\0\1\367\26\0\1\367"+
    "\3\0\2\136\1\0\33\136\1\370\30\136\2\145\1\0"+
    "\33\145\1\371\30\145\37\0\1\372\35\0\7\53\4\0"+
    "\1\53\4\0\20\53\1\0\6\53\1\373\3\53\1\0"+
    "\5\53\41\0\1\374\7\0\1\374\54\0\1\375\12\0"+
    "\1\375\53\0\1\376\12\0\1\376\14\0\2\136\1\0"+
    "\34\136\1\377\27\136\2\145\1\0\34\145\1\u0100\27\145"+
    "\36\0\1\u0101\36\0\7\53\4\0\1\53\4\0\5\53"+
    "\1\u0102\12\53\1\0\12\53\1\0\5\53\2\136\1\0"+
    "\33\136\1\u0103\30\136\2\145\1\0\33\145\1\u0104\30\145"+
    "\11\0\1\u0105\63\0\7\53\4\0\1\53\4\0\13\53"+
    "\1\u0106\4\53\1\0\12\53\1\0\5\53\2\136\1\0"+
    "\6\136\1\u0107\55\136\2\145\1\0\6\145\1\u0108\55\145"+
    "\6\0\7\53\4\0\1\53\4\0\14\53\1\u0109\3\53"+
    "\1\0\12\53\1\0\5\53\6\0\7\53\4\0\1\53"+
    "\4\0\20\53\1\0\12\53\1\0\4\53\1\u010a\6\0"+
    "\7\53\4\0\1\53\4\0\13\53\1\u010b\4\53\1\0"+
    "\12\53\1\0\5\53\6\0\7\53\4\0\1\53\4\0"+
    "\13\53\1\u010c\4\53\1\0\12\53\1\0\5\53\6\0"+
    "\7\53\4\0\1\53\4\0\20\53\1\0\3\53\1\u010d"+
    "\6\53\1\0\5\53";

  /** 
   * The transition table of the DFA
   */
  final private static int yytrans [] = yy_unpack(yy_packed);


  /* error codes */
  final private static int YY_UNKNOWN_ERROR = 0;
  // final private static int YY_ILLEGAL_STATE = 1;
  final private static int YY_NO_MATCH = 2;
  final private static int YY_PUSHBACK_2BIG = 3;

  /* error messages for the codes above */
  final private static String YY_ERROR_MSG[] = {
    "Unkown internal scanner error",		//$NON-NLS-1$
    "Internal error: unknown state",		//$NON-NLS-1$
    "Error: could not match input",		//$NON-NLS-1$
    "Error: pushback value was too large"	//$NON-NLS-1$
  };

  /**
   * YY_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private final static byte YY_ATTRIBUTE[] = {
     1,  0,  0,  0,  0,  1,  0,  0,  1,  1,  1,  0,  1,  1,  1,  1, 
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  0,  1,  1,  1,  1,  9, 
     1,  9,  1,  1,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  9,  1, 
     1,  1,  1,  9,  1,  1,  1,  1,  1,  1,  1,  1,  9,  1,  1,  1, 
     1,  9,  1,  1,  1,  1,  1,  9,  1,  1,  1,  1,  1,  1,  1,  1, 
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  9, 
     1,  1,  1,  1,  1,  1,  9,  9,  1,  9,  9,  1,  0,  1,  1,  1, 
     1,  0,  0,  0,  9,  1,  1,  9,  9,  0,  0,  0,  9,  0,  0,  9, 
     0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  9,  0,  0,  0,  0, 
     1,  0,  0,  9,  1,  0,  0,  1,  1,  0,  0,  0,  1,  0,  0,  9, 
     0,  0,  0,  0,  0,  9,  1,  0,  0,  1,  1,  0,  1,  0,  0,  0, 
     9,  1,  0,  0,  1,  1,  0,  1,  0,  0,  1,  1,  9,  1,  1,  9, 
     9,  9,  1,  1,  0,  0,  0,  0,  0,  0,  1,  0,  0,  1,  0,  1, 
     0,  1,  0,  1,  9,  0,  1,  1,  9,  1,  1,  0,  0,  0,  0,  0, 
     0,  0,  1,  0,  1,  0,  1,  9,  1,  0,  0,  0,  0,  0,  1,  1, 
     0,  1,  0,  0,  0,  9,  9,  1,  1,  0,  1,  9,  9,  9,  1,  1, 
     0,  1,  1,  1,  9,  1,  1,  1,  1,  1,  1,  1,  1
  };

  /** the input device */
  private java.io.Reader yy_reader;

  /** the current state of the DFA */
  private int yy_state;

  /** the current lexical state */
  private int yy_lexical_state = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char yy_buffer[] = new char[16384];

  /** the textposition at the last accepting state */
  private int yy_markedPos;

  /** the current text position in the buffer */
  private int yy_currentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int yy_startRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int yy_endRead;

  /** number of newlines encountered up to the start of the matched text */
  // private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  // private int yycolumn; 

  /** 
   * yy_atBOL == true <=> the scanner is currently at the beginning of a line
   */
  // private boolean yy_atBOL;

  /** yy_atEOF == true <=> the scanner has returned a value for EOF */
  private boolean yy_atEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean yy_eof_done;

  /* user code: */
	private int fTokenCount = 0;
 
	// required holders for white-space compacting
	private boolean fShouldLoadBuffered = false;
	private String fBufferedContext = null;
	private int fBufferedStart = 1;
	private int fBufferedLength = 0;
	private String f_context = null;

	// state stack for handling embedded regions
	private IntStack fStateStack = new IntStack();

	private String context = null;
	private int start = 0;
	private int textLength = 0;
	private int length = 0;

	// offset for tracking position specific block tags
	private int fOffset = 0;
	
	// the name of the current tag being opened
	private String fCurrentTagName = null;

	// the list of tag name BlockMarkers
	private List fBlockMarkers = new ArrayList();

	// required to not seek text blocks on an end tag
	private boolean fIsBlockingEnabled = false;
	private boolean fIsCaseSensitiveBlocking = true;

	private XMLParserRegionFactory fRegionFactory = new XMLParserRegionFactory();
/**
 * user method 
 */
public final void addBlockMarker(BlockMarker marker) {
	if(containsTagName(marker.getTagName()))
		return;
	fBlockMarkers.add(marker);
}
/**
 * user method 
 */
public final void removeBlockMarker(BlockMarker marker) {
	fBlockMarkers.remove(marker);
}
/**
 * user method 
 */
public final void removeBlockMarker(String tagname) {
	if (fBlockMarkers != null) {
		Iterator blocks = fBlockMarkers.iterator();
		while (blocks.hasNext()) {
			if (((BlockMarker) blocks.next()).getTagName().equals(tagname))
				blocks.remove();
		}
	}
}
/* user method */
public final boolean isCaseSensitiveBlocking() {
	return fIsCaseSensitiveBlocking;
}
/* user method */
public final void setCaseSensitiveBlocking(boolean newValue) {
	fIsCaseSensitiveBlocking = newValue;
}
/* user method */
public boolean getBlockMarkerCaseSensitivity() {
        return getBlockMarkerCaseSensitivity(fCurrentTagName);
}
/* user method */
public boolean getBlockMarkerCaseSensitivity(String name) {
	Iterator iterator = fBlockMarkers.iterator();
	while(iterator.hasNext()) {
		BlockMarker marker = (BlockMarker)iterator.next();
		boolean casesensitive = marker.isCaseSensitive();
		if(casesensitive && marker.getTagName().equals(name))
			return casesensitive;
		else if(!casesensitive && marker.getTagName().equalsIgnoreCase(name))
			return casesensitive;
	}
	return true;
}
/* user method */
public String getBlockMarkerContext() {
	return getBlockMarkerContext(fCurrentTagName);
}
/* user method */
public String getBlockMarkerContext(String name) {
	Iterator iterator = fBlockMarkers.iterator();
	while(iterator.hasNext()) {
		BlockMarker marker = (BlockMarker)iterator.next();
		if(marker.getTagName().equals(name))
			return marker.getContext();
	}
	return BLOCK_TEXT;
}
/* user method */
public List getBlockMarkers() {
	return fBlockMarkers;
}
/* user method */
public final int getOffset() {
	return fOffset + yychar;
}
private final boolean isBlockMarker() {
	return isBlockMarker(fCurrentTagName);
}
private final boolean isBlockMarker(String tagName) {
	if (!fIsBlockingEnabled)
		return false;
	return containsTagName(tagName);
}
/**
 * user method
 */
public final void beginBlockTagScan(String newTagName) {
	beginBlockMarkerScan(newTagName, BLOCK_TEXT);
}
/**
 * user method
 *
 * Special tokenizer setup.  Allows tokenization to be initiated at the
 * start of a text block within a "newTagName" tag.
 *
 * Example: 
 *	Tokenizer toker = new Tokenizer();
 *	toker.setCaseSensitiveBlocking(false);
 *	toker.reset(new java.io.StringReader("afiuhqwkejhtasihgalkwhtq</scripter></scr></script>asgdasga"));
 *	toker.beginBlockMarkerScan("script", BLOCK_TEXT);
 *	toker.getRegions(); 
 *
 * Returns:
 *	BLOCK_TEXT: 0-40
 *	XML_END_TAG_OPEN: 41-42
 *	XML_TAG_NAME: 43-48
 *	XML_TAG_CLOSE: 49-49
 *	XML_CONTENT: 50-57
 *
 */
public final void beginBlockMarkerScan(String newTagName, String blockcontext) {
	yybegin(ST_BLOCK_TAG_SCAN);
	fCurrentTagName = newTagName;
}
/**
 * Method doScan.
 * 
 * Returns a context region for all of the text from the current position upto the end of input or
 * to right *before* the first occurence of searchString
 * 
 * @param searchString - target string to search for ex.: "-->", "</tagname"
 * @param requireTailSeparator - whether the target must be immediately followed by whitespace or '>'
 * @param context - the context of the scanned region if non-zero length
 * @param exitState - the state to go to if the region was of non-zero length
 * @param abortState - the state to go to if the searchString was found immediately
 * @return String - the context found: the desired context on a non-zero length match, the abortContext on immediate success
 * @throws IOException
 */
private final String doScan(String searchString, boolean requireTailSeparator, String searchContext, int exitState, int immediateFallbackState) throws IOException {
	boolean stillSearching = true;
	// Disable further block (probably)
	fIsBlockingEnabled = false;
	int searchStringLength = searchString.length();
	int n = 0;
	char lastCheckChar;
	int i;
	boolean same = false;
	while (stillSearching) {
		n = 0;
		// Ensure that enough data from the input exists to compare against the search String.
		n = yy_advance();
		while(n != YYEOF && yy_currentPos < searchStringLength)
			n = yy_advance();
		// If the input was too short or we've exhausted the input, stop immediately.
		if (n == YYEOF) {
			stillSearching = false;
		}
		else {
			same = true;
			// Ensure that we've not encountered a complete block (<%%>) that was *shorter* than the closeTagString and
			// thus found twice at current-targetLength [since the first scan would have come out this far anyway].
			// Check the characters in the target versus the last targetLength characters read from the buffer
			// and see if it matches
			
			// safety check for array accesses (yy_currentPos is the *last* character we can check against)
			if(yy_currentPos >= searchStringLength && yy_currentPos <= yy_buffer.length) {
				for(i = 0; i < searchStringLength; i++) {
					if(same && fIsCaseSensitiveBlocking)
						same = yy_buffer[i + yy_currentPos - searchStringLength] == searchString.charAt(i);
					else if(same && !fIsCaseSensitiveBlocking)
						same = Character.toLowerCase(yy_buffer[i + yy_currentPos - searchStringLength]) == Character.toLowerCase(searchString.charAt(i));
				}
			}
			// safety check failed; no match is possible right now
			else {
				same = false;
			}
			if (same && requireTailSeparator && yy_currentPos < yy_buffer.length) {
				// Additional check for close tags to ensure that targetString="</script" doesn't match
				// "</scriptS"
				lastCheckChar = yy_buffer[yy_currentPos];
				// Succeed on "</script>" and "</script "
				if(lastCheckChar == '>' || Character.isWhitespace(lastCheckChar))
					stillSearching = false;
			}
			else {
				stillSearching = !same || (yy_currentPos < yy_startRead + searchStringLength);
			}
		}
	}
	if (n != YYEOF || same) {
		// We've stopped short of the end or definitely found a match
		yy_markedPos = yy_currentPos - searchStringLength;
		yy_currentPos = yy_markedPos + 1;
		// If the searchString occurs at the very beginning of what would have
		// been a Block, resume scanning normally immediately
		if (yy_markedPos == yy_startRead) {
			yybegin(immediateFallbackState);
			return primGetNextToken();
		}
	}
	else {
		// We ran through the rest of the input
		yy_markedPos = yy_currentPos;
		yy_currentPos++;
	}
	yybegin(exitState);
	// If the ending occurs at the very beginning of what would have
	// been a Block, resume scanning normally immediately
	if(yy_markedPos == yy_startRead)
		return primGetNextToken();
	return searchContext;
}
/**
 * user method
 *
 * A generic lookahead-like operation
 */
private final String doBlockScan(String target, String targetContext, int immediateFallbackState) throws IOException {
	return doScan(target, false, targetContext, immediateFallbackState, immediateFallbackState);
}
/**
 * user method 
 * does a lookahead for the current tag name
 */
private final String doBlockTagScan() throws IOException {
        fIsCaseSensitiveBlocking = getBlockMarkerCaseSensitivity();
	return doScan("</" + fCurrentTagName, true, getBlockMarkerContext(fCurrentTagName), YYINITIAL, YYINITIAL);
}
/**
 * user method
 *
 * Converts the raw context String returned by the primGetNextToken()
 * method into a full ITextRegion by pulling in values for the
 * current offset within the scanning text.
 *
 * Returns null when EOF is encountered and attaches intermittently
 * discovered whitespace onto the end of useful regions.
 *
 * Note that this algorithm caches the token following the one being returned
 * so that whitespace can be collapsed.
 */
public final ITextRegion getNextToken() throws IOException {
	// load the starting non-whitespace token (assume that it is so)
	if (fShouldLoadBuffered) {
		context = fBufferedContext;
		start = fBufferedStart;
		textLength = length = fBufferedLength;
		fShouldLoadBuffered = false;
	}
	else {
		context = primGetNextToken();
		if (context == XML_TAG_NAME) {
			if(containsTagName(yy_buffer, yy_startRead, yy_markedPos-yy_startRead))
				fCurrentTagName = yytext();
			else
				fCurrentTagName = null;
		}
		else if (context == XML_TAG_OPEN) {
			fIsBlockingEnabled = true;
		}
		else if (context == XML_END_TAG_OPEN) {
			fIsBlockingEnabled = false;
		}
		start = yychar;
		textLength = length = yylength();
		if (yy_atEOF) {
			fTokenCount++;
			return null;
		}
	}
	// store the next token
	f_context = primGetNextToken();
	if (f_context == XML_TAG_NAME) {
		if(containsTagName(yy_buffer, yy_startRead, yy_markedPos-yy_startRead))
			fCurrentTagName = yytext();
		else
			fCurrentTagName = null;
	}
	else if (f_context == XML_TAG_OPEN) {
		fIsBlockingEnabled = true;
	}
	else if (f_context == XML_END_TAG_OPEN) {
		fIsBlockingEnabled = false;
	}
	fBufferedContext = f_context;
	fBufferedStart = yychar;
	fBufferedLength = yylength();
	fShouldLoadBuffered = true;
	if (fBufferedContext == WHITE_SPACE) {
		fShouldLoadBuffered = false;
		length += fBufferedLength;
	}
	if (context == null) {
		// EOF
		if (Debug.debugTokenizer) {
			System.out.println(getClass().getName() + " discovered " + fTokenCount + " tokens."); //$NON-NLS-2$//$NON-NLS-1$
		}
		return null;
	}
	fTokenCount++;
	return fRegionFactory.createToken(context, start, textLength, length, null, fCurrentTagName);
}
/* user method */
public HTMLTokenizer(){
	super();
}
/* user method */
public HTMLTokenizer(char[] charArray){
		this(new CharArrayReader(charArray));
}
/* user method */
public void reset(char[] charArray) {
	reset(new CharArrayReader(charArray), 0);
}
/* user method */
public void reset(char[] charArray, int newOffset) {
	reset(new CharArrayReader(charArray), newOffset);
}
/* user method */
public void reset(java.io.InputStream in) {
	reset(new java.io.InputStreamReader(in), 0);
}
/* user method */
public void reset(java.io.InputStream in, int newOffset) {
	reset(new java.io.InputStreamReader(in), newOffset);
}
/* user method */
public void reset(java.io.Reader in) {
	reset(in, 0);
}
/**
 * user method *
 *
 * Reset internal counters and vars to "newly created" values, in the hopes
 * that resetting a pre-existing tokenizer is faster than creating a new one.
 *
 * This method contains code blocks that were essentially duplicated from the
 * <em>generated</em> output of this specification before this method was
 * added.  Those code blocks were under the above copyright.
 */
public void reset(java.io.Reader in, int newOffset) {
	if (Debug.debugTokenizer) {
		System.out.println("resetting tokenizer");//$NON-NLS-1$
	}
	fOffset = newOffset;

	/* the input device */
	yy_reader = in;

	/* the current state of the DFA */
	yy_state = 0;

	/* the current lexical state */
	yy_lexical_state = YYINITIAL;

	/* this buffer contains the current text to be matched and is
	the source of the yytext() string */
	java.util.Arrays.fill(yy_buffer, (char)0);

	/* the textposition at the last accepting state */
	yy_markedPos = 0;

	/* the current text position in the buffer */
	yy_currentPos = 0;

	/* startRead marks the beginning of the yytext() string in the buffer */
	yy_startRead = 0;

	/** 
	 * endRead marks the last character in the buffer, that has been read
	 * from input 
	 */
	yy_endRead = 0;

	/* number of newlines encountered up to the start of the matched text */
	//yyline = 0;

	/* the number of characters up to the start of the matched text */
	yychar = 0;

	/* yy_atEOF == true <=> the scanner has returned a value for EOF */
	yy_atEOF = false;

	/* denotes if the user-EOF-code has already been executed */
	yy_eof_done = false;


	/* user vars: */
	fTokenCount = 0;
 
	fShouldLoadBuffered = false;
	fBufferedContext = null;
	fBufferedStart = 1;
	fBufferedLength = 0;
	fStateStack = new IntStack();

	context = null;
	start = 0;
	textLength = 0;
	length = 0;
}

	/**
	 * user method
	 *
	 */
	public BlockTokenizer newInstance() {
		HTMLTokenizer newInstance = new HTMLTokenizer();
		// global tagmarkers can be shared; they have no state and 
		// are never destroyed (e.g. 'release')
		for(int i = 0; i < fBlockMarkers.size(); i++) {
			BlockMarker blockMarker = (BlockMarker) fBlockMarkers.get(i);
			if(blockMarker.isGlobal())
				newInstance.addBlockMarker(blockMarker);
		}
		return newInstance;
	}
/* user method */
private final String scanXMLCommentText() throws IOException {
	// Scan for '-->' and return the text up to that point as
	//   XML_COMMENT_TEXT unless the string occurs IMMEDIATELY, in which
	//  case change to the ST_XML_COMMENT_END state and return the next
	//  context as usual.
	return doScan("-->", false, XML_COMMENT_TEXT, ST_XML_COMMENT_END, ST_XML_COMMENT_END);
}


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public HTMLTokenizer(java.io.Reader in) {
    this.yy_reader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public HTMLTokenizer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed DFA transition table.
   *
   * @param packed   the packed transition table
   * @return         the unpacked transition table
   */
  private static int [] yy_unpack(String packed) {
    int [] trans = new int[10175];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 3126) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do trans[j++] = value; while (--count > 0);
    }
    return trans;
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] yy_unpack_cmap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1372) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Gets the next input character.
   *
   * @return      the next character of the input stream, EOF if the
   *              end of the stream is reached.
   * @exception   IOException  if any I/O-Error occurs
   */
  private int yy_advance() throws java.io.IOException {

    /* standard case */
    if (yy_currentPos < yy_endRead) return yy_buffer[yy_currentPos++];

    /* if the eof is reached, we don't need to work hard */ 
    if (yy_atEOF) return YYEOF;

    /* otherwise: need to refill the buffer */

    /* first: make room (if you can) */
    if (yy_startRead > 0) {
      System.arraycopy(yy_buffer, yy_startRead, 
                       yy_buffer, 0, 
                       yy_endRead-yy_startRead);

      /* translate stored positions */
      yy_endRead-= yy_startRead;
      yy_currentPos-= yy_startRead;
      yy_markedPos-= yy_startRead;
      yy_startRead = 0;
    }

    /* is the buffer big enough? */
    if (yy_currentPos >= yy_buffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[yy_currentPos*2];
      System.arraycopy(yy_buffer, 0, newBuffer, 0, yy_buffer.length);
      yy_buffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = yy_reader.read(yy_buffer, yy_endRead, 
                                            yy_buffer.length-yy_endRead);

    if ( numRead == -1 ) return YYEOF;

    yy_endRead+= numRead;

    return yy_buffer[yy_currentPos++];
  }

    
  /**
   * Closes the input stream.
   */
  final public void yyclose() throws java.io.IOException {
    yy_atEOF = true;            /* indicate end of file */
    yy_endRead = yy_startRead;  /* invalidate buffer    */
    yy_reader.close();
  }


  /**
   * Returns the current lexical state.
   */
  final public int yystate() {
    return yy_lexical_state;
  }

  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  final public void yybegin(int newState) {
    yy_lexical_state = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  final public String yytext() {
    return new String( yy_buffer, yy_startRead, yy_markedPos-yy_startRead );
  }

  /**
   * Returns the length of the matched text region.
   */
  final public int yylength() {
    return yy_markedPos-yy_startRead;
  }


  /**
   * Reports an error that occured while scanning - from the SED JFlex skeleton
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void yy_ScanError(int errorCode) {
    try {
      Logger.log(Logger.ERROR, YY_ERROR_MSG[errorCode]);
    }
    catch (ArrayIndexOutOfBoundsException e) {
      Logger.log(Logger.ERROR, YY_ERROR_MSG[YY_UNKNOWN_ERROR]);
    }
    // DO NOT EXIT the VM on an error
    // System.exit(1);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  void yypushback(int number) {
    if ( number > yylength() )
      yy_ScanError(YY_PUSHBACK_2BIG);

    yy_markedPos -= number;
  }

	/**
	 * user method - skeleton.sed
	 */
	protected final boolean containsTagName(char[] markerTagName, int offset, int tagnameLength) {
		for(int j = 0; j < fBlockMarkers.size(); j++) {
			BlockMarker marker = (BlockMarker)fBlockMarkers.get(j);
			if(marker.getTagName().length() == tagnameLength) {
				boolean matchesSoFar = true;
				for(int i = 0; i < tagnameLength && matchesSoFar; i++) {
					if(marker.isCaseSensitive()) {
						if(marker.getTagName().charAt(i) != markerTagName[i + offset])
							matchesSoFar = false;
					}
					else {
						if(Character.toLowerCase(marker.getTagName().charAt(i)) != Character.toLowerCase(markerTagName[i + offset]))
							matchesSoFar = false;
					}
				}
				if(matchesSoFar)
					return true;
			}
		}
		return false;
	}

	/**
	 * user method - skeleton.sed
	 *
	 * Return ALL of the regions scannable within the remaining text
	 * Note: for verification use
	 */
	public final List getRegions() {
		List tokens = new ArrayList();
		ITextRegion region = null;
		try {
			region = getNextToken();
			while(region != null) {
				if (region != null) {
					tokens.add(region);
				}
				region = getNextToken();
			}
		}
		catch (StackOverflowError e) {
			Logger.logException(getClass().getName()+": input could not be tokenized correctly at position " + getOffset(), e);//$NON-NLS-1$
			throw e;
		}
		catch (Exception e) {
			// Since this is convenience method and NOT the recommended 
			// way of getting tokens, many errors are simply hidden
			Logger.logException("Exception not handled retrieving regions: " + e.getLocalizedMessage(), e);//$NON-NLS-1$
		}
		return tokens;
	}
	/**
	 * user method - skeleton.sed
	 */
	private final void dump(String s) {
		if (Debug.debugTokenizer) {
			System.out.println(s + " (" + yychar + "-" + //$NON-NLS-2$//$NON-NLS-1$
				(yylength() + yychar) + "):\'" +//$NON-NLS-1$
					StringUtils.escape(yytext()) + "\'");//$NON-NLS-1$
		}
	}
	/* user method  - skeleton.sed */
	public final boolean isEOF() {
		return yy_atEOF;
	}
/* user method - skeleton.sed */
protected final boolean containsTagName(String markerTagName) {
	Iterator blocks = fBlockMarkers.iterator();
	while(blocks.hasNext()) {
		BlockMarker marker = (BlockMarker)blocks.next();
		if(marker.isCaseSensitive()) {
			if(marker.getTagName().equals(markerTagName))
				return true;
		}
		else {
			if(marker.getTagName().equalsIgnoreCase(markerTagName))
				return true;
		}
	}
	return false;
}

  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void yy_do_eof() {
    if (!yy_eof_done) {
      yy_eof_done = true;
    // do nothing, this is the downstream parser's job

    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   IOException  if any I/O-Error occurs
   */
  public String primGetNextToken() throws java.io.IOException {
    int yy_input;
    int yy_action;


    while (true) {

      yychar+= yylength();

      yy_action = -1;

      yy_currentPos = yy_startRead = yy_markedPos;

      yy_state = yy_lexical_state;


      yy_forAction: {
        while (true) {
    
          yy_input = yy_advance();

          if ( yy_input == YYEOF ) break yy_forAction;

          int yy_next = yytrans[ yy_rowMap[yy_state] + yycmap[yy_input] ];
          if (yy_next == -1) break yy_forAction;
          yy_state = yy_next;

          int yy_attributes = YY_ATTRIBUTE[yy_state];
          if ( (yy_attributes & 1) > 0 ) {
            yy_action = yy_state; 
            yy_markedPos = yy_currentPos; 
            if ( (yy_attributes & 8) > 0 ) break yy_forAction;
          }

        }
      }


      switch (yy_action) {    

        case 268: 
          { 
	if(Debug.debugTokenizer)
		dump("XSL processing instruction target");//$NON-NLS-1$
        yybegin(ST_XML_PI_ATTRIBUTE_NAME);
        return XML_TAG_NAME;
 }
        case 270: break;
        case 260: 
        case 262: 
        case 263: 
          { 
	if(Debug.debugTokenizer)
		dump("\nCDATA start");//$NON-NLS-1$
	fStateStack.push(yystate());
	yybegin(ST_CDATA_TEXT);
	return XML_CDATA_OPEN;
 }
        case 271: break;
        case 253: 
          { 
	if(Debug.debugTokenizer)
		dump("element");//$NON-NLS-1$
	yybegin(ST_XML_ELEMENT_DECLARATION);
	return XML_ELEMENT_DECLARATION;
 }
        case 272: break;
        case 252: 
          { 
	if(Debug.debugTokenizer)
		dump("attlist");//$NON-NLS-1$
	yybegin(ST_XML_ATTLIST_DECLARATION);
	return XML_ATTLIST_DECLARATION;
 }
        case 273: break;
        case 251: 
          { 
	if(Debug.debugTokenizer)
		dump("doctype");//$NON-NLS-1$
	yybegin(ST_XML_DOCTYPE_DECLARATION);
	return XML_DOCTYPE_DECLARATION;
 }
        case 274: break;
        case 246: 
          { 
	if(Debug.debugTokenizer)
		dump("doctype external id");//$NON-NLS-1$
	yybegin(ST_XML_DOCTYPE_ID_PUBLIC);
	return XML_DOCTYPE_EXTERNAL_ID_PUBLIC;
 }
        case 275: break;
        case 245: 
          { 
	if(Debug.debugTokenizer)
		dump("doctype external id");//$NON-NLS-1$
	yybegin(ST_XML_DOCTYPE_ID_SYSTEM);
	return XML_DOCTYPE_EXTERNAL_ID_SYSTEM;
 }
        case 276: break;
        case 216: 
          { 
	if(Debug.debugTokenizer)
		dump("\nCharRef");//$NON-NLS-1$
	return XML_CHAR_REFERENCE;
 }
        case 277: break;
        case 212: 
          { 
	if(Debug.debugTokenizer)
		dump("\ncomment start");//$NON-NLS-1$
	yybegin(ST_XML_COMMENT);
	return XML_COMMENT_OPEN;
 }
        case 278: break;
        case 194: 
        case 195: 
          { 
	if(Debug.debugTokenizer)
		dump("XML processing instruction target");//$NON-NLS-1$
        yybegin(ST_XML_PI_ATTRIBUTE_NAME);
        return XML_TAG_NAME;
 }
        case 279: break;
        case 193: 
          { 
	if(Debug.debugTokenizer)
		dump("comment end");//$NON-NLS-1$
	yybegin(YYINITIAL);
	return XML_COMMENT_CLOSE;
 }
        case 280: break;
        case 192: 
          { 
	if(Debug.debugTokenizer)
		dump("CDATA end");//$NON-NLS-1$
	yybegin(fStateStack.pop());
	return XML_CDATA_CLOSE;
 }
        case 281: break;
        case 191: 
          { 
	if(Debug.debugTokenizer)
		dump("\nPEReference");//$NON-NLS-1$
	return XML_PE_REFERENCE;
 }
        case 282: break;
        case 188: 
          { 
	if(Debug.debugTokenizer)
		dump("\nEntityRef");//$NON-NLS-1$
	return XML_ENTITY_REFERENCE;
 }
        case 283: break;
        case 139: 
        case 144: 
        case 156: 
          { 
	return XML_DOCTYPE_INTERNAL_SUBSET;
 }
        case 284: break;
        case 127: 
          { 
        yybegin(YYINITIAL);
	if(Debug.debugTokenizer)
		dump("empty tag close");//$NON-NLS-1$
        return XML_EMPTY_TAG_CLOSE;
 }
        case 285: break;
        case 120: 
          { 
	if(Debug.debugTokenizer)
		dump("XML processing instruction end");//$NON-NLS-1$
        yybegin(YYINITIAL);
        return XML_PI_CLOSE;
 }
        case 286: break;
        case 119: 
          { 
		// ended with nothing inside
        yybegin(YYINITIAL);
        return XML_PI_CLOSE;
 }
        case 287: break;
        case 52: 
        case 54: 
        case 55: 
        case 56: 
        case 124: 
          { 
	if(Debug.debugTokenizer)
		dump("XML processing instruction attribute value");//$NON-NLS-1$
        yybegin(ST_XML_PI_ATTRIBUTE_NAME);
        return XML_TAG_ATTRIBUTE_VALUE;
 }
        case 288: break;
        case 51: 
          { 
	if(Debug.debugTokenizer)
		dump("XML processing instruction '='");//$NON-NLS-1$
        yybegin(ST_XML_PI_ATTRIBUTE_VALUE);
        return XML_TAG_ATTRIBUTE_EQUALS;
 }
        case 289: break;
        case 50: 
          { 
	if(Debug.debugTokenizer)
		dump("XML processing instruction attribute name");//$NON-NLS-1$
        yybegin(ST_XML_PI_EQUALS);
        return XML_TAG_ATTRIBUTE_NAME;
 }
        case 290: break;
        case 46: 
        case 47: 
        case 48: 
          { 
	// block scan until close is found
	return doScan("?>", false, XML_PI_CONTENT, ST_XML_PI_TAG_CLOSE, ST_XML_PI_TAG_CLOSE);
 }
        case 291: break;
        case 45: 
          { 
        yybegin(ST_PI_CONTENT);
        return WHITE_SPACE;
 }
        case 292: break;
        case 42: 
        case 43: 
        case 44: 
        case 117: 
        case 118: 
        case 218: 
        case 232: 
        case 241: 
        case 250: 
        case 257: 
        case 261: 
        case 264: 
        case 265: 
        case 266: 
        case 267: 
          { 
	if(Debug.debugTokenizer)
		dump("processing instruction target");//$NON-NLS-1$
        yybegin(ST_PI_WS);
        return XML_TAG_NAME;
 }
        case 293: break;
        case 37: 
        case 38: 
          { 
	if(Debug.debugTokenizer)
		dump("comment content");//$NON-NLS-1$
	return scanXMLCommentText();
 }
        case 294: break;
        case 36: 
          { 
	if(Debug.debugTokenizer)
		dump("LINE FEED");//$NON-NLS-1$
	return WHITE_SPACE;
 }
        case 295: break;
        case 31: 
        case 32: 
          { 
	if(Debug.debugTokenizer)
		dump("CDATA text");//$NON-NLS-1$
	String blockContext = doBlockScan("]]>", XML_CDATA_TEXT, ST_CDATA_END);//$NON-NLS-1$
	if(blockContext == XML_CDATA_TEXT)
		yybegin(ST_CDATA_END);
	return blockContext;
 }
        case 296: break;
        case 0: 
        case 27: 
        case 109: 
        case 110: 
        case 111: 
        case 186: 
        case 187: 
        case 189: 
        case 190: 
        case 214: 
        case 215: 
        case 217: 
        case 230: 
        case 231: 
          { 
	if(Debug.debugTokenizer)
		dump("\nXML content");//$NON-NLS-1$
	return XML_CONTENT;
 }
        case 297: break;
        case 5: 
        case 8: 
        case 9: 
        case 10: 
        case 13: 
        case 14: 
        case 15: 
        case 16: 
        case 17: 
        case 18: 
        case 19: 
        case 20: 
        case 21: 
        case 22: 
        case 24: 
        case 41: 
          { 
	if(Debug.debugTokenizer)
		dump("white space");//$NON-NLS-1$
        return WHITE_SPACE;
 }
        case 298: break;
        case 12: 
        case 58: 
          { 
	if(Debug.debugTokenizer)
		dump("inappropriate tag name");//$NON-NLS-1$
	yybegin(YYINITIAL);
        return XML_CONTENT;
 }
        case 299: break;
        case 23: 
        case 93: 
        case 94: 
        case 172: 
        case 207: 
        case 226: 
        case 238: 
        case 247: 
        case 254: 
        case 258: 
          { 
	if(Debug.debugTokenizer)
		dump("elementdecl contentspec");//$NON-NLS-1$
	return XML_ELEMENT_DECL_CONTENT;
 }
        case 300: break;
        case 25: 
        case 100: 
        case 101: 
        case 183: 
        case 211: 
        case 228: 
        case 239: 
        case 248: 
        case 255: 
        case 259: 
          { 
	if(Debug.debugTokenizer)
		dump("attlist contentspec");//$NON-NLS-1$
	return XML_ATTLIST_DECL_CONTENT;
 }
        case 301: break;
        case 28: 
        case 59: 
        case 70: 
          { 
	if(Debug.debugTokenizer)
		dump("\nstart tag open");//$NON-NLS-1$
        yybegin(ST_XML_TAG_NAME);
        return XML_TAG_OPEN;
 }
        case 302: break;
        case 29: 
        case 33: 
        case 34: 
        case 35: 
        case 39: 
        case 40: 
        case 49: 
        case 53: 
        case 57: 
        case 61: 
        case 67: 
        case 72: 
        case 73: 
        case 74: 
        case 75: 
        case 77: 
        case 78: 
        case 80: 
        case 85: 
        case 90: 
        case 97: 
          { 
	if (Debug.debugTokenizer)
		System.out.println("!!!unexpected!!!: \"" + yytext() + "\":" + //$NON-NLS-2$//$NON-NLS-1$
			yychar + "-" + (yychar + yylength()));//$NON-NLS-1$
	return UNDEFINED;
 }
        case 303: break;
        case 30: 
        case 112: 
          { 
	if(Debug.debugTokenizer)
		dump("non-reference %");//$NON-NLS-1$
	return XML_CONTENT;
 }
        case 304: break;
        case 60: 
          { 
	if(Debug.debugTokenizer)
		dump("tag close");//$NON-NLS-1$
	if(isBlockMarker()) {
        	yybegin(ST_BLOCK_TAG_SCAN);
	}
	else
        	yybegin(YYINITIAL);
        return XML_TAG_CLOSE;
 }
        case 305: break;
        case 62: 
        case 63: 
          { 
	if(Debug.debugTokenizer)
		dump("tag name");//$NON-NLS-1$
        yybegin(ST_XML_ATTRIBUTE_NAME);
        return XML_TAG_NAME;
 }
        case 306: break;
        case 64: 
          { 
	if(Debug.debugTokenizer)
		dump("attr name");//$NON-NLS-1$
        yybegin(ST_XML_EQUALS);
        return XML_TAG_ATTRIBUTE_NAME;
 }
        case 307: break;
        case 65: 
          { 
	if(Debug.debugTokenizer)
		dump("equals");//$NON-NLS-1$
        yybegin(ST_XML_ATTRIBUTE_VALUE);
        return XML_TAG_ATTRIBUTE_EQUALS;
 }
        case 308: break;
        case 66: 
        case 68: 
        case 69: 
        case 131: 
          { 
	if(Debug.debugTokenizer)
		dump("attr value");//$NON-NLS-1$
        yybegin(ST_XML_ATTRIBUTE_NAME);
        return XML_TAG_ATTRIBUTE_VALUE;
 }
        case 309: break;
        case 71: 
          { 
	if(Debug.debugTokenizer)
		dump("declaration end");//$NON-NLS-1$
	if (Debug.debugTokenizer) {
		if(fStateStack.peek()!=YYINITIAL)
			System.out.println("end embedded region");//$NON-NLS-1$
	}
	yybegin(fStateStack.pop());
	return XML_DECLARATION_CLOSE;
 }
        case 310: break;
        case 76: 
          { 
	if(Debug.debugTokenizer)
		dump("doctype type");//$NON-NLS-1$
	yybegin(ST_XML_DOCTYPE_EXTERNAL_ID);
	return XML_DOCTYPE_NAME;
 }
        case 311: break;
        case 79: 
        case 81: 
        case 82: 
        case 83: 
        case 147: 
        case 148: 
        case 151: 
        case 152: 
        case 202: 
          { 
	if(Debug.debugTokenizer)
		dump("doctype public reference");//$NON-NLS-1$
	yybegin(ST_XML_DOCTYPE_ID_SYSTEM);
	return XML_DOCTYPE_EXTERNAL_ID_PUBREF;
 }
        case 312: break;
        case 84: 
        case 86: 
        case 87: 
        case 88: 
        case 159: 
          { 
	if(Debug.debugTokenizer)
		dump("doctype system reference");//$NON-NLS-1$
	yybegin(ST_XML_DECLARATION_CLOSE);
	return XML_DOCTYPE_EXTERNAL_ID_SYSREF;
 }
        case 313: break;
        case 89: 
        case 91: 
        case 92: 
        case 165: 
        case 166: 
        case 169: 
        case 170: 
        case 205: 
          { 
	if(Debug.debugTokenizer)
		dump("elementdecl name");//$NON-NLS-1$
	yybegin(ST_XML_ELEMENT_DECLARATION_CONTENT);
	return XML_ELEMENT_DECL_NAME;
 }
        case 314: break;
        case 95: 
          { 
	if(Debug.debugTokenizer)
		dump("elementdecl close");//$NON-NLS-1$
	if (Debug.debugTokenizer) {
		if(fStateStack.peek()!=YYINITIAL)
			System.out.println("end embedded region");//$NON-NLS-1$
	}
	yybegin(fStateStack.pop());
	return XML_DECLARATION_CLOSE;
 }
        case 315: break;
        case 96: 
        case 98: 
        case 99: 
        case 176: 
        case 177: 
        case 180: 
        case 181: 
        case 209: 
          { 
	if(Debug.debugTokenizer)
		dump("attlist name");//$NON-NLS-1$
	yybegin(ST_XML_ATTLIST_DECLARATION_CONTENT);
	return XML_ATTLIST_DECL_NAME;
 }
        case 316: break;
        case 102: 
          { 
	if(Debug.debugTokenizer)
		dump("attlist close");//$NON-NLS-1$
	if (Debug.debugTokenizer) {
		if(fStateStack.peek()!=YYINITIAL)
			System.out.println("end embedded region");//$NON-NLS-1$
	}
	yybegin(fStateStack.pop());
	return XML_DECLARATION_CLOSE;
 }
        case 317: break;
        case 105: 
          { 
	if(Debug.debugTokenizer)
		dump("\nend tag open");//$NON-NLS-1$
        yybegin(ST_XML_TAG_NAME);
        return XML_END_TAG_OPEN;
 }
        case 318: break;
        case 106: 
          { 
	if(Debug.debugTokenizer)
		dump("\nprocessing instruction start");//$NON-NLS-1$
	yybegin(ST_PI);
        return XML_PI_OPEN;
 }
        case 319: break;
        case 107: 
          { 
	fStateStack.push(yystate());
	if(Debug.debugTokenizer)
		dump("\ndeclaration start");//$NON-NLS-1$
        yybegin(ST_XML_DECLARATION);
	return XML_DECLARATION_OPEN;
 }
        case 320: break;
        case 116: 
          { 
	if(Debug.debugTokenizer)
		dump("processing instruction end");//$NON-NLS-1$
        yybegin(YYINITIAL);
        return XML_PI_CLOSE;
 }
        case 321: break;
        case 103: 
        case 104: 
          { 
		return doBlockTagScan();
	 }
        case 322: break;
        default: 
          if (yy_input == YYEOF && yy_startRead == yy_currentPos) {
            yy_atEOF = true;
            yy_do_eof();
              return null;
          } 
          else {
            yy_ScanError(YY_NO_MATCH);
          }
      }
    }
  }    


}
