/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.impl;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.internal.utility.iterators.NullIterator;
import org.eclipse.dali.internal.utility.iterators.TransformationIterator;
import org.eclipse.dali.orm.CascadeType;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.FetchType;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.RelationshipMapping;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.IRelationshipMappingModelAdapter;
import org.eclipse.dali.orm.impl.AttributeMappingImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public abstract class RelationshipMappingImpl
extends AttributeMappingImpl
implements RelationshipMapping {
    protected static final FetchType FETCH_TYPE_EDEFAULT = FetchType.DEFAULT_LITERAL;
    protected FetchType fetchType = FETCH_TYPE_EDEFAULT;
    protected static final CascadeType CASCADE_TYPE_EDEFAULT = CascadeType.DEFAULT_LITERAL;
    protected CascadeType cascadeType = CASCADE_TYPE_EDEFAULT;
    protected static final String DEFAULT_TARGET_ENTITY_EDEFAULT = null;
    protected String defaultTargetEntity = DEFAULT_TARGET_ENTITY_EDEFAULT;
    protected static final String SPECIFIED_TARGET_ENTITY_EDEFAULT = null;
    protected String specifiedTargetEntity = SPECIFIED_TARGET_ENTITY_EDEFAULT;
    protected static final String TARGET_ENTITY_EDEFAULT = "";

    protected RelationshipMappingImpl() {
    }

    protected RelationshipMappingImpl(IRelationshipMappingModelAdapter adapter) {
        super(adapter);
    }

    protected EClass eStaticClass() {
        return OrmPackage.Literals.RELATIONSHIP_MAPPING;
    }

    public FetchType getFetchType() {
        return this.fetchType;
    }

    public void setFetchTypeGen(FetchType newFetchType) {
        FetchType oldFetchType = this.fetchType;
        FetchType fetchType = this.fetchType = newFetchType == null ? FETCH_TYPE_EDEFAULT : newFetchType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldFetchType, (Object)this.fetchType));
        }
    }

    public void setFetchType(FetchType newFetchType) {
        this.setFetchTypeGen(newFetchType);
        this.getRelationshipMappingModelAdapter().fetchTypeChanged();
    }

    public CascadeType getCascadeType() {
        return this.cascadeType;
    }

    public void setCascadeTypeGen(CascadeType newCascadeType) {
        CascadeType oldCascadeType = this.cascadeType;
        CascadeType cascadeType = this.cascadeType = newCascadeType == null ? CASCADE_TYPE_EDEFAULT : newCascadeType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldCascadeType, (Object)this.cascadeType));
        }
    }

    public void setCascadeType(CascadeType newCascadeType) {
        this.setCascadeTypeGen(newCascadeType);
        this.getRelationshipMappingModelAdapter().cascadeTypeChanged();
    }

    public String getDefaultTargetEntity() {
        return this.defaultTargetEntity;
    }

    public void setDefaultTargetEntity(String newDefaultTargetEntity) {
        String oldDefaultTargetEntity = this.defaultTargetEntity;
        this.defaultTargetEntity = newDefaultTargetEntity;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldDefaultTargetEntity, (Object)this.defaultTargetEntity));
        }
    }

    public String getSpecifiedTargetEntity() {
        return this.specifiedTargetEntity;
    }

    public void setSpecifiedTargetEntityGen(String newSpecifiedTargetEntity) {
        String oldSpecifiedTargetEntity = this.specifiedTargetEntity;
        this.specifiedTargetEntity = newSpecifiedTargetEntity;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldSpecifiedTargetEntity, (Object)this.specifiedTargetEntity));
        }
    }

    public void setSpecifiedTargetEntity(String newTargetEntity) {
        this.setSpecifiedTargetEntityGen(newTargetEntity);
        this.getRelationshipMappingModelAdapter().specifiedTargetEntityChanged();
    }

    public String getTargetEntity() {
        return this.getSpecifiedTargetEntity() == null ? this.getDefaultTargetEntity() : this.getSpecifiedTargetEntity();
    }

    public Entity getResolvedTargetEntity() {
        TypeMapping typeMapping;
        PersistentType targetPersistentType;
        String targetEntity = this.getTargetEntity();
        if (targetEntity != null && (targetPersistentType = this.getPersistenceFile().resolvePersistentType(targetEntity)) != null && (typeMapping = targetPersistentType.getTypeMapping()).getKey() == Entity.Key.INSTANCE) {
            return (Entity)typeMapping;
        }
        return null;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getFetchType();
            }
            case 1: {
                return this.getCascadeType();
            }
            case 2: {
                return this.getDefaultTargetEntity();
            }
            case 3: {
                return this.getSpecifiedTargetEntity();
            }
            case 4: {
                return this.getTargetEntity();
            }
            case 5: {
                return this.getResolvedTargetEntity();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setFetchType((FetchType)((Object)newValue));
                return;
            }
            case 1: {
                this.setCascadeType((CascadeType)((Object)newValue));
                return;
            }
            case 2: {
                this.setDefaultTargetEntity((String)newValue);
                return;
            }
            case 3: {
                this.setSpecifiedTargetEntity((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setFetchType(FETCH_TYPE_EDEFAULT);
                return;
            }
            case 1: {
                this.setCascadeType(CASCADE_TYPE_EDEFAULT);
                return;
            }
            case 2: {
                this.setDefaultTargetEntity(DEFAULT_TARGET_ENTITY_EDEFAULT);
                return;
            }
            case 3: {
                this.setSpecifiedTargetEntity(SPECIFIED_TARGET_ENTITY_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.fetchType != FETCH_TYPE_EDEFAULT;
            }
            case 1: {
                return this.cascadeType != CASCADE_TYPE_EDEFAULT;
            }
            case 2: {
                return DEFAULT_TARGET_ENTITY_EDEFAULT == null ? this.defaultTargetEntity != null : !DEFAULT_TARGET_ENTITY_EDEFAULT.equals(this.defaultTargetEntity);
            }
            case 3: {
                return SPECIFIED_TARGET_ENTITY_EDEFAULT == null ? this.specifiedTargetEntity != null : !SPECIFIED_TARGET_ENTITY_EDEFAULT.equals(this.specifiedTargetEntity);
            }
            case 4: {
                return TARGET_ENTITY_EDEFAULT == null ? this.getTargetEntity() != null : !TARGET_ENTITY_EDEFAULT.equals(this.getTargetEntity());
            }
            case 5: {
                return this.getResolvedTargetEntity() != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (fetchType: ");
        result.append((Object)this.fetchType);
        result.append(", cascadeType: ");
        result.append((Object)this.cascadeType);
        result.append(", defaultTargetEntity: ");
        result.append(this.defaultTargetEntity);
        result.append(", specifiedTargetEntity: ");
        result.append(this.specifiedTargetEntity);
        result.append(')');
        return result.toString();
    }

    protected void addProblemsTo(List problems) {
        super.addProblemsTo(problems);
        this.addNonEntityTargetProblemTo(problems);
    }

    private void addNonEntityTargetProblemTo(List problems) {
        PersistentType persistentType = this.getTargetEntityPersistentType();
        if (persistentType == null || persistentType.getTypeMapping().getKey() != Entity.Key.INSTANCE) {
            problems.add(this.buildProblem("Target " + this.getFullyQualifiedTargetEntity() + ".class is not an entity", this.targetEntityTextRange()));
            return;
        }
    }

    public Iterator possibleMappedByAttributeNames() {
        PersistentType targetEntity = this.getTargetEntityPersistentType();
        if (targetEntity == null) {
            return NullIterator.instance();
        }
        return new TransformationIterator(targetEntity.getPersistentAttributes().iterator()){

            protected Object transform(Object next) {
                return ((PersistentAttribute)next).getName();
            }
        };
    }

    protected PersistentType getTargetEntityPersistentType() {
        String targetEntityTypeName = this.getFullyQualifiedTargetEntity();
        if (targetEntityTypeName != null) {
            return this.getPersistenceFile().resolvePersistentType(targetEntityTypeName);
        }
        return null;
    }

    protected String getFullyQualifiedTargetEntity() {
        return this.getRelationshipMappingModelAdapter().fullyQualifyTargetEntity(this.getTargetEntity());
    }

    public boolean supportsColumn() {
        return false;
    }

    protected IRelationshipMappingModelAdapter getRelationshipMappingModelAdapter() {
        return (IRelationshipMappingModelAdapter)this.getModelAdapter();
    }

    public boolean isValidTargetEntity(String targetEntity) {
        if (targetEntity == null) {
            return true;
        }
        StringTokenizer t = new StringTokenizer(targetEntity, ".", true);
        int balance = 0;
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            if (s.indexOf(46) >= 0) {
                if (s.length() > 1) {
                    return false;
                }
                if (--balance >= 0) continue;
                return false;
            }
            ++balance;
        }
        return balance == true;
    }

    protected ITextRange targetEntityTextRange() {
        ITextRange textRange = ((IRelationshipMappingModelAdapter)this.getModelAdapter()).targetEntityTextRange();
        if (textRange != null) {
            return textRange;
        }
        return this.getTextRange();
    }

    public boolean isPossibleRelationshipOwner() {
        return true;
    }
}

