/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.util.jdt.AttributeAnnotationTools;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.internal.utility.StringTools;
import org.eclipse.dali.orm.AccessType;
import org.eclipse.dali.orm.Embeddable;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.MappedSuperclass;
import org.eclipse.dali.orm.NullTypeMapping;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.PersistenceSourceRefElement;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.IEmbeddableModelAdapter;
import org.eclipse.dali.orm.adapters.IEntityModelAdapter;
import org.eclipse.dali.orm.adapters.INullTypeMappingModelAdapter;
import org.eclipse.dali.orm.adapters.IPersistentTypeModelAdapter;
import org.eclipse.dali.orm.adapters.ITypeMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.Attribute;
import org.eclipse.dali.orm.adapters.java.FieldAttribute;
import org.eclipse.dali.orm.adapters.java.IJavaTypeMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaEmbeddableModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaEntityModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaMappedSuperclassModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaNullTypeMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaPersistentAttributeModelAdapter;
import org.eclipse.dali.orm.adapters.java.MethodAttribute;
import org.eclipse.dali.orm.adapters.java.Type;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaPersistentTypeModelAdapter
implements IPersistentTypeModelAdapter {
    private PersistentType persistentType;
    private Type type;
    private static final String[] FIELD_METHOD_ANNOTATIONS = new String[]{"AttributeOverride", "AttributeOverrides", "Basic", "Column", "Embedded", "EmbeddedId", "Enumerated", "GeneratedValue", "Id", "JoinColumn", "JoinColumns", "JoinTable", "Lob", "ManyToMany", "ManyToOne", "MapKey", "OneToMany", "OneToOne", "OrderBy", "PrimaryKeyJoinColumn", "SequenceGenerator", "TableGenerator", "Temporal", "Transient", "Version"};

    public static PersistentAttribute persistentAttributeFor(PersistentType persistentType, IMember member) {
        Iterator i = persistentType.getPersistentAttributes().iterator();
        while (i.hasNext()) {
            PersistentAttribute mapping = (PersistentAttribute)i.next();
            if (!((JavaPersistentAttributeModelAdapter)mapping.getModelAdapter()).isPersistentAttributeFor(member)) continue;
            return mapping;
        }
        return null;
    }

    public JavaPersistentTypeModelAdapter(IType jdtType) {
        this.type = new Type(jdtType);
    }

    public void setPersistentType(PersistentType persistentType) {
        this.persistentType = persistentType;
    }

    public void disengage() {
        this.getTypeMappingModelAdapter().disengage();
        this.persistentType = null;
        this.type = null;
    }

    private IJavaTypeMappingModelAdapter getTypeMappingModelAdapter() {
        return (IJavaTypeMappingModelAdapter)this.persistentType.getTypeMapping().getModelAdapter();
    }

    public INullTypeMappingModelAdapter createNullTypeMappingModelAdapter() {
        return new JavaNullTypeMappingModelAdapter(this.getType());
    }

    public IEntityModelAdapter createEntityModelAdapter() {
        return new JavaEntityModelAdapter(this.getType());
    }

    public IEmbeddableModelAdapter createEmbeddableModelAdapter() {
        return new JavaEmbeddableModelAdapter(this.getType());
    }

    public ITypeMappingModelAdapter createMappedSuperclassModelAdapter() {
        return new JavaMappedSuperclassModelAdapter(this.getType());
    }

    public PersistentType getPersistentType() {
        return this.persistentType;
    }

    public IType getJDTType() {
        return this.type.getJDTType();
    }

    public Type getType() {
        return this.type;
    }

    public void updatePersModel(CompilationUnit astRoot) {
        this.updatePersTypeMapping(astRoot);
        this.updatePersClassName();
        this.updatePersAccessType(astRoot);
        this.updatePersMappings(astRoot);
    }

    public void postUpdatePersModel(CompilationUnit astRoot) {
        this.getTypeMappingModelAdapter().postUpdatePersModel(astRoot);
        this.postUpdatePersMappings(astRoot);
    }

    private void postUpdatePersMappings(CompilationUnit astRoot) {
        Iterator i = this.getPersistentType().getPersistentAttributes().iterator();
        while (i.hasNext()) {
            ((JavaPersistentAttributeModelAdapter)((PersistentAttribute)i.next()).getModelAdapter()).postUpdatePersModel(astRoot);
        }
    }

    private void updatePersClassName() {
        String persClassName;
        String javaClassName = this.javaClassName();
        if (!javaClassName.equals(persClassName = this.persistentType.getClassName())) {
            this.persistentType.setClassName(javaClassName);
        }
    }

    private void updatePersTypeMapping(CompilationUnit astRoot) {
        TypeMapping newTypeMapping;
        TypeMapping.Key persTypeMappingKey;
        TypeMapping.Key javaTypeMappingKey = this.javaTypeMappingKey(astRoot);
        if (javaTypeMappingKey.equals(persTypeMappingKey = this.persistentType.getTypeMappingKey())) {
            this.getTypeMappingModelAdapter().updatePersModel(astRoot);
            return;
        }
        if (javaTypeMappingKey.equals(NullTypeMapping.Key.INSTANCE)) {
            newTypeMapping = OrmFactory.eINSTANCE.createNullTypeMapping(this.createNullTypeMappingModelAdapter());
        } else if (javaTypeMappingKey.equals(Entity.Key.INSTANCE)) {
            newTypeMapping = OrmFactory.eINSTANCE.createEntity(this.createEntityModelAdapter());
        } else if (javaTypeMappingKey.equals(Embeddable.Key.INSTANCE)) {
            newTypeMapping = OrmFactory.eINSTANCE.createEmbeddable(this.createEmbeddableModelAdapter());
        } else if (javaTypeMappingKey.equals(MappedSuperclass.Key.INSTANCE)) {
            newTypeMapping = OrmFactory.eINSTANCE.createMappedSuperclass(this.createMappedSuperclassModelAdapter());
        } else {
            throw new IllegalArgumentException(javaTypeMappingKey.toString());
        }
        ((IJavaTypeMappingModelAdapter)newTypeMapping.getModelAdapter()).updatePersModel(astRoot);
        this.persistentType.setTypeMapping(newTypeMapping);
    }

    private void updatePersAccessType(CompilationUnit astRoot) {
        AccessType persAccessType;
        AccessType javaAccessType = this.javaAccessType(astRoot);
        if (javaAccessType != (persAccessType = this.persistentType.getAccessType())) {
            this.persistentType.setAccessType(javaAccessType);
        }
    }

    private void updatePersMappings(CompilationUnit astRoot) {
        if (this.persistentType.getAccessType() == AccessType.FIELD_LITERAL) {
            PersistentAttribute mapping;
            if (this.persistentType.getPersistentAttributes().size() > 0 && ((JavaPersistentAttributeModelAdapter)(mapping = (PersistentAttribute)this.persistentType.getPersistentAttributes().get(0)).getModelAdapter()).getAttribute().isMethod()) {
                this.persistentType.getPersistentAttributes().clear();
            }
            IField[] fields = AttributeAnnotationTools.persistableFields(this.getJDTType());
            Collection mappingsToRemove = CollectionTools.collection((Iterator)this.persistentType.getPersistentAttributes().iterator());
            Iterator i = this.persistentType.getPersistentAttributes().iterator();
            while (i.hasNext()) {
                PersistentAttribute mapping2 = (PersistentAttribute)i.next();
                boolean mappingExists = false;
                int j = 0;
                while (j < fields.length) {
                    IField field = fields[j];
                    if (((JavaPersistentAttributeModelAdapter)mapping2.getModelAdapter()).isPersistentAttributeFor((IMember)field)) {
                        ((JavaPersistentAttributeModelAdapter)mapping2.getModelAdapter()).updatePersModel(astRoot);
                        mappingExists = true;
                    }
                    ++j;
                }
                if (!mappingExists) continue;
                mappingsToRemove.remove(mapping2);
            }
            i = mappingsToRemove.iterator();
            while (i.hasNext()) {
                this.persistentType.getPersistentAttributes().remove(i.next());
            }
            int i2 = 0;
            while (i2 < fields.length) {
                IField field = fields[i2];
                if (this.persistentAttributeFor((IMember)field) == null) {
                    JavaPersistentAttributeModelAdapter modelAdapter = new JavaPersistentAttributeModelAdapter(new FieldAttribute(field));
                    PersistentAttribute attribute = OrmFactory.eINSTANCE.createPersistentAttribute(modelAdapter);
                    this.persistentType.getPersistentAttributes().add((Object)attribute);
                    modelAdapter.updatePersModel(astRoot);
                }
                ++i2;
            }
        } else {
            PersistentAttribute mapping;
            if (this.persistentType.getPersistentAttributes().size() > 0 && ((JavaPersistentAttributeModelAdapter)(mapping = (PersistentAttribute)this.persistentType.getPersistentAttributes().get(0)).getModelAdapter()).getAttribute().isField()) {
                this.persistentType.getPersistentAttributes().clear();
            }
            IMethod[] methods = AttributeAnnotationTools.persistablePropertyGetters(this.getJDTType());
            Collection mappingsToRemove = CollectionTools.collection((Iterator)this.persistentType.getPersistentAttributes().iterator());
            i = this.persistentType.getPersistentAttributes().iterator();
            while (i.hasNext()) {
                PersistentAttribute mapping3 = (PersistentAttribute)i.next();
                boolean mappingExists = false;
                int j = 0;
                while (j < methods.length) {
                    IMethod method = methods[j];
                    if (((JavaPersistentAttributeModelAdapter)mapping3.getModelAdapter()).isPersistentAttributeFor((IMember)method)) {
                        ((JavaPersistentAttributeModelAdapter)mapping3.getModelAdapter()).updatePersModel(astRoot);
                        mappingExists = true;
                    }
                    ++j;
                }
                if (!mappingExists) continue;
                mappingsToRemove.remove(mapping3);
            }
            i = mappingsToRemove.iterator();
            while (i.hasNext()) {
                this.persistentType.getPersistentAttributes().remove(i.next());
            }
            int i3 = 0;
            while (i3 < methods.length) {
                IMethod method = methods[i3];
                if (this.persistentAttributeFor((IMember)method) == null) {
                    this.addPersistentAttributeModelAdapter(new MethodAttribute(method), astRoot);
                }
                ++i3;
            }
        }
    }

    private void addPersistentAttributeModelAdapter(Attribute attribute, CompilationUnit astRoot) {
        JavaPersistentAttributeModelAdapter modelAdapter = new JavaPersistentAttributeModelAdapter(attribute);
        PersistentAttribute persAttribute = OrmFactory.eINSTANCE.createPersistentAttribute(modelAdapter);
        modelAdapter.updatePersModel(astRoot);
        this.persistentType.getPersistentAttributes().add((Object)persAttribute);
    }

    void synchWithJavaDelta(IJavaElementDelta delta, CompilationUnit astRoot) {
        if ((delta.getFlags() & 1) != 0) {
            this.updatePersModel(astRoot);
        } else if ((delta.getFlags() & 8) != 0) {
            int i = 0;
            while (i < delta.getAffectedChildren().length) {
                IJavaElementDelta childrenDelta = delta.getAffectedChildren()[i];
                IJavaElement element = childrenDelta.getElement();
                if (element instanceof IType && ((IType)element).getElementName().equals(this.getJDTType().getElementName())) {
                    this.sourceTypeChanged(childrenDelta, astRoot);
                }
                ++i;
            }
        }
        this.postUpdatePersModel(astRoot);
    }

    private void sourceTypeChanged(IJavaElementDelta delta, CompilationUnit astRoot) {
        if ((delta.getFlags() & 8) != 0) {
            int i = 0;
            while (i < delta.getAffectedChildren().length) {
                IJavaElementDelta childDelta = delta.getAffectedChildren()[i];
                if (childDelta.getKind() == 1) {
                    this.processSourceTypeChildAdded(childDelta, astRoot);
                } else if (childDelta.getKind() == 2) {
                    this.processSourceTypeChildRemoved(childDelta, astRoot);
                } else {
                    this.processSourceTypeChildChanged(childDelta, astRoot);
                }
                ++i;
            }
        } else if ((delta.getFlags() & 2) != 0) {
            this.updatePersModel(astRoot);
        }
    }

    private void processSourceTypeChildAdded(IJavaElementDelta addedDelta, CompilationUnit astRoot) {
        if (addedDelta.getElement() instanceof IField) {
            if (this.persistentType.getAccessType() == AccessType.FIELD_LITERAL && AttributeAnnotationTools.fieldIsPersistable((IField)addedDelta.getElement())) {
                this.addPersistentAttributeModelAdapter(new FieldAttribute((IField)addedDelta.getElement()), astRoot);
            }
        } else if (addedDelta.getElement() instanceof IMethod && this.persistentType.getAccessType() == AccessType.PROPERTY_LITERAL && AttributeAnnotationTools.methodIsPersistablePropertyGetter((IMethod)addedDelta.getElement())) {
            this.addPersistentAttributeModelAdapter(new MethodAttribute((IMethod)addedDelta.getElement()), astRoot);
        }
    }

    private void processSourceTypeChildRemoved(IJavaElementDelta removedDelta, CompilationUnit astRoot) {
        if (removedDelta.getElement() instanceof IField) {
            if (this.persistentType.getAccessType() == AccessType.FIELD_LITERAL) {
                this.removeMapping((IMember)((IField)removedDelta.getElement()));
            }
        } else if (removedDelta.getElement() instanceof IMethod && this.persistentType.getAccessType() == AccessType.PROPERTY_LITERAL) {
            this.removeMapping((IMember)((IMethod)removedDelta.getElement()));
        }
    }

    private void processSourceTypeChildChanged(IJavaElementDelta changedDelta, CompilationUnit astRoot) {
        if (changedDelta.getElement() instanceof IField) {
            if (this.persistentType.getAccessType() == AccessType.FIELD_LITERAL) {
                if ((changedDelta.getFlags() & 2) != 0) {
                    if (AttributeAnnotationTools.fieldIsPersistable((IField)changedDelta.getElement())) {
                        if (this.persistentAttributeFor((IMember)((IField)changedDelta.getElement())) == null) {
                            this.addPersistentAttributeModelAdapter(new FieldAttribute((IField)changedDelta.getElement()), astRoot);
                        }
                    } else {
                        this.removeMapping((IMember)((IField)changedDelta.getElement()));
                    }
                } else {
                    ((JavaPersistentAttributeModelAdapter)this.persistentAttributeFor((IMember)changedDelta.getElement()).getModelAdapter()).updatePersModel(astRoot);
                }
            }
        } else if (changedDelta.getElement() instanceof IMethod && this.persistentType.getAccessType() == AccessType.PROPERTY_LITERAL) {
            if ((changedDelta.getFlags() & 2) != 0) {
                if (AttributeAnnotationTools.methodIsPersistablePropertyGetter((IMethod)changedDelta.getElement())) {
                    if (this.persistentAttributeFor((IMember)((IMethod)changedDelta.getElement())) == null) {
                        this.addPersistentAttributeModelAdapter(new MethodAttribute((IMethod)changedDelta.getElement()), astRoot);
                    }
                } else {
                    this.removeMapping((IMember)((IMethod)changedDelta.getElement()));
                }
            } else {
                ((JavaPersistentAttributeModelAdapter)this.persistentAttributeFor((IMember)changedDelta.getElement()).getModelAdapter()).updatePersModel(astRoot);
            }
        }
    }

    private void removeMapping(IMember member) {
        PersistentAttribute mappingToRemove = this.persistentAttributeFor(member);
        if (mappingToRemove != null) {
            this.persistentType.getPersistentAttributes().remove((Object)mappingToRemove);
        }
    }

    public void accessTypeChanged() {
    }

    private String javaClassName() {
        return this.getJDTType().getFullyQualifiedName();
    }

    private AccessType javaAccessType(CompilationUnit astRoot) {
        IType jdtType = this.getJDTType();
        IField[] fields = AttributeAnnotationTools.persistableFields(jdtType);
        int i = 0;
        while (i < fields.length) {
            FieldAttribute fa = new FieldAttribute(fields[i]);
            if (fa.containsAnyAnnotation(FIELD_METHOD_ANNOTATIONS, astRoot)) {
                return AccessType.FIELD_LITERAL;
            }
            ++i;
        }
        IMethod[] methods = AttributeAnnotationTools.persistablePropertyGetters(jdtType);
        int i2 = 0;
        while (i2 < methods.length) {
            MethodAttribute ma = new MethodAttribute(methods[i2]);
            if (ma.containsAnyAnnotation(FIELD_METHOD_ANNOTATIONS, astRoot)) {
                return AccessType.PROPERTY_LITERAL;
            }
            ++i2;
        }
        return AccessType.FIELD_LITERAL;
    }

    private TypeMapping.Key javaTypeMappingKey(CompilationUnit astRoot) {
        if (this.getType().containsAnnotation("Entity", astRoot)) {
            return Entity.Key.INSTANCE;
        }
        if (this.getType().containsAnnotation("Embeddable", astRoot)) {
            return Embeddable.Key.INSTANCE;
        }
        if (this.getType().containsAnnotation("MappedSuperclass", astRoot)) {
            return MappedSuperclass.Key.INSTANCE;
        }
        return NullTypeMapping.Key.INSTANCE;
    }

    private PersistentAttribute persistentAttributeFor(IMember member) {
        return JavaPersistentTypeModelAdapter.persistentAttributeFor(this.persistentType, member);
    }

    public PersistenceSourceRefElement persistenceObjectAt(int offset) {
        ICompilationUnit unit = this.getJDTType().getCompilationUnit();
        IJavaElement javaElement = null;
        if (unit != null) {
            try {
                javaElement = unit.getElementAt(offset);
            }
            catch (JavaModelException javaModelException) {}
        }
        if (javaElement == null) {
            return this.persistentType;
        }
        switch (javaElement.getElementType()) {
            case 7: {
                if (!((IType)javaElement).getKey().equals(this.getJDTType().getKey())) break;
                return this.persistentType;
            }
            case 8: {
                if (!((Object)((Object)this.persistentType.getAccessType())).equals((Object)AccessType.FIELD_LITERAL)) break;
                return this.persistentAttributeFor((IMember)((IField)javaElement));
            }
            case 9: {
                if (((Object)((Object)this.persistentType.getAccessType())).equals((Object)AccessType.FIELD_LITERAL)) break;
                return this.persistentAttributeFor((IMember)((IMethod)javaElement));
            }
        }
        return this.persistentType;
    }

    public ITextRange getTextRange() {
        ISourceRange sourceRange;
        try {
            sourceRange = this.getJDTType().getNameRange();
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        return new ITextRange(){

            public int getOffset() {
                return sourceRange.getOffset();
            }

            public int getLength() {
                return sourceRange.getLength();
            }

            public int getLineNumber() {
                return 0;
            }
        };
    }

    public PersistentType getParentPersistentType() {
        String[][] resolvedType;
        String signature;
        try {
            signature = this.getJDTType().getSuperclassTypeSignature();
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        String simpleName = Signature.getSignatureSimpleName((String)signature);
        String qualifier = Signature.getSignatureQualifier((String)signature);
        String qualifiedName = simpleName;
        if (!StringTools.stringIsEmpty((String)qualifier)) {
            qualifiedName = String.valueOf(qualifier) + "." + simpleName;
        }
        try {
            resolvedType = this.getJDTType().resolveType(qualifiedName);
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        if (resolvedType == null || resolvedType.length > 1) {
            return null;
        }
        String packageName = resolvedType[0][0];
        String fullyQualifiedTypeName = simpleName;
        if (!StringTools.stringIsEmpty((String)packageName)) {
            fullyQualifiedTypeName = String.valueOf(packageName) + "." + simpleName;
        }
        return this.persistentType.getPersistenceFile().resolvePersistentType(fullyQualifiedTypeName);
    }
}

