/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.util.Iterator;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.JoinColumn;
import org.eclipse.dali.orm.JoinTable;
import org.eclipse.dali.orm.MultiRelationshipMapping;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.views.JoinColumnInJoinTableDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class InverseJoinColumnDialog
extends JoinColumnInJoinTableDialog {
    InverseJoinColumnDialog(Shell parent, JoinTable joinTable) {
        super(parent, joinTable);
    }

    InverseJoinColumnDialog(Shell parent, JoinColumn joinColumn) {
        super(parent, joinColumn);
    }

    protected String getTitle() {
        return DaliUiMessages.InverseJoinColumnDialog_editInverseJoinColumn;
    }

    protected void populateNameCombo() {
        if (this.getJoinColumn() == null) {
            return;
        }
        this.getNameCombo().add(NLS.bind((String)DaliUiMessages.InverseJoinColumnDialog_defaultWithOneParam, (Object)this.getJoinColumn().getDefaultName()));
        Table joinDBTable = ((JoinTable)this.getJoinColumn().getParent()).getDBTable();
        if (joinDBTable != null) {
            Iterator i = joinDBTable.columnNames();
            while (i.hasNext()) {
                this.getNameCombo().add((String)i.next());
            }
        }
        if (this.getJoinColumn().getSpecifiedReferencedColumnName() != null) {
            this.getNameCombo().setText(this.getJoinColumn().getSpecifiedName());
        } else {
            this.getNameCombo().select(0);
        }
    }

    protected void populateReferencedNameCombo() {
        Table referencedDbTable;
        if (this.getJoinColumn() == null) {
            return;
        }
        this.getReferencedColumnNameCombo().add(NLS.bind((String)DaliUiMessages.InverseJoinColumnDialog_defaultWithOneParam, (Object)this.getJoinColumn().getDefaultReferencedColumnName()));
        MultiRelationshipMapping multiRelationshipMapping = (MultiRelationshipMapping)((JoinTable)this.getJoinColumn().getParent()).getParent();
        Entity targetEntity = multiRelationshipMapping.getResolvedTargetEntity();
        if (targetEntity != null && (referencedDbTable = targetEntity.getResolvedDBTable()) != null) {
            Iterator i = referencedDbTable.columnNames();
            while (i.hasNext()) {
                this.getReferencedColumnNameCombo().add((String)i.next());
            }
        }
        if (this.getJoinColumn().getSpecifiedReferencedColumnName() != null) {
            this.getReferencedColumnNameCombo().setText(this.getJoinColumn().getSpecifiedReferencedColumnName());
        } else {
            this.getReferencedColumnNameCombo().select(0);
        }
    }
}

