/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.util.Iterator;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.FetchTypeDefaultLazy;
import org.eclipse.dali.orm.MultiRelationshipMapping;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.provider.MultiRelationshipMappingItemProvider;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.orm.provider.PersistentTypeItemProvider;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.dali.ui.views.JoinTableComposite;
import org.eclipse.dali.ui.views.OrderByComposite;
import org.eclipse.dali.ui.views.RelationshipMappingComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;

public abstract class MultiRelationshipMappingComposite
extends RelationshipMappingComposite
implements IPersistenceComposite {
    protected Combo mappedByCombo;
    protected JoinTableComposite joinTableComposite;
    protected OrderByComposite orderByComposite;
    private PersistentType targetEntityPersistentType;
    private PersistentTypeItemProvider persistentTypeItemProvider;
    private INotifyChangedListener persistentTypeListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected MultiRelationshipMappingComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
        super(parent, editingDomain, adapterFactory);
        this.persistentTypeItemProvider = (PersistentTypeItemProvider)adapterFactory.createPersistentTypeAdapter();
        this.initializeLayout();
    }

    private void initializeLayout() {
        this.setLayout((Layout)new FillLayout(512));
        TabFolder folder = new TabFolder((Composite)this, 128);
        Control generalControl = this.buildGeneralTab(folder);
        TabItem generalTab = new TabItem(folder, 0);
        generalTab.setText(DaliUiMessages.MultiRelationshipMappingComposite_general);
        generalTab.setControl(generalControl);
        Control joinTableControl = this.buildJoinTableTab(folder);
        TabItem joinTableTab = new TabItem(folder, 0);
        joinTableTab.setText(DaliUiMessages.MultiRelationshipMappingComposite_joinTable);
        joinTableTab.setControl(joinTableControl);
        folder.setSelection(0);
    }

    private Control buildGeneralTab(TabFolder folder) {
        Composite composite = new Composite((Composite)folder, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label targetEntityLabel = new Label(composite, 16384);
        targetEntityLabel.setText(DaliUiMessages.MultiRelationshipMappingComposite_targetEntity);
        this.targetEntityCombo = this.buildTargetEntityCombo(composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.targetEntityCombo.setLayoutData((Object)gridData);
        this.buildTargetEntitySelectionButton(composite);
        Label cascadeTypeLabel = new Label(composite, 16384);
        cascadeTypeLabel.setText(DaliUiMessages.MultiRelationshipMappingComposite_cascadeType);
        this.cascadeTypeComboViewer = this.buildCascadeTypeCombo(composite);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.cascadeTypeComboViewer.getCombo().setLayoutData((Object)gridData);
        Label fetchTypeLabel = new Label(composite, 16384);
        fetchTypeLabel.setText(DaliUiMessages.MultiRelationshipMappingComposite_fetchType);
        this.fetchTypeComboViewer = this.buildFetchTypeCombo(composite);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.fetchTypeComboViewer.getCombo().setLayoutData((Object)gridData);
        Label mappedByLabel = new Label(composite, 16384);
        mappedByLabel.setText(DaliUiMessages.MultiRelationshipMappingComposite_mappedBy);
        this.mappedByCombo = this.buildMappedByCombo(composite);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.mappedByCombo.setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.mappedByCombo, "org.eclipse.dali.ui.mapping_mappedBy");
        this.orderByComposite = new OrderByComposite(composite, this.editingDomain, this.adapterFactory, (MultiRelationshipMappingItemProvider)this.createRelationshipMappingItemProvider(this.adapterFactory));
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.orderByComposite.setLayoutData(gridData);
        return composite;
    }

    private Control buildJoinTableTab(TabFolder folder) {
        Composite composite = new Composite((Composite)folder, 0);
        composite.setLayout((Layout)new GridLayout());
        this.joinTableComposite = new JoinTableComposite(composite, this.editingDomain, this.adapterFactory);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.joinTableComposite.setLayoutData(gridData);
        return composite;
    }

    protected ComboViewer buildFetchTypeCombo(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add(FetchTypeDefaultLazy.VALUES.toArray());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (MultiRelationshipMappingComposite.this.populating) {
                    return;
                }
                if (event.getSelection() instanceof StructuredSelection) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    FetchTypeDefaultLazy fetchType = (FetchTypeDefaultLazy)selection.getFirstElement();
                    if (MultiRelationshipMappingComposite.this.getMultiRelationshipMapping().getFetchType() != fetchType) {
                        MultiRelationshipMappingComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)MultiRelationshipMappingComposite.this.editingDomain, (Object)MultiRelationshipMappingComposite.this.relationshipMapping, (Object)OrmPackage.eINSTANCE.getMultiRelationshipMapping_FetchType(), (Object)fetchType));
                    }
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)viewer.getCombo(), "org.eclipse.dali.ui.mapping_fetchType");
        return viewer;
    }

    private Combo buildMappedByCombo(Composite parent) {
        Combo combo = new Combo(parent, 2052);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (MultiRelationshipMappingComposite.this.populating) {
                    return;
                }
                String mappedBy = ((Combo)e.getSource()).getText();
                if (mappedBy.equals("")) {
                    mappedBy = null;
                    if (MultiRelationshipMappingComposite.this.getMultiRelationshipMapping().getMappedBy() == null || MultiRelationshipMappingComposite.this.getMultiRelationshipMapping().getMappedBy().equals("")) {
                        return;
                    }
                }
                if (MultiRelationshipMappingComposite.this.getMultiRelationshipMapping().getMappedBy() == null || !MultiRelationshipMappingComposite.this.getMultiRelationshipMapping().getMappedBy().equals(mappedBy)) {
                    MultiRelationshipMappingComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)MultiRelationshipMappingComposite.this.editingDomain, (Object)MultiRelationshipMappingComposite.this.getMultiRelationshipMapping(), (Object)OrmPackage.eINSTANCE.getNonOwningMapping_MappedBy(), (Object)mappedBy));
                }
            }
        });
        return combo;
    }

    private MultiRelationshipMapping getMultiRelationshipMapping() {
        return (MultiRelationshipMapping)this.relationshipMapping;
    }

    public void populate(EObject model) {
        super.populate(model);
        this.populating = true;
        if (this.mappedByCombo.getItemCount() > 0) {
            this.mappedByCombo.removeAll();
        }
        this.disenageListeners();
        if (model == null) {
            this.populating = false;
            this.targetEntityPersistentType = null;
            this.joinTableComposite.populate(null);
            this.orderByComposite.populate(null);
            return;
        }
        Entity newTargetEntity = this.getMultiRelationshipMapping().getResolvedTargetEntity();
        if (newTargetEntity != null) {
            this.targetEntityPersistentType = newTargetEntity.getPersistentType();
            this.engageListeners();
        }
        this.populateMappedByCombo();
        this.populateJoinTablePanel();
        this.populateFetchTypeCombo();
        this.populateOrderByPanel();
        this.populating = false;
    }

    private void engageListeners() {
        this.persistentTypeItemProvider.addListener(this.getPersistentTypeListener());
        this.targetEntityPersistentType.eAdapters().add((Object)this.persistentTypeItemProvider);
    }

    private void disenageListeners() {
        if (this.targetEntityPersistentType != null) {
            this.targetEntityPersistentType.eAdapters().remove((Object)this.persistentTypeItemProvider);
            this.persistentTypeItemProvider.removeListener(this.getPersistentTypeListener());
        }
    }

    private void populateFetchTypeCombo() {
        if (this.getMultiRelationshipMapping().getFetchType() == FetchTypeDefaultLazy.DEFAULT_LITERAL) {
            if (((StructuredSelection)this.fetchTypeComboViewer.getSelection()).getFirstElement() != FetchTypeDefaultLazy.DEFAULT_LITERAL) {
                this.fetchTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)FetchTypeDefaultLazy.DEFAULT_LITERAL));
            }
        } else if (this.getMultiRelationshipMapping().getFetchType() == FetchTypeDefaultLazy.EAGER_LITERAL) {
            if (((StructuredSelection)this.fetchTypeComboViewer.getSelection()).getFirstElement() != FetchTypeDefaultLazy.EAGER_LITERAL) {
                this.fetchTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)FetchTypeDefaultLazy.EAGER_LITERAL));
            }
        } else if (((StructuredSelection)this.fetchTypeComboViewer.getSelection()).getFirstElement() != FetchTypeDefaultLazy.LAZY_LITERAL) {
            this.fetchTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)FetchTypeDefaultLazy.LAZY_LITERAL));
        }
    }

    private void populateMappedByCombo() {
        String mappedBy = this.getMultiRelationshipMapping().getMappedBy();
        this.mappedByCombo.removeAll();
        Iterator i = this.getMultiRelationshipMapping().possibleMappedByAttributeNames();
        while (i.hasNext()) {
            this.mappedByCombo.add((String)i.next());
        }
        if (mappedBy != null && !this.mappedByCombo.getText().equals(mappedBy)) {
            this.mappedByCombo.setText(mappedBy);
        }
    }

    private void populateJoinTablePanel() {
        this.joinTableComposite.populate((EObject)this.getMultiRelationshipMapping().getJoinTable());
    }

    private void populateOrderByPanel() {
        this.orderByComposite.populate((EObject)this.getMultiRelationshipMapping().getOrderBy());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void relationshipMappingChanged(Notification notification) {
        block25: {
            block24: {
                super.relationshipMappingChanged(notification);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.dali.orm.MultiRelationshipMapping");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz) == 8) {
                    final FetchTypeDefaultLazy fetchType = (FetchTypeDefaultLazy)notification.getNewValue();
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            if (((StructuredSelection)MultiRelationshipMappingComposite.this.fetchTypeComboViewer.getSelection()).getFirstElement() != fetchType) {
                                MultiRelationshipMappingComposite.this.fetchTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)fetchType));
                            }
                        }
                    });
                    return;
                }
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.dali.orm.MultiRelationshipMapping");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz2) == 5) {
                    final String mappedBy = (String)notification.getNewValue();
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            if (MultiRelationshipMappingComposite.this.mappedByCombo.getText() == null || !MultiRelationshipMappingComposite.this.mappedByCombo.getText().equals(mappedBy)) {
                                if (mappedBy == null) {
                                    MultiRelationshipMappingComposite.this.mappedByCombo.setText("");
                                } else if (!MultiRelationshipMappingComposite.this.mappedByCombo.getText().equals(mappedBy)) {
                                    MultiRelationshipMappingComposite.this.mappedByCombo.setText(mappedBy);
                                }
                            }
                        }
                    });
                    return;
                }
                Class<?> clazz3 = class$0;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$0 = Class.forName("org.eclipse.dali.orm.MultiRelationshipMapping");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz3) == 2) break block24;
                Class<?> clazz4 = class$0;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$0 = Class.forName("org.eclipse.dali.orm.MultiRelationshipMapping");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz4) != 1) break block25;
            }
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    Entity targetEntity;
                    MultiRelationshipMappingComposite.this.populating = true;
                    if (MultiRelationshipMappingComposite.this.targetEntityPersistentType != null) {
                        MultiRelationshipMappingComposite.this.persistentTypeItemProvider.removeListener(MultiRelationshipMappingComposite.this.getPersistentTypeListener());
                        MultiRelationshipMappingComposite.this.targetEntityPersistentType.eAdapters().remove((Object)MultiRelationshipMappingComposite.this.persistentTypeItemProvider);
                    }
                    if ((targetEntity = MultiRelationshipMappingComposite.this.getMultiRelationshipMapping().getResolvedTargetEntity()) != null) {
                        MultiRelationshipMappingComposite.this.targetEntityPersistentType = targetEntity.getPersistentType();
                        MultiRelationshipMappingComposite.this.persistentTypeItemProvider.addListener(MultiRelationshipMappingComposite.this.getPersistentTypeListener());
                        MultiRelationshipMappingComposite.this.targetEntityPersistentType.eAdapters().add((Object)MultiRelationshipMappingComposite.this.persistentTypeItemProvider);
                    }
                    MultiRelationshipMappingComposite.this.populateMappedByCombo();
                    MultiRelationshipMappingComposite.this.populating = false;
                }
            });
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.orm.MultiRelationshipMapping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (notification.getFeatureID((Class)clazz) != 6) return;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                MultiRelationshipMappingComposite.this.populateOrderByPanel();
            }
        });
    }

    private INotifyChangedListener getPersistentTypeListener() {
        if (this.persistentTypeListener == null) {
            this.persistentTypeListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    MultiRelationshipMappingComposite.this.persistentTypeChanged(notification);
                }
            };
        }
        return this.persistentTypeListener;
    }

    private void persistentTypeChanged(Notification notification) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.dali.orm.PersistentType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (notification.getFeatureID((Class)clazz) == 3) {
            if (this.getMultiRelationshipMapping().getPersistentAttribute().eContainer() == null) {
                return;
            }
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    MultiRelationshipMappingComposite.this.populating = true;
                    MultiRelationshipMappingComposite.this.populateMappedByCombo();
                    MultiRelationshipMappingComposite.this.populating = false;
                }
            });
        }
    }

    public void dispose() {
        this.disenageListeners();
        this.joinTableComposite.dispose();
        this.orderByComposite.dispose();
        super.dispose();
    }
}

