/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.util.ArrayDeque;
import java.util.Deque;
import org.gradle.api.internal.AsmBackedClassGenerator;
import org.gradle.api.internal.ClassGeneratorBackedInstantiator;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.internal.reflect.Instantiator;

public abstract class ThreadGlobalInstantiator {
    private static final ThreadLocal<Deque<Instantiator>> STORAGE = new ThreadLocal<Deque<Instantiator>>(){

        @Override
        protected Deque<Instantiator> initialValue() {
            return new ArrayDeque<Instantiator>();
        }
    };

    private static Deque<Instantiator> getStack() {
        return STORAGE.get();
    }

    public static Instantiator get() {
        Deque<Instantiator> stack = ThreadGlobalInstantiator.getStack();
        return stack.isEmpty() ? null : stack.peek();
    }

    public static void set(Instantiator instantiator) {
        Deque<Instantiator> stack = ThreadGlobalInstantiator.getStack();
        if (instantiator != null) {
            stack.push(instantiator);
        } else if (!stack.isEmpty()) {
            stack.pop();
        }
    }

    public static Instantiator getOrCreate() {
        Instantiator instantiator = ThreadGlobalInstantiator.get();
        if (instantiator != null) {
            return instantiator;
        }
        return new ClassGeneratorBackedInstantiator(new AsmBackedClassGenerator(), DirectInstantiator.INSTANCE);
    }
}

