/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public final class JSComparisonWithNaNInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        return new JSElementVisitor(){

            @Override
            public void visitJSBinaryExpression(@NotNull JSBinaryExpression node) {
                JSExpression exprComparedToNaN;
                IElementType sign;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (((sign = node.getOperationSign()) == JSTokenTypes.EQEQEQ || sign == JSTokenTypes.EQEQ || sign == JSTokenTypes.NEQEQ || sign == JSTokenTypes.NE) && (exprComparedToNaN = JSComparisonWithNaNInspection.findExpressionComparedToNaN(node)) != null) {
                    boolean addNot = sign == JSTokenTypes.NE || sign == JSTokenTypes.NEQEQ;
                    holder.registerProblem((PsiElement)node, JavaScriptBundle.message(addNot ? "js.comparison.with.nan.inspection.problem2" : "js.comparison.with.nan.inspection.problem", new Object[0]), new LocalQuickFix[]{new JSReplaceWithIsNaNCallQuickFix(addNot)});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSComparisonWithNaNInspection$1", "visitJSBinaryExpression"));
            }
        };
    }

    private static JSExpression findExpressionComparedToNaN(JSBinaryExpression node) {
        JSExpression lOperand = node.getLOperand();
        JSExpression rOperand = node.getROperand();
        JSExpression exprComparedToNaN = null;
        if (lOperand instanceof JSReferenceExpression && "NaN".equals(lOperand.getText())) {
            exprComparedToNaN = rOperand;
        } else if (rOperand instanceof JSReferenceExpression && "NaN".equals(rOperand.getText())) {
            exprComparedToNaN = lOperand;
        }
        return exprComparedToNaN;
    }

    static class JSReplaceWithIsNaNCallQuickFix
    implements LocalQuickFix {
        private final boolean myAddNot;

        JSReplaceWithIsNaNCallQuickFix(boolean addNot) {
            this.myAddNot = addNot;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message("js.comparison.with.nan.inspection.quickfix", this.myAddNot ? "!" : "");
            if (string == null) {
                JSReplaceWithIsNaNCallQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                JSReplaceWithIsNaNCallQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                JSReplaceWithIsNaNCallQuickFix.$$$reportNull$$$0(2);
            }
            JSBinaryExpression node = (JSBinaryExpression)descriptor.getPsiElement();
            JSExpression expression = JSComparisonWithNaNInspection.findExpressionComparedToNaN(node);
            PsiFile file = node.getContainingFile();
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            if (document != null) {
                document.replaceString(node.getTextRange().getStartOffset(), node.getTextRange().getEndOffset(), (CharSequence)((this.myAddNot ? "!" : "") + "isNaN(" + expression.getText() + ")"));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSComparisonWithNaNInspection$JSReplaceWithIsNaNCallQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSComparisonWithNaNInspection$JSReplaceWithIsNaNCallQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

