/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.stubs.JSEmbeddedContentStub;
import com.intellij.lang.javascript.psi.stubs.TypeScriptModuleStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileStubImpl;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StubTreeUtil {
    @Nullable
    public static StubElement<?> getNextSibling(StubElement<?> stub) {
        return StubTreeUtil.getNextSibling(stub, null);
    }

    @Nullable
    public static StubElement<?> getNextSibling(StubElement<?> stub, @Nullable TokenSet filter) {
        ListIterator<StubElement<?>> iterator = StubTreeUtil.getIteratorBeforeElement(stub);
        iterator.next();
        while (iterator.hasNext()) {
            StubElement<?> next = iterator.next();
            if (!StubTreeUtil.isAcceptable(filter, next)) continue;
            return next;
        }
        return null;
    }

    @NotNull
    private static ListIterator<StubElement<?>> getIteratorBeforeElement(@NotNull StubElement<?> stub) {
        StubElement parentStub;
        List children;
        if (stub == null) {
            StubTreeUtil.$$$reportNull$$$0(0);
        }
        if (StubTreeUtil.areTooManyChildren(children = (parentStub = stub.getParentStub()).getChildrenStubs())) {
            int indexOfStub = Collections.binarySearch(children, stub, Comparator.comparing(stubElement -> ((StubBase)stubElement).getStubId()));
            assert (indexOfStub >= 0) : "Can't find stub in it's parent children";
            ListIterator<StubElement<?>> listIterator = children.listIterator(indexOfStub);
            if (listIterator == null) {
                StubTreeUtil.$$$reportNull$$$0(1);
            }
            return listIterator;
        }
        ListIterator<StubElement<?>> listIterator = children.listIterator();
        while (listIterator.hasNext()) {
            StubElement next = (StubElement)listIterator.next();
            if (next != stub) continue;
            listIterator.previous();
            ListIterator<StubElement<?>> listIterator2 = listIterator;
            if (listIterator2 == null) {
                StubTreeUtil.$$$reportNull$$$0(2);
            }
            return listIterator2;
        }
        throw new AssertionError((Object)"Can't find stub in it's parent children");
    }

    private static boolean areTooManyChildren(List<StubElement<?>> children) {
        return children.size() > 10;
    }

    private static boolean isAcceptable(@Nullable TokenSet filter, @NotNull StubElement<?> child) {
        if (child == null) {
            StubTreeUtil.$$$reportNull$$$0(3);
        }
        return filter == null || filter.contains((IElementType)child.getStubType());
    }

    @Nullable
    public static StubElement<?> getPrevSibling(StubElement<?> stub) {
        ListIterator<StubElement<?>> iterator = StubTreeUtil.getIteratorBeforeElement(stub);
        return iterator.hasPrevious() ? iterator.previous() : null;
    }

    @Nullable
    public static Language getJSLanguage(@NotNull StubElement<?> stub) {
        if (stub == null) {
            StubTreeUtil.$$$reportNull$$$0(4);
        }
        for (StubElement parent = stub; parent != null; parent = parent.getParentStub()) {
            stub = parent;
        }
        return stub instanceof JSFileStubImpl ? ((JSFileStubImpl)stub).getLanguage() : null;
    }

    @Nullable
    public static StubElement<?> findChildStubByType(@NotNull StubElement<?> parent, @NotNull TokenSet types, boolean isDirectOnly) {
        if (parent == null) {
            StubTreeUtil.$$$reportNull$$$0(5);
        }
        if (types == null) {
            StubTreeUtil.$$$reportNull$$$0(6);
        }
        if (isDirectOnly) {
            return StubTreeUtil.findDirectChild(parent, child -> types.contains((IElementType)child.getStubType()));
        }
        return (StubElement)ContainerUtil.find((Iterable)parent.getChildrenStubs(), child -> types.contains((IElementType)child.getStubType()));
    }

    public static boolean isFromGlobalNamespace(StubElement<?> startElement) {
        if (startElement instanceof TypeScriptModuleStub && !((TypeScriptModuleStub)startElement).isAugmentation() && StubTreeUtil.isExternalModule(startElement)) {
            return true;
        }
        for (StubElement parentStub = startElement.getParentStub(); parentStub != null; parentStub = parentStub.getParentStub()) {
            if (parentStub instanceof PsiFileStub) {
                if (parentStub instanceof JSFileStubImpl) {
                    JSFileStubImpl fileStub = (JSFileStubImpl)parentStub;
                    JSFileCachedData data2 = fileStub.getCachedData();
                    if (data2 == null) {
                        return true;
                    }
                    JSModuleStatusOwner.ModuleStatus status = data2.getModuleStatus();
                    return status != JSModuleStatusOwner.ModuleStatus.ES6 && status != JSModuleStatusOwner.ModuleStatus.COMMONJS;
                }
                return true;
            }
            if (parentStub instanceof TypeScriptModuleStub) {
                StubElement possibleModuleElement = parentStub.getParentStub();
                if (possibleModuleElement instanceof JSFileStubImpl) {
                    String name = ((TypeScriptModuleStub)parentStub).getName();
                    return TypeScriptUtil.convertToExternalModuleText(name) == null;
                }
                if (!StubTreeUtil.isExternalModule(possibleModuleElement)) continue;
                return ((TypeScriptModuleStub)parentStub).getName() == null;
            }
            if (!(parentStub instanceof JSEmbeddedContentStub)) continue;
            IStubElementType type2 = parentStub.getStubType();
            return !JSExtendedLanguagesTokenSetProvider.MODULE_EMBEDDED_CONTENTS.contains((IElementType)type2);
        }
        return true;
    }

    private static boolean isExternalModule(StubElement<?> possibleModuleElement) {
        if (!(possibleModuleElement instanceof TypeScriptModuleStub)) {
            return false;
        }
        String name = ((TypeScriptModuleStub)possibleModuleElement).getName();
        return TypeScriptUtil.convertToExternalModuleText(name) != null;
    }

    public static boolean checkParentStubShouldCreate(@NotNull ASTNode node) {
        ASTNode owner;
        if (node == null) {
            StubTreeUtil.$$$reportNull$$$0(7);
        }
        if ((owner = node.getTreeParent()) != null) {
            IElementType ownerType = owner.getElementType();
            if (ownerType instanceof IStubElementType) {
                return ((IStubElementType)ownerType).shouldCreateStub(owner);
            }
            if (ownerType instanceof JSFileElementType) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static StubElement<?> findDirectChild(@NotNull StubElement<?> stub, @NotNull Predicate<StubElement<?>> filter) {
        if (stub == null) {
            StubTreeUtil.$$$reportNull$$$0(8);
        }
        if (filter == null) {
            StubTreeUtil.$$$reportNull$$$0(9);
        }
        for (StubElement child : stub.getChildrenStubs()) {
            ObjectStubBase objectStubBase;
            if (!(child instanceof ObjectStubBase) || (objectStubBase = (ObjectStubBase)child).isDangling() || !filter.test(child)) continue;
            return child;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/StubTreeUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/StubTreeUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIteratorBeforeElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIteratorBeforeElement";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getJSLanguage";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findChildStubByType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkParentStubShouldCreate";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findDirectChild";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

