/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.service.LoggerBucket;
import com.intellij.lang.javascript.service.MessageStreamLogger;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/lang/javascript/service/MessageStreamLoggerService;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "loggers", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/lang/javascript/service/LoggerBucket;", "connect", "Lcom/intellij/lang/javascript/service/MessageStreamLogger;", "logFileName", "disconnect", "", "logger", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nMessageStreamLoggerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageStreamLoggerService.kt\ncom/intellij/lang/javascript/service/MessageStreamLoggerService\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,126:1\n72#2,2:127\n1#3:129\n1#3:130\n15#4:131\n*S KotlinDebug\n*F\n+ 1 MessageStreamLoggerService.kt\ncom/intellij/lang/javascript/service/MessageStreamLoggerService\n*L\n24#1:127,2\n24#1:129\n31#1:131\n*E\n"})
public final class MessageStreamLoggerService {
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final ConcurrentHashMap<String, LoggerBucket> loggers;

    public MessageStreamLoggerService(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
        this.loggers = new ConcurrentHashMap();
    }

    @Nullable
    public final MessageStreamLogger connect(@NotNull String logFileName) {
        Intrinsics.checkNotNullParameter((Object)logFileName, (String)"logFileName");
        ConcurrentMap $this$getOrPut$iv = this.loggers;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(logFileName);
        if (object == null) {
            boolean bl = false;
            LoggerBucket default$iv = new LoggerBucket(logFileName, this.cs);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(logFileName, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        LoggerBucket bucket = (LoggerBucket)object;
        return bucket.connect();
    }

    public final void disconnect(@NotNull MessageStreamLogger logger) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Collection<LoggerBucket> collection = this.loggers.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable iterable = collection;
            for (Object t : iterable) {
                LoggerBucket it = (LoggerBucket)t;
                boolean bl = false;
                if (!it.containsLogger(logger)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        LoggerBucket bucket = v1;
        if (bucket == null) {
            boolean $i$f$logger = false;
            Logger logger2 = Logger.getInstance(MessageStreamLoggerService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.error("Cannot find a bucket of " + logger.getLogPath$intellij_javascript_impl().getFileName());
            return;
        }
        bucket.disconnect(logger);
    }
}

