/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.toolwindow.preview;

import com.intellij.codeInsight.highlighting.TooltipLinkHandler;
import com.intellij.codeInsight.hint.InspectionDescriptionLinkHandler;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.packageChecker.toolwindow.preview.PackageCheckerLinkHandlerKt;
import com.intellij.packageChecker.toolwindow.tree.panel.VulnerableDependenciesProblemTab;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0011\u0010\u0004\u001a\u00020\u00058G\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/packageChecker/toolwindow/preview/PackageCheckerLinkHandler;", "Lcom/intellij/codeInsight/highlighting/TooltipLinkHandler;", "<init>", "()V", "inspectionDescriptionLinkHandler", "Lcom/intellij/codeInsight/hint/InspectionDescriptionLinkHandler;", "getInspectionDescriptionLinkHandler", "()Lcom/intellij/codeInsight/hint/InspectionDescriptionLinkHandler;", "handleLink", "", "refSuffix", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "getDescription", "parseRefSuffix", "", "LinkHandlerUtil", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nPackageCheckerLinkHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageCheckerLinkHandler.kt\ncom/intellij/packageChecker/toolwindow/preview/PackageCheckerLinkHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1187#2,2:109\n1261#2,4:111\n*S KotlinDebug\n*F\n+ 1 PackageCheckerLinkHandler.kt\ncom/intellij/packageChecker/toolwindow/preview/PackageCheckerLinkHandler\n*L\n100#1:109,2\n100#1:111,4\n*E\n"})
public final class PackageCheckerLinkHandler
extends TooltipLinkHandler {
    @VisibleForTesting
    @NotNull
    public final InspectionDescriptionLinkHandler getInspectionDescriptionLinkHandler() {
        return new InspectionDescriptionLinkHandler();
    }

    public boolean handleLink(@NotNull String refSuffix, @NotNull Editor editor) {
        Map<String, String> parameters;
        Intrinsics.checkNotNullParameter((Object)refSuffix, (String)"refSuffix");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Object[] objectArray = new Object[]{refSuffix};
        PackageCheckerLinkHandlerKt.access$getLogger$p().debug("handleLink with refSuffix: ", objectArray);
        if (editor.getProject() != null && StringsKt.startsWith$default((String)refSuffix, (String)"dependency", (boolean)false, (int)2, null)) {
            parameters = this.parseRefSuffix(StringsKt.removePrefix((String)refSuffix, (CharSequence)"dependency?"));
            String moduleModelId = parameters.get("moduleModelId");
            String pkgCoordinates = parameters.get("pkgCoordinates");
            Object[] objectArray2 = new Object[]{moduleModelId, ", pkgCoordinates: ", pkgCoordinates};
            PackageCheckerLinkHandlerKt.access$getLogger$p().debug("moduleModelId: ", objectArray2);
            if (pkgCoordinates != null) {
                Project project = editor.getProject();
                Intrinsics.checkNotNull((Object)project);
                Project project2 = project;
                if (!VulnerableDependenciesProblemTab.Companion.isVisible(project2)) {
                    VulnerableDependenciesProblemTab.Companion.createAndOpen(project2);
                }
                VulnerableDependenciesProblemTab.Companion.selectPackage(project2, pkgCoordinates, moduleModelId);
            }
            return true;
        }
        if (StringsKt.startsWith$default((String)refSuffix, (String)"cve", (boolean)false, (int)2, null)) {
            parameters = this.parseRefSuffix(StringsKt.removePrefix((String)refSuffix, (CharSequence)"cve?"));
            String reference = parameters.get("reference");
            if (reference != null) {
                String decodedReference = URLDecoder.decode(reference, "UTF-8");
                Object[] objectArray3 = new Object[]{decodedReference};
                PackageCheckerLinkHandlerKt.access$getLogger$p().debug("reference: ", objectArray3);
                BrowserUtil.browse((String)decodedReference);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public String getDescription(@NotNull String refSuffix, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)refSuffix, (String)"refSuffix");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Object[] objectArray = new Object[]{refSuffix};
        PackageCheckerLinkHandlerKt.access$getLogger$p().debug("getDescription with refSuffix: ", objectArray);
        Map<String, String> parameters = this.parseRefSuffix(StringsKt.removePrefix((String)StringsKt.removePrefix((String)refSuffix, (CharSequence)"dependency?"), (CharSequence)"cve?"));
        String string = parameters.get("inspection");
        if (string == null) {
            return null;
        }
        String inspectionName = string;
        return this.getInspectionDescriptionLinkHandler().getDescription(inspectionName, editor);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> parseRefSuffix(String refSuffix) {
        void $this$associateTo$iv$iv;
        char[] cArray = new char[]{'&'};
        Iterable $this$associate$iv = StringsKt.split$default((CharSequence)refSuffix, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            String string;
            String name;
            Map map2 = destination$iv$iv;
            String it = (String)element$iv$iv;
            boolean bl = false;
            char[] cArray2 = new char[]{'='};
            List parts = StringsKt.split$default((CharSequence)it, (char[])cArray2, (boolean)false, (int)0, (int)6, null);
            String string2 = (String)CollectionsKt.firstOrNull((List)parts);
            if (string2 == null) {
                string2 = name = "";
            }
            if ((string = (String)CollectionsKt.firstOrNull((List)CollectionsKt.drop((Iterable)parts, (int)1))) == null) {
                string = "";
            }
            String value = string;
            Pair pair = TuplesKt.to((Object)name, (Object)value);
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u0005J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005\u00a8\u0006\n"}, d2={"Lcom/intellij/packageChecker/toolwindow/preview/PackageCheckerLinkHandler$LinkHandlerUtil;", "", "<init>", "()V", "buildLink", "", "moduleModelId", "pkgCoordinates", "inspectionName", "reference", "intellij.packageChecker"})
    @SourceDebugExtension(value={"SMAP\nPackageCheckerLinkHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageCheckerLinkHandler.kt\ncom/intellij/packageChecker/toolwindow/preview/PackageCheckerLinkHandler$LinkHandlerUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
    public static final class LinkHandlerUtil {
        @NotNull
        public static final LinkHandlerUtil INSTANCE = new LinkHandlerUtil();

        private LinkHandlerUtil() {
        }

        @NotNull
        public final String buildLink(@Nullable String moduleModelId, @Nullable String pkgCoordinates, @NotNull String inspectionName) {
            String it;
            Intrinsics.checkNotNullParameter((Object)inspectionName, (String)"inspectionName");
            StringBuilder linkBuilder = new StringBuilder("#package_checker/dependency?");
            linkBuilder.append("inspection=" + inspectionName + "&");
            String string = moduleModelId;
            if (string != null) {
                it = string;
                boolean bl = false;
                linkBuilder.append("moduleModelId=" + moduleModelId + "&");
            }
            String string2 = pkgCoordinates;
            if (string2 != null) {
                it = string2;
                boolean bl = false;
                linkBuilder.append("pkgCoordinates=" + pkgCoordinates);
            }
            String string3 = linkBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            return string3;
        }

        @NotNull
        public final String buildLink(@NotNull String reference, @NotNull String inspectionName) {
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            Intrinsics.checkNotNullParameter((Object)inspectionName, (String)"inspectionName");
            StringBuilder linkBuilder = new StringBuilder("#package_checker/cve?");
            linkBuilder.append("inspection=" + inspectionName + "&");
            linkBuilder.append("reference=" + URLEncoder.encode(reference, "UTF-8"));
            String string = linkBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }
}

