/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.dynamicVariables;

import com.intellij.httpClient.http.request.dynamicVariables.HttpClientDynamicVariableValue;
import com.intellij.httpClient.http.request.dynamicVariables.HttpClientDynamicVariablesRandomProvider;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.PlatformRandomKt;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.ranges.CharRange;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010 \n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\b\u0010\u0010\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0001H\u0002\u001a&\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0014\"\u0004\b\u0000\u0010\u0015*\b\u0012\u0004\u0012\u0002H\u00150\u00062\u0006\u0010\u0016\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u0017\u001a\u00020\u000b*\b\u0012\u0004\u0012\u00020\u00070\u0014H\u0002\"\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"asKInteger", "", "Lcom/intellij/httpClient/http/request/dynamicVariables/HttpClientDynamicVariableValue$ParameterValue;", "asKFloat", "", "lowercaseLetters", "", "", "letters", "lettersAndDigits", "domains", "", "hexadecimal", "userNameLength", "Lkotlin/ranges/IntRange;", "hostNameLength", "randomEmail", "randomHexadecimal", "length", "chooseNTimes", "Lkotlin/sequences/Sequence;", "T", "n", "collectString", "intellij.httpClient.lang"})
public final class HttpClientDynamicVariablesKt {
    @NotNull
    private static final List<Character> lowercaseLetters = CollectionsKt.toList((Iterable)((Iterable)new CharRange('a', 'z')));
    @NotNull
    private static final List<Character> letters = CollectionsKt.plus((Collection)lowercaseLetters, (Iterable)((Iterable)new CharRange('A', 'Z')));
    @NotNull
    private static final List<Character> lettersAndDigits = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)letters, (Iterable)((Iterable)new CharRange('0', '9'))), (Object)Character.valueOf('_'));
    @NotNull
    private static final List<String> domains;
    @NotNull
    private static final List<Character> hexadecimal;
    @NotNull
    private static final IntRange userNameLength;
    @NotNull
    private static final IntRange hostNameLength;

    public static final int asKInteger(@NotNull HttpClientDynamicVariableValue.ParameterValue $this$asKInteger) {
        Intrinsics.checkNotNullParameter((Object)$this$asKInteger, (String)"<this>");
        return ((HttpClientDynamicVariableValue.ParameterValue.Integer)$this$asKInteger).getValue();
    }

    public static final float asKFloat(@NotNull HttpClientDynamicVariableValue.ParameterValue $this$asKFloat) {
        float f;
        Intrinsics.checkNotNullParameter((Object)$this$asKFloat, (String)"<this>");
        HttpClientDynamicVariableValue.ParameterValue parameterValue = $this$asKFloat;
        if (parameterValue instanceof HttpClientDynamicVariableValue.ParameterValue.Float) {
            f = ((HttpClientDynamicVariableValue.ParameterValue.Float)$this$asKFloat).getValue();
        } else if (parameterValue instanceof HttpClientDynamicVariableValue.ParameterValue.Integer) {
            f = ((HttpClientDynamicVariableValue.ParameterValue.Integer)$this$asKFloat).getValue();
        } else {
            if (parameterValue instanceof HttpClientDynamicVariableValue.ParameterValue.Str) {
                throw new IllegalStateException(("Tried to get " + $this$asKFloat + " as Float").toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        return f;
    }

    private static final String randomEmail() {
        Random random = PlatformRandomKt.asKotlinRandom((java.util.Random)HttpClientDynamicVariablesRandomProvider.INSTANCE.getRandom$intellij_httpClient_lang());
        String domain = (String)CollectionsKt.random((Collection)domains, (Random)random);
        int userNameLength = RandomKt.nextInt((Random)random, (IntRange)HttpClientDynamicVariablesKt.userNameLength);
        int hostNameLength = RandomKt.nextInt((Random)random, (IntRange)HttpClientDynamicVariablesKt.hostNameLength);
        String userName = HttpClientDynamicVariablesKt.collectString(HttpClientDynamicVariablesKt.chooseNTimes(lettersAndDigits, userNameLength));
        String hostName = HttpClientDynamicVariablesKt.collectString(HttpClientDynamicVariablesKt.chooseNTimes(letters, hostNameLength));
        return userName + "@" + hostName + "." + domain;
    }

    private static final String randomHexadecimal(int length2) {
        StringBuilder stringBuilder;
        StringBuilder $this$randomHexadecimal_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$randomHexadecimal_u24lambda_u240.append(hexadecimal.get(HttpClientDynamicVariablesRandomProvider.INSTANCE.getRandom$intellij_httpClient_lang().nextInt(1, hexadecimal.size())).charValue());
        if (length2 > 1) {
            Iterator iterator = HttpClientDynamicVariablesKt.chooseNTimes(hexadecimal, length2 - 1).iterator();
            while (iterator.hasNext()) {
                char c = ((Character)iterator.next()).charValue();
                $this$randomHexadecimal_u24lambda_u240.append(c);
            }
        }
        return stringBuilder.toString();
    }

    private static final <T> Sequence<T> chooseNTimes(List<? extends T> $this$chooseNTimes, int n) {
        IntStream intStream = HttpClientDynamicVariablesRandomProvider.INSTANCE.getRandom$intellij_httpClient_lang().ints(0, $this$chooseNTimes.size());
        Intrinsics.checkNotNullExpressionValue((Object)intStream, (String)"ints(...)");
        return SequencesKt.map((Sequence)SequencesKt.take((Sequence)StreamsKt.asSequence((IntStream)intStream), (int)n), arg_0 -> HttpClientDynamicVariablesKt.chooseNTimes$lambda$1($this$chooseNTimes, arg_0));
    }

    private static final String collectString(Sequence<Character> $this$collectString) {
        return SequencesKt.joinToString$default($this$collectString, (CharSequence)"", null, null, (int)0, null, HttpClientDynamicVariablesKt::collectString$lambda$2, (int)30, null);
    }

    private static final Object chooseNTimes$lambda$1(List $this_chooseNTimes, int it) {
        return $this_chooseNTimes.get(it);
    }

    private static final CharSequence collectString$lambda$2(char it) {
        return String.valueOf(it);
    }

    public static final /* synthetic */ String access$collectString(Sequence $receiver) {
        return HttpClientDynamicVariablesKt.collectString((Sequence<Character>)$receiver);
    }

    public static final /* synthetic */ Sequence access$chooseNTimes(List $receiver, int n) {
        return HttpClientDynamicVariablesKt.chooseNTimes($receiver, n);
    }

    public static final /* synthetic */ List access$getLettersAndDigits$p() {
        return lettersAndDigits;
    }

    public static final /* synthetic */ List access$getLetters$p() {
        return letters;
    }

    public static final /* synthetic */ String access$randomHexadecimal(int length2) {
        return HttpClientDynamicVariablesKt.randomHexadecimal(length2);
    }

    public static final /* synthetic */ String access$randomEmail() {
        return HttpClientDynamicVariablesKt.randomEmail();
    }

    static {
        Object[] objectArray = new String[]{"com", "org", "nl", "cz", "de", "io", "cy", "us", "uk", "cn", "it"};
        domains = CollectionsKt.listOf((Object[])objectArray);
        hexadecimal = CollectionsKt.plus((Collection)CollectionsKt.toList((Iterable)((Iterable)new CharRange('0', '9'))), (Iterable)((Iterable)new CharRange('A', 'F')));
        userNameLength = new IntRange(5, 20);
        hostNameLength = new IntRange(3, 7);
    }
}

