/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.asynccontext;

import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.asynccontext.AsyncContextBuiltins;
import com.oracle.truffle.js.builtins.asynccontext.AsyncContextSnapshotPrototypeBuiltins;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.builtins.asynccontext.JSAsyncContextSnapshotObject;
import com.oracle.truffle.js.runtime.objects.AsyncContext;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;

public final class JSAsyncContextSnapshot
extends JSNonProxy
implements JSConstructorFactory.WithFunctions,
PrototypeSupplier {
    public static final TruffleString CLASS_NAME = Strings.constant("Snapshot");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("Snapshot.prototype");
    public static final TruffleString TO_STRING_TAG = Strings.constant("AsyncContext.Snapshot");
    public static final JSAsyncContextSnapshot INSTANCE = new JSAsyncContextSnapshot();

    private JSAsyncContextSnapshot() {
    }

    public static JSAsyncContextSnapshotObject create(JSContext context2, JSRealm realm, JSDynamicObject proto, AsyncContext asyncContextMapping) {
        JSObjectFactory factory = context2.getAsyncContextSnapshotFactory();
        Shape shape = factory.getShape(realm, proto);
        JSAsyncContextSnapshotObject newObj = factory.initProto(new JSAsyncContextSnapshotObject(shape, proto, asyncContextMapping), realm, proto);
        return factory.trackAllocation(newObj);
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject ctor) {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(prototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, AsyncContextSnapshotPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putAccessorsFromContainer(realm, prototype, AsyncContextSnapshotPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(prototype, TO_STRING_TAG);
        return prototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context2, JSDynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context2);
    }

    @Override
    public JSFunctionObject createConstructorObject(JSRealm realm) {
        return realm.lookupFunction(AsyncContextBuiltins.BUILTINS, this.getClassName());
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, AsyncContextBuiltins.BUILTINS);
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    @Override
    public TruffleString getClassName(JSDynamicObject object) {
        return this.getClassName();
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getAsyncContextSnapshotPrototype();
    }

    public static boolean isJSAsyncContextSnapshot(Object object) {
        return object instanceof JSAsyncContextSnapshotObject;
    }
}

