/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.ModuleRootAndDepOps;
import com.jetbrains.python.sdk.ModuleTransferredRoots;
import com.jetbrains.python.sdk.PySdkCoreToolsKt;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PyTransferredSdkRootsKt;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.TransferredRootsDetector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a4\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\tH\u0002\u001a\u0018\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u0018\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001c\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u001a\u0018\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\n2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u0018\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u0018\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\n2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u0018\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a$\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u001a4\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\tH\u0002\u00a8\u0006\u001b"}, d2={"transferRootsToModulesWithSdk", "", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "removeTransferredRootsFromModulesWithSdk", "updateRootsForModulesWithSdk", "action", "Lkotlin/Function2;", "Lcom/intellij/openapi/module/Module;", "transferRootsToModulesWithInheritedSdk", "removeTransferredRootsFromModulesWithInheritedSdk", "getPathsToTransfer", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "setPathsToTransfer", "roots", "transferRoots", "module", "addTransferredRoots", "newTransferredRoots", "Lcom/jetbrains/python/sdk/ModuleTransferredRoots;", "removeTransferredRoots", "updateTransferredRoots", "newInProjectPaths", "updateRootsForModulesWithInheritedSdk", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyTransferredSdkRoots.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyTransferredSdkRoots.kt\ncom/jetbrains/python/sdk/PyTransferredSdkRootsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n774#2:201\n865#2,2:202\n1279#2,2:204\n1293#2,4:206\n1279#2,2:210\n1293#2,4:212\n1368#2:216\n1454#2,2:217\n1611#2,9:219\n1863#2:228\n1864#2:230\n1620#2:231\n1456#2,3:232\n1#3:229\n*S KotlinDebug\n*F\n+ 1 PyTransferredSdkRoots.kt\ncom/jetbrains/python/sdk/PyTransferredSdkRootsKt\n*L\n120#1:201\n120#1:202,2\n122#1:204,2\n122#1:206,4\n123#1:210,2\n123#1:212,4\n125#1:216\n125#1:217,2\n125#1:219,9\n125#1:228\n125#1:230\n125#1:231\n125#1:232,3\n125#1:229\n*E\n"})
public final class PyTransferredSdkRootsKt {
    public static final void transferRootsToModulesWithSdk(@NotNull Project project, @NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        PyTransferredSdkRootsKt.updateRootsForModulesWithSdk(project, sdk2, (Function2<? super Module, ? super Sdk, Unit>)((Function2)transferRootsToModulesWithSdk.1.INSTANCE));
    }

    public static final void removeTransferredRootsFromModulesWithSdk(@NotNull Project project, @NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        PyTransferredSdkRootsKt.updateRootsForModulesWithSdk(project, sdk2, (Function2<? super Module, ? super Sdk, Unit>)((Function2)removeTransferredRootsFromModulesWithSdk.1.INSTANCE));
    }

    private static final void updateRootsForModulesWithSdk(Project project, Sdk sdk2, Function2<? super Module, ? super Sdk, Unit> action) {
        if (sdk2 == null) {
            return;
        }
        for (Module module : (Module[])ActionsKt.runReadAction(() -> PyTransferredSdkRootsKt.updateRootsForModulesWithSdk$lambda$0(project))) {
            action.invoke((Object)module, (Object)sdk2);
        }
    }

    public static final void transferRootsToModulesWithInheritedSdk(@NotNull Project project, @Nullable Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PyTransferredSdkRootsKt.updateRootsForModulesWithInheritedSdk(project, sdk2, (Function2<? super Module, ? super Sdk, Unit>)((Function2)transferRootsToModulesWithInheritedSdk.1.INSTANCE));
    }

    public static final void removeTransferredRootsFromModulesWithInheritedSdk(@NotNull Project project, @Nullable Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PyTransferredSdkRootsKt.updateRootsForModulesWithInheritedSdk(project, sdk2, (Function2<? super Module, ? super Sdk, Unit>)((Function2)removeTransferredRootsFromModulesWithInheritedSdk.1.INSTANCE));
    }

    @NotNull
    public static final Set<VirtualFile> getPathsToTransfer(@NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        SdkAdditionalData sdkAdditionalData = sdk2.getSdkAdditionalData();
        Object object = sdkAdditionalData instanceof PythonSdkAdditionalData ? (PythonSdkAdditionalData)sdkAdditionalData : null;
        if (object == null || (object = ((PythonSdkAdditionalData)object).getPathsToTransfer()) == null) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    public static final void setPathsToTransfer(@NotNull Sdk sdk2, @NotNull Set<? extends VirtualFile> roots) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        ActionsKt.runInEdt$default(null, () -> PyTransferredSdkRootsKt.setPathsToTransfer$lambda$3(roots, sdk2), (int)1, null);
    }

    public static final void transferRoots(@NotNull Module module, @Nullable Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (sdk2 != null && Intrinsics.areEqual((Object)PySdkExtKt.getPythonSdk(module), (Object)sdk2)) {
            ActionsKt.runInEdt$default(null, () -> PyTransferredSdkRootsKt.transferRoots$lambda$4(sdk2, module), (int)1, null);
        }
    }

    private static final void addTransferredRoots(Module module, ModuleTransferredRoots newTransferredRoots) {
        ModuleRootAndDepOps.INSTANCE.getLOG().info("Adding source roots " + newTransferredRoots.getSourceRoots() + " to module " + module);
        PyUtil.addSourceRoots(module, (Collection<VirtualFile>)newTransferredRoots.getSourceRoots());
        ModuleRootAndDepOps.INSTANCE.getLOG().info("Adding dependencies " + newTransferredRoots.getDependencies() + " to module " + module);
        PyUtil.addModuleDependencies(module, (Collection<Module>)newTransferredRoots.getDependencies());
    }

    public static final void removeTransferredRoots(@NotNull Module module, @Nullable Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (sdk2 != null && Intrinsics.areEqual((Object)PySdkExtKt.getPythonSdk(module), (Object)sdk2)) {
            ActionsKt.runInEdt$default(null, () -> PyTransferredSdkRootsKt.removeTransferredRoots$lambda$5(sdk2, module), (int)1, null);
        }
    }

    private static final void removeTransferredRoots(Module module, ModuleTransferredRoots newTransferredRoots) {
        ModuleRootAndDepOps.INSTANCE.getLOG().info("Removing source roots " + newTransferredRoots.getSourceRoots() + " from module " + module);
        PyUtil.removeSourceRoots(module, (Collection<VirtualFile>)newTransferredRoots.getSourceRoots());
        ModuleRootAndDepOps.INSTANCE.getLOG().info("Removing dependencies " + newTransferredRoots.getDependencies() + " from module " + module);
        PyUtil.removeModuleDependencies(module, (Collection<Module>)newTransferredRoots.getDependencies());
    }

    /*
     * WARNING - void declaration
     */
    public static final void updateTransferredRoots(@NotNull Project project, @NotNull Sdk sdk2, @NotNull Set<? extends VirtualFile> newInProjectPaths) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        ModuleTransferredRoots moduleTransferredRoots;
        Map map2;
        Object object;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter(newInProjectPaths, (String)"newInProjectPaths");
        TransferredRootsDetector rootsDetector = new TransferredRootsDetector(project);
        Iterable $this$filter$iv = rootsDetector.getProjectModules();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Module it = (Module)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)PySdkExtKt.getPythonSdk(it), (Object)sdk2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List modulesWithThisSdk = (List)destination$iv$iv;
        Set<VirtualFile> oldTransferredRoots = PyTransferredSdkRootsKt.getPathsToTransfer(sdk2);
        Iterable $this$associateWith$iv = modulesWithThisSdk;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            Module module = (Module)element$iv$iv;
            object = element$iv$iv;
            map2 = result$iv;
            boolean bl = false;
            moduleTransferredRoots = rootsDetector.detect((Module)it, oldTransferredRoots, oldTransferredRoots);
            map2.put(object, moduleTransferredRoots);
        }
        Map oldTransferredRootsStructure = result$iv;
        Iterable $this$associateWith$iv2 = modulesWithThisSdk;
        boolean $i$f$associateWith22 = false;
        LinkedHashMap result$iv2 = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv2, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv2 = $this$associateWith$iv2;
        boolean $i$f$associateWithTo2 = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv2) {
            void it;
            Module bl = (Module)element$iv$iv;
            object = element$iv$iv;
            map2 = result$iv2;
            boolean bl2 = false;
            moduleTransferredRoots = rootsDetector.detect((Module)it, newInProjectPaths, oldTransferredRoots);
            map2.put(object, moduleTransferredRoots);
        }
        Map newTransferredRootsStructure = result$iv2;
        Iterable $i$f$associateWith22 = newTransferredRootsStructure.values();
        boolean $i$f$flatMap = false;
        $this$associateWithTo$iv$iv2 = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            ModuleTransferredRoots it = (ModuleTransferredRoots)element$iv$iv;
            boolean bl = false;
            Iterable iterable2 = it.getDependencies();
            Set<VirtualFile> set = it.getSourceRoots();
            boolean $i$f$mapNotNull = false;
            void var21_42 = $this$mapNotNull$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                VirtualFile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                boolean bl3 = false;
                Module it2 = (Module)element$iv$iv2;
                boolean bl4 = false;
                if (BasePySdkExtKt.getBaseDir(it2) == null) continue;
                boolean bl5 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            Iterable list$iv$iv = SetsKt.plus(set, (Iterable)((List)destination$iv$iv3));
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Set newTransferredRoots = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        if (!Intrinsics.areEqual(oldTransferredRoots, (Object)newTransferredRoots)) {
            for (Map.Entry entry : newTransferredRootsStructure.entrySet()) {
                Module module = (Module)entry.getKey();
                ModuleTransferredRoots newModuleRoots = (ModuleTransferredRoots)entry.getValue();
                ActionsKt.runInEdt$default(null, () -> PyTransferredSdkRootsKt.updateTransferredRoots$lambda$11(oldTransferredRootsStructure, module, newModuleRoots), (int)1, null);
            }
            PyTransferredSdkRootsKt.setPathsToTransfer(sdk2, newTransferredRoots);
        }
    }

    private static final void updateRootsForModulesWithInheritedSdk(Project project, Sdk sdk2, Function2<? super Module, ? super Sdk, Unit> action) {
        if (sdk2 == null) {
            return;
        }
        for (Module module : (Module[])ActionsKt.runReadAction(() -> PyTransferredSdkRootsKt.updateRootsForModulesWithInheritedSdk$lambda$12(project))) {
            if (!ModuleRootManager.getInstance((Module)module).isSdkInherited()) continue;
            action.invoke((Object)module, (Object)sdk2);
        }
    }

    private static final Module[] updateRootsForModulesWithSdk$lambda$0(Project $project) {
        return ModuleManager.Companion.getInstance($project).getModules();
    }

    private static final Unit setPathsToTransfer$lambda$3$lambda$2$lambda$1(SdkModificator $this_apply) {
        $this_apply.commitChanges();
        return Unit.INSTANCE;
    }

    private static final Unit setPathsToTransfer$lambda$3(Set $roots, Sdk $sdk) {
        if (!((Collection)$roots).isEmpty() || !((Collection)PyTransferredSdkRootsKt.getPathsToTransfer($sdk)).isEmpty()) {
            SdkModificator sdkModificator;
            PySdkCoreToolsKt.getOrCreateAdditionalData($sdk);
            SdkModificator $this$setPathsToTransfer_u24lambda_u243_u24lambda_u242 = sdkModificator = $sdk.getSdkModificator();
            boolean bl = false;
            SdkAdditionalData sdkAdditionalData = $this$setPathsToTransfer_u24lambda_u243_u24lambda_u242.getSdkAdditionalData();
            Intrinsics.checkNotNull((Object)sdkAdditionalData, (String)"null cannot be cast to non-null type com.jetbrains.python.sdk.PythonSdkAdditionalData");
            ((PythonSdkAdditionalData)sdkAdditionalData).setPathsToTransferFromVirtualFiles($roots);
            ActionsKt.runWriteAction(() -> PyTransferredSdkRootsKt.setPathsToTransfer$lambda$3$lambda$2$lambda$1($this$setPathsToTransfer_u24lambda_u243_u24lambda_u242));
        }
        return Unit.INSTANCE;
    }

    private static final Unit transferRoots$lambda$4(Sdk $sdk, Module $module) {
        Set<VirtualFile> transferredRoots = PyTransferredSdkRootsKt.getPathsToTransfer($sdk);
        Project project = $module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ModuleTransferredRoots newTransferredRoots = new TransferredRootsDetector(project).detect($module, transferredRoots, transferredRoots);
        PyTransferredSdkRootsKt.addTransferredRoots($module, newTransferredRoots);
        return Unit.INSTANCE;
    }

    private static final Unit removeTransferredRoots$lambda$5(Sdk $sdk, Module $module) {
        Set<VirtualFile> transferredRoots = PyTransferredSdkRootsKt.getPathsToTransfer($sdk);
        Project project = $module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ModuleTransferredRoots newTransferredRoots = new TransferredRootsDetector(project).detect($module, transferredRoots, transferredRoots);
        PyTransferredSdkRootsKt.removeTransferredRoots($module, newTransferredRoots);
        return Unit.INSTANCE;
    }

    private static final Unit updateTransferredRoots$lambda$11(Map $oldTransferredRootsStructure, Module $module, ModuleTransferredRoots $newModuleRoots) {
        ModuleTransferredRoots oldModuleRoots = (ModuleTransferredRoots)$oldTransferredRootsStructure.get($module);
        if (oldModuleRoots != null) {
            PyTransferredSdkRootsKt.removeTransferredRoots($module, oldModuleRoots);
        }
        PyTransferredSdkRootsKt.addTransferredRoots($module, $newModuleRoots);
        return Unit.INSTANCE;
    }

    private static final Module[] updateRootsForModulesWithInheritedSdk$lambda$12(Project $project) {
        return ModuleManager.Companion.getInstance($project).getModules();
    }
}

