/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.ClientVersion;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.PerforceClient;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.FStat;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;

public class RevisionGraphAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(RevisionGraphAction.class);

    private static void addCommandParameters(@NonNls GeneralCommandLine cmd, PerforceClient client) throws VcsException {
        String port = client.getDeclaredServerPort();
        if (StringUtil.isEmptyOrSpaces((String)port)) {
            port = client.getServerPort();
        }
        String userName = client.getUserName();
        String clientName = client.getName();
        if (port == null || userName == null || clientName == null) {
            throw new VcsException(PerforceBundle.message("error.failed.to.retrieve.perforce.client.settings", port, userName, clientName));
        }
        cmd.addParameters(new String[]{"-p", port, "-u", userName, "-c", clientName});
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        boolean supportsP4vcParam;
        GeneralCommandLine cmd;
        if (e == null) {
            RevisionGraphAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        assert (project != null && virtualFile != null);
        if (!project.isDefault() && !TrustedProjects.isTrusted((Project)project)) {
            throw new IllegalStateException("Shouldn't be possible to run a P4 command in the safe mode");
        }
        P4Connection connection = PerforceConnectionManager.getInstance(project).getConnectionForFile(virtualFile);
        if (connection == null) {
            Messages.showInfoMessage((Project)project, (String)PerforceBundle.message("connection.cannot.determine.settings", new Object[0]), (String)PerforceBundle.message("connection.problem", new Object[0]));
            return;
        }
        PerforceManager manager = PerforceManager.getInstance(project);
        PerforceClient client = manager.getClient(connection);
        ClientVersion version = manager.getClientVersion();
        PerforceSettings settings = PerforceSettings.getSettings(project);
        FilePath p4vPath = VcsUtil.getFilePath((String)settings.PATH_TO_P4VC, (boolean)false);
        if (!SystemInfo.isWindows || !Registry.is((String)"p4.force.p4v.exe")) {
            cmd = new GeneralCommandLine(new String[]{settings.PATH_TO_P4VC});
        } else {
            String p4vExeName = "p4v.exe";
            FilePath parentPath = p4vPath.getParentPath();
            FilePath p4vExePath = p4vPath.getName().equals(p4vExeName) ? p4vPath : VcsUtil.getFilePath((String)(parentPath != null ? parentPath.getPath() + "/" + p4vExeName : p4vExeName), (boolean)false);
            cmd = new GeneralCommandLine(new String[]{FileUtil.toSystemDependentName((String)p4vExePath.getPath())});
        }
        boolean bl = supportsP4vcParam = version != null && version.supportsP4vcParam();
        if (supportsP4vcParam) {
            cmd.addParameters(new String[]{"-p4vc"});
        }
        try {
            RevisionGraphAction.addCommandParameters(cmd, client);
        }
        catch (VcsException e1) {
            Messages.showErrorDialog((Project)project, (String)e1.getMessage(), (String)PerforceBundle.message("perforce", new Object[0]));
            return;
        }
        cmd.addParameters(new String[]{this.getCommandName()});
        FStat fStat = null;
        if (settings.ENABLED) {
            P4File p4File = P4File.create(virtualFile);
            try {
                fStat = p4File.getFstat(project, false);
            }
            catch (VcsException ex) {
                Messages.showErrorDialog((Project)project, (String)PerforceBundle.message("failed.to.retrieve.p4.status.information", FileUtil.toSystemDependentName((String)virtualFile.getPath()), ex.getMessage()), (String)PerforceBundle.message("perforce", new Object[0]));
                return;
            }
        }
        if (fStat != null && !StringUtil.isEmpty((String)fStat.depotFile)) {
            cmd.addParameters(new String[]{fStat.depotFile});
        } else {
            cmd.addParameters(new String[]{FileUtil.toSystemDependentName((String)virtualFile.getPath())});
        }
        LOG.debug("Invoking p4v with command line " + cmd.getCommandLineString());
        try {
            new OSProcessHandler(cmd){
                private final StringBuilder output;
                {
                    super(arg0);
                    this.output = new StringBuilder();
                }

                public void notifyTextAvailable(@NotNull String text, @NotNull Key outputType) {
                    if (text == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    super.notifyTextAvailable(text, outputType);
                    this.output.append(text);
                }

                protected void onOSProcessTerminated(int exitCode) {
                    if (exitCode != 0) {
                        Notifications.Bus.notify((Notification)new Notification(PerforceVcs.getKey().getName(), PerforceBundle.message("p4vc.running.problems", new Object[0]), PerforceBundle.message("p4vc.running.problems.message", cmd, exitCode, !this.output.isEmpty() ? PerforceBundle.message("p4vc.running.problems.output", this.output) : ""), NotificationType.ERROR));
                    }
                    super.onOSProcessTerminated(exitCode);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "text";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/idea/perforce/actions/RevisionGraphAction$1";
                    objectArray[2] = "notifyTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }.startNotify();
        }
        catch (ExecutionException ex) {
            Messages.showErrorDialog((Project)project, (String)PerforceBundle.message("p4vc.run.failed", ex.getMessage()), (String)PerforceBundle.message("p4vc", new Object[0]));
        }
    }

    @NonNls
    protected String getCommandName() {
        return "revgraph";
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RevisionGraphAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RevisionGraphAction.$$$reportNull$$$0(2);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || virtualFile == null || !virtualFile.isInLocalFileSystem() || virtualFile.isDirectory() || !PerforceSettings.getSettings((Project)project).ENABLED || !(VcsUtil.getVcsFor((Project)project, (VirtualFile)virtualFile) instanceof PerforceVcs)) {
            e.getPresentation().setEnabled(false);
            return;
        }
        FileStatus fileStatus = FileStatusManager.getInstance((Project)project).getStatus(virtualFile);
        e.getPresentation().setEnabled(fileStatus != FileStatus.ADDED && fileStatus != FileStatus.UNKNOWN && fileStatus != FileStatus.IGNORED);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/actions/RevisionGraphAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/actions/RevisionGraphAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

