/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.thinclient.terminal;

import com.intellij.cwm.frontend.CodeWithMeFrontendBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.rd.platform.codeWithMe.permissions.PermissionsRequestLevel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.thinclient.ThinClientIdKt;
import com.jetbrains.thinclient.services.FrontendPermissionListener;
import com.jetbrains.thinclient.services.ThinClientPermissionHost;
import com.jetbrains.thinclient.services.ThinClientPermissionInteractionManager;
import com.jetbrains.thinclient.terminal.NoAccessTab;
import com.jetbrains.thinclient.terminal.ThinClientTerminalPermissionsListenerKt;
import com.jetbrains.thinclient.terminal.ThinClientTerminalRunnerKt;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;
import org.jetbrains.plugins.terminal.ui.TerminalContainer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\f"}, d2={"Lcom/jetbrains/thinclient/terminal/ThinClientTerminalPermissionsListener;", "Lcom/jetbrains/thinclient/services/FrontendPermissionListener;", "<init>", "()V", "permissionsChanged", "", "showTerminalDisabledNotification", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "widget", "Ljavax/swing/JPanel;", "MyDisabledNotification", "intellij.terminal.frontend.split"})
@SourceDebugExtension(value={"SMAP\nThinClientTerminalPermissionsListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThinClientTerminalPermissionsListener.kt\ncom/jetbrains/thinclient/terminal/ThinClientTerminalPermissionsListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n774#2:81\n865#2,2:82\n1863#2,2:84\n*S KotlinDebug\n*F\n+ 1 ThinClientTerminalPermissionsListener.kt\ncom/jetbrains/thinclient/terminal/ThinClientTerminalPermissionsListener\n*L\n47#1:81\n47#1:82,2\n53#1:84,2\n*E\n"})
public final class ThinClientTerminalPermissionsListener
implements FrontendPermissionListener {
    /*
     * WARNING - void declaration
     */
    public void permissionsChanged() {
        for (ClientProjectSession session : ThinClientIdKt.getFrontendAppSession().getProjectSessions()) {
            TerminalToolWindowManager manager = TerminalToolWindowManager.getInstance((Project)session.getProject());
            Intrinsics.checkNotNull((Object)manager);
            TerminalContainer noAccessTab = ThinClientTerminalRunnerKt.findNoAccessTab(manager);
            if (noAccessTab != null) {
                if (ThinClientPermissionHost.Companion.getInstance().hasFullAccessToTerminal()) {
                    TerminalContainer terminalContainer = ThinClientTerminalRunnerKt.findNoAccessTab(manager);
                    if (terminalContainer != null) {
                        terminalContainer.closeAndHide();
                    }
                } else {
                    JBTerminalWidget jBTerminalWidget = JBTerminalWidget.asJediTermWidget((TerminalWidget)noAccessTab.getTerminalWidget());
                    NoAccessTab noAccessTab2 = jBTerminalWidget instanceof NoAccessTab ? (NoAccessTab)jBTerminalWidget : null;
                    if (noAccessTab2 != null) {
                        NoAccessTab.updateEmptyText$intellij_terminal_frontend_split$default(noAccessTab2, false, 1, null);
                    }
                }
            }
            if (!ThinClientPermissionHost.Companion.getInstance().hasReadAccessToTerminal()) {
                void $this$filterTo$iv$iv;
                LifetimeDefinition lifetimeDefinition = ThinClientTerminalPermissionsListenerKt.access$getDisabledNotificationLt(session);
                if (lifetimeDefinition != null ? RLifetimeKt.isAlive((Lifetime)((Lifetime)lifetimeDefinition)) : false) continue;
                Set set = manager.getTerminalWidgets();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getTerminalWidgets(...)");
                Iterable $this$filter$iv = set;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    TerminalWidget it = (TerminalWidget)element$iv$iv;
                    boolean bl = false;
                    if (!(!(JBTerminalWidget.asJediTermWidget((TerminalWidget)it) instanceof NoAccessTab))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List widgets = (List)destination$iv$iv;
                if (widgets.isEmpty()) continue;
                LifetimeDefinition lt = UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)session)).createNested();
                Disposable disposable = LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)((Lifetime)lt), null, (int)1, null);
                LifetimeDefinition lifetimeDefinition2 = ThinClientTerminalPermissionsListenerKt.access$getDisabledNotificationLt(session);
                if (lifetimeDefinition2 != null) {
                    LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition2, (boolean)false, (int)1, null);
                }
                ThinClientTerminalPermissionsListenerKt.access$setDisabledNotificationLt(session, lt);
                Iterable $this$forEach$iv = widgets;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TerminalWidget it = (TerminalWidget)element$iv;
                    boolean bl = false;
                    BorderLayoutPanel terminalUpperPanel = new BorderLayoutPanel();
                    it.addNotification((JComponent)terminalUpperPanel, disposable);
                    this.showTerminalDisabledNotification((Lifetime)lt, (JPanel)terminalUpperPanel);
                }
                continue;
            }
            if (!ThinClientPermissionHost.Companion.getInstance().hasReadAccessToTerminal()) continue;
            LifetimeDefinition lifetimeDefinition = ThinClientTerminalPermissionsListenerKt.access$getDisabledNotificationLt(session);
            if (lifetimeDefinition == null) continue;
            LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
        }
    }

    private final void showTerminalDisabledNotification(Lifetime lifetime, JPanel widget2) {
        MyDisabledNotification panel = new MyDisabledNotification();
        panel.setText(CodeWithMeFrontendBundle.INSTANCE.message("terminal.message.access.denied.label", new Object[0]));
        panel.createActionLabel(CodeWithMeFrontendBundle.INSTANCE.message("presentation.permissions.full.access.tooltip", new Object[0]), ThinClientTerminalPermissionsListener::showTerminalDisabledNotification$lambda$2);
        widget2.add((Component)((Object)panel), "South");
        lifetime.onTermination(() -> ThinClientTerminalPermissionsListener.showTerminalDisabledNotification$lambda$3(widget2, panel));
    }

    private static final void showTerminalDisabledNotification$lambda$2() {
        ThinClientPermissionInteractionManager.Companion.askForPermissions(PermissionsRequestLevel.FULL_ACCESS, "ToolwindowContent");
    }

    private static final Unit showTerminalDisabledNotification$lambda$3(JPanel $widget, MyDisabledNotification $panel) {
        $widget.remove((Component)((Object)$panel));
        $widget.revalidate();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/jetbrains/thinclient/terminal/ThinClientTerminalPermissionsListener$MyDisabledNotification;", "Lcom/intellij/ui/EditorNotificationPanel;", "<init>", "()V", "intellij.terminal.frontend.split"})
    public static final class MyDisabledNotification
    extends EditorNotificationPanel {
        public MyDisabledNotification() {
            super(JBUI.CurrentTheme.Validator.warningBackgroundColor());
        }
    }
}

