/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.actions;

import com.intellij.icons.AllIcons;
import com.intellij.notebooks.ui.editor.actions.JupyterEditorAction;
import com.intellij.notebooks.visualization.context.NotebookDataContext;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.registry.Registry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0016J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/jupyter/core/core/impl/actions/ToggleReadOnlyAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/notebooks/ui/editor/actions/JupyterEditorAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isSelected", "", "e", "setSelected", "state", "intellij.jupyter.core"})
public final class ToggleReadOnlyAction
extends ToggleAction
implements JupyterEditorAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.update(event);
        event.getPresentation().setEnabledAndVisible(Registry.Companion.is("jupyter.editor.action.viewer.enable"));
        event.getPresentation().setIcon(this.isSelected(event) ? AllIcons.Ide.Readonly : AllIcons.Ide.Readwrite);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        EditorImpl editorImpl = NotebookDataContext.INSTANCE.getNotebookEditor(dataContext);
        return editorImpl != null ? editorImpl.isViewer() : false;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            DataContext dataContext = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            EditorImpl editorImpl = NotebookDataContext.INSTANCE.getNotebookEditor(dataContext);
            if (editorImpl == null) break block0;
            editorImpl.setViewer(state);
        }
    }
}

