/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.activity;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.activity.NextJsConfigStatsCollector;
import com.intellij.javascript.debugger.activity.NextJsPackageJsonUtilKt;
import com.intellij.javascript.debugger.activity.NextJsPropertiesComponentKt;
import com.intellij.javascript.debugger.activity.NextJsRunConfigKind;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmConfigurationType;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfiguration;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfigurationProducer;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\bR\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/javascript/debugger/activity/NextJsCreateServerRunConfigurationActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "npmConfigProducer", "Lcom/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationProducer;", "Lorg/jetbrains/annotations/NotNull;", "intellij.javascript.debugger"})
@SourceDebugExtension(value={"SMAP\nNextJsCreateServerRunConfigurationActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextJsCreateServerRunConfigurationActivity.kt\ncom/intellij/javascript/debugger/activity/NextJsCreateServerRunConfigurationActivity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1#2:65\n*E\n"})
public final class NextJsCreateServerRunConfigurationActivity
implements ProjectActivity {
    @NotNull
    private final NpmRunConfigurationProducer npmConfigProducer;

    public NextJsCreateServerRunConfigurationActivity() {
        RunConfigurationProducer runConfigurationProducer = RunConfigurationProducer.getInstance(NpmRunConfigurationProducer.class);
        Intrinsics.checkNotNullExpressionValue((Object)runConfigurationProducer, (String)"getInstance(...)");
        this.npmConfigProducer = (NpmRunConfigurationProducer)runConfigurationProducer;
    }

    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        if (NextJsPropertiesComponentKt.isNextJsRunConfigCreated(project, NextJsRunConfigKind.Server)) {
            return Unit.INSTANCE;
        }
        VirtualFile virtualFile = PackageJsonUtil.findChildPackageJsonFile((VirtualFile)ProjectUtil.guessProjectDir((Project)project));
        if (virtualFile == null) {
            return Unit.INSTANCE;
        }
        VirtualFile packageJsonFile = virtualFile;
        Object object = CoroutinesKt.readAction(() -> NextJsCreateServerRunConfigurationActivity.execute$lambda$2(project, packageJsonFile, this), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final Unit execute$lambda$2(Project $project, VirtualFile $packageJsonFile, NextJsCreateServerRunConfigurationActivity this$0) {
        ConfigurationFromContext newConfig;
        Object v4;
        String configName;
        JsonFile packageJson;
        block9: {
            if ($project.isDisposed()) {
                return Unit.INSTANCE;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)$project).findFile($packageJsonFile);
            JsonFile jsonFile = psiFile instanceof JsonFile ? (JsonFile)psiFile : null;
            if (jsonFile == null) {
                return Unit.INSTANCE;
            }
            packageJson = jsonFile;
            if (!NextJsPackageJsonUtilKt.hasNextJsDependency(packageJson)) {
                return Unit.INSTANCE;
            }
            String string = JSDebuggerBundle.message("runConfig.nextJs.server.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            configName = string;
            RunManager runManager = RunManager.Companion.getInstance($project);
            NpmConfigurationType npmConfigurationType = NpmConfigurationType.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)npmConfigurationType, (String)"getInstance(...)");
            Iterable iterable = runManager.getConfigurationSettingsList((ConfigurationType)npmConfigurationType);
            for (Object t : iterable) {
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)configName)) continue;
                v4 = t;
                break block9;
            }
            v4 = null;
        }
        if (v4 != null) {
            return Unit.INSTANCE;
        }
        JsonStringLiteral jsonStringLiteral = NextJsPackageJsonUtilKt.findDevScriptBodyPsi(packageJson);
        if (jsonStringLiteral == null) {
            return Unit.INSTANCE;
        }
        JsonStringLiteral devScriptBodyPsi = jsonStringLiteral;
        String string = devScriptBodyPsi.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        if (NextJsPackageJsonUtilKt.getNextJsDevPort(string) == null) {
            return Unit.INSTANCE;
        }
        DataContext dataContext = SimpleDataContext.getSimpleContext((DataKey)Location.DATA_KEY, (Object)PsiLocation.fromPsiElement((PsiElement)((PsiElement)devScriptBodyPsi)));
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getSimpleContext(...)");
        DataContext dataContext2 = dataContext;
        ConfigurationContext configurationContext = ConfigurationContext.getFromContext((DataContext)dataContext2, (String)"unknown");
        Intrinsics.checkNotNullExpressionValue((Object)configurationContext, (String)"getFromContext(...)");
        ConfigurationContext configContext = configurationContext;
        if (this$0.npmConfigProducer.findExistingConfiguration(configContext) != null) {
            return Unit.INSTANCE;
        }
        ConfigurationFromContext configurationFromContext = newConfig = this$0.npmConfigProducer.createConfigurationFromContext(configContext);
        RunConfiguration runConfiguration = configurationFromContext != null ? configurationFromContext.getConfiguration() : null;
        NpmRunConfiguration npmRunConfiguration = runConfiguration instanceof NpmRunConfiguration ? (NpmRunConfiguration)runConfiguration : null;
        if (npmRunConfiguration == null) {
            return Unit.INSTANCE;
        }
        NpmRunConfiguration npmRunConfig = npmRunConfiguration;
        npmRunConfig.setName(configName);
        npmRunConfig.setNameChangedByUser(true);
        RunManager it = RunManager.Companion.getInstance($project);
        boolean bl = false;
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = newConfig.getConfigurationSettings();
        Intrinsics.checkNotNullExpressionValue((Object)runnerAndConfigurationSettings, (String)"getConfigurationSettings(...)");
        it.addConfiguration(runnerAndConfigurationSettings);
        it.setSelectedConfiguration(newConfig.getConfigurationSettings());
        NextJsConfigStatsCollector.serverConfigCreated.log();
        NextJsPropertiesComponentKt.setNextJsRunConfigCreated($project, NextJsRunConfigKind.Server);
        return Unit.INSTANCE;
    }
}

