/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.execution;

import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.openapi.util.Comparing;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016R\u001b\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/intellij/javascript/debugger/execution/JSRemoteUrlMappingModel;", "Ljavax/swing/table/AbstractTableModel;", "columnNames", "", "", "<init>", "([Ljava/lang/String;)V", "getColumnNames", "()[Ljava/lang/String;", "[Ljava/lang/String;", "data", "", "Lcom/intellij/javascript/debugger/execution/RemoteUrlMappingBean;", "getData", "()Ljava/util/List;", "isCellEditable", "", "rowIndex", "", "columnIndex", "getRowCount", "getColumnName", "column", "getColumnCount", "getValueAt", "", "setValueAt", "", "aValue", "intellij.javascript.debugger"})
final class JSRemoteUrlMappingModel
extends AbstractTableModel {
    @NotNull
    private final String[] columnNames;
    @NotNull
    private final List<RemoteUrlMappingBean> data;

    public JSRemoteUrlMappingModel(String ... columnNames) {
        Intrinsics.checkNotNullParameter((Object)columnNames, (String)"columnNames");
        this.columnNames = columnNames;
        this.data = new ArrayList();
    }

    @NotNull
    public final String[] getColumnNames() {
        return this.columnNames;
    }

    @NotNull
    public final List<RemoteUrlMappingBean> getData() {
        return this.data;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    @NotNull
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    @NotNull
    public Object getValueAt(int rowIndex, int columnIndex) {
        String string = columnIndex == 0 ? this.data.get((int)rowIndex).localFilePath : this.data.get(rowIndex).getRemoteUrl();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Override
    public void setValueAt(@NotNull Object aValue, int rowIndex, int columnIndex) {
        Intrinsics.checkNotNullParameter((Object)aValue, (String)"aValue");
        RemoteUrlMappingBean pair = this.data.get(rowIndex);
        if (columnIndex == 1) {
            if (Comparing.equal((Object)aValue, (Object)pair.getRemoteUrl())) {
                return;
            }
            String t = (String)aValue;
            this.data.set(rowIndex, new RemoteUrlMappingBean(pair.localFilePath, t));
        } else {
            if (Comparing.equal((Object)aValue, (Object)pair.localFilePath)) {
                return;
            }
            this.data.set(rowIndex, new RemoteUrlMappingBean((String)aValue, pair.getRemoteUrl()));
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }
}

