/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler;

import com.intellij.python.profiler.CallTreeNode;
import com.intellij.python.profiler.PythonProfilerBundle;
import com.intellij.python.profiler.UtilsKt;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u00012\u00020\u0002:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004JD\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/python/profiler/CallTreeCellRenderer;", "Lcom/intellij/ui/SimpleColoredRenderer;", "Ljavax/swing/tree/TreeCellRenderer;", "<init>", "()V", "getTreeCellRendererComponent", "Ljava/awt/Component;", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "Companion", "intellij.python.profiler"})
public final class CallTreeCellRenderer
extends SimpleColoredRenderer
implements TreeCellRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Component getTreeCellRendererComponent(@Nullable JTree tree, @Nullable Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        block1: {
            this.clear();
            CallTreeNode callTreeNode = (CallTreeNode)TreeUtil.getUserObject(CallTreeNode.class, (Object)value2);
            if (callTreeNode == null) break block1;
            CallTreeNode node = callTreeNode;
            boolean bl = false;
            this.append(UtilsKt.formatPercent(node.getPercent()), CallTreeCellRenderer.Companion.createBlueTextAttributes());
            this.append("  ");
            String functionName = node.getName();
            Object[] objectArray = new Object[]{String.valueOf(node.getTime())};
            String string = PythonProfilerBundle.message("profiler.time.ms", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String formattedTime = string;
            Object[] objectArray2 = new Object[]{node.getFile(), node.getLine()};
            String string2 = PythonProfilerBundle.message("python.profiler.file.location", objectArray2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            String fileLocation = string2;
            this.append(functionName, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            this.append(" - ");
            this.append(formattedTime, CallTreeCellRenderer.Companion.createBlueTextAttributes());
            if (((CharSequence)fileLocation).length() > 0) {
                this.append(" - ");
                this.append(fileLocation, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
            }
        }
        return (Component)((Object)this);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u0006"}, d2={"Lcom/intellij/python/profiler/CallTreeCellRenderer$Companion;", "", "<init>", "()V", "createBlueTextAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "intellij.python.profiler"})
    public static final class Companion {
        private Companion() {
        }

        private final SimpleTextAttributes createBlueTextAttributes() {
            return new SimpleTextAttributes(0, (Color)JBColor.BLUE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

