/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.frontend.TerminalSessionController;
import com.intellij.terminal.session.TerminalBeepEvent;
import com.intellij.terminal.session.TerminalCommandFinishedEvent;
import com.intellij.terminal.session.TerminalCommandStartedEvent;
import com.intellij.terminal.session.TerminalContentUpdatedEvent;
import com.intellij.terminal.session.TerminalCursorPositionChangedEvent;
import com.intellij.terminal.session.TerminalInitialStateEvent;
import com.intellij.terminal.session.TerminalOutputEvent;
import com.intellij.terminal.session.TerminalPromptFinishedEvent;
import com.intellij.terminal.session.TerminalPromptStartedEvent;
import com.intellij.terminal.session.TerminalSession;
import com.intellij.terminal.session.TerminalSessionTerminatedEvent;
import com.intellij.terminal.session.TerminalState;
import com.intellij.terminal.session.TerminalStateChangedEvent;
import com.intellij.terminal.session.dto.StyleRangeDto;
import com.intellij.terminal.session.dto.StyleRangeDtoKt;
import com.intellij.terminal.session.dto.TerminalBlocksModelStateDto;
import com.intellij.terminal.session.dto.TerminalBlocksModelStateDtoKt;
import com.intellij.terminal.session.dto.TerminalOutputModelStateDto;
import com.intellij.terminal.session.dto.TerminalOutputModelStateDtoKt;
import com.intellij.terminal.session.dto.TerminalStateDto;
import com.intellij.terminal.session.dto.TerminalStateDtoKt;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.DisposableWrapperList;
import java.awt.Toolkit;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.reworked.TerminalBlocksModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalSessionModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalShellIntegrationEventsListener;
import org.jetbrains.plugins.terminal.fus.BatchLatencyReporter;
import org.jetbrains.plugins.terminal.fus.DurationAndTextLength;
import org.jetbrains.plugins.terminal.fus.FrontendOutputActivity;
import org.jetbrains.plugins.terminal.fus.ReworkedTerminalUsageCollector;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u001c\u0010!\u001a\u00020\u001e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0082@\u00a2\u0006\u0002\u0010%J\u0016\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020$H\u0082@\u00a2\u0006\u0002\u0010(J\"\u0010)\u001a\u00020\u001e2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001e0+H\u0082@\u00a2\u0006\u0002\u0010,J\u0018\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u00052\u0006\u0010'\u001a\u00020/H\u0003J\b\u00100\u001a\u00020\u0005H\u0002J\u001a\u00101\u001a\u00020\u001e2\n\u00102\u001a\u00060\u0013j\u0002`\u00142\u0006\u00103\u001a\u000204J\b\u00105\u001a\u00020\u001eH\u0002J\u0016\u00106\u001a\u00020\u001e2\u0006\u00103\u001a\u0002042\u0006\u00107\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\f\u0012\b\u0012\u00060\u0013j\u0002`\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/terminal/frontend/TerminalSessionController;", "", "sessionModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;", "outputModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;", "alternateBufferModel", "blocksModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalBlocksModel;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "fusActivity", "Lorg/jetbrains/plugins/terminal/fus/FrontendOutputActivity;", "<init>", "(Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalBlocksModel;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lkotlinx/coroutines/CoroutineScope;Lorg/jetbrains/plugins/terminal/fus/FrontendOutputActivity;)V", "terminationListeners", "Lcom/intellij/util/containers/DisposableWrapperList;", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "shellIntegrationEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalShellIntegrationEventsListener;", "edtContext", "Lkotlin/coroutines/CoroutineContext;", "documentUpdateLatencyReporter", "Lorg/jetbrains/plugins/terminal/fus/BatchLatencyReporter;", "Lorg/jetbrains/plugins/terminal/fus/DurationAndTextLength;", "handleEvents", "", "session", "Lcom/intellij/terminal/session/TerminalSession;", "doHandleEvents", "events", "", "Lcom/intellij/terminal/session/TerminalOutputEvent;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleEvent", "event", "(Lcom/intellij/terminal/session/TerminalOutputEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateOutputModel", "block", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateOutputModelContent", "model", "Lcom/intellij/terminal/session/TerminalContentUpdatedEvent;", "getCurrentOutputModel", "addTerminationCallback", "onTerminated", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "fireSessionTerminated", "addShellIntegrationListener", "listener", "intellij.terminal.frontend"})
@SourceDebugExtension(value={"SMAP\nTerminalSessionController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalSessionController.kt\ncom/intellij/terminal/frontend/TerminalSessionController\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 BatchLatencyReporter.kt\norg/jetbrains/plugins/terminal/fus/BatchLatencyReporterKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n25#2:177\n25#2:182\n1557#3:178\n1628#3,3:179\n1797#3,3:184\n1010#3,2:190\n1010#3,2:219\n101#4:183\n87#4:187\n89#4:189\n90#4,2:192\n50#4:194\n52#4,20:196\n87#4:216\n89#4:218\n90#4,2:221\n1#5:188\n1#5:195\n1#5:217\n*S KotlinDebug\n*F\n+ 1 TerminalSessionController.kt\ncom/intellij/terminal/frontend/TerminalSessionController\n*L\n70#1:177\n168#1:182\n147#1:178\n147#1:179,3\n45#1:184,3\n46#1:190,2\n48#1:219,2\n45#1:183\n46#1:187\n46#1:189\n46#1:192,2\n47#1:194\n47#1:196,20\n48#1:216\n48#1:218\n48#1:221,2\n46#1:188\n47#1:195\n48#1:217\n*E\n"})
public final class TerminalSessionController {
    @NotNull
    private final TerminalSessionModel sessionModel;
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final TerminalOutputModel alternateBufferModel;
    @NotNull
    private final TerminalBlocksModel blocksModel;
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final FrontendOutputActivity fusActivity;
    @NotNull
    private final DisposableWrapperList<Runnable> terminationListeners;
    @NotNull
    private final EventDispatcher<TerminalShellIntegrationEventsListener> shellIntegrationEventDispatcher;
    @NotNull
    private final CoroutineContext edtContext;
    @NotNull
    private final BatchLatencyReporter<DurationAndTextLength> documentUpdateLatencyReporter;

    public TerminalSessionController(@NotNull TerminalSessionModel sessionModel, @NotNull TerminalOutputModel outputModel, @NotNull TerminalOutputModel alternateBufferModel, @NotNull TerminalBlocksModel blocksModel, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull CoroutineScope coroutineScope, @NotNull FrontendOutputActivity fusActivity) {
        Intrinsics.checkNotNullParameter((Object)sessionModel, (String)"sessionModel");
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        Intrinsics.checkNotNullParameter((Object)alternateBufferModel, (String)"alternateBufferModel");
        Intrinsics.checkNotNullParameter((Object)blocksModel, (String)"blocksModel");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)fusActivity, (String)"fusActivity");
        this.sessionModel = sessionModel;
        this.outputModel = outputModel;
        this.alternateBufferModel = alternateBufferModel;
        this.blocksModel = blocksModel;
        this.settings = settings;
        this.coroutineScope = coroutineScope;
        this.fusActivity = fusActivity;
        this.terminationListeners = new DisposableWrapperList();
        EventDispatcher eventDispatcher2 = EventDispatcher.create(TerminalShellIntegrationEventsListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher2, (String)"create(...)");
        this.shellIntegrationEventDispatcher = eventDispatcher2;
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        this.edtContext = coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState));
        this.documentUpdateLatencyReporter = new BatchLatencyReporter(100, TerminalSessionController::documentUpdateLatencyReporter$lambda$3);
    }

    public final void handleEvents(@NotNull TerminalSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(session2, this, null){
            int label;
            final /* synthetic */ TerminalSession $session;
            final /* synthetic */ TerminalSessionController this$0;
            {
                this.$session = $session;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.$session.getOutputFlow((Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        outputFlow = (Flow)v0;
                        this.label = 2;
                        v1 = outputFlow.collect(new FlowCollector(this.this$0){
                            final /* synthetic */ TerminalSessionController this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            public final Object emit(List<? extends TerminalOutputEvent> events, Continuation<? super Unit> $completion) {
                                Object object = TerminalSessionController.access$doHandleEvents(this.this$0, events, $completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl22
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl22:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object doHandleEvents(List<? extends TerminalOutputEvent> var1_1, Continuation<? super Unit> $completion) {
        if (!($completion instanceof doHandleEvents.1)) ** GOTO lbl-1000
        var8_3 = $completion;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ TerminalSessionController this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TerminalSessionController.access$doHandleEvents(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var3_6 = events.iterator();
lbl13:
                // 4 sources

                while (var3_6.hasNext()) {
                    event = (TerminalOutputEvent)var3_6.next();
                    $continuation.L$0 = this;
                    $continuation.L$1 = var3_6;
                    $continuation.label = 1;
                    v0 = this.handleEvent(event, (Continuation<? super Unit>)$continuation);
                    if (v0 != var9_5) continue;
                    return var9_5;
                }
                break;
            }
            case 1: {
                var3_6 = (Iterator<E>)$continuation.L$1;
                this = (TerminalSessionController)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                    ** GOTO lbl13
                }
                catch (CancellationException e) {
                    throw e;
                }
                catch (Throwable t) {
                    $i$f$thisLogger = false;
                    v1 = Logger.getInstance(TerminalSessionController.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getInstance(...)");
                    v1.error(t);
                    ** GOTO lbl13
                }
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleEvent(TerminalOutputEvent var1_1, Continuation<? super Unit> $completion) {
        block23: {
            block29: {
                block28: {
                    block27: {
                        block26: {
                            block25: {
                                block24: {
                                    block22: {
                                        block21: {
                                            block20: {
                                                if (!($completion instanceof handleEvent.1)) ** GOTO lbl-1000
                                                var6_3 = $completion;
                                                if ((var6_3.label & -2147483648) != 0) {
                                                    var6_3.label -= -2147483648;
                                                } else lbl-1000:
                                                // 2 sources

                                                {
                                                    $continuation = new ContinuationImpl(this, $completion){
                                                        Object L$0;
                                                        Object L$1;
                                                        /* synthetic */ Object result;
                                                        final /* synthetic */ TerminalSessionController this$0;
                                                        int label;
                                                        {
                                                            this.this$0 = this$0;
                                                            super($completion);
                                                        }

                                                        @Nullable
                                                        public final Object invokeSuspend(@NotNull Object $result) {
                                                            this.result = $result;
                                                            this.label |= Integer.MIN_VALUE;
                                                            return TerminalSessionController.access$handleEvent(this.this$0, null, (Continuation)this);
                                                        }
                                                    };
                                                }
                                                $result = $continuation.result;
                                                var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch ($continuation.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        var3_6 = event;
                                                        if (!(var3_6 instanceof TerminalInitialStateEvent)) break;
                                                        this.sessionModel.updateTerminalState(TerminalStateDtoKt.toTerminalState((TerminalStateDto)((TerminalInitialStateEvent)event).getSessionState()));
                                                        $continuation.label = 1;
                                                        v0 = this.updateOutputModel((Function1<? super TerminalOutputModel, Unit>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, handleEvent$lambda$4(com.intellij.terminal.frontend.TerminalSessionController com.intellij.terminal.session.TerminalOutputEvent org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel ), (Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;)Lkotlin/Unit;)((TerminalSessionController)this, (TerminalOutputEvent)event), (Continuation<? super Unit>)$continuation);
                                                        if (v0 == var7_5) {
                                                            return var7_5;
                                                        }
                                                        ** GOTO lbl23
                                                    }
                                                    case 1: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        v0 = $result;
lbl23:
                                                        // 2 sources

                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                if (!(var3_6 instanceof TerminalContentUpdatedEvent)) break block20;
                                                this.fusActivity.eventReceived((TerminalContentUpdatedEvent)event);
                                                $continuation.label = 2;
                                                v1 = this.updateOutputModel((Function1<? super TerminalOutputModel, Unit>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, handleEvent$lambda$5(com.intellij.terminal.frontend.TerminalSessionController com.intellij.terminal.session.TerminalOutputEvent org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel ), (Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;)Lkotlin/Unit;)((TerminalSessionController)this, (TerminalOutputEvent)event), (Continuation<? super Unit>)$continuation);
                                                if (v1 == var7_5) {
                                                    return var7_5;
                                                }
                                                ** GOTO lbl34
                                                {
                                                    case 2: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        v1 = $result;
lbl34:
                                                        // 2 sources

                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                            }
                                            if (!(var3_6 instanceof TerminalCursorPositionChangedEvent)) break block21;
                                            $continuation.label = 3;
                                            v2 = this.updateOutputModel((Function1<? super TerminalOutputModel, Unit>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, handleEvent$lambda$6(com.intellij.terminal.session.TerminalOutputEvent org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel ), (Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;)Lkotlin/Unit;)((TerminalOutputEvent)event), (Continuation<? super Unit>)$continuation);
                                            if (v2 == var7_5) {
                                                return var7_5;
                                            }
                                            ** GOTO lbl45
                                            {
                                                case 3: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v2 = $result;
lbl45:
                                                    // 2 sources

                                                    return Unit.INSTANCE;
                                                }
                                            }
                                        }
                                        if (!(var3_6 instanceof TerminalStateChangedEvent)) break block22;
                                        state = TerminalStateDtoKt.toTerminalState((TerminalStateDto)((TerminalStateChangedEvent)event).getState());
                                        this.sessionModel.updateTerminalState(state);
                                        break block23;
                                    }
                                    if (!(var3_6 instanceof TerminalBeepEvent)) break block24;
                                    if (this.settings.audibleBell()) {
                                        Toolkit.getDefaultToolkit().beep();
                                    }
                                    break block23;
                                }
                                if (!Intrinsics.areEqual((Object)var3_6, (Object)TerminalSessionTerminatedEvent.INSTANCE)) break block25;
                                this.fireSessionTerminated();
                                break block23;
                            }
                            if (!Intrinsics.areEqual((Object)var3_6, (Object)TerminalPromptStartedEvent.INSTANCE)) break block26;
                            $continuation.L$0 = this;
                            $continuation.label = 4;
                            v3 = BuildersKt.withContext((CoroutineContext)this.edtContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                                int label;
                                final /* synthetic */ TerminalSessionController this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            TerminalSessionController.access$getBlocksModel$p(this.this$0).promptStarted(((Number)TerminalSessionController.access$getOutputModel$p(this.this$0).getCursorOffsetState().getValue()).intValue());
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)$continuation);
                            if (v3 == var7_5) {
                                return var7_5;
                            }
                            ** GOTO lbl72
                            {
                                case 4: {
                                    this = (TerminalSessionController)$continuation.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v3 = $result;
lbl72:
                                    // 2 sources

                                    ((TerminalShellIntegrationEventsListener)this.shellIntegrationEventDispatcher.getMulticaster()).promptStarted();
                                    break block23;
                                }
                            }
                        }
                        if (!Intrinsics.areEqual((Object)var3_6, (Object)TerminalPromptFinishedEvent.INSTANCE)) break block27;
                        $continuation.L$0 = this;
                        $continuation.label = 5;
                        v4 = BuildersKt.withContext((CoroutineContext)this.edtContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                            int label;
                            final /* synthetic */ TerminalSessionController this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        TerminalSessionController.access$getBlocksModel$p(this.this$0).promptFinished(((Number)TerminalSessionController.access$getOutputModel$p(this.this$0).getCursorOffsetState().getValue()).intValue());
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)$continuation);
                        if (v4 == var7_5) {
                            return var7_5;
                        }
                        ** GOTO lbl86
                        {
                            case 5: {
                                this = (TerminalSessionController)$continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v4 = $result;
lbl86:
                                // 2 sources

                                ((TerminalShellIntegrationEventsListener)this.shellIntegrationEventDispatcher.getMulticaster()).promptFinished();
                                break block23;
                            }
                        }
                    }
                    if (!(var3_6 instanceof TerminalCommandStartedEvent)) break block28;
                    $continuation.L$0 = this;
                    $continuation.L$1 = event;
                    $continuation.label = 6;
                    v5 = BuildersKt.withContext((CoroutineContext)this.edtContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                        int label;
                        final /* synthetic */ TerminalSessionController this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    TerminalSessionController.access$getBlocksModel$p(this.this$0).commandStarted(((Number)TerminalSessionController.access$getOutputModel$p(this.this$0).getCursorOffsetState().getValue()).intValue());
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v5 == var7_5) {
                        return var7_5;
                    }
                    ** GOTO lbl102
                    {
                        case 6: {
                            event = (TerminalOutputEvent)$continuation.L$1;
                            this = (TerminalSessionController)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v5 = $result;
lbl102:
                            // 2 sources

                            ((TerminalShellIntegrationEventsListener)this.shellIntegrationEventDispatcher.getMulticaster()).commandStarted(((TerminalCommandStartedEvent)event).getCommand());
                            break block23;
                        }
                    }
                }
                if (!(var3_6 instanceof TerminalCommandFinishedEvent)) break block29;
                $continuation.L$0 = this;
                $continuation.L$1 = event;
                $continuation.label = 7;
                v6 = BuildersKt.withContext((CoroutineContext)this.edtContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, event, null){
                    int label;
                    final /* synthetic */ TerminalSessionController this$0;
                    final /* synthetic */ TerminalOutputEvent $event;
                    {
                        this.this$0 = $receiver;
                        this.$event = $event;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                TerminalSessionController.access$getBlocksModel$p(this.this$0).commandFinished(((TerminalCommandFinishedEvent)this.$event).getExitCode());
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v6 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl118
                {
                    case 7: {
                        event = (TerminalOutputEvent)$continuation.L$1;
                        this = (TerminalSessionController)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v6 = $result;
lbl118:
                        // 2 sources

                        ((TerminalShellIntegrationEventsListener)this.shellIntegrationEventDispatcher.getMulticaster()).commandFinished(((TerminalCommandFinishedEvent)event).getCommand(), ((TerminalCommandFinishedEvent)event).getExitCode(), ((TerminalCommandFinishedEvent)event).getCurrentDirectory());
                        break block23;
                    }
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object updateOutputModel(Function1<? super TerminalOutputModel, Unit> block, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)this.edtContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(block, this, null){
            int label;
            final /* synthetic */ Function1<TerminalOutputModel, Unit> $block;
            final /* synthetic */ TerminalSessionController this$0;
            {
                this.$block = $block;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.$block.invoke((Object)TerminalSessionController.access$getCurrentOutputModel(this.this$0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    private final void updateOutputModelContent(TerminalOutputModel model, TerminalContentUpdatedEvent event) {
        void $this$mapTo$iv$iv;
        long startTime = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        Iterable $this$map$iv = event.getStyles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StyleRangeDto styleRangeDto = (StyleRangeDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StyleRangeDtoKt.toStyleRange((StyleRangeDto)it));
        }
        List styles = (List)destination$iv$iv;
        model.updateContent(event.getStartLineLogicalIndex(), event.getText(), styles);
        DurationAndTextLength latencyData = new DurationAndTextLength(TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)startTime), event.getText().length(), null);
        this.documentUpdateLatencyReporter.update(latencyData);
    }

    private final TerminalOutputModel getCurrentOutputModel() {
        return ((TerminalState)this.sessionModel.getTerminalState().getValue()).isAlternateScreenBuffer() ? this.alternateBufferModel : this.outputModel;
    }

    public final void addTerminationCallback(@NotNull Runnable onTerminated, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)onTerminated, (String)"onTerminated");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.terminationListeners.add((Object)onTerminated, parentDisposable);
    }

    private final void fireSessionTerminated() {
        Iterator iterator = this.terminationListeners.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Runnable listener2 = (Runnable)iterator2.next();
            try {
                listener2.run();
            }
            catch (Throwable t) {
                TerminalSessionController $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(TerminalSessionController.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Unhandled exception in termination listener", t);
            }
        }
    }

    public final void addShellIntegrationListener(@NotNull Disposable parentDisposable, @NotNull TerminalShellIntegrationEventsListener listener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.shellIntegrationEventDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit documentUpdateLatencyReporter$lambda$3(List samples) {
        List $this$thirdLargestOf$iv;
        void p0;
        List $this$percentileOf$iv;
        long l;
        long l2;
        void $this$fold$iv$iv;
        List $this$totalDurationOf$iv;
        Intrinsics.checkNotNullParameter((Object)samples, (String)"samples");
        List list = samples;
        ReworkedTerminalUsageCollector reworkedTerminalUsageCollector = ReworkedTerminalUsageCollector.INSTANCE;
        boolean $i$f$totalDurationOf = false;
        Iterable iterable = $this$totalDurationOf$iv;
        long initial$iv$iv = Duration.Companion.getZERO-UwyO8pc();
        boolean $i$f$fold22 = false;
        long accumulator$iv$iv = initial$iv$iv;
        Iterator iterator = $this$fold$iv$iv.iterator();
        while (iterator.hasNext()) {
            void p02;
            void value$iv;
            Object element$iv$iv;
            Object t = element$iv$iv = iterator.next();
            long acc$iv = accumulator$iv$iv;
            boolean bl = false;
            DurationAndTextLength durationAndTextLength = (DurationAndTextLength)value$iv;
            l2 = acc$iv;
            boolean bl2 = false;
            l = p02.getDuration-UwyO8pc();
            accumulator$iv$iv = Duration.plus-LRDsOJo((long)l2, (long)l);
        }
        l2 = accumulator$iv$iv;
        $this$totalDurationOf$iv = samples;
        int n$iv = 90;
        boolean $i$f$percentileOf = false;
        void $this$sortBy$iv$iv = $this$percentileOf$iv;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    DurationAndTextLength p0 = (DurationAndTextLength)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)Duration.box-impl((long)p0.getDuration-UwyO8pc());
                    p0 = (DurationAndTextLength)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)Duration.box-impl((long)p0.getDuration-UwyO8pc())));
                }
            });
        }
        int index$iv = RangesKt.coerceAtMost((int)($this$percentileOf$iv.size() * n$iv / 100), (int)($this$percentileOf$iv.size() - 1));
        DurationAndTextLength $i$f$fold22 = (DurationAndTextLength)$this$percentileOf$iv.get(index$iv);
        boolean bl = false;
        l = p0.getDuration-UwyO8pc();
        $this$percentileOf$iv = samples;
        boolean $i$f$thirdLargestOf = false;
        if (!(!((Collection)$this$thirdLargestOf$iv).isEmpty())) {
            boolean $i$a$-check-BatchLatencyReporterKt$thirdLargestOf$1$iv22 = false;
            String $i$a$-check-BatchLatencyReporterKt$thirdLargestOf$1$iv22 = "It is expected that array is not empty";
            throw new IllegalStateException($i$a$-check-BatchLatencyReporterKt$thirdLargestOf$1$iv22.toString());
        }
        DurationAndTextLength p03 = (DurationAndTextLength)$this$thirdLargestOf$iv.get(0);
        boolean bl3 = false;
        Object max$iv = (Comparable)Duration.box-impl((long)p03.getDuration-UwyO8pc());
        Comparable secondLargest$iv = max$iv;
        Comparable thirdLargest$iv = max$iv;
        for (Object value$iv : $this$thirdLargestOf$iv) {
            DurationAndTextLength p04 = (DurationAndTextLength)value$iv;
            $i$a$-thirdLargestOf-TerminalSessionController$documentUpdateLatencyReporter$1$3 = false;
            Comparable comparableValue$iv = (Comparable)Duration.box-impl((long)p04.getDuration-UwyO8pc());
            if (comparableValue$iv.compareTo(max$iv) > 0) {
                thirdLargest$iv = secondLargest$iv;
                secondLargest$iv = max$iv;
                max$iv = comparableValue$iv;
                continue;
            }
            if (comparableValue$iv.compareTo(secondLargest$iv) > 0) {
                thirdLargest$iv = secondLargest$iv;
                secondLargest$iv = comparableValue$iv;
                continue;
            }
            if (comparableValue$iv.compareTo(thirdLargest$iv) <= 0) continue;
            thirdLargest$iv = comparableValue$iv;
        }
        Comparable comparable = thirdLargest$iv;
        long l3 = ((Duration)comparable).unbox-impl();
        $this$thirdLargestOf$iv = samples;
        n$iv = 90;
        $i$f$percentileOf = false;
        List $this$sortBy$iv$iv2 = $this$percentileOf$iv;
        $i$f$sortBy = false;
        if ($this$sortBy$iv$iv2.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv$iv2, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    DurationAndTextLength p0 = (DurationAndTextLength)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(p0.getTextLength());
                    p0 = (DurationAndTextLength)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(p0.getTextLength()));
                }
            });
        }
        index$iv = RangesKt.coerceAtMost((int)($this$percentileOf$iv.size() * n$iv / 100), (int)($this$percentileOf$iv.size() - 1));
        max$iv = (DurationAndTextLength)$this$percentileOf$iv.get(index$iv);
        long l4 = l3;
        boolean bl4 = false;
        int n = p0.getTextLength();
        reworkedTerminalUsageCollector.logFrontendDocumentUpdateLatency-2d-g_3Q(l2, l, l4, n);
        return Unit.INSTANCE;
    }

    private static final Unit handleEvent$lambda$4(TerminalSessionController this$0, TerminalOutputEvent $event, TerminalOutputModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.outputModel.restoreFromState(TerminalOutputModelStateDtoKt.toState((TerminalOutputModelStateDto)((TerminalInitialStateEvent)$event).getOutputModelState()));
        this$0.alternateBufferModel.restoreFromState(TerminalOutputModelStateDtoKt.toState((TerminalOutputModelStateDto)((TerminalInitialStateEvent)$event).getAlternateBufferState()));
        this$0.blocksModel.restoreFromState(TerminalBlocksModelStateDtoKt.toState((TerminalBlocksModelStateDto)((TerminalInitialStateEvent)$event).getBlocksModelState()));
        return Unit.INSTANCE;
    }

    private static final Unit handleEvent$lambda$5(TerminalSessionController this$0, TerminalOutputEvent $event, TerminalOutputModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this$0.fusActivity.beforeModelUpdate();
        this$0.updateOutputModelContent(model, (TerminalContentUpdatedEvent)$event);
        this$0.fusActivity.afterModelUpdate();
        return Unit.INSTANCE;
    }

    private static final Unit handleEvent$lambda$6(TerminalOutputEvent $event, TerminalOutputModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        model.updateCursorPosition(((TerminalCursorPositionChangedEvent)$event).getLogicalLineIndex(), ((TerminalCursorPositionChangedEvent)$event).getColumnIndex());
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$doHandleEvents(TerminalSessionController $this, List events, Continuation $completion) {
        return $this.doHandleEvents(events, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$handleEvent(TerminalSessionController $this, TerminalOutputEvent event, Continuation $completion) {
        return $this.handleEvent(event, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ TerminalBlocksModel access$getBlocksModel$p(TerminalSessionController $this) {
        return $this.blocksModel;
    }

    public static final /* synthetic */ TerminalOutputModel access$getOutputModel$p(TerminalSessionController $this) {
        return $this.outputModel;
    }

    public static final /* synthetic */ Object access$updateOutputModel(TerminalSessionController $this, Function1 block, Continuation $completion) {
        return $this.updateOutputModel((Function1<? super TerminalOutputModel, Unit>)block, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ TerminalOutputModel access$getCurrentOutputModel(TerminalSessionController $this) {
        return $this.getCurrentOutputModel();
    }
}

