/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.prompt;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.TerminalCommandExecutor;
import org.jetbrains.plugins.terminal.block.completion.spec.impl.ShellDataGeneratorsExecutorImpl;
import org.jetbrains.plugins.terminal.block.completion.spec.impl.ShellRuntimeContextProviderImpl;
import org.jetbrains.plugins.terminal.block.history.CommandHistoryManager;
import org.jetbrains.plugins.terminal.block.prompt.ShellEditorBufferReportShellCommandListener;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptCustomEnterHandler;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptModel;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptModelImpl;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtilsKt;
import org.jetbrains.plugins.terminal.block.util.TerminalDataContextUtils;
import org.jetbrains.plugins.terminal.util.ShellType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 .2\u00020\u0001:\u0002-.B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0010J\b\u0010&\u001a\u00020$H\u0007J\u0014\u0010'\u001a\u00020$2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)H\u0007J\b\u0010*\u001a\u00020$H\u0007J\b\u0010+\u001a\u00020$H\u0007J\b\u0010,\u001a\u00020$H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R+\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b!\u0010\"\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006/"}, d2={"Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptController;", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "session", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "commandExecutor", "Lorg/jetbrains/plugins/terminal/block/TerminalCommandExecutor;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/ex/EditorEx;Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;Lorg/jetbrains/plugins/terminal/block/TerminalCommandExecutor;)V", "commandHistoryManager", "Lorg/jetbrains/plugins/terminal/block/history/CommandHistoryManager;", "listeners", "", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptController$PromptStateListener;", "model", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;", "getModel", "()Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;", "commandHistory", "", "", "getCommandHistory", "()Ljava/util/List;", "<set-?>", "", "promptIsVisible", "getPromptIsVisible", "()Z", "setPromptIsVisible", "(Z)V", "promptIsVisible$delegate", "Lkotlin/properties/ReadWriteProperty;", "addListener", "", "listener", "handleEnterPressed", "performPaste", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "showCommandHistory", "onCommandHistoryClosed", "showCommandSearch", "PromptStateListener", "Companion", "intellij.terminal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTerminalPromptController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalPromptController.kt\norg/jetbrains/plugins/terminal/block/prompt/TerminalPromptController\n+ 2 Delegates.kt\nkotlin/properties/Delegates\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n33#2,3:118\n1863#3,2:121\n1863#3,2:123\n1863#3,2:125\n*S KotlinDebug\n*F\n+ 1 TerminalPromptController.kt\norg/jetbrains/plugins/terminal/block/prompt/TerminalPromptController\n*L\n38#1:118,3\n93#1:121,2\n98#1:123,2\n103#1:125,2\n*E\n"})
public final class TerminalPromptController {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final TerminalCommandExecutor commandExecutor;
    @NotNull
    private final CommandHistoryManager commandHistoryManager;
    @NotNull
    private final List<PromptStateListener> listeners;
    @NotNull
    private final TerminalPromptModel model;
    @NotNull
    private final ReadWriteProperty promptIsVisible$delegate;
    @NotNull
    private static final DataKey<TerminalPromptController> KEY;

    public TerminalPromptController(@NotNull Project project, @NotNull EditorEx editor, @NotNull BlockTerminalSession session2, @NotNull TerminalCommandExecutor commandExecutor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)commandExecutor, (String)"commandExecutor");
        this.editor = editor;
        this.commandExecutor = commandExecutor;
        this.listeners = new CopyOnWriteArrayList();
        this.model = new TerminalPromptModelImpl(this.editor, session2);
        Delegates delegates = Delegates.INSTANCE;
        Boolean initialValue$iv = true;
        boolean $i$f$observable = false;
        this.promptIsVisible$delegate = (ReadWriteProperty)new ObservableProperty<Boolean>((Object)initialValue$iv, this){
            final /* synthetic */ TerminalPromptController this$0;
            {
                this.this$0 = terminalPromptController;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(KProperty property, Object oldValue, Object newValue) {
                void newValue2;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                boolean bl = (Boolean)newValue;
                boolean oldValue2 = (Boolean)oldValue;
                boolean bl2 = false;
                if (newValue2 != oldValue2) {
                    Iterable $this$forEach$iv = TerminalPromptController.access$getListeners$p(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        PromptStateListener it = (PromptStateListener)element$iv;
                        boolean bl3 = false;
                        it.promptVisibilityChanged((boolean)newValue2);
                    }
                }
            }
        };
        this.editor.putUserData(TerminalDataContextUtils.INSTANCE.getIS_PROMPT_EDITOR_KEY$intellij_terminal(), (Object)true);
        this.editor.putUserData(TerminalPromptModel.Companion.getKEY(), (Object)this.model);
        this.editor.putUserData(BlockTerminalSession.Companion.getKEY(), (Object)session2);
        this.editor.getVirtualFile().putUserData(TerminalPromptModel.Companion.getKEY(), (Object)this.model);
        this.editor.getVirtualFile().putUserData(ShellType.Companion.getKEY(), (Object)session2.getShellIntegration().getShellType());
        ShellRuntimeContextProviderImpl shellRuntimeContextProvider = new ShellRuntimeContextProviderImpl(project, session2);
        this.editor.putUserData(ShellRuntimeContextProviderImpl.Companion.getKEY(), (Object)shellRuntimeContextProvider);
        ShellDataGeneratorsExecutorImpl shellGeneratorsExecutor = new ShellDataGeneratorsExecutorImpl(session2);
        this.editor.putUserData(ShellDataGeneratorsExecutorImpl.Companion.getKEY(), (Object)shellGeneratorsExecutor);
        this.commandHistoryManager = new CommandHistoryManager(session2, this.model);
        Disposer.register((Disposable)session2, (Disposable)this.model);
        ShellEditorBufferReportShellCommandListener bufferReporting = new ShellEditorBufferReportShellCommandListener(session2, (Function1<? super String, Unit>)((Function1)arg_0 -> TerminalPromptController._init_$lambda$3(this, arg_0)));
        session2.addCommandListener(bufferReporting, session2);
    }

    @NotNull
    public final TerminalPromptModel getModel() {
        return this.model;
    }

    @NotNull
    public final List<String> getCommandHistory() {
        return this.commandHistoryManager.getHistory();
    }

    public final boolean getPromptIsVisible() {
        return (Boolean)this.promptIsVisible$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setPromptIsVisible(boolean bl) {
        this.promptIsVisible$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
    }

    public final void addListener(@NotNull PromptStateListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @RequiresEdt
    public final void handleEnterPressed() {
        List customHandlers = TerminalPromptCustomEnterHandler.Companion.getEP_NAME$intellij_terminal().getExtensionList();
        for (TerminalPromptCustomEnterHandler handler : customHandlers) {
            boolean consumed = handler.handleEnter(this.model);
            if (!consumed) continue;
            return;
        }
        this.commandExecutor.startCommandExecution(this.model.getCommandText());
    }

    @RequiresEdt
    public final void performPaste(@Nullable DataContext dataContext) {
        DataContext dataContext2 = dataContext;
        if (dataContext2 == null) {
            DataContext dataContext3 = this.editor.getDataContext();
            dataContext2 = dataContext3;
            Intrinsics.checkNotNullExpressionValue((Object)dataContext3, (String)"getDataContext(...)");
        }
        DataContext context = dataContext2;
        this.editor.getPasteProvider().performPaste(context);
    }

    public static /* synthetic */ void performPaste$default(TerminalPromptController terminalPromptController, DataContext dataContext, int n, Object object) {
        if ((n & 1) != 0) {
            dataContext = null;
        }
        terminalPromptController.performPaste(dataContext);
    }

    @RequiresEdt
    public final void showCommandHistory() {
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PromptStateListener it = (PromptStateListener)element$iv;
            boolean bl = false;
            it.commandHistoryStateChanged(true);
        }
    }

    @RequiresEdt
    public final void onCommandHistoryClosed() {
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PromptStateListener it = (PromptStateListener)element$iv;
            boolean bl = false;
            it.commandHistoryStateChanged(false);
        }
    }

    @RequiresEdt
    public final void showCommandSearch() {
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PromptStateListener it = (PromptStateListener)element$iv;
            boolean bl = false;
            it.commandSearchRequested();
        }
    }

    private static final void lambda$3$lambda$2(TerminalPromptController this$0, String $buffer) {
        this$0.model.setCommandText($buffer);
        this$0.editor.getCaretModel().moveToOffset(this$0.editor.getDocument().getTextLength());
    }

    private static final Unit _init_$lambda$3(TerminalPromptController this$0, String buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (!StringsKt.isBlank((CharSequence)buffer)) {
            TerminalUiUtilsKt.invokeLater$default(null, null, () -> TerminalPromptController.lambda$3$lambda$2(this$0, buffer), 3, null);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ List access$getListeners$p(TerminalPromptController $this) {
        return $this.listeners;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(TerminalPromptController.class, "promptIsVisible", "getPromptIsVisible()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        KEY = DataKey.Companion.create("TerminalPromptController");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptController$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptController;", "getKEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<TerminalPromptController> getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0005H\u0017\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptController$PromptStateListener;", "", "commandHistoryStateChanged", "", "showing", "", "commandSearchRequested", "promptVisibilityChanged", "visible", "intellij.terminal"})
    public static interface PromptStateListener {
        default public void commandHistoryStateChanged(boolean showing) {
        }

        default public void commandSearchRequested() {
        }

        @RequiresEdt
        default public void promptVisibilityChanged(boolean visible) {
        }
    }
}

