/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.find.ngrams.TrigramIndex;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexingFlag;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.dependencies.FileIndexingStamp;
import com.intellij.util.indexing.dependencies.ProjectIndexingDependenciesService;
import com.intellij.util.indexing.dependencies.ScanningRequestToken;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.kind.SdkOrigin;
import com.jetbrains.performancePlugin.commands.CollectFilesNotMarkedAsIndex;
import com.jetbrains.performancePlugin.commands.PerformanceCommandCoroutineAdapter;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0094@\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u0003H\u0014J\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017H\u0002J\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\u0005H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/performancePlugin/commands/CollectFilesNotMarkedAsIndex;", "Lcom/jetbrains/performancePlugin/commands/PerformanceCommandCoroutineAdapter;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "doExecute", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "(Lcom/intellij/openapi/ui/playback/PlaybackContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getName", "collectFilesNotMarkedAsIndexed", "project", "Lcom/intellij/openapi/project/Project;", "fullLogPath", "Ljava/nio/file/Path;", "dumpIdsWithPaths", "ids", "", "consumer", "Ljava/util/function/Consumer;", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nCollectFilesNotMarkedAsIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollectFilesNotMarkedAsIndex.kt\ncom/jetbrains/performancePlugin/commands/CollectFilesNotMarkedAsIndex\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,188:1\n31#2,2:189\n774#3:191\n865#3,2:192\n774#3:194\n865#3,2:195\n13402#4,2:197\n*S KotlinDebug\n*F\n+ 1 CollectFilesNotMarkedAsIndex.kt\ncom/jetbrains/performancePlugin/commands/CollectFilesNotMarkedAsIndex\n*L\n65#1:189,2\n133#1:191\n133#1:192,2\n137#1:194\n137#1:195,2\n59#1:197,2\n*E\n"})
public final class CollectFilesNotMarkedAsIndex
extends PerformanceCommandCoroutineAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "collectFilesNotMarkedAsIndex";
    @NotNull
    public static final String PREFIX = "%collectFilesNotMarkedAsIndex";

    public CollectFilesNotMarkedAsIndex(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    @Override
    @Nullable
    protected Object doExecute(@NotNull PlaybackContext context, @NotNull Continuation<? super Unit> $completion) {
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String string = System.getProperty("integration.tests.indexing.full.problem.file");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        Path path = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        String message = this.collectFilesNotMarkedAsIndexed(project, path);
        String string2 = System.getProperty("integration.tests.indexing.problem.file");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
        Path path2 = Paths.get(string2, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        PathsKt.writeText$default((Path)path2, (CharSequence)message, null, (OpenOption[])new OpenOption[0], (int)2, null);
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    protected String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String collectFilesNotMarkedAsIndexed(Project project, Path fullLogPath) {
        StringBuilder sb = new StringBuilder();
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        Intrinsics.checkNotNull((Object)fileBasedIndex, (String)"null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
        FileBasedIndexImpl fbi = (FileBasedIndexImpl)fileBasedIndex;
        ReadAction.run(() -> CollectFilesNotMarkedAsIndex.collectFilesNotMarkedAsIndexed$lambda$1(fbi, project));
        Closeable closeable = Files.newBufferedWriter(fullLogPath, new OpenOption[0]);
        Throwable throwable = null;
        try {
            IndexableFilesIterator p;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            BufferedWriter writer = (BufferedWriter)closeable;
            boolean bl = false;
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ProjectIndexingDependenciesService> serviceClass$iv = ProjectIndexingDependenciesService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ScanningRequestToken indexingRequest = ((ProjectIndexingDependenciesService)object).getReadOnlyTokenForTest();
            ContentIterator iterator2 = new ContentIterator(sb, writer, indexingRequest, fbi){
                private int number;
                final /* synthetic */ StringBuilder $sb;
                final /* synthetic */ BufferedWriter $writer;
                final /* synthetic */ ScanningRequestToken $indexingRequest;
                final /* synthetic */ FileBasedIndexImpl $fbi;
                {
                    this.$sb = $sb;
                    this.$writer = $writer;
                    this.$indexingRequest = $indexingRequest;
                    this.$fbi = $fbi;
                }

                public final int getNumber() {
                    return this.number;
                }

                public final void setNumber(int n) {
                    this.number = n;
                }

                private final void logIndexingIssue(String text) {
                    if (this.number < 100) {
                        this.$sb.append(text);
                        int n = this.number;
                        this.number = n + 1;
                    }
                    this.$writer.write(text);
                }

                public boolean processFile(VirtualFile fileOrDir) {
                    Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
                    if (!fileOrDir.isValid()) {
                        return true;
                    }
                    if (!(fileOrDir instanceof VirtualFileSystemEntry)) {
                        this.logIndexingIssue(fileOrDir + " (" + fileOrDir.getClass() + ") is not a VirtualFileSystemEntry\n");
                        return true;
                    }
                    this.checkIndexed((VirtualFileSystemEntry)fileOrDir, false, "has no indexing timestamp", arg_0 -> collectFilesNotMarkedAsIndexed.2.iterator.1.processFile$lambda$0(this.$indexingRequest, fileOrDir, arg_0));
                    return true;
                }

                private final void checkIndexed(VirtualFileSystemEntry fileOrDir, boolean checkDirectories, String errorMessagePart, Predicate<VirtualFileSystemEntry> isIndexed) {
                    if (!checkDirectories && fileOrDir.isDirectory()) {
                        return;
                    }
                    if (!isIndexed.test(fileOrDir)) {
                        if (fileOrDir.isDirectory()) {
                            this.logIndexingIssue("Directory " + fileOrDir + " " + errorMessagePart + "\n");
                            return;
                        }
                        if (this.$fbi.isTooLarge((VirtualFile)fileOrDir)) {
                            return;
                        }
                        try {
                            fileOrDir.contentsToByteArray();
                            if (this.$fbi.getFilesToUpdateCollector().containsFileId(fileOrDir.getId())) {
                                this.logIndexingIssue(fileOrDir + " (id=" + fileOrDir.getId() + ") " + errorMessagePart + " because is changed\n");
                            } else {
                                this.logIndexingIssue(fileOrDir + " (id=" + fileOrDir.getId() + ") " + errorMessagePart + "\n");
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }

                private static final boolean processFile$lambda$0(ScanningRequestToken $indexingRequest, VirtualFile $fileOrDir, VirtualFileSystemEntry it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    boolean indexedFlagSetOrDisabled = IndexingFlag.isIndexedFlagDisabled() || IndexingFlag.isFileIndexed((VirtualFile)((VirtualFile)it), (FileIndexingStamp)$indexingRequest.getFileIndexingStamp($fileOrDir));
                    boolean hasIndexingStamp = IndexingStamp.hasIndexingTimeStamp((int)it.getId());
                    return hasIndexingStamp || ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)((VirtualFile)it), (FileType)it.getFileType());
                }
            };
            List list = fbi.getIndexableFilesProviders(project);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getIndexableFilesProviders(...)");
            List originalOrderedProviders = list;
            List orderedProviders = new ArrayList();
            Iterable iterable = originalOrderedProviders;
            boolean $i$f$filter = false;
            void var15_20 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                p = (IndexableFilesIterator)element$iv$iv;
                boolean bl2 = false;
                if (!(!(p.getOrigin() instanceof SdkOrigin))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            CollectionsKt.toCollection((Iterable)((List)destination$iv$iv), (Collection)orderedProviders);
            $this$filter$iv = originalOrderedProviders;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                p = (IndexableFilesIterator)element$iv$iv;
                boolean bl3 = false;
                if (!(p.getOrigin() instanceof SdkOrigin)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            CollectionsKt.toCollection((Iterable)((List)destination$iv$iv), (Collection)orderedProviders);
            for (IndexableFilesIterator provider : orderedProviders) {
                provider.iterateFiles(project, iterator2, VirtualFileFilter.ALL);
            }
            Consumer<String> textConsumer = arg_0 -> CollectFilesNotMarkedAsIndex.collectFilesNotMarkedAsIndexed$lambda$5$lambda$4(sb, writer, arg_0);
            int[] lockedFiles = IndexingFlag.dumpLockedFiles();
            if (!(lockedFiles.length == 0)) {
                String string = Arrays.toString(lockedFiles);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                textConsumer.accept("Locked files' ids in IndexingFlag: " + string + "\n");
                this.dumpIdsWithPaths(lockedFiles, textConsumer);
            }
            try {
                int[] nArray = IndexingStamp.dumpCachedUnfinishedFiles();
                Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"dumpCachedUnfinishedFiles(...)");
                int[] cachedUnfinishedFiles = nArray;
                if (!(cachedUnfinishedFiles.length == 0)) {
                    String string = Arrays.toString(cachedUnfinishedFiles);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    textConsumer.accept("Unfinished cached files' ids in IndexingStamp: " + string + "\n");
                    this.dumpIdsWithPaths(cachedUnfinishedFiles, textConsumer);
                    textConsumer.accept("All changed unindexed files: " + fbi.getAllFilesToUpdate());
                }
            }
            catch (RuntimeException e) {
                textConsumer.accept("Exception while checking IndexingStamp cache:\n");
                textConsumer.accept(ExceptionUtil.getThrowableText((Throwable)e));
                textConsumer.accept("\n");
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void dumpIdsWithPaths(int[] ids, Consumer<String> consumer) {
        for (int fileId : ids) {
            consumer.accept(String.valueOf(fileId));
            if (this.findFile(fileId) != null) {
                VirtualFile virtualFile;
                VirtualFile it = virtualFile;
                boolean bl = false;
                consumer.accept(" ");
                consumer.accept(it.getPath());
            }
            consumer.accept("\n");
        }
    }

    private final VirtualFile findFile(int $this$findFile) {
        return ManagingFS.getInstance().findFileById($this$findFile);
    }

    /*
     * WARNING - void declaration
     */
    private static final void collectFilesNotMarkedAsIndexed$lambda$1(FileBasedIndexImpl $fbi, Project $project) {
        void $this$forEach$iv;
        ID[] iDArray = new ID[]{StubUpdatingIndex.INDEX_ID, TrigramIndex.INDEX_ID, IdIndex.NAME};
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv;
            void it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            $fbi.ensureUpToDate((ID)it, $project, GlobalSearchScope.allScope((Project)$project));
        }
    }

    private static final void collectFilesNotMarkedAsIndexed$lambda$5$lambda$4(StringBuilder $sb, BufferedWriter $writer, String text) {
        $sb.append(text);
        $writer.write(text);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/performancePlugin/commands/CollectFilesNotMarkedAsIndex$Companion;", "", "<init>", "()V", "NAME", "", "Lorg/jetbrains/annotations/NonNls;", "PREFIX", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

