/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.junit.internal.MethodSorter;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMember;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;

public class MixinAwareJUnitRunner
extends BlockJUnit4ClassRunner {
    public MixinAwareJUnitRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    protected TestClass createTestClass(Class<?> testClass) {
        return new MixinAwareTestClass(testClass);
    }

    static class MixinAwareTestClass
    extends TestClass {
        MixinAwareTestClass(Class<?> clazz) {
            super(clazz);
        }

        protected void scanAnnotatedMembers(Map<Class<? extends Annotation>, List<FrameworkMethod>> methodsForAnnotations, Map<Class<? extends Annotation>, List<FrameworkField>> fieldsForAnnotations) {
            super.scanAnnotatedMembers(methodsForAnnotations, fieldsForAnnotations);
            MixinAwareTestClass.scanAnnotatedMethodsInInterfaces(this.getJavaClass(), methodsForAnnotations);
        }

        private static void scanAnnotatedMethodsInInterfaces(Class<?> clazz, Map<Class<? extends Annotation>, List<FrameworkMethod>> methodsForAnnotations) {
            for (Class<?> superInterface : clazz.getInterfaces()) {
                for (Method eachMethod : MethodSorter.getDeclaredMethods(superInterface)) {
                    MixinAwareTestClass.addToAnnotationLists((FrameworkMember)new FrameworkMethod(eachMethod), methodsForAnnotations);
                }
                MixinAwareTestClass.scanAnnotatedMethodsInInterfaces(superInterface, methodsForAnnotations);
            }
            Class<?> superClass = clazz.getSuperclass();
            if (superClass != null) {
                MixinAwareTestClass.scanAnnotatedMethodsInInterfaces(superClass, methodsForAnnotations);
            }
        }
    }
}

