/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generate;

import com.intellij.indexing.shared.generate.CanonicalSorters;
import com.intellij.indexing.shared.platform.api.SharedIndexInfrastructureVersion;
import com.intellij.indexing.shared.platform.impl.SharedIndexExtension;
import com.intellij.indexing.shared.platform.impl.layout.FileBasedSharedIndexLocation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.indexing.CustomInputsIndexFileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.InputIndexDataExternalizer;
import com.intellij.util.indexing.impl.InvertedIndexValueIterator;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.indexing.impl.MapInputDataDiffBuilder;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.indexing.impl.UpdatableValueContainer;
import com.intellij.util.indexing.impl.UpdateData;
import com.intellij.util.indexing.impl.UpdatedEntryProcessor;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.MapForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.PersistentMapBasedForwardIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentMap;
import com.intellij.util.io.PersistentMapBase;
import com.intellij.util.io.PersistentMapImpl;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.stream.Stream;
import kotlin.Triple;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class HashBasedIndexGenerator<K, V> {
    private static final Logger LOG = Logger.getInstance(HashBasedIndexGenerator.class);
    @NotNull
    private final SharedIndexExtension<K, V> mySharedExtension;
    @NotNull
    private final FileBasedIndex.InputFilter myInputFilter;
    @NotNull
    private final FileBasedSharedIndexLocation<K, V> indexLocation;
    private final AtomicInteger myIndexedFilesNumber;
    private final AtomicBoolean myIsEmpty;
    private final AtomicBoolean myCollisionReported;
    private InvertedIndex<K, V, FileContent> myIndex;
    @NotNull
    private final ID<K, V> myIndexId;
    private final boolean myShouldCanonicalize;

    public HashBasedIndexGenerator(@NotNull FileBasedIndexExtension<K, V> originalExtension, @NotNull FileBasedSharedIndexLocation<K, V> indexLocation, boolean canonicalize) {
        if (originalExtension == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(0);
        }
        if (indexLocation == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(1);
        }
        this.myIndexedFilesNumber = new AtomicInteger();
        this.myIsEmpty = new AtomicBoolean(true);
        this.myCollisionReported = new AtomicBoolean();
        this.myIndexId = originalExtension.getName();
        this.myShouldCanonicalize = canonicalize;
        this.indexLocation = indexLocation;
        SharedIndexInfrastructureVersion ideVersion = SharedIndexInfrastructureVersion.getIdeVersion();
        this.mySharedExtension = SharedIndexExtension.findExtensionAndOpen(originalExtension, indexLocation, false, ideVersion);
        FileBasedIndex.InputFilter filter = originalExtension.getInputFilter();
        if (filter instanceof FileBasedIndex.FileTypeSpecificInputFilter) {
            HashSet fileTypes = new HashSet();
            ((FileBasedIndex.FileTypeSpecificInputFilter)filter).registerFileTypesUsedForIndexing(fileTypes::add);
            this.myInputFilter = FileBasedIndexEx.composeInputFilter((FileBasedIndex.InputFilter)filter, (file, project) -> fileTypes.contains(file.getFileType()));
        } else {
            this.myInputFilter = filter;
        }
    }

    public void openIndex() throws IOException {
        FileBasedIndexExtension<K, V> extension = this.mySharedExtension.getFileBasedIndexExtension();
        MapIndexStorage indexStorage = new MapIndexStorage<K, V>(this.indexLocation.getStorageFileName$intellij_indexing_shared(this.mySharedExtension), extension.getKeyDescriptor(), extension.getValueExternalizer(), extension.getCacheSize(), extension.keyIsUniqueForIndexedFile()){

            public void addValue(K k, int inputId, V v) throws StorageException {
                super.addValue(k, inputId, v);
                HashBasedIndexGenerator.this.myIsEmpty.set(false);
            }

            public void removeAllValues(@NotNull K k, int inputId) {
                if (k == null) {
                    1.$$$reportNull$$$0(0);
                }
                HashBasedIndexGenerator.this.reportHashCollision(inputId);
            }

            protected boolean compactOnClose() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k", "com/intellij/indexing/shared/generate/HashBasedIndexGenerator$1", "removeAllValues"));
            }
        };
        final boolean isSingleEntryIndex = extension instanceof SingleEntryFileBasedIndexExtension;
        ForwardIndex forwardIndex = this.indexLocation.createForwardIndex(this.mySharedExtension, false);
        MapForwardIndexAccessor<K, V> forwardIndexAccessor = HashBasedIndexGenerator.createForwardIndexAccessor(this.mySharedExtension, this::reportHashCollision);
        this.myIndex = new MapReduceIndex<K, V, FileContent>((IndexExtension)extension, (IndexStorage)indexStorage, forwardIndex, (ForwardIndexAccessor)forwardIndexAccessor){

            @NotNull
            protected Map<K, V> mapByIndexer(int inputId, @NotNull FileContent content) {
                if (content == null) {
                    2.$$$reportNull$$$0(0);
                }
                Map data = super.mapByIndexer(inputId, (Object)content);
                if (isSingleEntryIndex && !data.isEmpty()) {
                    data = Collections.singletonMap(inputId, data.values().iterator().next());
                }
                Map map = HashBasedIndexGenerator.this.transformIndexedData(data, content);
                if (map == null) {
                    2.$$$reportNull$$$0(1);
                }
                return map;
            }

            protected void updateForwardIndex(int inputId, @NotNull InputData<K, V> data) throws IOException {
                if (data == null) {
                    2.$$$reportNull$$$0(2);
                }
                super.updateForwardIndex(inputId, data);
                try {
                    HashBasedIndexGenerator.this.visitInputData(inputId, data);
                }
                catch (StorageException e) {
                    throw new IOException(e);
                }
            }

            public void updateWith(@NotNull UpdateData<K, V> updateData) throws StorageException {
                if (updateData == null) {
                    2.$$$reportNull$$$0(3);
                }
                super.updateWith(updateData);
                HashBasedIndexGenerator.this.myIndexedFilesNumber.incrementAndGet();
            }

            public void checkCanceled() {
            }

            protected void requestRebuild(@NotNull Throwable e) {
                if (e == null) {
                    2.$$$reportNull$$$0(4);
                }
                throw new RuntimeException("Error while processing " + String.valueOf(this.getExtension().getName()), e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "content";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/indexing/shared/generate/HashBasedIndexGenerator$2";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "data";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "updateData";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/indexing/shared/generate/HashBasedIndexGenerator$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "mapByIndexer";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "mapByIndexer";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "updateForwardIndex";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "updateWith";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "requestRebuild";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    private void reportHashCollision(int hashId) {
        if (this.myCollisionReported.compareAndSet(false, true)) {
            LOG.error("Index \"" + String.valueOf(this.mySharedExtension.getFileBasedIndexExtension().getName()) + "\" contains data collision for hashId = " + hashId, (Throwable)null);
        }
    }

    @NotNull
    public static <K, V> MapForwardIndexAccessor<K, V> createForwardIndexAccessor(@NotNull SharedIndexExtension<K, V> extension, final @NotNull IntConsumer collisionReporter) {
        if (extension == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(2);
        }
        if (collisionReporter == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(3);
        }
        InputMapExternalizerToStableBinary inputMapExternalizer = new InputMapExternalizerToStableBinary(extension.getFileBasedIndexExtension());
        return new MapForwardIndexAccessor<K, V>(inputMapExternalizer){

            @NotNull
            public InputDataDiffBuilder<K, V> createDiffBuilderByMap(int inputId, @Nullable Map<K, V> map) {
                return new MapInputDataDiffBuilder<K, V>(inputId, map){

                    public boolean differentiate(@NotNull Map<K, V> newData, @NotNull UpdatedEntryProcessor<? super K, ? super V> changesProcessor) throws StorageException {
                        if (newData == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (changesProcessor == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return super.differentiate(newData, (kind, k, v, inputId) -> {
                            switch (kind) {
                                case REMOVED: 
                                case UPDATED: {
                                    collisionReporter.accept(this.myInputId);
                                }
                            }
                            changesProcessor.process(kind, k, v, inputId);
                        });
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "newData";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "changesProcessor";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/indexing/shared/generate/HashBasedIndexGenerator$3$1";
                        objectArray[2] = "differentiate";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }
        };
    }

    public static boolean shouldCreateForwardIndex(@NotNull SharedIndexExtension<?, ?> sharedExtension) {
        FileBasedIndexExtension<?, ?> extension;
        if (sharedExtension == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(4);
        }
        boolean needsForwardIndex = (extension = sharedExtension.getFileBasedIndexExtension()).needsForwardIndexWhenSharing() || Boolean.getBoolean("shared.indexes.always.use.forward.index");
        return needsForwardIndex && !(extension instanceof SingleEntryFileBasedIndexExtension);
    }

    @NotNull
    private static Path getForwardIndexPath(@NotNull Path storageFile) {
        if (storageFile == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(5);
        }
        Path path = FileBasedSharedIndexLocation.getForwardIndexPath(storageFile);
        if (path == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(6);
        }
        return path;
    }

    protected void visitInputData(int hashId, @NotNull InputData<K, V> data) throws StorageException {
        if (data == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(7);
        }
    }

    @NotNull
    protected Map<K, V> transformIndexedData(@NotNull Map<K, V> data, @NotNull FileContent content) {
        if (data == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(8);
        }
        if (content == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(9);
        }
        Map<K, V> map = data;
        if (map == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(10);
        }
        return map;
    }

    public void closeIndex() throws IOException {
        boolean shouldCreateForwardIndex = HashBasedIndexGenerator.shouldCreateForwardIndex(this.mySharedExtension);
        try {
            this.myIndex.flush();
        }
        catch (StorageException e) {
            throw new IOException(e);
        }
        if (this.myIndex != null) {
            if (this.myShouldCanonicalize) {
                PersistentMapImpl<K, UpdatableValueContainer<V>> invertedIndexMap = this.extractInvertedIndexPersistentMap(this.myIndex);
                HashBasedIndexGenerator.canonicalizePersistentMap(invertedIndexMap);
                if (shouldCreateForwardIndex) {
                    PersistentMapImpl<Integer, ByteArraySequence> forwardIndexMap = this.extractForwardIndexPersistentMap(this.myIndex);
                    HashBasedIndexGenerator.canonicalizePersistentMap(forwardIndexMap);
                }
            }
            this.myIndex.dispose();
        }
        this.mySharedExtension.closeResources();
        if (!shouldCreateForwardIndex) {
            IOUtil.deleteAllFilesStartingWith((Path)HashBasedIndexGenerator.getForwardIndexPath(this.indexLocation.getStorageFileName$intellij_indexing_shared(this.mySharedExtension)));
        }
    }

    public void indexFile(int hashId, @NotNull FileContent fileContent) {
        if (fileContent == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(11);
        }
        if (!FileBasedIndexEx.acceptsInput((FileBasedIndex.InputFilter)this.myInputFilter, (IndexedFile)fileContent)) {
            return;
        }
        if (!this.myIndex.mapInputAndPrepareUpdate(hashId, (Object)fileContent).update()) {
            throw new RuntimeException("Index computation returned false for hashId = " + hashId + ", file = " + fileContent.getFile().getPath() + ", index = " + this.getIndexId().getName());
        }
    }

    @NotNull
    public Path getIndexRoot() {
        Path path = this.indexLocation.getStorageFileName$intellij_indexing_shared(this.mySharedExtension);
        if (path == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(12);
        }
        return path;
    }

    public int getIndexedFilesNumber() {
        return this.myIndexedFilesNumber.get();
    }

    public boolean isEmpty() {
        return this.myIsEmpty.get();
    }

    @NotNull
    public ID<K, V> getIndexId() {
        ID<K, V> iD = this.myIndexId;
        if (iD == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(13);
        }
        return iD;
    }

    public InvertedIndex<K, V, FileContent> getIndex() {
        return this.myIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <K, V> void canonicalizePersistentMap(@NotNull PersistentMapImpl<K, V> persistentMap) throws IOException {
        if (persistentMap == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(14);
        }
        Path mainIndexFileName = persistentMap.getBaseFile().getFileName();
        Path tempIndexFolder = FileUtil.createTempDirectory((String)"canonicalizedIndex", (String)mainIndexFileName.toString()).toPath();
        Path canonicalizedIndexFile = tempIndexFolder.resolve(mainIndexFileName);
        KeyDescriptor keyDescriptor = persistentMap.getKeyDescriptor();
        Function sorter = CanonicalSorters.stableSortByHashCodeAndBytes(keyDescriptor);
        try (PersistentMapImpl canonicalizedMap = persistentMap.deriveEmptyMap(canonicalizedIndexFile);){
            PersistentMapBase.canonicalize(persistentMap, (PersistentMapBase)canonicalizedMap, sorter, value -> {
                if (value instanceof ValueContainer) {
                    ValueContainer container = (ValueContainer)value;
                    return HashBasedIndexGenerator.canonicalizeValueContainer(container);
                }
                return value;
            });
            persistentMap.closeAndDelete();
        }
        Path targetIndexDir = persistentMap.getBaseFile().getParent();
        HashBasedIndexGenerator.copyRecursively(tempIndexFolder, targetIndexDir, new StandardCopyOption[0]);
    }

    private static void copyRecursively(@NotNull Path sourceDir, @NotNull Path targetDir, StandardCopyOption ... copyOptions) throws IOException {
        if (sourceDir == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(15);
        }
        if (targetDir == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(16);
        }
        NioFiles.createDirectories((Path)targetDir);
        try (Stream<Path> sourcePaths = Files.walk(sourceDir, new FileVisitOption[0]);){
            sourcePaths.forEach(sourcePath -> {
                try {
                    Path relativeSourcePath = sourceDir.relativize((Path)sourcePath);
                    Path targetPath = targetDir.resolve(relativeSourcePath);
                    if (Files.isRegularFile(sourcePath, new LinkOption[0])) {
                        if (!Files.exists(targetPath.getParent(), new LinkOption[0])) {
                            NioFiles.createDirectories((Path)targetPath);
                        }
                        Files.copy(sourcePath, targetPath, (CopyOption[])copyOptions);
                    }
                }
                catch (IOException ex) {
                    throw new UncheckedIOException("Can't copy " + String.valueOf(sourcePath), ex);
                }
            });
        }
    }

    @NotNull
    private PersistentMapImpl<K, UpdatableValueContainer<V>> extractInvertedIndexPersistentMap(@NotNull InvertedIndex<K, V, FileContent> invertedIndex) {
        if (invertedIndex == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(17);
        }
        MapIndexStorage storage = (MapIndexStorage)((MapReduceIndex)invertedIndex).getStorage();
        PersistentMapImpl persistentMapImpl = (PersistentMapImpl)storage.getIndexMap();
        if (persistentMapImpl == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(18);
        }
        return persistentMapImpl;
    }

    @NotNull
    private PersistentMapImpl<Integer, ByteArraySequence> extractForwardIndexPersistentMap(@NotNull InvertedIndex<K, V, FileContent> index) {
        if (index == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(19);
        }
        ForwardIndex forwardIndex = ((MapReduceIndex)index).getForwardIndex();
        PersistentMapBasedForwardIndex pmapBasedForwardIndexMap = (PersistentMapBasedForwardIndex)forwardIndex;
        PersistentMap pMap = pmapBasedForwardIndexMap.getUnderlyingMap();
        PersistentHashMap forwardIndexMap = (PersistentHashMap)pMap;
        PersistentMapImpl persistentMapImpl = (PersistentMapImpl)forwardIndexMap.getImpl();
        if (persistentMapImpl == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(20);
        }
        return persistentMapImpl;
    }

    @VisibleForTesting
    @NotNull
    static <V> ValueContainer<V> canonicalizeValueContainer(@NotNull ValueContainer<V> container) {
        ValueContainerImpl valueContainer;
        if (container == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(21);
        }
        if (container.size() <= 1) {
            ValueContainer<V> valueContainer2 = container;
            if (valueContainer2 == null) {
                HashBasedIndexGenerator.$$$reportNull$$$0(22);
            }
            return valueContainer2;
        }
        if (container instanceof ValueContainerImpl) {
            valueContainer = (ValueContainerImpl)container;
        } else {
            valueContainer = ValueContainerImpl.createNewValueContainer();
            container.forEach((sourceId, sourceValue) -> {
                valueContainer.addValue(sourceId, sourceValue);
                return true;
            });
        }
        return new ValueContainerWithStableBinaryRepresentation(valueContainer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 10, 12, 13, 18, 20, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalExtension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexLocation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collisionReporter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sharedExtension";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageFile";
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/generate/HashBasedIndexGenerator";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistentMap";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceDir";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDir";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invertedIndex";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/generate/HashBasedIndexGenerator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getForwardIndexPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "transformIndexedData";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexRoot";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexId";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "extractInvertedIndexPersistentMap";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "extractForwardIndexPersistentMap";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "canonicalizeValueContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createForwardIndexAccessor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shouldCreateForwardIndex";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getForwardIndexPath";
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 18: 
            case 20: 
            case 22: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitInputData";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "transformIndexedData";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "indexFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "canonicalizePersistentMap";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "copyRecursively";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "extractInvertedIndexPersistentMap";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "extractForwardIndexPersistentMap";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "canonicalizeValueContainer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 10, 12, 13, 18, 20, 22 -> new IllegalStateException(string);
        };
    }

    public static class InputMapExternalizerToStableBinary<Key, Value>
    implements DataExternalizer<Map<Key, Value>> {
        private final DataExternalizer<Value> valueExternalizer;
        private final DataExternalizer<Collection<Key>> keysExternalizer;
        private final boolean valuesAreNullAlways;
        private final Function<List<Value>, List<Value>> valuesSorter;
        private final Function<List<Key>, List<Key>> keysSorter;

        public InputMapExternalizerToStableBinary(@NotNull IndexExtension<Key, Value, ?> extension) {
            if (extension == null) {
                InputMapExternalizerToStableBinary.$$$reportNull$$$0(0);
            }
            this.valueExternalizer = extension.getValueExternalizer();
            this.keysExternalizer = extension instanceof CustomInputsIndexFileBasedIndexExtension ? ((CustomInputsIndexFileBasedIndexExtension)extension).createExternalizer() : new InputIndexDataExternalizer(extension.getKeyDescriptor(), extension.getName());
            this.valuesAreNullAlways = extension instanceof ScalarIndexExtension;
            this.keysSorter = CanonicalSorters.stableSortByHashCodeAndBytes(extension.getKeyDescriptor());
            this.valuesSorter = CanonicalSorters.stableSortBySerializedBytes(extension.getValueExternalizer());
        }

        public void save(@NotNull DataOutput stream, Map<Key, Value> data) throws IOException {
            if (stream == null) {
                InputMapExternalizerToStableBinary.$$$reportNull$$$0(1);
            }
            int size = data.size();
            DataInputOutputUtil.writeINT((DataOutput)stream, (int)size);
            if (size == 0) {
                return;
            }
            if (this.valuesAreNullAlways) {
                List keysForNullValue = data.keySet().stream().toList();
                List<Key> sortedKeys = this.keysSorter.apply(keysForNullValue);
                this.valueExternalizer.save(stream, null);
                this.keysExternalizer.save(stream, sortedKeys);
                return;
            }
            Map keysPerValue = CollectionFactory.createSmallMemoryFootprintMap();
            for (Map.Entry<Key, Value> e : data.entrySet()) {
                Value value = e.getValue();
                keysPerValue.computeIfAbsent(value, unused -> new SmartList()).add(e.getKey());
            }
            List<Value> sortedValues = this.valuesSorter.apply(keysPerValue.keySet().stream().toList());
            for (Value value : sortedValues) {
                List keysForValue = (List)keysPerValue.get(value);
                List<Key> keysForValueSorted = this.keysSorter.apply(keysForValue);
                this.valueExternalizer.save(stream, value);
                this.keysExternalizer.save(stream, keysForValueSorted);
            }
        }

        public Map<Key, Value> read(@NotNull DataInput in) throws IOException {
            int entries;
            if (in == null) {
                InputMapExternalizerToStableBinary.$$$reportNull$$$0(2);
            }
            if ((entries = DataInputOutputUtil.readINT((DataInput)in)) == 0) {
                return Collections.emptyMap();
            }
            HashMap result = new HashMap(entries);
            while (((InputStream)((Object)in)).available() > 0) {
                Object value = this.valueExternalizer.read(in);
                Collection keys = (Collection)this.keysExternalizer.read(in);
                for (Object k : keys) {
                    result.put(k, value);
                }
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stream";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/indexing/shared/generate/HashBasedIndexGenerator$InputMapExternalizerToStableBinary";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ValueContainerWithStableBinaryRepresentation<Value>
    extends UpdatableValueContainer<Value> {
        @NotNull
        private final ValueContainerImpl<Value> wrappedContainer;

        public ValueContainerWithStableBinaryRepresentation(@NotNull ValueContainerImpl<Value> wrappedContainer) {
            if (wrappedContainer == null) {
                ValueContainerWithStableBinaryRepresentation.$$$reportNull$$$0(0);
            }
            this.wrappedContainer = wrappedContainer;
        }

        public void saveTo(@NotNull DataOutput out, @NotNull DataExternalizer<? super Value> externalizer) throws IOException {
            Object fileSetObject;
            if (out == null) {
                ValueContainerWithStableBinaryRepresentation.$$$reportNull$$$0(1);
            }
            if (externalizer == null) {
                ValueContainerWithStableBinaryRepresentation.$$$reportNull$$$0(2);
            }
            ArrayList<Triple> items = new ArrayList<Triple>();
            InvertedIndexValueIterator valueIterator = this.wrappedContainer.getValueIterator();
            while (valueIterator.hasNext()) {
                Object value = valueIterator.next();
                fileSetObject = valueIterator.getFileSetObject();
                byte[] valueBytes = IOUtil.toBytes((Object)value, externalizer);
                items.add(new Triple(value, (Object)valueBytes, fileSetObject));
            }
            items.sort((o1, o2) -> Arrays.compare((byte[])o1.component2(), (byte[])o2.component2()));
            DataInputOutputUtil.writeINT((DataOutput)out, (int)this.size());
            for (Triple item : items) {
                out.write((byte[])item.component2());
                fileSetObject = item.component3();
                if (fileSetObject instanceof Integer) {
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)((Integer)fileSetObject));
                    continue;
                }
                ValueContainerImpl.storeFileSet((DataOutput)out, (Object)fileSetObject);
            }
        }

        @NotNull
        public ValueContainer.ValueIterator<Value> getValueIterator() {
            InvertedIndexValueIterator invertedIndexValueIterator = this.wrappedContainer.getValueIterator();
            if (invertedIndexValueIterator == null) {
                ValueContainerWithStableBinaryRepresentation.$$$reportNull$$$0(3);
            }
            return invertedIndexValueIterator;
        }

        public int size() {
            return this.wrappedContainer.size();
        }

        public void addValue(int inputId, Value value) {
            this.wrappedContainer.addValue(inputId, value);
        }

        public boolean removeAssociatedValue(int inputId) {
            return this.wrappedContainer.removeAssociatedValue(inputId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrappedContainer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "externalizer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/indexing/shared/generate/HashBasedIndexGenerator$ValueContainerWithStableBinaryRepresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/indexing/shared/generate/HashBasedIndexGenerator$ValueContainerWithStableBinaryRepresentation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueIterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "saveTo";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public static final class ValueContainerExternalizerWithStableBinaryFormat<Value>
    implements DataExternalizer<UpdatableValueContainer<Value>> {
        @NotNull
        private final DataExternalizer<UpdatableValueContainer<Value>> regularContainerExternalizer;
        @NotNull
        private final DataExternalizer<Value> valueExternalizer;

        public ValueContainerExternalizerWithStableBinaryFormat(@NotNull DataExternalizer<UpdatableValueContainer<Value>> regularContainerExternalizer, @NotNull DataExternalizer<Value> valueExternalizer) {
            if (regularContainerExternalizer == null) {
                ValueContainerExternalizerWithStableBinaryFormat.$$$reportNull$$$0(0);
            }
            if (valueExternalizer == null) {
                ValueContainerExternalizerWithStableBinaryFormat.$$$reportNull$$$0(1);
            }
            this.regularContainerExternalizer = regularContainerExternalizer;
            this.valueExternalizer = valueExternalizer;
        }

        public void save(@NotNull DataOutput out, UpdatableValueContainer<Value> container) throws IOException {
            if (out == null) {
                ValueContainerExternalizerWithStableBinaryFormat.$$$reportNull$$$0(2);
            }
            if (container.size() <= 1) {
                this.regularContainerExternalizer.save(out, container);
            } else {
                HashMap map = new HashMap();
                container.forEach((inputId, value) -> {
                    map.computeIfAbsent(value, unused -> new IntArrayList(2)).add(inputId);
                    return true;
                });
                List<Triple> items = map.entrySet().stream().peek(e -> ((IntArrayList)e.getValue()).sort(null)).map(e -> {
                    Object value = e.getKey();
                    IntList inputIdSorted = (IntList)e.getValue();
                    try {
                        byte[] valueBytes = IOUtil.toBytes(value, this.valueExternalizer);
                        return new Triple(value, (Object)valueBytes, (Object)inputIdSorted);
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException("Can't serialize " + String.valueOf(value), ex);
                    }
                }).sorted((o1, o2) -> Arrays.compare((byte[])o1.component2(), (byte[])o2.component2())).toList();
                DataInputOutputUtil.writeINT((DataOutput)out, (int)items.size());
                for (Triple item : items) {
                    byte[] valueBytes = (byte[])item.component2();
                    IntList inputIdsSorted = (IntList)item.component3();
                    out.write(valueBytes);
                    int inputIdsCount = inputIdsSorted.size();
                    if (inputIdsCount == 1) {
                        int singleInputId = inputIdsSorted.getInt(0);
                        DataInputOutputUtil.writeINT((DataOutput)out, (int)singleInputId);
                        continue;
                    }
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)(-inputIdsCount));
                    int prev = 0;
                    IntIterator inputIdsIterator = inputIdsSorted.intIterator();
                    while (inputIdsIterator.hasNext()) {
                        int inputId2 = inputIdsIterator.nextInt();
                        DataInputOutputUtil.writeINT((DataOutput)out, (int)(inputId2 - prev));
                        prev = inputId2;
                    }
                }
            }
        }

        public UpdatableValueContainer<Value> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                ValueContainerExternalizerWithStableBinaryFormat.$$$reportNull$$$0(3);
            }
            return (UpdatableValueContainer)this.regularContainerExternalizer.read(in);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "regularContainerExternalizer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueExternalizer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/indexing/shared/generate/HashBasedIndexGenerator$ValueContainerExternalizerWithStableBinaryFormat";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

