/*
 * Decompiled with CFR 0.152.
 */
package training.learn.course;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.TaskTestContext;
import training.lang.LangSupport;
import training.learn.CourseManager;
import training.learn.course.IftModule;
import training.learn.course.LessonProperties;
import training.learn.course.LessonType;
import training.learn.lesson.LessonListener;
import training.learn.lesson.LessonState;
import training.learn.lesson.LessonStateManager;
import training.statistic.LearningInternalProblems;
import training.statistic.LessonStartingWay;
import training.util.LessonEndInfo;
import training.util.UtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u0018\u0010.\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010/\u001a\u000200H\u0016J\u000e\u00101\u001a\u00020\u001b2\u0006\u00102\u001a\u000203J\u000e\u00104\u001a\u00020\u001b2\u0006\u00102\u001a\u000203J\u0015\u0010<\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020>H\u0000\u00a2\u0006\u0002\b?J;\u0010@\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010A\u001a\u0002062\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020C2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020G0FH\u0000\u00a2\u0006\u0002\bHJ\r\u0010I\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\bJJ\r\u0010K\u001a\u000206H\u0000\u00a2\u0006\u0002\bLR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\bR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR \u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\"\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%8\u0016X\u0097\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b&\u0010'\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0014\u00105\u001a\u0002068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u001a\u00109\u001a\b\u0012\u0004\u0012\u0002030:X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010)\u00a8\u0006M"}, d2={"Ltraining/learn/course/Lesson;", "", "id", "", "name", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getName", "module", "Ltraining/learn/course/IftModule;", "getModule", "()Ltraining/learn/course/IftModule;", "languageId", "getLanguageId", "lessonType", "Ltraining/learn/course/LessonType;", "getLessonType", "()Ltraining/learn/course/LessonType;", "preferredLearnWindowAnchor", "Lcom/intellij/openapi/wm/ToolWindowAnchor;", "project", "Lcom/intellij/openapi/project/Project;", "sampleFilePath", "getSampleFilePath", "prepare", "", "properties", "Ltraining/learn/course/LessonProperties;", "getProperties", "()Ltraining/learn/course/LessonProperties;", "helpLinks", "", "getHelpLinks", "()Ljava/util/Map;", "suitableTips", "", "getSuitableTips$annotations", "()V", "getSuitableTips", "()Ljava/util/List;", "testScriptProperties", "Ltraining/dsl/TaskTestContext$TestScriptProperties;", "getTestScriptProperties", "()Ltraining/dsl/TaskTestContext$TestScriptProperties;", "onLessonEnd", "lessonEndInfo", "Ltraining/util/LessonEndInfo;", "addLessonListener", "lessonListener", "Ltraining/learn/lesson/LessonListener;", "removeLessonListener", "passed", "", "getPassed$intellij_featuresTrainer", "()Z", "lessonListeners", "", "getLessonListeners$intellij_featuresTrainer", "onStart", "way", "Ltraining/statistic/LessonStartingWay;", "onStart$intellij_featuresTrainer", "onStop", "lessonPassed", "currentTaskIndex", "", "currentVisualIndex", "internalProblems", "", "Ltraining/statistic/LearningInternalProblems;", "onStop$intellij_featuresTrainer", "pass", "pass$intellij_featuresTrainer", "isNewLesson", "isNewLesson$intellij_featuresTrainer", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nLesson.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lesson.kt\ntraining/learn/course/Lesson\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1863#2,2:99\n1863#2,2:101\n1863#2,2:103\n*S KotlinDebug\n*F\n+ 1 Lesson.kt\ntraining/learn/course/Lesson\n*L\n69#1:99,2\n77#1:101,2\n83#1:103,2\n*E\n"})
public abstract class Lesson {
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @Nullable
    private final String sampleFilePath;
    @NotNull
    private final LessonProperties properties;
    @NotNull
    private final List<String> suitableTips;
    @NotNull
    private final TaskTestContext.TestScriptProperties testScriptProperties;
    @NotNull
    private final List<LessonListener> lessonListeners;

    public Lesson(@NonNls @NotNull String id, @Nls @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.id = id;
        this.name = name;
        this.properties = new LessonProperties(false, false, null, 7, null);
        this.suitableTips = CollectionsKt.emptyList();
        this.testScriptProperties = new TaskTestContext.TestScriptProperties(0, false, 3, null);
        this.lessonListeners = new ArrayList();
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public abstract IftModule getModule();

    @Nullable
    public String getLanguageId() {
        LangSupport langSupport = this.getModule().getPrimaryLanguage();
        return langSupport != null ? langSupport.getPrimaryLanguage() : null;
    }

    @NotNull
    public LessonType getLessonType() {
        return this.getModule().getModuleType();
    }

    @NotNull
    public ToolWindowAnchor preferredLearnWindowAnchor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.getModule().preferredLearnWindowAnchor(project);
    }

    @Nullable
    public String getSampleFilePath() {
        return this.sampleFilePath;
    }

    @RequiresBackgroundThread
    public void prepare(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    @NotNull
    public LessonProperties getProperties() {
        return this.properties;
    }

    @NotNull
    public Map<String, String> getHelpLinks() {
        return MapsKt.emptyMap();
    }

    @NotNull
    public List<String> getSuitableTips() {
        return this.suitableTips;
    }

    @Deprecated(message="Specify tips in LearningCourse.getLessonIdToTipsMap()")
    public static /* synthetic */ void getSuitableTips$annotations() {
    }

    @NotNull
    public TaskTestContext.TestScriptProperties getTestScriptProperties() {
        return this.testScriptProperties;
    }

    public void onLessonEnd(@NotNull Project project, @NotNull LessonEndInfo lessonEndInfo) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lessonEndInfo, (String)"lessonEndInfo");
    }

    public final void addLessonListener(@NotNull LessonListener lessonListener) {
        Intrinsics.checkNotNullParameter((Object)lessonListener, (String)"lessonListener");
        this.lessonListeners.add(lessonListener);
    }

    public final void removeLessonListener(@NotNull LessonListener lessonListener) {
        Intrinsics.checkNotNullParameter((Object)lessonListener, (String)"lessonListener");
        this.lessonListeners.remove(lessonListener);
    }

    public final boolean getPassed$intellij_featuresTrainer() {
        return LessonStateManager.INSTANCE.getStateFromBase(this.id) == LessonState.PASSED;
    }

    @NotNull
    public final List<LessonListener> getLessonListeners$intellij_featuresTrainer() {
        return this.lessonListeners;
    }

    public final void onStart$intellij_featuresTrainer(@NotNull LessonStartingWay way) {
        Intrinsics.checkNotNullParameter((Object)((Object)way), (String)"way");
        Iterable $this$forEach$iv = this.lessonListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LessonListener it = (LessonListener)element$iv;
            boolean bl = false;
            it.lessonStarted(this, way);
        }
    }

    public final void onStop$intellij_featuresTrainer(@NotNull Project project, boolean lessonPassed, int currentTaskIndex, int currentVisualIndex, @NotNull Set<? extends LearningInternalProblems> internalProblems) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(internalProblems, (String)"internalProblems");
        Iterable $this$forEach$iv = this.lessonListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LessonListener it = (LessonListener)element$iv;
            boolean bl = false;
            it.lessonStopped(this);
        }
        this.onLessonEnd(project, new LessonEndInfo(lessonPassed, currentTaskIndex, currentVisualIndex, internalProblems));
    }

    public final void pass$intellij_featuresTrainer() {
        LessonStateManager.INSTANCE.setPassed(this);
        Iterable $this$forEach$iv = this.lessonListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LessonListener it = (LessonListener)element$iv;
            boolean bl = false;
            it.lessonPassed(this);
        }
    }

    public final boolean isNewLesson$intellij_featuresTrainer() {
        String string = this.getProperties().getAvailableSince();
        if (string == null) {
            return false;
        }
        String availableSince = string;
        BuildNumber buildNumber = BuildNumber.fromString((String)availableSince);
        if (buildNumber == null) {
            return false;
        }
        BuildNumber lessonVersion = buildNumber;
        BuildNumber previousOpenedVersion = CourseManager.Companion.getInstance().getPreviousOpenedVersion();
        if (previousOpenedVersion != null) {
            return previousOpenedVersion.compareTo(lessonVersion) < 0;
        }
        return UtilsKt.filterUnseenLessons(this.getModule().getLessons()).contains(this);
    }
}

