/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.intellij.docker.agent.progress.DockerProgressDetailsFormat;
import com.intellij.docker.agent.util.DockerUtil;
import com.intellij.docker.runtimes.DockerImageRuntime;
import com.intellij.docker.ui.utils.DockerUiUtilsKt;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\u001a\u0013\u0010\u0002\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\u0003*\u00020\u0004H\u0002\u001a\u0011\u0010\u0005\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0006*\u00020\u0004H\u0002\u001a\u0013\u0010\u0007\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\u0003*\u00020\u0004H\u0002\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"REPRODUCIBLE_IMAGE_LABEL", "", "imageCreatedAgo", "Lcom/intellij/openapi/util/NlsSafe;", "Lcom/intellij/docker/runtimes/DockerImageRuntime;", "mainTag", "Lorg/jetbrains/annotations/Nls;", "imageDisplaySize", "isReproducibleImage", "", "secondsSinceTimeStart", "", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nDockerImageRuntimeImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerImageRuntimeImpl.kt\ncom/intellij/docker/runtimes/DockerImageRuntimeImplKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n2341#2,14:147\n*S KotlinDebug\n*F\n+ 1 DockerImageRuntimeImpl.kt\ncom/intellij/docker/runtimes/DockerImageRuntimeImplKt\n*L\n131#1:147,14\n*E\n"})
public final class DockerImageRuntimeImplKt {
    @NotNull
    private static final String REPRODUCIBLE_IMAGE_LABEL = "omitted date";

    private static final String imageCreatedAgo(DockerImageRuntime $this$imageCreatedAgo) {
        String string;
        Long l = $this$imageCreatedAgo.getAgentApplication().getImage().getCreated();
        if (l != null) {
            long secondsSinceTimeStart = ((Number)l).longValue();
            boolean bl = false;
            if (DockerImageRuntimeImplKt.isReproducibleImage(secondsSinceTimeStart)) {
                string = REPRODUCIBLE_IMAGE_LABEL;
            } else {
                String string2 = DockerUtil.formatDuration(System.currentTimeMillis() / (long)1000 - secondsSinceTimeStart);
                Intrinsics.checkNotNull((Object)string2);
                string = string2;
            }
        } else {
            string = null;
        }
        return string;
    }

    private static final String mainTag(DockerImageRuntime $this$mainTag) {
        String string;
        Set<String> it = $this$mainTag.getImageRepoTags();
        boolean bl = false;
        if (it.isEmpty()) {
            string = "";
        } else {
            Object v1;
            Iterable $this$minByOrNull$iv = it;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = minElem$iv;
                } else {
                    String next = (String)minElem$iv;
                    boolean bl2 = false;
                    int minValue$iv = next.length();
                    do {
                        Object e$iv = iterator$iv.next();
                        String next2 = (String)e$iv;
                        $i$a$-minByOrNull-DockerImageRuntimeImplKt$mainTag$1$1 = false;
                        int v$iv = next2.length();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = minElem$iv;
                }
            }
            Intrinsics.checkNotNull(v1);
            string = DockerUiUtilsKt.asNlsSafe(v1);
        }
        return DockerUiUtilsKt.nlsSafe(string);
    }

    private static final String imageDisplaySize(DockerImageRuntime $this$imageDisplaySize) {
        String string;
        Long l = $this$imageDisplaySize.getAgentApplication().getImage().getVirtualSize();
        if (l != null) {
            long bytes = ((Number)l).longValue();
            boolean bl = false;
            string = DockerProgressDetailsFormat.Companion.humanSizeBytes(bytes);
        } else {
            string = null;
        }
        return string;
    }

    private static final boolean isReproducibleImage(long secondsSinceTimeStart) {
        return secondsSinceTimeStart == 0L || secondsSinceTimeStart == 315532801L;
    }

    public static final /* synthetic */ String access$mainTag(DockerImageRuntime $receiver) {
        return DockerImageRuntimeImplKt.mainTag($receiver);
    }

    public static final /* synthetic */ String access$imageCreatedAgo(DockerImageRuntime $receiver) {
        return DockerImageRuntimeImplKt.imageCreatedAgo($receiver);
    }

    public static final /* synthetic */ String access$imageDisplaySize(DockerImageRuntime $receiver) {
        return DockerImageRuntimeImplKt.imageDisplaySize($receiver);
    }
}

