/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.bridge;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.jetbrains.relocated.apache.batik.bridge.AnimatableGenericSVGBridge;
import org.jetbrains.relocated.apache.batik.bridge.BridgeContext;
import org.jetbrains.relocated.apache.batik.bridge.GVTBuilder;
import org.jetbrains.relocated.apache.batik.bridge.MaskBridge;
import org.jetbrains.relocated.apache.batik.bridge.SVGUtilities;
import org.jetbrains.relocated.apache.batik.ext.awt.image.renderable.Filter;
import org.jetbrains.relocated.apache.batik.gvt.CompositeGraphicsNode;
import org.jetbrains.relocated.apache.batik.gvt.GraphicsNode;
import org.jetbrains.relocated.apache.batik.gvt.filter.Mask;
import org.jetbrains.relocated.apache.batik.gvt.filter.MaskRable8Bit;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGMaskElementBridge
extends AnimatableGenericSVGBridge
implements MaskBridge {
    @Override
    public String getLocalName() {
        return "mask";
    }

    @Override
    public Mask createMask(BridgeContext ctx2, Element maskElement, Element maskedElement, GraphicsNode maskedNode) {
        Rectangle2D maskRegion = SVGUtilities.convertMaskRegion(maskElement, maskedElement, maskedNode, ctx2);
        GVTBuilder builder = ctx2.getGVTBuilder();
        CompositeGraphicsNode maskNode = new CompositeGraphicsNode();
        CompositeGraphicsNode maskNodeContent = new CompositeGraphicsNode();
        maskNode.getChildren().add(maskNodeContent);
        boolean hasChildren = false;
        for (Node node = maskElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element child;
            GraphicsNode gn;
            if (node.getNodeType() != 1 || (gn = builder.build(ctx2, child = (Element)node)) == null) continue;
            hasChildren = true;
            maskNodeContent.getChildren().add(gn);
        }
        if (!hasChildren) {
            return null;
        }
        String s = maskElement.getAttributeNS(null, "transform");
        AffineTransform Tx = s.length() != 0 ? SVGUtilities.convertTransform(maskElement, "transform", s, ctx2) : new AffineTransform();
        s = maskElement.getAttributeNS(null, "maskContentUnits");
        int coordSystemType = s.length() == 0 ? 1 : (int)SVGUtilities.parseCoordinateSystem(maskElement, "maskContentUnits", s, ctx2);
        if (coordSystemType == 2) {
            Tx = SVGUtilities.toObjectBBox(Tx, maskedNode);
        }
        maskNodeContent.setTransform(Tx);
        Filter filter2 = maskedNode.getFilter();
        if (filter2 == null) {
            filter2 = maskedNode.getGraphicsNodeRable(true);
        }
        return new MaskRable8Bit(filter2, maskNode, maskRegion);
    }
}

