/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.yaml.completion;

import com.intellij.ml.inline.completion.impl.MLCompletionParameters;
import com.intellij.ml.inline.completion.impl.kit.MLCompletionSkipLocationSupporter;
import com.intellij.ml.inline.completion.impl.kit.SkipLocationReason;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001f\u0010\n\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/yaml/completion/YamlSkipLocationSupporter;", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionSkipLocationSupporter$Base;", "<init>", "()V", "getReasonOrNull", "Lcom/intellij/ml/inline/completion/impl/kit/SkipLocationReason;", "parameters", "Lcom/intellij/ml/inline/completion/impl/MLCompletionParameters;", "hasYamlSchemaDefinedForFile", "", "getJsonSchemaForYamlFileOrNull", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaObject;", "Lorg/jetbrains/annotations/Nullable;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "intellij.ml.llm.yaml.completion"})
public final class YamlSkipLocationSupporter
extends MLCompletionSkipLocationSupporter.Base {
    @Override
    @Nullable
    public SkipLocationReason getReasonOrNull(@NotNull MLCompletionParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        return this.hasYamlSchemaDefinedForFile(parameters) ? SkipLocationReason.YAML_CC_NOT_SUPPORTED_WHEN_SCHEMA_DEFINED : super.getReasonOrNull(parameters);
    }

    private final boolean hasYamlSchemaDefinedForFile(MLCompletionParameters parameters) {
        Project project = parameters.getPosition().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PsiFile psiFile2 = parameters.getPosition().getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
        return this.getJsonSchemaForYamlFileOrNull(project, psiFile2) != null;
    }

    private final JsonSchemaObject getJsonSchemaForYamlFileOrNull(Project project, PsiFile file2) {
        return JsonSchemaService.Impl.get((Project)project).getSchemaObject(file2);
    }
}

