/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.dashboard;

import com.intellij.util.EventDispatcher;
import git4idea.ui.branch.dashboard.BranchNodeDescriptor;
import git4idea.ui.branch.dashboard.BranchesTreeModel;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b \u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0004J\b\u0010\u0017\u001a\u00020\u0013H\u0004J\b\u0010\u0018\u001a\u00020\u0013H\u0004J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\nJ\u000e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R!\u0010\b\u001a\u0015\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesTreeModelBase;", "Lgit4idea/ui/branch/dashboard/BranchesTreeModel;", "<init>", "()V", "root", "Lgit4idea/ui/branch/dashboard/BranchNodeDescriptor$Root;", "getRoot", "()Lgit4idea/ui/branch/dashboard/BranchNodeDescriptor$Root;", "listeners", "Lcom/intellij/util/EventDispatcher;", "Lgit4idea/ui/branch/dashboard/BranchesTreeModel$Listener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "loadingCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "isLoading", "", "()Z", "setTree", "", "nodes", "", "Lgit4idea/ui/branch/dashboard/BranchNodeDescriptor;", "startLoading", "finishLoading", "addListener", "listener", "removeListener", "intellij.vcs.git"})
public abstract class BranchesTreeModelBase
implements BranchesTreeModel {
    @NotNull
    private final BranchNodeDescriptor.Root root = new BranchNodeDescriptor.Root();
    @NotNull
    private final EventDispatcher<BranchesTreeModel.Listener> listeners;
    @NotNull
    private final AtomicInteger loadingCounter;

    public BranchesTreeModelBase() {
        EventDispatcher eventDispatcher = EventDispatcher.create(BranchesTreeModel.Listener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.listeners = eventDispatcher;
        this.loadingCounter = new AtomicInteger();
    }

    @Override
    @NotNull
    public final BranchNodeDescriptor.Root getRoot() {
        return this.root;
    }

    @Override
    public final boolean isLoading() {
        return this.loadingCounter.get() > 0;
    }

    protected final void setTree(@NotNull List<? extends BranchNodeDescriptor> nodes) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        this.root.setChildren(nodes);
        ((BranchesTreeModel.Listener)this.listeners.getMulticaster()).onTreeChange();
    }

    protected final void startLoading() {
        this.loadingCounter.incrementAndGet();
        ((BranchesTreeModel.Listener)this.listeners.getMulticaster()).onLoadingStateChange();
    }

    protected final void finishLoading() {
        this.loadingCounter.decrementAndGet();
        ((BranchesTreeModel.Listener)this.listeners.getMulticaster()).onLoadingStateChange();
    }

    @Override
    public final void addListener(@NotNull BranchesTreeModel.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.addListener((EventListener)listener2);
    }

    @Override
    public final void removeListener(@NotNull BranchesTreeModel.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.removeListener((EventListener)listener2);
    }
}

