/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tailwind.settings;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.library.typings.TypeScriptPackageName;
import com.intellij.lang.typescript.lsp.ExternalDefinitionsNodePackageKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.tailwind.settings.TailwindState;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@State(name="TailwindSettings", storages={@Storage(value="tailwindcss.xml")})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0002H\u0016J\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0011R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/intellij/tailwind/settings/TailwindSettings;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/tailwind/settings/TailwindState;", "<init>", "()V", "state", "getState", "loadState", "", "value", "Lcom/intellij/javascript/nodejs/util/NodePackageRef;", "lspServerPackageRef", "getLspServerPackageRef", "()Lcom/intellij/javascript/nodejs/util/NodePackageRef;", "setLspServerPackageRef", "(Lcom/intellij/javascript/nodejs/util/NodePackageRef;)V", "getLspConfiguration", "", "setLspConfiguration", "lspConfiguration", "Companion", "intellij.tailwindcss"})
public final class TailwindSettings
implements PersistentStateComponent<TailwindState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private TailwindState state = new TailwindState();
    @NotNull
    private static final Lazy<ObjectMapper> objectMapper$delegate = LazyKt.lazy(TailwindSettings::objectMapper_delegate$lambda$0);
    @NotNull
    private static final TypeScriptPackageName defaultLspPackage = TypeScriptPackageName.Companion.from("@tailwindcss/language-server", "0.14.16");
    @JvmField
    @NotNull
    public static final String DEFAULT_CONFIGURATION = "{\n  \"includeLanguages\": {\n    \"ftl\": \"html\",\n    \"jinja\": \"html\",\n    \"jinja2\": \"html\",\n    \"smarty\": \"html\",\n    \"tmpl\": \"gohtml\",\n    \"cshtml\": \"html\",\n    \"vbhtml\": \"html\",\n    \"razor\": \"html\"\n  },\n  \"files\": {\n    \"exclude\": [\n      \"**/.git/**\",\n      \"**/node_modules/**\",\n      \"**/.hg/**\",\n      \"**/.svn/**\"\n    ]\n  },\n  \"emmetCompletions\": false,\n  \"classAttributes\": [\"class\", \"className\", \"ngClass\"],\n  \"colorDecorators\": true,\n  \"showPixelEquivalents\": true,\n  \"rootFontSize\": 16,\n  \"hovers\": true,\n  \"suggestions\": true,\n  \"codeActions\": true,\n  \"validate\": true,\n  \"lint\": {\n    \"invalidScreen\": \"error\",\n    \"invalidVariant\": \"error\",\n    \"invalidTailwindDirective\": \"error\",\n    \"invalidApply\": \"error\",\n    \"invalidConfigPath\": \"error\",\n    \"cssConflict\": \"warning\",\n    \"recommendedVariantOrder\": \"warning\"\n  },\n  \"experimental\": {\n    \"configFile\": null,\n    \"classRegex\": []\n  }\n}";

    @NotNull
    public TailwindState getState() {
        return this.state;
    }

    public void loadState(@NotNull TailwindState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
    }

    @NotNull
    public final NodePackageRef getLspServerPackageRef() {
        return ExternalDefinitionsNodePackageKt.createPackageRef((String)this.state.getLspServerPackageName(), (TypeScriptPackageName)defaultLspPackage);
    }

    public final void setLspServerPackageRef(@NotNull NodePackageRef value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.state.setLspServerPackageName(ExternalDefinitionsNodePackageKt.extractRefText((NodePackageRef)value));
    }

    @NotNull
    public final String getLspConfiguration() {
        return this.state.getLspConfiguration();
    }

    public final void setLspConfiguration(@NotNull String lspConfiguration) {
        Intrinsics.checkNotNullParameter((Object)lspConfiguration, (String)"lspConfiguration");
        this.state.setLspConfiguration(lspConfiguration);
    }

    private static final ObjectMapper objectMapper_delegate$lambda$0() {
        return new ObjectMapper();
    }

    @JvmStatic
    @NotNull
    public static final TailwindSettings getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    @NotNull
    public static final JsonObject getParsedLspConfigurationGson(@NotNull Project project) {
        return Companion.getParsedLspConfigurationGson(project);
    }

    @JvmStatic
    public static final boolean hasCustomLanguage(@NotNull Project project, @NotNull String languageId) {
        return Companion.hasCustomLanguage(project, languageId);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u00020\u00158\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/tailwind/settings/TailwindSettings$Companion;", "", "<init>", "()V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "objectMapper$delegate", "Lkotlin/Lazy;", "getInstance", "Lcom/intellij/tailwind/settings/TailwindSettings;", "project", "Lcom/intellij/openapi/project/Project;", "getParsedLspConfigurationGson", "Lcom/google/gson/JsonObject;", "getParsedLspConfiguration", "Lcom/fasterxml/jackson/databind/JsonNode;", "hasCustomLanguage", "", "languageId", "", "defaultLspPackage", "Lcom/intellij/lang/javascript/library/typings/TypeScriptPackageName;", "getDefaultLspPackage", "()Lcom/intellij/lang/javascript/library/typings/TypeScriptPackageName;", "DEFAULT_CONFIGURATION", "intellij.tailwindcss"})
    @SourceDebugExtension(value={"SMAP\nTailwindSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TailwindSettings.kt\ncom/intellij/tailwind/settings/TailwindSettings$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,134:1\n31#2,2:135\n1#3:137\n15#4:138\n15#4:139\n*S KotlinDebug\n*F\n+ 1 TailwindSettings.kt\ncom/intellij/tailwind/settings/TailwindSettings$Companion\n*L\n26#1:135,2\n34#1:138\n45#1:139\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final ObjectMapper getObjectMapper() {
            Lazy lazy = objectMapper$delegate;
            return (ObjectMapper)lazy.getValue();
        }

        @JvmStatic
        @NotNull
        public final TailwindSettings getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<TailwindSettings> serviceClass$iv = TailwindSettings.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (TailwindSettings)object;
        }

        @JvmStatic
        @NotNull
        public final JsonObject getParsedLspConfigurationGson(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            try {
                JsonObject jsonObject;
                JsonElement jsonElement = JsonParser.parseString((String)this.getInstance(project).getLspConfiguration());
                JsonObject jsonObject2 = jsonObject = jsonElement instanceof JsonObject ? (JsonObject)jsonElement : null;
                if (jsonObject != null) {
                    JsonObject it = jsonObject;
                    boolean bl = false;
                    return it;
                }
            }
            catch (JsonParseException e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(TailwindSettings.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Manually specified Tailwind CSS configuration has invalid JSON syntax. Falling back to the default configuration.\n" + e);
            }
            JsonObject jsonObject = JsonParser.parseString((String)DEFAULT_CONFIGURATION).getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
            return jsonObject;
        }

        private final JsonNode getParsedLspConfiguration(Project project) {
            try {
                JsonNode jsonNode = this.getObjectMapper().readTree(this.getInstance(project).getLspConfiguration());
                Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"readTree(...)");
                return jsonNode;
            }
            catch (com.fasterxml.jackson.core.JsonParseException e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(TailwindSettings.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Manually specified Tailwind CSS configuration has invalid JSON syntax. Falling back to the default configuration.\n" + e);
                JsonNode jsonNode = this.getObjectMapper().readTree(DEFAULT_CONFIGURATION);
                Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"readTree(...)");
                return jsonNode;
            }
        }

        @JvmStatic
        public final boolean hasCustomLanguage(@NotNull Project project, @NotNull String languageId) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
            JsonNode jsonNode = this.getParsedLspConfiguration(project).at("/includeLanguages");
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"at(...)");
            JsonNode languages = jsonNode;
            return !languages.isMissingNode() && languages.isObject() && languages.findValue(languageId) != null;
        }

        @NotNull
        public final TypeScriptPackageName getDefaultLspPackage() {
            return defaultLspPackage;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

