/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diagram.actions;

import com.intellij.database.diagram.DbDiagramDataModel;
import com.intellij.database.diagram.DbDiagramNode;
import com.intellij.database.diagram.actions.DbDiagramRefresher$accept$;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.view.DatabaseNodeWrappingService;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.util.DiagramUpdateService;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.services.GraphAnimationService;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J \u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u0018\u0010\u0017\u001a\u00020\u000f2\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012H\u0002J\u0018\u0010\u0019\u001a\u00020\u000f2\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/diagram/actions/DbDiagramRefresher;", "Ljava/util/function/Consumer;", "", "Lcom/intellij/database/util/ObjectPath;", "builder", "Lcom/intellij/diagram/DiagramBuilder;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "<init>", "(Lcom/intellij/diagram/DiagramBuilder;Lcom/intellij/database/model/basic/BasicModel;)V", "getBuilder", "()Lcom/intellij/diagram/DiagramBuilder;", "getModel", "()Lcom/intellij/database/model/basic/BasicModel;", "accept", "", "createdElements", "updateDataModel", "Lcom/intellij/diagram/DiagramNode;", "Lcom/intellij/database/psi/DbElement;", "dataModel", "Lcom/intellij/database/diagram/DbDiagramDataModel;", "created", "refreshDiagram", "newNode", "updateDiagramFocus", "added", "intellij.database.diagrams"})
@SourceDebugExtension(value={"SMAP\nDbDiagramRefresher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbDiagramRefresher.kt\ncom/intellij/database/diagram/actions/DbDiagramRefresher\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n477#2:71\n1#3:72\n*S KotlinDebug\n*F\n+ 1 DbDiagramRefresher.kt\ncom/intellij/database/diagram/actions/DbDiagramRefresher\n*L\n25#1:71\n*E\n"})
public final class DbDiagramRefresher
implements Consumer<List<ObjectPath>> {
    @NotNull
    private final DiagramBuilder builder;
    @NotNull
    private final BasicModel model;

    public DbDiagramRefresher(@NotNull DiagramBuilder builder, @NotNull BasicModel model) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.builder = builder;
        this.model = model;
    }

    @NotNull
    public final DiagramBuilder getBuilder() {
        return this.builder;
    }

    @NotNull
    public final BasicModel getModel() {
        return this.model;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void accept(@NotNull List<ObjectPath> createdElements) {
        DiagramNode<DbElement> diagramNode;
        DbElement created;
        void $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter(createdElements, (String)"createdElements");
        Project project = this.builder.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DatabaseNodeWrappingService wrappingService = new DatabaseNodeWrappingService(project);
        Sequence sequence = SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)createdElements), arg_0 -> DbDiagramRefresher.accept$lambda$0(this, arg_0));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)accept$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        DbElement dbElement = created = (DbElement)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)sequence2, arg_0 -> DbDiagramRefresher.accept$lambda$1(wrappingService, arg_0)));
        if (dbElement != null) {
            DbElement it = dbElement;
            boolean bl = false;
            DiagramDataModel diagramDataModel = this.builder.getDataModel();
            Intrinsics.checkNotNull((Object)diagramDataModel, (String)"null cannot be cast to non-null type com.intellij.database.diagram.DbDiagramDataModel");
            diagramNode = this.updateDataModel((DbDiagramDataModel)diagramDataModel, it);
        } else {
            diagramNode = null;
        }
        DiagramNode<DbElement> newNode = diagramNode;
        ReadAction.run(() -> DbDiagramRefresher.accept$lambda$3(this, newNode));
    }

    private final DiagramNode<DbElement> updateDataModel(DbDiagramDataModel dataModel, DbElement created) {
        DiagramNode diagramNode;
        if (DbImplUtilCore.isDataTable(created.getKind())) {
            return dataModel.addElement(created);
        }
        DbElement p2 = created.getParent();
        if (p2 == null) {
            diagramNode = null;
        } else {
            Object v2;
            block4: {
                Collection<DbDiagramNode> collection = dataModel.getNodes();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"getNodes(...)");
                Iterable iterable = collection;
                for (Object t : iterable) {
                    DbDiagramNode it = (DbDiagramNode)((Object)t);
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getIdentifyingElement().getDelegate(), (Object)p2.getDelegate())) continue;
                    v2 = t;
                    break block4;
                }
                v2 = null;
            }
            diagramNode = v2;
        }
        return diagramNode;
    }

    private final void refreshDiagram(DiagramNode<DbElement> newNode) {
        DiagramBuilder.DiagramUpdateQueryParams diagramUpdateQueryParams;
        DiagramBuilder.DiagramUpdateQueryParams it = diagramUpdateQueryParams = DiagramUpdateService.getInstance().requestDataModelRefreshPreservingLayout(this.builder);
        boolean bl = false;
        if (newNode != null) {
            DiagramNode[] diagramNodeArray = new DiagramNode[]{newNode};
            v0 = it.withNodeSizeUpdate(diagramNodeArray);
        } else {
            v0 = it.withAllNodeSizeUpdate();
        }
        diagramUpdateQueryParams.runAsync().thenRunAsync(() -> DbDiagramRefresher.refreshDiagram$lambda$6(this, newNode), Futures.inEdt$default(null, (int)1, null));
    }

    private final void updateDiagramFocus(DiagramNode<DbElement> added) {
        IdeFocusManager.getInstance((Project)this.builder.getProject()).requestFocus((Component)this.builder.getView().getCanvasComponent(), true);
        if (added == null) {
            return;
        }
        Node n = this.builder.getNode(added);
        if (n != null) {
            this.builder.getGraph().unselectAll();
            GraphAnimationService.getInstance().focusViewOnNodes(this.builder.getGraphBuilder(), (Collection)CollectionsKt.listOf((Object)n), false);
        }
    }

    private static final Iterable accept$lambda$0(DbDiagramRefresher this$0, ObjectPath it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JBIterable<DasObject> jBIterable = QNameUtil.findByPath(this$0.model, it);
        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"findByPath(...)");
        return (Iterable)jBIterable;
    }

    private static final DbElement accept$lambda$1(DatabaseNodeWrappingService $wrappingService, BasicElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PsiElement psiElement = $wrappingService.wrap(it);
        return psiElement instanceof DbElement ? (DbElement)psiElement : null;
    }

    private static final void accept$lambda$3(DbDiagramRefresher this$0, DiagramNode $newNode) {
        this$0.refreshDiagram((DiagramNode<DbElement>)$newNode);
    }

    private static final void refreshDiagram$lambda$6(DbDiagramRefresher this$0, DiagramNode $newNode) {
        this$0.updateDiagramFocus((DiagramNode<DbElement>)$newNode);
    }
}

