/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.run.actions.ConsoleSourceNameProvider;
import com.intellij.database.run.actions.DumpSource;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.translator.TranslateException;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.containers.JBIterable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ConsoleSource
implements DumpSource<String> {
    private final JdbcConsole console;
    private final ScriptModel<?> model;

    public ConsoleSource(@NotNull JdbcConsole console, @NotNull ScriptModel<?> model) {
        if (console == null) {
            ConsoleSource.$$$reportNull$$$0(0);
        }
        if (model == null) {
            ConsoleSource.$$$reportNull$$$0(1);
        }
        this.console = console;
        this.model = model;
    }

    @NotNull
    public JdbcConsole getConsole() {
        JdbcConsole jdbcConsole = this.console;
        if (jdbcConsole == null) {
            ConsoleSource.$$$reportNull$$$0(2);
        }
        return jdbcConsole;
    }

    @NotNull
    public ScriptModel<?> getModel() {
        ScriptModel<?> scriptModel = this.model;
        if (scriptModel == null) {
            ConsoleSource.$$$reportNull$$$0(3);
        }
        return scriptModel;
    }

    @NotNull
    public JBIterable<String> getSources() {
        FileDocumentManager.getInstance().saveAllDocuments();
        JBIterable<String> jBIterable = this.getSourcesInner();
        if (jBIterable == null) {
            ConsoleSource.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    private JBIterable<String> getSourcesInner() {
        return JBIterable.from((Iterable)this.model.statements().transform(it -> {
            try {
                return it.consoleQuery(this.console.getPStorage(), Conditions.alwaysFalse());
            }
            catch (TranslateException e) {
                return null;
            }
        }).filter(Objects::nonNull).toList());
    }

    public int estimateSize() {
        JBIterable<String> sources = this.getSourcesInner();
        return sources.isEmpty() ? 0 : (sources.skip(1).isEmpty() ? 1 : 2);
    }

    @NotNull
    public ConsoleSourceNameProvider getNameProvider() {
        ConsoleSourceNameProvider consoleSourceNameProvider = ConsoleSourceNameProvider.INSTANCE;
        if (consoleSourceNameProvider == null) {
            ConsoleSource.$$$reportNull$$$0(5);
        }
        return consoleSourceNameProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ConsoleSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ConsoleSource";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsole";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSources";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

