/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.StatisticsWeigher;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.script.ScriptModelUtilCore;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.util.Case;
import com.intellij.database.util.SqlDialects;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.SyntaxTreeBuilder;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.completion.SqlCompletionUtil;
import com.intellij.sql.completion.SqlInsertHandlers;
import com.intellij.sql.completion.SqlTypesStatisticIndex;
import com.intellij.sql.completion.providers.SqlJoinSmartCompletionProvider;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlBatchBlock;
import com.intellij.sql.psi.SqlCodeBlockElement;
import com.intellij.sql.psi.SqlCodeFragmentImpl;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlInfoElementType;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlLazyElementTypeImpl;
import com.intellij.sql.psi.SqlParameterList;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlPsiMiscUtil;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import com.intellij.sql.psi.stubs.SqlFileElementType;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.text.CharSequenceSubSequence;
import com.intellij.util.text.matching.KeyboardLayoutUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlKeywordCompletionContributor
extends CompletionContributor
implements DumbAware {
    public static final int USAGE_THRESHOLD = 2;
    public static final Key<Boolean> FALLBACK_ARGUMENTS = Key.create((String)"FALLBACK_ARGUMENTS");
    private static final TokenSet DO_NOT_BALANCE = TokenSet.create((IElementType[])new IElementType[]{SqlTokens.SQL_IDENT_DELIMITED, SqlTokens.SQL_STRING_TOKEN, SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN});
    private static final Pattern WHITESPACES = Pattern.compile("[\\u00A0\\s]+");

    public SqlKeywordCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inFile((ElementPattern)StandardPatterns.instanceOf(SqlFile.class)), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            public void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet _result) {
                IElementType prevType;
                PsiFile file;
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (_result == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!((file = parameters.getOriginalFile()) instanceof SqlFile)) {
                    return;
                }
                PsiElement position = parameters.getPosition();
                if (position instanceof SqlStringTokenElement || position instanceof PsiComment) {
                    return;
                }
                PsiElement prevSibling = position.getParent().getPrevSibling();
                if (prevSibling instanceof ASTNode && ((prevType = ((ASTNode)prevSibling).getElementType()) == SqlCommonTokens.SQL_PERIOD || SqlImplUtil.getSqlDialectSafe((PsiElement)file).getDbms().isDb2() && prevType == SqlCommonTokens.SQL_DOUBLE_PERIOD)) {
                    return;
                }
                CompletionResultSet result2 = _result.caseInsensitive();
                String prefix = result2.getPrefixMatcher().getPrefix();
                SqlCodeStyleSettings settings = SqlPsiMiscUtil.settings(position.getContainingFile());
                Case prefixCase = Case.forString(prefix);
                Case keywordCase = SqlKeywordCompletionContributor.refineCase(settings != null ? settings.getKeywordCase() : Case.MIXED, prefixCase);
                Case typeCase = SqlKeywordCompletionContributor.refineCase(settings != null ? settings.getBuiltInTypeCase() : Case.MIXED, prefixCase);
                Case identifierCase = SqlKeywordCompletionContributor.refineCase(settings != null ? settings.getIdentifierCase() : Case.MIXED, prefixCase);
                SqlKeywordCompletionContributor.suggestKeywords(result2, position, parameters, typeCase, keywordCase, identifierCase);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "_result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/completion/SqlKeywordCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    private static Case refineCase(@NotNull Case originalCase, @Nullable Case implicitCase) {
        if (originalCase == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(0);
        }
        Case case_ = originalCase == Case.MIXED && implicitCase != null ? implicitCase : originalCase;
        if (case_ == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(1);
        }
        return case_;
    }

    private static InsertHandler<LookupElement> wrapWithMoveIntoParenIfNeeded(String text2, InsertHandler<LookupElement> prevHandler) {
        if (!StringUtil.endsWith((CharSequence)text2, (CharSequence)" )")) {
            return prevHandler;
        }
        return new InsertHandler<LookupElement>(){

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                int c2;
                if (context == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    2.$$$reportNull$$$0(1);
                }
                int offset = context.getEditor().getCaretModel().getOffset() - 2;
                CharSequence charSequence = context.getDocument().getCharsSequence();
                int n = c2 = offset < 1 ? 120 : (int)charSequence.charAt(offset - 1);
                if (c2 != 32) {
                    context.getDocument().insertString(offset, (CharSequence)" ");
                    context.getEditor().getCaretModel().moveToOffset(offset + 1);
                } else {
                    context.getEditor().getCaretModel().moveToOffset(offset);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/completion/SqlKeywordCompletionContributor$2";
                objectArray[2] = "handleInsert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static InsertHandler<LookupElement> wrapHandlerIfNeeded(final String text2, InsertHandler<LookupElement> prevHandler) {
        boolean braceHandler;
        final InsertHandler<LookupElement> handler2 = SqlKeywordCompletionContributor.wrapWithMoveIntoParenIfNeeded(text2, prevHandler);
        boolean bl = braceHandler = handler2 != prevHandler;
        if (text2.indexOf(32) == -1) {
            return handler2;
        }
        return new InsertHandler<LookupElement>(){

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                if (context == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (!this.handleMultiwordInsertion(context) || braceHandler) {
                    handler2.handleInsert(context, item);
                }
            }

            private boolean handleMultiwordInsertion(@NotNull InsertionContext context) {
                String part;
                CharSequence docContent;
                if (context == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (context.getCompletionChar() != '\t') {
                    return false;
                }
                int offset = context.getTailOffset();
                if (offset >= (docContent = context.getDocument().getCharsSequence()).length()) {
                    return false;
                }
                if (docContent.charAt(offset) != ' ') {
                    return false;
                }
                ++offset;
                List parts = StringUtil.split((String)text2, (String)" ", (boolean)true, (boolean)true);
                int dropStart = -1;
                int dropEnd = -1;
                int mismatchCount = 0;
                for (int i2 = 1; i2 < parts.size() && offset + (part = (String)parts.get(i2)).length() <= docContent.length(); ++i2) {
                    CharSequence word = docContent.subSequence(offset, offset + part.length());
                    if (!StringUtil.equalsIgnoreCase((CharSequence)word, (CharSequence)part)) {
                        if (i2 + 1 < parts.size() && StringUtil.equalsIgnoreCase((CharSequence)((CharSequence)parts.get(i2 + 1)), (CharSequence)docContent.subSequence(offset, offset + ((String)parts.get(i2 + 1)).length()))) continue;
                        if (mismatchCount != 0) break;
                        ++mismatchCount;
                        int nextWs = StringUtil.indexOf((CharSequence)docContent, (char)' ', (int)(offset + part.length()));
                        if (nextWs == -1) {
                            return false;
                        }
                        if (dropStart == -1) {
                            dropStart = offset;
                        }
                        offset = nextWs + 1;
                        --i2;
                        continue;
                    }
                    if (dropStart == -1) {
                        dropStart = offset;
                    }
                    dropEnd = offset + part.length();
                    offset = dropEnd + 1;
                }
                if (dropStart > 0 && dropEnd != -1 && dropStart < dropEnd) {
                    context.getEditor().getCaretModel().moveToOffset(dropEnd);
                    context.getDocument().deleteString(dropStart - 1, dropEnd);
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/sql/completion/SqlKeywordCompletionContributor$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleInsert";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleMultiwordInsertion";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(3);
        }
        if (SqlCompletionUtil.isCompletionAllowed(parameters)) {
            super.fillCompletionVariants(parameters, result2);
        }
    }

    public static boolean isSupported(SqlLanguageDialect dialect) {
        return dialect != SqlDialects.getGenericDialect();
    }

    @NotNull
    private static Pair<Map<String, Integer>, Long> getTypeWeightMap(@NotNull PsiElement file, @NotNull Language dialect) {
        if (file == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(4);
        }
        if (dialect == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(5);
        }
        Pair pair = (Pair)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.create(SqlKeywordCompletionContributor.calcTypeWeightMap(file, dialect), (Object[])new Object[]{file}));
        if (pair == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(6);
        }
        return pair;
    }

    @NotNull
    private static Pair<Map<String, Integer>, Long> calcTypeWeightMap(@NotNull PsiElement file, @NotNull Language dialect) {
        if (file == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(7);
        }
        if (dialect == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(8);
        }
        if (!SqlTypesStatisticIndex.IS_ENABLED) {
            Pair pair = Pair.create(Collections.emptyMap(), (Object)0L);
            if (pair == null) {
                SqlKeywordCompletionContributor.$$$reportNull$$$0(9);
            }
            return pair;
        }
        String id = dialect.getID();
        FileBasedIndex index = FileBasedIndex.getInstance();
        Collection keys = index.getAllKeys(SqlTypesStatisticIndex.NAME, file.getProject());
        Map map2 = CollectionFactory.createCaseInsensitiveStringMap();
        GlobalSearchScope scope2 = GlobalSearchScope.projectScope((Project)file.getProject());
        long total = 0L;
        for (String key2 : keys) {
            if (!key2.startsWith(id)) continue;
            List values = index.getValues(SqlTypesStatisticIndex.NAME, (Object)key2, scope2);
            int subTotal = 0;
            for (Integer value : values) {
                subTotal += value.intValue();
            }
            total += (long)subTotal;
            map2.put(key2.substring(id.length() + 2), subTotal);
        }
        Pair pair = Pair.create((Object)map2, (Object)total);
        if (pair == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(10);
        }
        return pair;
    }

    private static boolean isInsignificant(@NotNull PsiElement element) {
        if (element == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(11);
        }
        return element instanceof PsiWhiteSpace || element instanceof PsiComment || element instanceof PsiErrorElement || PsiUtilCore.getElementType((PsiElement)element) instanceof SqlInfoElementType;
    }

    @Nullable
    private static PsiElement skipInsignificantsBackward(@NotNull PsiElement startLeaf, @NotNull PsiElement position) {
        if (startLeaf == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(12);
        }
        if (position == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(13);
        }
        PsiElement p2 = PsiTreeUtil.prevLeaf((PsiElement)position);
        while (p2 != null && p2 != startLeaf && SqlKeywordCompletionContributor.isInsignificant(p2)) {
            p2 = PsiTreeUtil.prevLeaf((PsiElement)p2);
        }
        return p2;
    }

    private static JBIterable<PsiElement> getElementsToMatch(@NotNull PsiElement startElement, @NotNull PsiElement position) {
        if (startElement == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(14);
        }
        if (position == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(15);
        }
        PsiElement startLeaf = PsiTreeUtil.firstChild((PsiElement)startElement);
        PsiElement last = SqlKeywordCompletionContributor.skipInsignificantsBackward(startLeaf, position);
        if (startLeaf == position) {
            return JBIterable.empty();
        }
        return JBIterable.generate((Object)startLeaf, e -> e != last ? PsiTreeUtil.nextLeaf((PsiElement)e) : null).filter(e -> !SqlKeywordCompletionContributor.isInsignificant(e));
    }

    public static void suggestKeywords(@NotNull CompletionResultSet result2, @NotNull PsiElement position, @NotNull CompletionParameters parameters, @NotNull Case typeCase, @NotNull Case keywordCase, @NotNull Case identifierCase) {
        if (result2 == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(16);
        }
        if (position == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(17);
        }
        if (parameters == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(18);
        }
        if (typeCase == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(19);
        }
        if (keywordCase == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(20);
        }
        if (identifierCase == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(21);
        }
        PsiElement root = SqlKeywordCompletionContributor.getStatementsRoot(position);
        PsiElement originalPosition = parameters.getOriginalPosition();
        Language dialect = SqlKeywordCompletionContributor.getLanguage(originalPosition != null ? SqlKeywordCompletionContributor.getStatementsRoot(originalPosition) : root);
        Pair<PsiElement, String> prefSuf = SqlKeywordCompletionContributor.extractFragment(position, root, dialect);
        Object fragment = InjectedLanguageUtilBase.getUnescapedText((PsiFile)root.getContainingFile(), (PsiElement)((PsiElement)prefSuf.first), (PsiElement)position);
        String tailText = StringUtil.notNullize((String)InjectedLanguageUtilBase.getUnescapedLeafText((PsiElement)position, (boolean)false));
        String tailTextTrimmed = StringUtil.trimEnd((String)tailText, (String)"IntellijIdeaRulezzz");
        fragment = (String)fragment + tailTextTrimmed;
        boolean empty = StringUtil.isEmptyOrSpaces((String)fragment);
        String text2 = empty ? "" : (String)fragment + (String)prefSuf.second;
        int offset = parameters.getOffset();
        int completionOffset = empty ? 0 : ((String)fragment).length() - (tailTextTrimmed.length() - (offset - position.getTextRange().getStartOffset()));
        IElementType rootElementType = PsiUtilCore.getElementType((PsiElement)root);
        SqlCodeFragmentImpl file = root instanceof SqlCodeFragmentImpl ? new SqlCodeFragmentImpl((SqlCodeFragmentImpl)root, text2) : (rootElementType instanceof SqlCodeBlockElement.SqlCodeBlockElementType && dialect instanceof SqlLanguageDialect ? SqlPsiElementFactory.createFragmentFromText(text2, (SqlLanguageDialect)dialect, rootElementType, root.getProject(), null) : PsiFileFactory.getInstance((Project)root.getProject()).createFileFromText("a.sql", dialect, (CharSequence)text2, true, false));
        SqlFileElementType.setPlSubDialect((PsiElement)file, SqlFileElementType.isInPl(root));
        JBIterable<PsiElement> elementsToMatch = SqlKeywordCompletionContributor.getElementsToMatch((PsiElement)prefSuf.first, position);
        SqlCompletionState state = new SqlCompletionState(dialect, parameters, root, position, result2, completionOffset, elementsToMatch, typeCase, keywordCase, identifierCase, (Function<LookupElement, Integer>)((Function)e -> StatisticsManager.getInstance().getUseCount(StatisticsWeigher.getBaseStatisticsInfo((LookupElement)e, (CompletionLocation)new CompletionLocation(parameters)))), new HashSet<String>());
        file.putUserData(GeneratedParserUtilBase.COMPLETION_STATE_KEY, (Object)state);
        TreeUtil.ensureParsed((ASTNode)file.getNode());
        PsiElement last = file.findElementAt(completionOffset);
        if (last != null) {
            PsiTreeUtil.prevVisibleLeaf((PsiElement)last);
        }
    }

    @Nullable
    private static <T extends PsiElement> T getTopmostParentOfType(@Nullable PsiElement element, @NotNull Class<T> clazz, @NotNull PsiElement ceil) {
        if (clazz == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(22);
        }
        if (ceil == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(23);
        }
        if (ceil == element) {
            return null;
        }
        return (T)((PsiElement)ObjectUtils.chooseNotNull(element == null ? null : SqlKeywordCompletionContributor.getTopmostParentOfType(element.getParent(), clazz, ceil), (Object)((PsiElement)ObjectUtils.tryCast((Object)element, clazz))));
    }

    @NotNull
    private static Pair<PsiElement, String> extractFragment(@NotNull PsiElement position, @NotNull PsiElement root, @NotNull Language dialect) {
        SqlStatement loBound;
        if (position == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(24);
        }
        if (root == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(25);
        }
        if (dialect == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(26);
        }
        if ((loBound = SqlKeywordCompletionContributor.getTopmostParentOfType(position, SqlStatement.class, root)) != null) {
            loBound = SqlKeywordCompletionContributor.findGoodStatement((PsiElement)loBound, root);
        }
        if (loBound != null) {
            loBound = loBound.getFirstChild();
        }
        if (loBound == null) {
            loBound = (PsiElement)ObjectUtils.chooseNotNull((Object)SqlKeywordCompletionContributor.getFragmentBorderElement(dialect, root, position, true), (Object)root);
        }
        SyntaxTraverser s = SyntaxTraverser.psiTraverser((PsiElement)root);
        s = (SyntaxTraverser)ScriptModelUtilCore.inRange(s, TextRange.create((int)loBound.getTextRange().getStartOffset(), (int)position.getTextRange().getStartOffset())).filter(element -> {
            LeafPsiElement leaf = (LeafPsiElement)ObjectUtils.tryCast((Object)element, LeafPsiElement.class);
            return leaf != null && !DO_NOT_BALANCE.contains(leaf.getElementType());
        });
        int balance = 0;
        for (PsiElement element2 : s) {
            balance += SqlKeywordCompletionContributor.getParenBalance(element2.getText());
        }
        Pair pair = Pair.create((Object)loBound, (Object)(balance > 0 ? StringUtil.repeat((String)")", (int)balance) : ""));
        if (pair == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(27);
        }
        return pair;
    }

    @Nullable
    private static SqlStatement getPrevStatementSameLevel(@NotNull PsiElement stmt) {
        if (stmt == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(28);
        }
        PsiElement parent = SqlKeywordCompletionContributor.blockRoot(stmt);
        SyntaxTraverser s = ScriptModelUtilCore.inRange((SyntaxTraverser)SyntaxTraverser.revPsiTraverser().withRoot((Object)parent), TextRange.create((int)0, (int)stmt.getTextOffset()));
        return (SqlStatement)((SyntaxTraverser)s.expandAndSkip(Conditions.or((Condition)Conditions.is((Object)parent), (Condition)Conditions.compose((Function)s.api.TO_TYPE, (Condition)Conditions.is((Object)GeneratedParserUtilBase.DUMMY_BLOCK))))).filter(SqlStatement.class).first();
    }

    @Nullable
    private static PsiElement blockRoot(@NotNull PsiElement stmt) {
        PsiElement parent;
        if (stmt == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(29);
        }
        for (parent = stmt.getParent(); parent != null && parent.getNode() != null && parent.getNode().getElementType() == GeneratedParserUtilBase.DUMMY_BLOCK; parent = parent.getParent()) {
        }
        return parent;
    }

    @NotNull
    static PsiElement findGoodStatement(@NotNull PsiElement stmt, @NotNull PsiElement ceil) {
        if (stmt == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(30);
        }
        if (ceil == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(31);
        }
        PsiElement levelStatement = stmt;
        while (levelStatement != null && PsiTreeUtil.isContextAncestor((PsiElement)ceil, (PsiElement)levelStatement, (boolean)true)) {
            SqlStatement prev2 = SqlKeywordCompletionContributor.getPrevStatementSameLevel(levelStatement);
            if (prev2 != null && SqlKeywordCompletionContributor.findError((PsiElement)prev2, stmt) != null) {
                SqlStatement sqlStatement = prev2;
                if (sqlStatement == null) {
                    SqlKeywordCompletionContributor.$$$reportNull$$$0(32);
                }
                return sqlStatement;
            }
            levelStatement = PsiTreeUtil.getParentOfType((PsiElement)levelStatement, SqlStatement.class);
        }
        PsiElement psiElement = stmt;
        if (psiElement == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(33);
        }
        return psiElement;
    }

    @Nullable
    private static PsiElement findError(@NotNull PsiElement stmt, @NotNull PsiElement end) {
        if (stmt == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(34);
        }
        if (end == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(35);
        }
        HashSet<PsiElement> checked = new HashSet<PsiElement>();
        PsiElement tmp = PsiTreeUtil.prevLeaf((PsiElement)end, (boolean)false);
        while (tmp != null) {
            if (SqlKeywordCompletionContributor.isError(tmp, checked)) {
                return tmp;
            }
            if (!(tmp instanceof PsiComment) && !StringUtil.isEmptyOrSpaces((String)tmp.getText()) && tmp.getTextRange().getStartOffset() < stmt.getTextRange().getEndOffset()) break;
            tmp = PsiTreeUtil.prevLeaf((PsiElement)tmp, (boolean)false);
        }
        return null;
    }

    private static boolean isError(@NotNull PsiElement el, @NotNull Set<PsiElement> checked) {
        if (el == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(36);
        }
        if (checked == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(37);
        }
        if (el instanceof PsiErrorElement) {
            return true;
        }
        PsiElement parent = el.getParent();
        if (parent == null || checked.contains(parent)) {
            return false;
        }
        checked.add(parent);
        return SqlKeywordCompletionContributor.isError(parent, checked);
    }

    @NotNull
    private static Language getLanguage(@NotNull PsiElement element) {
        if (element == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(38);
        }
        if (element instanceof SqlCodeBlockElement) {
            Language language = (Language)ILazyParseableElementType.LANGUAGE_KEY.get((UserDataHolder)element, (Object)PlainTextLanguage.INSTANCE);
            if (language == null) {
                SqlKeywordCompletionContributor.$$$reportNull$$$0(39);
            }
            return language;
        }
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe(element);
        if (sqlLanguageDialectEx == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(40);
        }
        return sqlLanguageDialectEx;
    }

    @NotNull
    private static PsiElement getStatementsRoot(@NotNull PsiElement element) {
        if (element == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(41);
        }
        SqlCodeBlockElement root = (SqlCodeBlockElement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlCodeBlockElement.class);
        PsiElement psiElement = (PsiElement)ObjectUtils.chooseNotNull((Object)root, (Object)element.getContainingFile());
        if (psiElement == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(42);
        }
        return psiElement;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static LookupElement createKeywordLookupElement(@NotNull Case keywordCase, @NotNull String filePrefix, @NotNull String str, @Nullable String tail, @NotNull Language dialect, @NotNull PsiBuilder builder, @Nullable String frameName, boolean addWhitespace, double correction, boolean strikeout, @NotNull Set<String> addedKeywords, @NotNull PsiElement position, @NotNull Editor editor2) {
        String keyword;
        InsertHandler<LookupElement> handler2;
        void editor3;
        if (keywordCase == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(43);
        }
        if (filePrefix == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(44);
        }
        if (str == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(45);
        }
        if (dialect == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(46);
        }
        if (builder == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(47);
        }
        if (addedKeywords == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(48);
        }
        if (position == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(49);
        }
        if (editor2 == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(50);
        }
        String k = SqlKeywordCompletionContributor.findMultiWordKeyword(filePrefix, str);
        InsertHandler<LookupElement> customHandler = SqlKeywordCompletionContributor.findCustomInsertHandler(str, builder, frameName, dialect, position, (Editor)editor3);
        Object object = handler2 = customHandler != null ? customHandler : (addWhitespace ? SqlKeywordCompletionContributor.wrapHandlerIfNeeded(str, SqlInsertHandlers.WHITESPACE_PROTECTED) : null);
        if (!addedKeywords.add((k == null ? str : k) + (String)(tail != null ? " " + tail : ""))) {
            return null;
        }
        String string = keyword = k != null ? k : str;
        if (StringUtil.startsWithChar((CharSequence)keyword, (char)'(')) {
            return null;
        }
        List<String> aliases = k != null ? ContainerUtil.emptyList() : Arrays.asList(StringUtil.toLowerCase((String)str).replaceAll(" ", "_"), str.replaceAll(" ", "_"));
        return SqlCompletionUtil.createKeywordLookupElement(keywordCase, keyword, tail, handler2, correction, (Collection<String>)aliases, strikeout);
    }

    private static boolean isInsideAnalyticClause(@NotNull PsiBuilder builder) {
        if (builder == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(51);
        }
        GeneratedParserUtilBase.Frame frame = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).currentFrame;
        while (frame != null) {
            if (frame.elementType == SqlCompositeElementTypes.SQL_ANALYTIC_CLAUSE) {
                return true;
            }
            frame = frame.parentFrame;
        }
        return false;
    }

    @Nullable
    private static InsertHandler<LookupElement> findCustomInsertHandler(@NotNull String str, @NotNull PsiBuilder builder, @Nullable String frameName, @NotNull Language dialect, @NotNull PsiElement position, @NotNull Editor editor2) {
        if (str == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(52);
        }
        if (builder == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(53);
        }
        if (dialect == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(54);
        }
        if (position == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(55);
        }
        if (editor2 == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(56);
        }
        if (SqlKeywordCompletionContributor.isInsideAnalyticClause(builder)) {
            return null;
        }
        if (str.equalsIgnoreCase("AUTO_INCREMENT") || frameName != null && frameName.endsWith("paren argument list>")) {
            return SqlInsertHandlers.DUMMY_HANDLER;
        }
        if (str.equalsIgnoreCase("VARCHAR") || str.equalsIgnoreCase("VARCHAR2") || str.equalsIgnoreCase("NVARCHAR")) {
            Dbms dbms;
            Dbms dbms2 = dbms = dialect instanceof SqlLanguageDialect ? ((SqlLanguageDialect)dialect).getDbms() : Dbms.UNKNOWN;
            if (dbms == Dbms.UNKNOWN || dbms.isCassandra() || dbms.isH2() || dbms.isHive() || dbms == Dbms.MARIA || dbms.isPostgres() || dbms.isSnowflake() || dbms.is(Dbms.SPARK) || dbms.isTransactSql() || dbms.isVertica()) {
                return null;
            }
            if (dbms.isOracle() && PsiTreeUtil.getParentOfType((PsiElement)position, SqlParameterList.class) != null) {
                return null;
            }
            return ParenthesesInsertHandler.WITH_PARAMETERS;
        }
        if (str.equalsIgnoreCase("WHERE") || str.equalsIgnoreCase("FROM") || str.equalsIgnoreCase("ON") || StringUtil.endsWithIgnoreCase((String)str, (String)"JOIN") && "<join>".equals(frameName)) {
            return SqlKeywordCompletionContributor.wrapHandlerIfNeeded(str, SqlKeywordCompletionContributor.isTemplateOrHasFollowingTail(editor2, position) ? SqlInsertHandlers.WHITESPACE_PROTECTED : SqlInsertHandlers.WHITESPACE_POPUP_PROTECTED);
        }
        if (str.equalsIgnoreCase("GO")) {
            return SqlInsertHandlers.NEW_LINE_INSERT_HANDLER;
        }
        return null;
    }

    private static boolean isTemplateOrHasFollowingTail(@NotNull Editor editor2, @NotNull PsiElement position) {
        if (editor2 == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(57);
        }
        if (position == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(58);
        }
        if (TemplateManager.getInstance((Project)position.getProject()).getActiveTemplate(editor2) != null) {
            return true;
        }
        SqlQueryExpression queryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)position, SqlQueryExpression.class);
        PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)position);
        return nextLeaf != null && PsiTreeUtil.isAncestor((PsiElement)queryExpression, (PsiElement)nextLeaf, (boolean)false);
    }

    @Nullable
    public static String findMultiWordKeyword(@NotNull String filePrefix, @NotNull String str) {
        List<CharSequence> kwSeq;
        if (filePrefix == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(59);
        }
        if (str == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(60);
        }
        if ((kwSeq = SqlKeywordCompletionContributor.splitSpaces(str)) == null) {
            return null;
        }
        List<CharSequence> fileSeq = SqlKeywordCompletionContributor.splitSpaces(filePrefix);
        if (fileSeq == null) {
            fileSeq = Collections.singletonList(filePrefix);
        }
        for (int i2 = Math.min(kwSeq.size(), fileSeq.size()); i2 > 0; --i2) {
            ThreeState comparison = SqlKeywordCompletionContributor.compareFileSuffixWithKwPrefix(fileSeq, kwSeq, i2);
            if (comparison == ThreeState.NO) continue;
            int matched = comparison == ThreeState.UNSURE ? i2 - 1 : i2;
            return StringUtil.join(kwSeq.subList(matched, kwSeq.size()), (String)" ");
        }
        return null;
    }

    private static ThreeState compareFileSuffixWithKwPrefix(@NotNull List<CharSequence> fileSeq, @NotNull List<CharSequence> kwSeq, int size) {
        if (fileSeq == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(61);
        }
        if (kwSeq == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(62);
        }
        assert (size > 0);
        int end = size - 1;
        for (int i2 = 0; i2 < end; ++i2) {
            CharSequence keyWord;
            CharSequence fileWord = fileSeq.get(fileSeq.size() - size + i2);
            if (StringUtil.equalsIgnoreCase((CharSequence)fileWord, (CharSequence)(keyWord = kwSeq.get(i2)))) continue;
            return ThreeState.NO;
        }
        CharSequence fileWord = fileSeq.get(fileSeq.size() - 1);
        CharSequence keyWord = kwSeq.get(size - 1);
        if (keyWord.length() >= fileWord.length() && StringUtil.equalsIgnoreCase((CharSequence)fileWord, (CharSequence)keyWord.subSequence(0, fileWord.length()))) {
            return keyWord.length() == fileWord.length() ? ThreeState.YES : ThreeState.UNSURE;
        }
        return ThreeState.NO;
    }

    @Nullable
    private static PsiElement getFragmentBorderElement(@NotNull Language dialect, PsiElement root, PsiElement position, boolean backward) {
        if (dialect == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(63);
        }
        int count = 0;
        PsiElement cur = position;
        while (cur != null && cur != root) {
            PsiElement next;
            PsiElement psiElement = next = backward ? cur.getPrevSibling() : cur.getNextSibling();
            if (next instanceof SqlStatement) {
                if (backward && SqlKeywordCompletionContributor.isStatementClosingToken(dialect, next.getLastChild())) {
                    return SqlKeywordCompletionContributor.getNextElement(next);
                }
                return next;
            }
            if (next instanceof SqlBatchBlock || next instanceof GeneratedParserUtilBase.DummyBlock) {
                PsiElement psiElement2 = next = backward ? PsiTreeUtil.getDeepestLast((PsiElement)next) : PsiTreeUtil.getDeepestFirst((PsiElement)next);
                if (backward && SqlKeywordCompletionContributor.isStatementClosingToken(dialect, next)) {
                    return SqlKeywordCompletionContributor.getNextElement(next);
                }
            } else if (next == null) {
                next = cur.getParent();
            } else if (SqlKeywordCompletionContributor.isStatementClosingToken(dialect, next)) {
                return SqlKeywordCompletionContributor.getNextElement(next);
            }
            cur = next;
            ++count;
        }
        return null;
    }

    private static PsiElement getNextElement(PsiElement next) {
        for (PsiElement e = next; e != null; e = e.getParent()) {
            PsiElement p2 = e.getNextSibling();
            if (p2 == null) continue;
            return p2;
        }
        return next;
    }

    private static boolean isStatementClosingToken(@NotNull Language dialect, PsiElement child) {
        if (dialect == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(64);
        }
        return dialect instanceof SqlLanguageDialect && child instanceof LeafPsiElement && ((SqlLanguageDialect)dialect).getStatementSeparators().contains(((LeafPsiElement)child).getElementType());
    }

    private static int getParenBalance(@NotNull CharSequence text2) {
        if (text2 == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(65);
        }
        int count = 0;
        int len = text2.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = text2.charAt(i2);
            if (c2 == '(') {
                ++count;
            }
            if (c2 != ')') continue;
            --count;
        }
        return count;
    }

    private static List<CharSequence> splitSpaces(CharSequence input) {
        SmartList res2 = null;
        Matcher matcher = WHITESPACES.matcher(input);
        if (!matcher.find()) {
            return null;
        }
        int start2 = 0;
        int end = matcher.start();
        while (true) {
            if (res2 == null) {
                res2 = new SmartList();
            }
            res2.add(new CharSequenceSubSequence(input, start2, end));
            if (end == input.length()) break;
            start2 = matcher.end();
            end = matcher.find() ? matcher.start() : input.length();
        }
        return res2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 9, 10, 27, 32, 33, 39, 40, 42 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalCase";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 10: 
            case 27: 
            case 32: 
            case 33: 
            case 39: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/completion/SqlKeywordCompletionContributor";
                break;
            }
            case 2: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 8: 
            case 26: 
            case 46: 
            case 54: 
            case 63: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 11: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startLeaf";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 24: 
            case 49: 
            case 55: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeCase";
                break;
            }
            case 20: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywordCase";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifierCase";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 23: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ceil";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stmt";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checked";
                break;
            }
            case 44: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePrefix";
                break;
            }
            case 45: 
            case 52: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 47: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedKeywords";
                break;
            }
            case 50: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSeq";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kwSeq";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/completion/SqlKeywordCompletionContributor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "refineCase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeWeightMap";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "calcTypeWeightMap";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "extractFragment";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "findGoodStatement";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementsRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "refineCase";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 10: 
            case 27: 
            case 32: 
            case 33: 
            case 39: 
            case 40: 
            case 42: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTypeWeightMap";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "calcTypeWeightMap";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isInsignificant";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "skipInsignificantsBackward";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToMatch";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "suggestKeywords";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostParentOfType";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "extractFragment";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getPrevStatementSameLevel";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "blockRoot";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findGoodStatement";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findError";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isError";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getStatementsRoot";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createKeywordLookupElement";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isInsideAnalyticClause";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "findCustomInsertHandler";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isTemplateOrHasFollowingTail";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "findMultiWordKeyword";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "compareFileSuffixWithKwPrefix";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getFragmentBorderElement";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "isStatementClosingToken";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getParenBalance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6, 9, 10, 27, 32, 33, 39, 40, 42 -> new IllegalStateException(string);
        };
    }

    public static class SqlCompletionState
    extends GeneratedParserUtilBase.CompletionState {
        private boolean myErrorMode;
        private final Set<String> myAddedKeywords;
        private final Case myTypeCase;
        private final Case myKeywordCase;
        private final Case myIdentifierCase;
        private final CompletionResultSet myResult;
        private final CompletionParameters myParameters;
        private final Language myDialect;
        private final PsiElement myPosition;
        private final Function<LookupElement, Integer> myUseCounter;
        private final PsiElement myRoot;
        private final JBIterable<PsiElement> myElementsToMatch;
        private final Map<String, DasTypeSystemBase.DeprecatedTypeInfo> myDeprecatedTypes;
        private static final Set<String> literalItemsNoWs = SqlCompletionState.createKeywordsSet("default", "true", "false", "null", "unknown");
        private static final Set<String> frameTrailingWords = SqlCompletionState.createKeywordsSet("preceding", "following");
        public static final String GROUP_BY = "GROUP BY";
        private static final Set<String> RAISE_PRIORITY = Set.of("left join", "right join", "not null");

        SqlCompletionState(@NotNull Language dialect, @NotNull CompletionParameters parameters, @NotNull PsiElement root, @NotNull PsiElement position, @NotNull CompletionResultSet result2, int offset, @NotNull JBIterable<PsiElement> elementsToMatch, @NotNull Case typeCase, @NotNull Case keywordCase, @NotNull Case identifierCase, @NotNull Function<LookupElement, Integer> useCounter, @NotNull Set<String> addedKeywords) {
            Map<Object, Object> map2;
            if (dialect == null) {
                SqlCompletionState.$$$reportNull$$$0(0);
            }
            if (parameters == null) {
                SqlCompletionState.$$$reportNull$$$0(1);
            }
            if (root == null) {
                SqlCompletionState.$$$reportNull$$$0(2);
            }
            if (position == null) {
                SqlCompletionState.$$$reportNull$$$0(3);
            }
            if (result2 == null) {
                SqlCompletionState.$$$reportNull$$$0(4);
            }
            if (elementsToMatch == null) {
                SqlCompletionState.$$$reportNull$$$0(5);
            }
            if (typeCase == null) {
                SqlCompletionState.$$$reportNull$$$0(6);
            }
            if (keywordCase == null) {
                SqlCompletionState.$$$reportNull$$$0(7);
            }
            if (identifierCase == null) {
                SqlCompletionState.$$$reportNull$$$0(8);
            }
            if (useCounter == null) {
                SqlCompletionState.$$$reportNull$$$0(9);
            }
            if (addedKeywords == null) {
                SqlCompletionState.$$$reportNull$$$0(10);
            }
            super(offset);
            this.myTypeCase = typeCase;
            this.myKeywordCase = keywordCase;
            this.myIdentifierCase = identifierCase;
            this.myResult = result2;
            this.myDialect = dialect;
            this.myPosition = position;
            this.myParameters = parameters;
            this.myUseCounter = useCounter;
            this.myRoot = root;
            this.myElementsToMatch = elementsToMatch;
            this.myAddedKeywords = addedKeywords;
            if (dialect instanceof SqlLanguageDialectEx) {
                SqlLanguageDialectEx dialectEx = (SqlLanguageDialectEx)dialect;
                map2 = dialectEx.getTypeSystem().getDeprecatedTypes(parameters.getOriginalFile());
            } else {
                map2 = Collections.emptyMap();
            }
            this.myDeprecatedTypes = map2;
        }

        public boolean isErrorMode() {
            return this.myErrorMode;
        }

        public void setErrorMode(boolean value) {
            this.myErrorMode = value;
        }

        public SqlCompletionState atOffset(int offset) {
            return new SqlCompletionState(this.myDialect, this.myParameters, this.myRoot, this.myPosition, this.myResult, offset, this.myElementsToMatch, this.myTypeCase, this.myKeywordCase, this.myIdentifierCase, this.myUseCounter, this.myAddedKeywords);
        }

        public String convertItem(Object o) {
            Object keywordItem = SqlCompletionState.transformKeywordItem(o);
            return keywordItem != null ? super.convertItem(keywordItem) : null;
        }

        private static Object transformKeywordItem(Object o) {
            IElementType elementType;
            Object item;
            if (o instanceof String || o instanceof SqlKeywordTokenType) {
                return o;
            }
            if (o == SqlCommonTokens.SQL_LEFT_PAREN) {
                return "(";
            }
            if (o == SqlCommonTokens.SQL_RIGHT_PAREN) {
                return ")";
            }
            if (!(o instanceof IElementType[])) {
                return null;
            }
            IElementType[] elementTypes = (IElementType[])o;
            ArrayList<Object> types = new ArrayList<Object>(elementTypes.length);
            boolean hasParens = false;
            IElementType[] iElementTypeArray = elementTypes;
            int n = iElementTypeArray.length;
            for (int j = 0; j < n && (item = SqlCompletionState.transformKeywordItem(elementType = iElementTypeArray[j])) != null; ++j) {
                if (item instanceof String) {
                    hasParens = true;
                }
                types.add(item);
            }
            return !hasParens && types.size() == elementTypes.length ? elementTypes : ContainerUtil.toArray(types, Object[]::new);
        }

        private static Set<String> createKeywordsSet(String ... elements) {
            if (elements == null) {
                SqlCompletionState.$$$reportNull$$$0(11);
            }
            return CollectionFactory.createCaseInsensitiveStringSet(Arrays.asList(elements));
        }

        private static boolean skipWhitespace(@Nullable String frameName, @NotNull String itemText) {
            if (itemText == null) {
                SqlCompletionState.$$$reportNull$$$0(12);
            }
            return "<type>".equals(frameName) || "<builtin type element>".equals(frameName) || "<privilege>".equals(frameName) || "<literal>".equals(frameName) && literalItemsNoWs.contains(itemText) || "<frame clause>".equals(frameName) && frameTrailingWords.contains(itemText);
        }

        private boolean isStatementInsideExpression(@Nullable String frameName) {
            if (!(this.myDialect instanceof SqlLanguageDialect)) {
                return false;
            }
            if (!((SqlLanguageDialect)this.myDialect).getDbms().isMicrosoft()) {
                return false;
            }
            if (frameName == null || !frameName.contains("statement")) {
                return false;
            }
            PsiElement originalPosition = this.myParameters.getOriginalPosition();
            if (originalPosition == null) {
                return false;
            }
            PsiElement prev2 = originalPosition.getParent().getPrevSibling();
            while (prev2 instanceof PsiWhiteSpace || prev2 instanceof PsiComment) {
                if (prev2.getText().contains("\n")) {
                    return false;
                }
                prev2 = prev2.getPrevSibling();
            }
            return prev2 instanceof SqlExpression;
        }

        private boolean matchTokens(@NotNull PsiBuilder builder, @NotNull String itemText) {
            int j;
            PsiElement start2;
            if (builder == null) {
                SqlCompletionState.$$$reportNull$$$0(13);
            }
            if (itemText == null) {
                SqlCompletionState.$$$reportNull$$$0(14);
            }
            if ((start2 = (PsiElement)this.myElementsToMatch.first()) == null) {
                return true;
            }
            PsiElement chameleon = SqlLazyElementTypeImpl.getContextElement(builder);
            int chameleonOffset = chameleon != null ? chameleon.getTextRange().getStartOffset() : 0;
            int parserOffset = builder.rawTokenTypeStart(0);
            int offset = start2.getTextRange().getStartOffset() + parserOffset + chameleonOffset;
            List elements = this.myElementsToMatch.skipWhile(e -> e.getTextRange().getStartOffset() < offset).toList();
            List tokens = StringUtil.split((String)itemText, (String)" ");
            int i2 = 0;
            for (j = 0; i2 < tokens.size() && j < elements.size(); ++i2, ++j) {
                String text2 = ((PsiElement)elements.get(j)).getText();
                if (text2.isEmpty() || StringUtil.equalsIgnoreCase((CharSequence)((CharSequence)tokens.get(i2)), (CharSequence)text2)) continue;
                return false;
            }
            return j >= elements.size();
        }

        private static boolean isParsingOrderBy(@NotNull PsiBuilder builder) {
            if (builder == null) {
                SqlCompletionState.$$$reportNull$$$0(15);
            }
            GeneratedParserUtilBase.Frame frame = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).currentFrame;
            while (frame != null) {
                if (frame.elementType == SqlCompositeElementTypes.SQL_ORDER_BY_CLAUSE) {
                    return true;
                }
                frame = frame.parentFrame;
            }
            return false;
        }

        public void addItem(@NotNull PsiBuilder builder, @NotNull String itemText) {
            if (builder == null) {
                SqlCompletionState.$$$reportNull$$$0(16);
            }
            if (itemText == null) {
                SqlCompletionState.$$$reportNull$$$0(17);
            }
            this.addItem(builder, itemText, null);
        }

        private void addItem(@NotNull PsiBuilder builder, @NotNull String itemText, @Nullable String tail) {
            int count;
            LookupElement element;
            String groupByTail;
            if (builder == null) {
                SqlCompletionState.$$$reportNull$$$0(18);
            }
            if (itemText == null) {
                SqlCompletionState.$$$reportNull$$$0(19);
            }
            if (this.isErrorMode()) {
                return;
            }
            int errorAt = this.findReportedError(builder, (String)itemText);
            if (errorAt >= 0 && errorAt == builder.rawTokenIndex()) {
                return;
            }
            String frameName = SqlCompletionState.frameName(builder);
            if (!this.matchTokens(builder, (String)itemText)) {
                return;
            }
            if (PsiUtilCore.getElementType((PsiElement)((PsiElement)this.myElementsToMatch.last())) == SqlCommonTokens.SQL_ASTERISK && "<expression>".equals(frameName)) {
                return;
            }
            if (this.isStatementInsideExpression(frameName)) {
                return;
            }
            if (SqlCompletionState.isMergedWithPreviousToken(builder)) {
                return;
            }
            if (((String)itemText).equals("IS") && "<expression>".equals(frameName)) {
                this.addItem(builder, "IS NULL");
                this.addItem(builder, "IS NOT NULL");
            }
            if (((String)itemText).equals("INSERT") && ("<insert_statement>".equals(frameName) || "<insert statement>".equals(frameName))) {
                this.addItem(builder, "INSERT INTO");
            }
            if (((String)itemText).equals(GROUP_BY) && tail == null && !(groupByTail = this.getGroupByTail()).isEmpty()) {
                this.addItem(builder, (String)itemText, groupByTail);
            }
            boolean type = "<type>".equals(frameName) || "<builtin type element>".equals(frameName);
            boolean funArg = "<function call expression>".equals(frameName);
            String trimForCorrection = SqlCompletionState.trimForCorrection((String)itemText);
            double correction = this.correction(type, trimForCorrection, tail);
            Case mode = type ? this.myTypeCase : (Objects.equals(frameName, "<pl_directive_clause>") ? this.myIdentifierCase : this.myKeywordCase);
            PrefixMatcher prefixMatcher = this.myResult.getPrefixMatcher();
            if (!prefixMatcher.prefixMatches(mode.apply(trimForCorrection))) {
                return;
            }
            if ("<join>".equals(frameName) && ((String)itemText).contains("JOIN") && !((String)itemText).contains("NATURAL") && !prefixMatcher.getPrefix().isEmpty() && (((String)itemText).equals("JOIN") || prefixMatcher.isStartMatch((String)itemText))) {
                SqlJoinSmartCompletionProvider.suggestForPredictedJoin(mode.apply((String)itemText), this.myParameters, this.myResult);
            }
            if ((((String)itemText).equals("ASC") || ((String)itemText).equals("DESC")) && SqlCompletionState.isParsingOrderBy(builder)) {
                correction += 1000.0;
            }
            boolean isDeprecated = type && this.myDeprecatedTypes.containsKey(StringUtil.toLowerCase((String)itemText));
            String completionPrefix = StringUtil.notNullize((String)this.buildSearchText(builder, Math.max(this.offset - builder.getCurrentOffset(), 0)));
            int lastParen = ((String)itemText).lastIndexOf(40);
            if (lastParen != -1 && !StringUtil.contains((CharSequence)completionPrefix, (CharSequence)((String)itemText).substring(0, lastParen))) {
                itemText = (String)itemText + " )";
            }
            if (StringUtil.isEmptyOrSpaces((String)StringUtil.trimEnd((String)StringUtil.trimStart((String)itemText, (String)"("), (char)')'))) {
                return;
            }
            if (Boolean.TRUE.equals(FALLBACK_ARGUMENTS.get((UserDataHolder)builder))) {
                correction -= 0.1;
            }
            if (isDeprecated) {
                correction -= 1.0;
            }
            if ((element = SqlKeywordCompletionContributor.createKeywordLookupElement(mode, completionPrefix, (String)itemText, tail, this.myDialect, builder, frameName, !SqlCompletionState.skipWhitespace(frameName, (String)itemText), correction + (double)(funArg ? 1 : 0), isDeprecated, this.myAddedKeywords, this.myPosition, this.myParameters.getEditor())) == null) {
                return;
            }
            if (type && (count = ((Integer)this.myUseCounter.fun((Object)element)).intValue()) >= 2) {
                element = SqlKeywordCompletionContributor.createKeywordLookupElement(mode, completionPrefix, (String)itemText, tail, this.myDialect, builder, frameName, false, correction + 1.0, isDeprecated, new HashSet<String>(), this.myPosition, this.myParameters.getEditor());
            }
            assert (element != null);
            this.myResult.addElement(element);
        }

        @NotNull
        private String getGroupByTail() {
            SqlQueryExpression query;
            PsiElement queryAnchor = this.myPosition;
            if (queryAnchor.getParent() instanceof PsiErrorElement) {
                queryAnchor = PsiTreeUtil.prevCodeLeaf((PsiElement)queryAnchor);
            }
            if ((query = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)queryAnchor, SqlQueryExpression.class)) == null) {
                return "";
            }
            JBIterable names = JBIterable.from(SqlImplUtil.getNonAggregateColumnRefs(query)).flatMap(ref2 -> {
                DatabaseDialectEx databaseDialectEx;
                Language patt38929$temp = this.myDialect;
                if (patt38929$temp instanceof SqlLanguageDialectEx) {
                    SqlLanguageDialectEx sqlDialect = (SqlLanguageDialectEx)patt38929$temp;
                    databaseDialectEx = sqlDialect.getDatabaseDialect();
                } else {
                    databaseDialectEx = DatabaseDialects.getGenericDialect();
                }
                DatabaseDialectEx databaseDialect = databaseDialectEx;
                return SqlImplUtil.getResolvesNotInGroupBy(ref2, null).transform(element -> SqlImplUtil.getResolvedColumnName(databaseDialect, ref2, element));
            });
            String string = StringUtil.join((Iterable)names, (String)", ");
            if (string == null) {
                SqlCompletionState.$$$reportNull$$$0(20);
            }
            return string;
        }

        private static boolean isMergedWithPreviousToken(@NotNull PsiBuilder builder) {
            SyntaxTreeBuilder.Production marker;
            IElementType tokenType;
            List productions;
            if (builder == null) {
                SqlCompletionState.$$$reportNull$$$0(21);
            }
            if ((productions = builder.getProductions()).isEmpty()) {
                return false;
            }
            SyntaxTreeBuilder.Production lastMarker = (SyntaxTreeBuilder.Production)ContainerUtil.getLastItem((List)productions);
            int index = lastMarker.getStartIndex();
            for (int i2 = productions.size() - 2; i2 >= 0 && (tokenType = (marker = (SyntaxTreeBuilder.Production)productions.get(i2)).getTokenType()) != SqlCompositeElementTypes.SQL_AS_EXPRESSION && tokenType != SqlCompositeElementTypes.SQL_VARIABLE_DEFINITION; --i2) {
                if (tokenType != SqlCompositeElementTypes.SQL_IDENTIFIER) continue;
                return marker.getEndIndex() == index;
            }
            return false;
        }

        @NotNull
        private static String trimForCorrection(@NotNull String itemText) {
            if (itemText == null) {
                SqlCompletionState.$$$reportNull$$$0(22);
            }
            String string = StringUtil.endsWithChar((CharSequence)itemText, (char)'(') ? itemText.substring(0, itemText.length() - 1).trim() : itemText;
            if (string == null) {
                SqlCompletionState.$$$reportNull$$$0(23);
            }
            return string;
        }

        private int findReportedError(PsiBuilder builder, @NotNull String itemText) {
            GeneratedParserUtilBase.Frame lastFrame;
            GeneratedParserUtilBase.Frame frame;
            LighterASTNode lastNode;
            if (itemText == null) {
                SqlCompletionState.$$$reportNull$$$0(24);
            }
            if ((lastNode = builder.getLatestDoneMarker()) instanceof SyntaxTreeBuilder.Production) {
                SyntaxTreeBuilder.Production production = (SyntaxTreeBuilder.Production)lastNode;
                int steps = production.getStartIndex() - builder.rawTokenIndex();
                IElementType tokenType = builder.rawLookup(steps);
                int startOffset = builder.rawTokenTypeStart(steps);
                int endOffset = builder.rawTokenTypeStart(steps + 1);
                String tokenText = builder.getOriginalText().subSequence(startOffset, endOffset).toString();
                if (tokenType == SqlTokens.SQL_IDENT && endOffset == this.offset && StringUtil.startsWithIgnoreCase((String)itemText, (String)tokenText)) {
                    return -1;
                }
            }
            if ((frame = (lastFrame = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).currentFrame)) == null) {
                return -1;
            }
            int frameOffset = frame.offset;
            while (frame != null) {
                if (frame.errorReportedAt != -1 && (frame == lastFrame || frame.offset < frameOffset)) {
                    return frame.errorReportedAt;
                }
                frame = frame.parentFrame;
            }
            return -1;
        }

        private double correction(boolean type, @NotNull String text2, @Nullable String tail) {
            if (text2 == null) {
                SqlCompletionState.$$$reportNull$$$0(25);
            }
            if (type) {
                Pair<Map<String, Integer>, Long> map2 = SqlKeywordCompletionContributor.getTypeWeightMap(this.myRoot, this.myDialect);
                Integer count = (Integer)((Map)map2.first).get(text2);
                return count != null && (Long)map2.second != 0L ? 1.0 * (double)count.intValue() / (double)((Long)map2.second).longValue() : 0.0;
            }
            if (text2.equals(GROUP_BY) && tail != null) {
                return 0.1;
            }
            String textToCheck = StringUtil.toLowerCase((String)text2);
            if (RAISE_PRIORITY.contains(textToCheck)) {
                return 0.1;
            }
            if ("like".equals(textToCheck) && !this.myResult.getPrefixMatcher().getPrefix().isEmpty()) {
                return 0.1;
            }
            return 0.0;
        }

        @Nullable
        private String buildSearchText(@NotNull PsiBuilder builder, int maxLength) {
            int builderOffset;
            if (builder == null) {
                SqlCompletionState.$$$reportNull$$$0(26);
            }
            if (this.offset == (builderOffset = builder.getCurrentOffset())) {
                return "";
            }
            StringBuilder compText = new StringBuilder();
            int i2 = 0;
            while (true) {
                IElementType type = builder.rawLookup(i2);
                int tokenStart = builder.rawTokenTypeStart(i2);
                if (tokenStart > this.offset || type == null) {
                    compText.append(" ");
                    break;
                }
                if (!GeneratedParserUtilBase.isWhitespaceOrComment((PsiBuilder)builder, (IElementType)type)) {
                    int tokenEnd = Math.min(builder.rawTokenTypeStart(i2 + 1), this.offset);
                    CharSequence token = builder.getOriginalText().subSequence(tokenStart, tokenEnd);
                    if (!compText.isEmpty() || this.convertItem(type) != null) {
                        if (!compText.isEmpty()) {
                            compText.append(" ");
                        }
                        compText.append(token);
                    }
                    if (compText.length() >= maxLength && tokenEnd != this.offset) {
                        return null;
                    }
                    if (tokenEnd == this.offset) break;
                }
                ++i2;
            }
            return !compText.isEmpty() ? compText.toString() : "";
        }

        public boolean prefixMatches(@NotNull PsiBuilder builder, @NotNull String text2) {
            String searchText;
            if (builder == null) {
                SqlCompletionState.$$$reportNull$$$0(27);
            }
            if (text2 == null) {
                SqlCompletionState.$$$reportNull$$$0(28);
            }
            return (searchText = this.buildSearchText(builder, text2.length())) != null && (searchText.isEmpty() || super.prefixMatches(SqlCompletionState.convertLayout(searchText), text2));
        }

        private static String convertLayout(String s) {
            char[] alternatePattern = new char[s.length()];
            for (int i2 = 0; i2 < s.length(); ++i2) {
                char c2 = s.charAt(i2);
                Character newC = KeyboardLayoutUtil.getAsciiForChar((char)c2);
                alternatePattern[i2] = newC == null ? c2 : newC.charValue();
            }
            return new String(alternatePattern);
        }

        @Nullable
        private static String frameName(@NotNull PsiBuilder builder) {
            if (builder == null) {
                SqlCompletionState.$$$reportNull$$$0(29);
            }
            GeneratedParserUtilBase.Frame frame = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).currentFrame;
            while (frame != null) {
                if (!StringUtil.isEmpty((String)frame.name)) {
                    return frame.name;
                }
                frame = frame.parentFrame;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 20, 23 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementsToMatch";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeCase";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keywordCase";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "identifierCase";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "useCounter";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "addedKeywords";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 12: 
                case 14: 
                case 17: 
                case 19: 
                case 22: 
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "itemText";
                    break;
                }
                case 13: 
                case 15: 
                case 16: 
                case 18: 
                case 21: 
                case 26: 
                case 27: 
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 20: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/completion/SqlKeywordCompletionContributor$SqlCompletionState";
                    break;
                }
                case 25: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/completion/SqlKeywordCompletionContributor$SqlCompletionState";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupByTail";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "trimForCorrection";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "createKeywordsSet";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "skipWhitespace";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "matchTokens";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "isParsingOrderBy";
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "addItem";
                    break;
                }
                case 20: 
                case 23: {
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "isMergedWithPreviousToken";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "trimForCorrection";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "findReportedError";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "correction";
                    break;
                }
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "buildSearchText";
                    break;
                }
                case 27: 
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "prefixMatches";
                    break;
                }
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "frameName";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 20, 23 -> new IllegalStateException(string);
            };
        }
    }
}

