/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasHideableObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.inspections.SqlTypeInspection;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlReturningClause;
import com.intellij.sql.psi.SqlSetOperatorExpression;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SqlInsertValuesInspection
extends SqlInspectionBase {
    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        if (dialect == null) {
            SqlInsertValuesInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlInsertValuesInspection.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            SqlInsertValuesInspection.$$$reportNull$$$0(2);
        }
        final Dbms dbms = dialect.getDbms();
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            public void visitSqlTableColumnList(SqlTableColumnsList o) {
                if (dbms.isClickHouse()) {
                    return;
                }
                if (!(o.getParent() instanceof SqlInsertDmlInstruction)) {
                    return;
                }
                SqlReferenceExpression tableReference = o.getTableReference();
                if (tableReference == null) {
                    return;
                }
                PsiElement targetTable = tableReference.resolve();
                if (!(targetTable instanceof DasTable)) {
                    return;
                }
                HashSet implicitColumns = ContainerUtil.newHashSet(DasUtil.getColumns((DasTable)targetTable));
                SqlReferenceList referenceList = o.getColumnsReferenceList();
                if (referenceList == null) {
                    return;
                }
                for (Object reference : referenceList.getReferenceList()) {
                    PsiElement target2 = reference.resolve();
                    if (!(target2 instanceof DasColumn)) continue;
                    implicitColumns.remove(target2);
                }
                SmartList missingColumnNames = new SmartList();
                for (DasColumn column2 : implicitColumns) {
                    if (!column2.isNotNull() || column2.getDefault() != null || SqlImplUtil.isAutoVal(column2) || SqlImplUtil.isComputedVal(column2)) continue;
                    missingColumnNames.add((Object)column2.getName());
                }
                if (!missingColumnNames.isEmpty()) {
                    String columnText = StringUtil.join((Collection)missingColumnNames, (String)", ");
                    String message = SqlBundle.message((String)"inspection.message.following.columns.have.no.computed.default.value.must.be.listed.explicitly", (Object[])new Object[]{columnText});
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)referenceList, (PsiElement)referenceList, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly, new LocalQuickFix[0]));
                }
            }

            public void visitSqlValuesExpression(SqlValuesExpression o) {
                super.visitSqlValuesExpression(o);
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                SqlDmlInstruction insertStatement = (SqlDmlInstruction)ObjectUtils.tryCast((Object)o.getParent(), SqlDmlInstruction.class);
                if (insertStatement != null) {
                    SqlTableType targetType = insertStatement.getTargetType();
                    if (SqlTypeInspection.isNotInspectable((DasType)targetType)) {
                        return;
                    }
                    Pair<Integer, Integer> minMax = this.minMaxColumnCount(targetType);
                    if ((Integer)minMax.second <= 0) {
                        return;
                    }
                    int counter = 0;
                    for (SqlExpression expression : o.getExpressions()) {
                        int actual;
                        ++counter;
                        if (this.shouldNotCheckElement((SqlElement)expression)) continue;
                        DasType type = expression.getDasType();
                        int n = type instanceof SqlTableType ? (Integer)this.minMaxColumnCount((SqlTableType)((SqlTableType)type)).first : (actual = type == DasTypeSystemBase.UNKNOWN ? 0 : 1);
                        if (actual == 0) continue;
                        this.checkElement((SqlElement)expression, (Integer)minMax.second, (Integer)minMax.first, actual);
                    }
                    if (counter == 0) {
                        this.checkElement((SqlElement)o, (Integer)minMax.second, (Integer)minMax.first, 0);
                    }
                }
            }

            public void visitSqlClause(SqlClause o) {
                if (dbms.isMicrosoft() && o instanceof SqlReturningClause && o.getParent() instanceof SqlInsertDmlInstruction) {
                    SqlTableColumnsList columnsList = (SqlTableColumnsList)PsiTreeUtil.getChildOfType((PsiElement)o, SqlTableColumnsList.class);
                    if (columnsList == null) {
                        return;
                    }
                    List outputExpressions = SqlImplUtil.revSiblings((PsiElement)columnsList).skip(1).filter(SqlExpression.class).toList();
                    if (outputExpressions.isEmpty()) {
                        return;
                    }
                    SqlTableType targetType = (SqlTableType)ObjectUtils.tryCast((Object)columnsList.getDasType(), SqlTableType.class);
                    if (targetType == null || SqlTypeInspection.isNotInspectable((DasType)targetType)) {
                        return;
                    }
                    SqlTableType outputType = SqlImplUtil.getSelectType(outputExpressions, (PsiElement)o);
                    SqlExpression startAnchor = (SqlExpression)ContainerUtil.getLastItem((List)outputExpressions);
                    SqlExpression endAnchor = (SqlExpression)ContainerUtil.getFirstItem((List)outputExpressions);
                    this.checkElement((SqlElement)startAnchor, (SqlElement)endAnchor, targetType.getColumnCount(), targetType.getColumnCount(), outputType.getColumnCount());
                } else {
                    super.visitSqlClause(o);
                }
            }

            @NotNull
            private Pair<Integer, Integer> minMaxColumnCount(@NotNull SqlTableType targetType) {
                int max;
                if (targetType == null) {
                    1.$$$reportNull$$$0(0);
                }
                int min = max = targetType.getColumnCount();
                for (int i2 = 0; i2 < max; ++i2) {
                    boolean hasDefaultOrNullable;
                    PsiElement element = targetType.getSourceColumnElement(i2);
                    if (!(element instanceof PsiColumn)) continue;
                    PsiColumn column2 = (PsiColumn)element;
                    boolean isPostgres = dbms.isPostgres();
                    boolean supportsAutoInc = dbms.isTransactSql() || isPostgres;
                    boolean isAutoInc = SqlImplUtil.isAutoVal(column2);
                    boolean bl = hasDefaultOrNullable = column2.getDefault() != null || !column2.isNotNull() && !DasUtil.isPrimary(column2);
                    if (!(supportsAutoInc && isAutoInc || isPostgres && hasDefaultOrNullable) && (!dbms.isMysql() || !1.isHidden(column2))) continue;
                    --min;
                }
                Pair pair = Pair.create((Object)min, (Object)max);
                if (pair == null) {
                    1.$$$reportNull$$$0(1);
                }
                return pair;
            }

            private static boolean isHidden(PsiColumn column2) {
                DasHideableObject hideable;
                return column2 instanceof DasHideableObject && (hideable = (DasHideableObject)((Object)column2)).isHidden();
            }

            public void visitSqlExpression(SqlExpression o) {
                super.visitSqlExpression(o);
                if (o instanceof SqlSetOperatorExpression) {
                    int i2;
                    SqlSetOperatorExpression setExpr = (SqlSetOperatorExpression)o;
                    List operands2 = setExpr.getOperands();
                    if (operands2.size() < 2) {
                        return;
                    }
                    IntArrayList counts = new IntArrayList(operands2.size());
                    for (SqlExpression operand : operands2) {
                        SqlTableType type = (SqlTableType)ObjectUtils.tryCast((Object)operand.getDasType(), SqlTableType.class);
                        int size = type == null ? -1 : type.getColumnCount();
                        counts.add(size);
                    }
                    IntArrayList errors = new IntArrayList(operands2.size());
                    int sz = -1;
                    for (i2 = 0; i2 < counts.size(); ++i2) {
                        int cur = counts.getInt(i2);
                        if (cur == -1) {
                            counts.set(i2, sz);
                            continue;
                        }
                        if (sz == -1) {
                            sz = cur;
                        }
                        if (cur != sz) {
                            errors.add(i2 - 1);
                        }
                        sz = cur;
                    }
                    if (!errors.isEmpty()) {
                        for (i2 = 0; i2 < errors.size(); ++i2) {
                            int k = errors.getInt(i2);
                            PsiElement sign = setExpr.getOpSignElement(k);
                            this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)ObjectUtils.chooseNotNull((Object)sign, (Object)o), SqlBundle.message((String)"inspection.message.left.right.operands.should.have.same.number.columns.got", (Object[])new Object[]{counts.getInt(k), counts.getInt(k + 1)}), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                        }
                    } else {
                        this.processQuery(o);
                    }
                } else if (o instanceof SqlResultSetExpression && !(o instanceof SqlValuesExpression)) {
                    this.processQuery(o);
                }
            }

            private void processQuery(SqlExpression expression) {
                if (this.shouldNotCheckElement((SqlElement)expression)) {
                    return;
                }
                SqlDmlInstruction insertStatement = (SqlDmlInstruction)ObjectUtils.tryCast((Object)expression.getParent(), SqlDmlInstruction.class);
                SqlInsertStatement insert = (SqlInsertStatement)ObjectUtils.tryCast((Object)(insertStatement == null ? null : insertStatement.getParent()), SqlInsertStatement.class);
                if (insert != null) {
                    assert (insertStatement != null);
                    SqlTableType exprType = (SqlTableType)ObjectUtils.tryCast((Object)expression.getDasType(), SqlTableType.class);
                    if (exprType == null) {
                        return;
                    }
                    SqlTableType targetType = insertStatement.getTargetType();
                    Pair<Integer, Integer> targetMinMax = this.minMaxColumnCount(targetType);
                    if ((Integer)targetMinMax.second <= 0) {
                        return;
                    }
                    this.checkElement((SqlElement)expression, (Integer)targetMinMax.second, (Integer)targetMinMax.first, exprType.getColumnCount());
                }
            }

            private void checkElement(SqlElement anchor, int max, int min, int actual) {
                this.checkElement(anchor, anchor, max, min, actual);
            }

            private void checkElement(SqlElement startAnchor, SqlElement endAnchor, int max, int min, int actual) {
                if (actual > max || actual < min) {
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)startAnchor, (PsiElement)endAnchor, SqlBundle.message((String)"incorrect.values.number", (Object[])new Object[]{max == min ? Integer.valueOf(max) : "from " + min + " to " + max, actual}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly, new LocalQuickFix[0]));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "targetType";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/inspections/SqlInsertValuesInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/inspections/SqlInsertValuesInspection$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "minMaxColumnCount";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "minMaxColumnCount";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/inspections/SqlInsertValuesInspection";
        objectArray[2] = "createAnnotationVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

