/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.filter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.RemoteRepositoryFilterManager;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.filter.RemoteRepositoryFilter;
import org.eclipse.aether.spi.connector.filter.RemoteRepositoryFilterSource;

@Singleton
@Named
public final class DefaultRemoteRepositoryFilterManager
implements RemoteRepositoryFilterManager {
    private static final String INSTANCE_KEY = DefaultRemoteRepositoryFilterManager.class.getName() + ".instance";
    private final Map<String, RemoteRepositoryFilterSource> sources;

    @Deprecated
    public DefaultRemoteRepositoryFilterManager() {
        this.sources = new HashMap<String, RemoteRepositoryFilterSource>();
    }

    @Inject
    public DefaultRemoteRepositoryFilterManager(Map<String, RemoteRepositoryFilterSource> sources) {
        this.sources = Objects.requireNonNull(sources);
    }

    @Override
    public RemoteRepositoryFilter getRemoteRepositoryFilter(RepositorySystemSession session) {
        return (RemoteRepositoryFilter)session.getData().computeIfAbsent(INSTANCE_KEY, () -> {
            HashMap<String, RemoteRepositoryFilter> filters = new HashMap<String, RemoteRepositoryFilter>();
            for (Map.Entry<String, RemoteRepositoryFilterSource> entry : this.sources.entrySet()) {
                RemoteRepositoryFilter filter = entry.getValue().getRemoteRepositoryFilter(session);
                if (filter == null) continue;
                filters.put(entry.getKey(), filter);
            }
            if (!filters.isEmpty()) {
                return new Participants(filters);
            }
            return null;
        });
    }

    private static class Participants
    implements RemoteRepositoryFilter {
        private final Map<String, RemoteRepositoryFilter> participants;

        private Participants(Map<String, RemoteRepositoryFilter> participants) {
            this.participants = Collections.unmodifiableMap(participants);
        }

        @Override
        public RemoteRepositoryFilter.Result acceptArtifact(RemoteRepository remoteRepository, Artifact artifact) {
            return new Consensus(this.participants.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((RemoteRepositoryFilter)e.getValue()).acceptArtifact(remoteRepository, artifact))));
        }

        @Override
        public RemoteRepositoryFilter.Result acceptMetadata(RemoteRepository remoteRepository, Metadata metadata) {
            return new Consensus(this.participants.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((RemoteRepositoryFilter)e.getValue()).acceptMetadata(remoteRepository, metadata))));
        }
    }

    private static class Consensus
    implements RemoteRepositoryFilter.Result {
        private final boolean accepted;
        private final String reasoning;

        Consensus(Map<String, RemoteRepositoryFilter.Result> results2) {
            this.accepted = results2.values().stream().allMatch(RemoteRepositoryFilter.Result::isAccepted);
            this.reasoning = results2.values().stream().filter(r -> !r.isAccepted()).map(RemoteRepositoryFilter.Result::reasoning).collect(Collectors.joining("; "));
        }

        @Override
        public boolean isAccepted() {
            return this.accepted;
        }

        @Override
        public String reasoning() {
            return this.reasoning;
        }
    }
}

