/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ExtensionsKt;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesListener;
import com.intellij.openapi.vcs.changes.committed.IncomingChangesViewProviderKt;
import com.intellij.openapi.vcs.changes.committed.OutdatedVersionNotifierKt;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Consumer;
import java.util.List;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J,\u0010\u0005\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0007\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/vcs/changes/committed/OutdatedVersionNotifier;", "Lcom/intellij/ui/EditorNotificationProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "IncomingChangesListener", "intellij.platform.vcs.impl"})
public final class OutdatedVersionNotifier
implements EditorNotificationProvider,
DumbAware {
    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CommittedChangesCache committedChangesCache = CommittedChangesCache.getInstanceIfCreated(project);
        if (committedChangesCache == null) {
            return null;
        }
        CommittedChangesCache cache = committedChangesCache;
        Pair<CommittedChangeList, Change> pair = cache.getIncomingChangeList(file);
        if (pair == null) {
            return null;
        }
        Pair<CommittedChangeList, Change> pair2 = pair;
        CommittedChangeList incomingChangeList = (CommittedChangeList)ExtensionsKt.component1(pair2);
        Change incomingChange = (Change)ExtensionsKt.component2(pair2);
        AbstractVcs abstractVcs = incomingChangeList.getVcs();
        Intrinsics.checkNotNullExpressionValue((Object)abstractVcs, (String)"getVcs(...)");
        if (!IncomingChangesViewProviderKt.isIncomingChangesAvailable(abstractVcs)) {
            return null;
        }
        return arg_0 -> OutdatedVersionNotifier.collectNotificationData$lambda$0(incomingChangeList, incomingChange, arg_0);
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$0(CommittedChangeList $incomingChangeList, Change $incomingChange, FileEditor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Intrinsics.checkNotNull((Object)$incomingChangeList);
        Intrinsics.checkNotNull((Object)$incomingChange);
        return OutdatedVersionNotifierKt.access$createOutdatedVersionPanel($incomingChangeList, $incomingChange, it);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/changes/committed/OutdatedVersionNotifier$IncomingChangesListener;", "Lcom/intellij/openapi/vcs/changes/committed/CommittedChangesListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "incomingChangesUpdated", "", "receivedChanges", "", "Lcom/intellij/openapi/vcs/versionBrowser/CommittedChangeList;", "changesCleared", "intellij.platform.vcs.impl"})
    public static final class IncomingChangesListener
    implements CommittedChangesListener {
        @NotNull
        private final Project project;

        public IncomingChangesListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        public void incomingChangesUpdated(@Nullable List<? extends CommittedChangeList> receivedChanges) {
            CommittedChangesCache cache = CommittedChangesCache.getInstance(this.project);
            if (cache.getCachedIncomingChanges() != null) {
                EditorNotifications.getInstance((Project)this.project).updateAllNotifications();
            } else {
                cache.hasCachesForAnyRoot((Consumer<? super Boolean>)((Consumer)arg_0 -> IncomingChangesListener.incomingChangesUpdated$lambda$1(arg_0 -> IncomingChangesListener.incomingChangesUpdated$lambda$0(cache, arg_0), arg_0)));
            }
        }

        @Override
        public void changesCleared() {
            EditorNotifications.getInstance((Project)this.project).updateAllNotifications();
        }

        private static final Unit incomingChangesUpdated$lambda$0(CommittedChangesCache $cache, Boolean hasCaches) {
            if (!hasCaches.booleanValue()) {
                return Unit.INSTANCE;
            }
            $cache.loadIncomingChangesAsync(null, true);
            return Unit.INSTANCE;
        }

        private static final void incomingChangesUpdated$lambda$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }
    }
}

