# Upgrading to 5.0.0

isort 5.0.0 is the first major release of isort in 5 years, and as such it does introduce some breaking changes.
This guide is meant to help migrate projects from using isort 4.x.x unto the 5.0.0 release.

Related documentation:

* [isort 5.0.0 changelog](https://pycqa.github.io/isort/CHANGELOG#500-penny-july-4-2020)
* [isort 5 release document](https://pycqa.github.io/isort/docs/major_releases/introducing_isort_5.html)

!!! important - "If you use pre-commit remove seed-isort-config."
    If you currently use pre-commit, make sure to see the pre-commit section of this document. In particular, make sure to remove any `seed-isort-config` pre-step.

## Imports no Longer Moved to Top

One of the most immediately evident changes when upgrading to isort 5, is it now avoids moving imports around code by default.
The great thing about this is that it means that isort can safely run against complex code bases that need to place side effects between import sections without needing any comments, flags, or configs. It's also part of the rearchitecting that allows it to sort within type checking conditionals and functions. However, it can be a jarring change
for those of us who have gotten used to placing imports right above their usage in code to avoid context switching. No need to worry! isort still supports this work mode.

If you want to move all imports to the top, you can use the new`--float-to-top` flag in the CLI or `float_to_top=true` option in your config file.

See: [https://pycqa.github.io/isort/docs/configuration/options.html#float-to-top](https://pycqa.github.io/isort/docs/configuration/options.html#float-to-top)

## Migrating CLI options

### `--dont-skip` or `-ns`
In an earlier version isort had a default skip of `__init__.py`. To get around that many projects wanted a way to not skip `__init__.py` or any other files that were automatically skipped in the future by isort. isort no longer has any default skips, so if the value here is `__init__.py` you can simply remove the command line option. If it is something else, just make sure you aren't specifying to skip that file somewhere else in your config.

### `--recursive` or `-rc`
Prior to version 5.0.0, isort wouldn't automatically traverse directories. The --recursive option was necessary to tell it to do so. In 5.0.0 directories are automatically traversed for all Python files, and as such this option is no longer necessary and should simply be removed.

### `--apply` or `-y`
Prior to version 5.0.0, depending on how isort was executed, it would ask you before making every file change. In isort 5.0.0 file changes happen by default inline with other formatters. `--interactive` is available to restore the previous behavior. If encountered this option can simply be removed.

### `--keep-direct-and-as` or `-k`
Many versions ago, by default isort would remove imports such as `from datetime import datetime` if an alias for the same import also existed such as `from datetime import datetime as dt` - never allowing both to exist.
The option was originally added to allow working around this, and was then turned on as the default. Now the option for the old behaviour has been removed. Simply remove the option from your config file.

### `-ac`, `-wl`, `-ws`, `-tc`, `-sp`, `-sp`, `-sl`, `-sg`, `-sd`, `-rr`, `-ot`, `-nlb`, `-nis`, `-ls`, `-le`, `-lbt`, `-lai`, `-fss`, `-fgw`, `-ff`, `-fass`, `-fas`, `-dt`, `-ds`, `-df`, `-cs`, `-ca`, `-af`, `-ac`
Two-letter shortened setting names (like `ac` for `atomic`) now require two dashes to avoid ambiguity. Simply add another dash before the option, or switch to the long form option to fix (example: `--ac` or `--atomic`).

### `-v` and `-V`
The `-v` (previously for version now for verbose) and `-V` (previously for verbose and now for version) options have been swapped to be more consistent with tools across the CLI and in particular Python ecosystem.

## Migrating Config options

The first thing to keep in mind is how isort loads config options has changed in isort 5. It will no longer merge multiple config files, instead you must have 1 isort config per a project.
If you have multiple configs, they will need to be merged into 1 single one. You can see the priority order of configuration files and the manner in which they are loaded on the
[config files documentation page](https://pycqa.github.io/isort/docs/configuration/config_files.html).

!!! tip - "Config options are loaded relative to the file, not the isort instance."
    isort looks for a config file based on the path of the file you request to sort. If you have your config placed outside of the project, you can use `--settings-path` to manually specify the config location instead. Full information about how config files are loaded is in the linked config files documentation page.


### `not_skip`
This is the same as the `--dont-skip` CLI option above. In an earlier version isort had a default skip of `__init__.py`. To get around that many projects wanted a way to not skip `__init__.py` or any other files that were automatically skipped in the future by isort. isort no longer has any default skips, so if the value here is `__init__.py` you can simply remove the setting. If it is something else, just make sure you aren't specifying to skip that file somewhere else in your config.

### `keep_direct_and_as_imports`
This is the same as `keep-direct-and-as` from CLI. Many versions ago, by default isort would remove imports such as `from datetime import datetime` if an alias for the same import also existed such as `from datetime import datetime as dt` - never allowing both to exist.
The option was originally added to allow working around this, and was then turned on as the default. Now the option for the old behaviour has been removed. Simply remove the option from your config file.

### `known_standard_library`
isort settings no longer merge together, instead they override. The old behavior of merging together caused many hard to
track down errors, but the one place it was very convenient was for adding a few additional standard library modules.
In isort 5, you can still get this behavior by moving your extra modules from the `known_standard_library` setting to [`extra_standard_library`](https://pycqa.github.io/isort/docs/configuration/options.html#extra-standard-library).

### module placement changes: `known_third_party`, `known_first_party`, `default_section`, etc...
isort has completely rewritten its logic for placing modules in 5.0.0 to ensure the same behavior across environments. You can see the details of this change [here](https://github.com/pycqa/isort/issues/1147).
The TL;DR of which is that isort has now changed from `default_section=FIRSTPARTY` to `default_section=THIRDPARTY`. If you all already setting the default section to third party, your config is probably in good shape.
If not, you can either use the old finding approach with `--magic-placement` in the CLI or `old_finders=True` in your config, or preferably, you are able to remove all placement options and isort will determine it correctly.
If it doesn't, you should be able to just specify your projects modules with `known_first_party` and be done with it.

## Migrating pre-commit

### seed-isort-config

If you have a step in your precommit called `seed-isort-config` or similar, it is highly recommend that you remove this. It is unnecessary in 5.x.x, is guaranteed to slow things down, and worse can conflict with isort's own module placement logic.

### isort pre-commit step

isort now includes an optimized precommit configuration in the repo itself. To use it you can replace any existing isort precommit step with:

```
  - repo: https://github.com/pycqa/isort
    rev: 5.13.2
    hooks:
      - id: isort
        name: isort (python)
      - id: isort
        name: isort (cython)
        types: [cython]
      - id: isort
        name: isort (pyi)
        types: [pyi]
```

under the `repos` section of your projects `.pre-commit-config.yaml` config.
