#!/bin/bash
if [ -z "$JAVA_HOME" ]; then
	echo Set your JAVA_HOME environment variable!
	exit 1
fi

if [ -z "$PROJECTX_HOME" ]; then
	if [ -f ../../ProjectX.jar ]; then
		echo Setting PROJECTX_HOME...
		pushd ../..
		export PROJECTX_HOME=`pwd`
		popd
		echo PROJECTX_HOME=$PROJECTX_HOME
	else
		echo Set your PROJECTX_HOME environment variable!
		echo to the directory where ProjectX.jar is
		exit 1
	fi
fi

case `uname` in
	Linux)
		NATIVE=libidctfast.so
		;;
	*)
		NATIVE=idctfast.dll
		;;
esac

make $* && \
	[ -f $NATIVE ] && \
	echo Installing $NATIVE && \
	cp -v $NATIVE $PROJECTX_HOME/lib
